/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.IOException;
import java.net.SocketException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.logging.Logger;

public class MailServer {
    private static final Logger log = Logger.getLogger(MailServer.class);
    private static GreenMail greenMail;

    public static void main(String[] args) throws Exception {
        MailServer.start();
        MailServer.createEmailAccount("test@email.test", "password");
        try {
            while (true) {
                int c;
                if (!greenMail.waitForIncomingEmail(Long.MAX_VALUE, (c = greenMail.getReceivedMessages().length) + 1)) {
                    continue;
                }
                MimeMessage m = greenMail.getReceivedMessages()[c++];
                log.info((Object)"-------------------------------------------------------");
                log.info((Object)("Received mail to " + m.getRecipients(MimeMessage.RecipientType.TO)[0]));
                if (m.getContent() instanceof MimeMultipart) {
                    MimeMultipart mimeMultipart = (MimeMultipart)m.getContent();
                    for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                        log.info((Object)"----");
                        log.info((Object)(mimeMultipart.getBodyPart(i).getContentType() + ":\n"));
                        log.info(mimeMultipart.getBodyPart(i).getContent());
                    }
                } else {
                    log.info((Object)("\n" + m.getContent()));
                }
                log.info((Object)"-------------------------------------------------------");
            }
        }
        catch (IOException | InterruptedException | MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void start() {
        ServerSetup setup = new ServerSetup(Integer.parseInt("3025"), "localhost", "smtp");
        greenMail = new GreenMail(setup);
        greenMail.start();
        log.info((Object)"Started mail server (localhost:3025)");
    }

    public static void stop() {
        if (greenMail != null) {
            log.info((Object)"Stopping mail server (localhost:3025)");
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e.getCause() instanceof SocketException) || !e.getStackTrace()[0].getClassName().equals("com.icegreen.greenmail.smtp.SmtpHandler")) {
                        log.error((Object)("Exception in thread \"" + t.getName() + "\" "));
                        log.error((Object)e.getMessage(), e);
                    }
                }
            });
            greenMail.stop();
        }
    }

    public static void createEmailAccount(String email, String password) {
        log.debug((Object)("Creating email account " + email));
        greenMail.setUser(email, password);
    }

    public static MimeMessage getLastReceivedMessage() throws InterruptedException {
        if (greenMail.waitForIncomingEmail(1)) {
            return greenMail.getReceivedMessages()[greenMail.getReceivedMessages().length - 1];
        }
        return null;
    }

    public static MimeMessage[] getReceivedMessages() {
        return greenMail.getReceivedMessages();
    }
}

