/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.List;
import java.util.Map;
import org.keycloak.representations.idm.GroupRepresentation;

public class GroupBuilder {
    private final GroupRepresentation rep;

    public static GroupBuilder create() {
        GroupRepresentation rep = new GroupRepresentation();
        return new GroupBuilder(rep);
    }

    private GroupBuilder(GroupRepresentation rep) {
        this.rep = rep;
    }

    public GroupRepresentation build() {
        return this.rep;
    }

    public GroupBuilder id(String id) {
        this.rep.setId(id);
        return this;
    }

    public GroupBuilder name(String name) {
        this.rep.setName(name);
        return this;
    }

    public GroupBuilder path(String path) {
        this.rep.setPath(path);
        return this;
    }

    public GroupBuilder realmRoles(List<String> realmRoles) {
        this.rep.setRealmRoles(realmRoles);
        return this;
    }

    public GroupBuilder clientRoles(Map<String, List<String>> clientRoles) {
        this.rep.setClientRoles(clientRoles);
        return this;
    }

    public GroupBuilder attributes(Map<String, List<String>> attributes) {
        this.rep.setAttributes(attributes);
        return this;
    }

    public GroupBuilder singleAttribute(String name, String value) {
        this.rep.singleAttribute(name, value);
        return this;
    }

    public GroupBuilder subGroups(List<GroupRepresentation> subGroups) {
        this.rep.setSubGroups(subGroups);
        return this;
    }
}

