/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testsuite.util.ProtocolMapperUtil;

public class ClientBuilder {
    private ClientRepresentation rep;

    public static ClientBuilder create() {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setEnabled(Boolean.TRUE);
        return new ClientBuilder(rep);
    }

    public static ClientBuilder edit(ClientRepresentation rep) {
        return new ClientBuilder(rep);
    }

    private ClientBuilder(ClientRepresentation rep) {
        this.rep = rep;
    }

    public ClientBuilder id(String id) {
        this.rep.setId(id);
        return this;
    }

    public ClientBuilder name(String name) {
        this.rep.setName(name);
        return this;
    }

    public ClientBuilder clientId(String clientId) {
        this.rep.setClientId(clientId);
        return this;
    }

    public ClientBuilder consentRequired(boolean consentRequired) {
        this.rep.setConsentRequired(Boolean.valueOf(consentRequired));
        return this;
    }

    public ClientBuilder publicClient() {
        this.rep.setPublicClient(Boolean.valueOf(true));
        return this;
    }

    @Deprecated
    public ClientBuilder defaultRoles(String ... roles) {
        this.rep.setDefaultRoles(roles);
        return this;
    }

    public ClientBuilder addOptionalClientScopes(String ... optionalClientScopes) {
        if (this.rep.getOptionalClientScopes() == null) {
            this.rep.setOptionalClientScopes(new ArrayList());
        }
        this.rep.getOptionalClientScopes().addAll(Arrays.asList(optionalClientScopes));
        return this;
    }

    public ClientBuilder serviceAccount() {
        this.rep.setServiceAccountsEnabled(Boolean.valueOf(true));
        return this;
    }

    public ClientBuilder directAccessGrants() {
        this.rep.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        return this;
    }

    public ClientBuilder fullScopeEnabled(Boolean fullScopeEnabled) {
        this.rep.setFullScopeAllowed(fullScopeEnabled);
        return this;
    }

    public ClientBuilder frontchannelLogout(Boolean frontchannelLogout) {
        this.rep.setFrontchannelLogout(frontchannelLogout);
        return this;
    }

    public ClientBuilder secret(String secret) {
        this.rep.setSecret(secret);
        return this;
    }

    public ClientBuilder serviceAccountsEnabled(Boolean serviceAccountsEnabled) {
        this.rep.setServiceAccountsEnabled(serviceAccountsEnabled);
        return this;
    }

    public ClientRepresentation build() {
        return this.rep;
    }

    public ClientBuilder attribute(String name, String value) {
        HashMap<String, String> attributes = this.rep.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.put(name, value);
        this.rep.setAttributes(attributes);
        return this;
    }

    public ClientBuilder removeAttribute(String name) {
        Map attributes = this.rep.getAttributes();
        if (attributes != null) {
            attributes.remove(name);
            this.rep.setAttributes(attributes);
        }
        return this;
    }

    public ClientBuilder authenticatorType(String providerId) {
        this.rep.setClientAuthenticatorType(providerId);
        return this;
    }

    public ClientBuilder addWebOrigin(String webOrigin) {
        LinkedList<String> uris = this.rep.getWebOrigins();
        if (uris == null) {
            uris = new LinkedList<String>();
            this.rep.setWebOrigins(uris);
        }
        uris.add(webOrigin);
        return this;
    }

    public ClientBuilder addRedirectUri(String redirectUri) {
        LinkedList<String> uris = this.rep.getRedirectUris();
        if (uris == null) {
            uris = new LinkedList<String>();
            this.rep.setRedirectUris(uris);
        }
        uris.add(redirectUri);
        return this;
    }

    public ClientBuilder redirectUris(String ... redirectUris) {
        this.rep.setRedirectUris(Arrays.asList(redirectUris));
        return this;
    }

    public ClientBuilder baseUrl(String baseUrl) {
        this.rep.setBaseUrl(baseUrl);
        return this;
    }

    public ClientBuilder adminUrl(String adminUrl) {
        this.rep.setAdminUrl(adminUrl);
        return this;
    }

    public ClientBuilder rootUrl(String rootUrl) {
        this.rep.setRootUrl(rootUrl);
        return this;
    }

    public ClientBuilder protocol(String protocol) {
        this.rep.setProtocol(protocol);
        return this;
    }

    public ClientBuilder enabled(Boolean enabled) {
        this.rep.setEnabled(enabled);
        return this;
    }

    public ClientBuilder alwaysDisplayInConsole(Boolean alwaysDisplayInConsole) {
        this.rep.setAlwaysDisplayInConsole(alwaysDisplayInConsole);
        return this;
    }

    public ClientBuilder authorizationServicesEnabled(boolean enable) {
        this.rep.setAuthorizationServicesEnabled(Boolean.valueOf(enable));
        return this;
    }

    public ClientBuilder protocolMapper(ProtocolMapperRepresentation ... mappers) {
        if (this.rep.getProtocolMappers() == null) {
            this.rep.setProtocolMappers(new ArrayList());
        }
        this.rep.getProtocolMappers().addAll(Arrays.asList(mappers));
        return this;
    }

    public ClientBuilder pairwise(String sectorIdentifierUri, String salt) {
        return this.protocolMapper(ProtocolMapperUtil.createPairwiseMapper(sectorIdentifierUri, salt));
    }

    public ClientBuilder pairwise(String sectorIdentifierUri) {
        return this.protocolMapper(ProtocolMapperUtil.createPairwiseMapper(sectorIdentifierUri, null));
    }
}

