/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.user.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.user.profile.AbstractUserProfileTest;
import org.keycloak.testsuite.util.ClientScopeBuilder;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.DeclarativeUserProfileProvider;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.userprofile.config.UPAttribute;
import org.keycloak.userprofile.config.UPAttributePermissions;
import org.keycloak.userprofile.config.UPAttributeRequired;
import org.keycloak.userprofile.config.UPAttributeSelector;
import org.keycloak.userprofile.config.UPConfig;
import org.keycloak.util.JsonSerialization;
import org.keycloak.validate.ValidationError;

public class UserProfileTest
extends AbstractUserProfileTest {
    protected static final String ATT_ADDRESS = "address";

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        super.configureTestRealm(testRealm);
        testRealm.setClientScopes(new ArrayList());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("customer").protocol("openid-connect").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("client-a").protocol("openid-connect").build());
        ClientRepresentation client = org.keycloak.testsuite.util.KeycloakModelUtils.createClient(testRealm, "client-a");
        client.setDefaultClientScopes(Collections.singletonList("customer"));
        org.keycloak.testsuite.util.KeycloakModelUtils.createClient(testRealm, "client-b");
    }

    @Test
    public void testIdempotentProfile() {
        this.getTestingClient().server("test").run(UserProfileTest::testIdempotentProfile);
    }

    private static void testIdempotentProfile(KeycloakSession session) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        attributes.put("username", "profiled-user");
        Assert.assertTrue((boolean)profile.getAttributes().contains("username"));
        Assert.assertNull((Object)profile.getAttributes().getFirstValue("username"));
    }

    @Test
    public void testCustomAttributeInAnyContext() {
        this.getTestingClient().server("test").run(UserProfileTest::testCustomAttributeInAnyContext);
    }

    private static void testCustomAttributeInAnyContext(KeycloakSession session) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "profiled-user");
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration("{\"attributes\": [{\"name\": \"address\", \"required\": {}, \"permissions\": {\"edit\": [\"user\"]}}]}");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        MatcherAssert.assertThat((Object)profile.getAttributes().nameSet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"username", "email", ATT_ADDRESS}));
        attributes.put(ATT_ADDRESS, "myaddress");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
    }

    @Test
    public void testResolveProfile() {
        this.getTestingClient().server("test").run(UserProfileTest::testResolveProfile);
    }

    private static void testResolveProfile(KeycloakSession session) {
        UserProfileTest.configureAuthenticationSession(session);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "profiled-user");
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration("{\"attributes\": [{\"name\": \"business.address\", \"required\": {\"scopes\": [\"customer\"]}, \"permissions\": {\"edit\": [\"user\"]}}]}");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.getAttributes();
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"business.address"}));
        }
        attributes.put("business.address", "valid-address");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        profile.validate();
    }

    @Test
    public void testValidation() {
        this.getTestingClient().server("test").run(UserProfileTest::failValidationWhenEmptyAttributes);
        this.getTestingClient().server("test").run(UserProfileTest::testAttributeValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void failValidationWhenEmptyAttributes(KeycloakSession session) {
        UserProfile profile;
        HashMap<String, String> attributes = new HashMap<String, String>();
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        provider.setConfiguration(null);
        try {
            profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"username"}));
        }
        RealmModel realm = session.getContext().getRealm();
        try {
            attributes.clear();
            attributes.put("email", "profile-user@keycloak.org");
            profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"username"}));
        }
        try {
            realm.setRegistrationEmailAsUsername(true);
            attributes.clear();
            attributes.put("firstName", "Joe");
            attributes.put("lastName", "Doe");
            attributes.put("email", "profile-user@keycloak.org");
            profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
            profile.validate();
        }
        catch (ValidationException ve) {
            Assert.fail((String)"Should be OK email as username");
        }
        finally {
            realm.setRegistrationEmailAsUsername(false);
        }
        attributes.clear();
        attributes.put("username", "profile-user");
        attributes.put("firstName", "Joe");
        attributes.put("lastName", "Doe");
        provider.create(UserProfileContext.UPDATE_PROFILE, attributes).validate();
    }

    private static void testAttributeValidation(KeycloakSession session) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = errors::add;
        Assert.assertFalse((boolean)profile.getAttributes().validate("username", consumerArray));
        Assert.assertTrue((boolean)UserProfileTest.containsErrorMessage(errors, "missingUsernameMessage"));
        errors.clear();
        attributes.clear();
        attributes.put("email", "invalid");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        Consumer[] consumerArray2 = new Consumer[1];
        consumerArray2[0] = errors::add;
        Assert.assertFalse((boolean)profile.getAttributes().validate("email", consumerArray2));
        Assert.assertTrue((boolean)UserProfileTest.containsErrorMessage(errors, "error-invalid-email"));
    }

    private static boolean containsErrorMessage(List<ValidationError> errors, String message) {
        for (ValidationError err : errors) {
            if (!err.getMessage().equals(message)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testValidateComplianceWithUserProfile() {
        this.getTestingClient().server("test").run(UserProfileTest::testValidateComplianceWithUserProfile);
    }

    private static void testValidateComplianceWithUserProfile(KeycloakSession session) throws IOException {
        RealmModel realm = session.getContext().getRealm();
        UserModel user = session.users().addUser(realm, "profiled-user");
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributeRequired requirements = new UPAttributeRequired();
        attribute.setRequired(requirements);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Collections.singleton("user"));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        UserProfile profile = provider.create(UserProfileContext.ACCOUNT, user);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        user.setAttribute(ATT_ADDRESS, Arrays.asList("fixed-address"));
        profile = provider.create(UserProfileContext.ACCOUNT, user);
        profile.validate();
    }

    @Test
    public void testGetProfileAttributes() {
        this.getTestingClient().server("test").run(UserProfileTest::testGetProfileAttributes);
    }

    private static void testGetProfileAttributes(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        UserModel user = session.users().addUser(realm, KeycloakModelUtils.generateId());
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration("{\"attributes\": [{\"name\": \"address\", \"required\": {}, \"permissions\": {\"edit\": [\"user\"]}}]}");
        UserProfile profile = provider.create(UserProfileContext.ACCOUNT, user);
        Attributes attributes = profile.getAttributes();
        MatcherAssert.assertThat((Object)attributes.nameSet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"username", "email", "firstName", "lastName", ATT_ADDRESS}));
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        Assert.assertNotNull((Object)attributes.getFirstValue("username"));
        Assert.assertNull((Object)attributes.getFirstValue("email"));
        Assert.assertNull((Object)attributes.getFirstValue("firstName"));
        Assert.assertNull((Object)attributes.getFirstValue("lastName"));
        Assert.assertNull((Object)attributes.getFirstValue(ATT_ADDRESS));
        user.setAttribute(ATT_ADDRESS, Arrays.asList("fixed-address"));
        profile = provider.create(UserProfileContext.ACCOUNT, user);
        attributes = profile.getAttributes();
        profile.validate();
        Assert.assertNotNull((Object)attributes.getFirstValue(ATT_ADDRESS));
    }

    @Test
    public void testGetProfileAttributeGroups() {
        this.getTestingClient().server("test").run(UserProfileTest::testGetProfileAttributeGroups);
    }

    private static void testGetProfileAttributeGroups(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        UserModel user = session.users().addUser(realm, KeycloakModelUtils.generateId());
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        String configuration = "{\n  \"attributes\": [\n    {\n      \"name\": \"address\",\n      \"group\": \"companyaddress\"\n    },\n    {\n      \"name\": \"second\",\n      \"group\": \"groupwithanno\"\n    }\n  ],\n  \"groups\": [\n    {\n      \"name\": \"companyaddress\",\n      \"displayHeader\": \"header\",\n      \"displayDescription\": \"description\"\n    },\n    {\n      \"name\": \"groupwithanno\",\n      \"annotations\": {\n        \"anno1\": \"value1\",\n        \"anno2\": \"value2\"\n      }\n    }\n  ]\n}\n";
        provider.setConfiguration(configuration);
        UserProfile profile = provider.create(UserProfileContext.ACCOUNT, user);
        Attributes attributes = profile.getAttributes();
        MatcherAssert.assertThat((Object)attributes.nameSet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"username", "email", "firstName", "lastName", ATT_ADDRESS, "second"}));
        AttributeGroupMetadata companyAddressGroup = attributes.getMetadata(ATT_ADDRESS).getAttributeGroupMetadata();
        Assert.assertEquals((Object)"companyaddress", (Object)companyAddressGroup.getName());
        Assert.assertEquals((Object)"header", (Object)companyAddressGroup.getDisplayHeader());
        Assert.assertEquals((Object)"description", (Object)companyAddressGroup.getDisplayDescription());
        Assert.assertNull((Object)companyAddressGroup.getAnnotations());
        AttributeGroupMetadata groupwithannoGroup = attributes.getMetadata("second").getAttributeGroupMetadata();
        Assert.assertEquals((Object)"groupwithanno", (Object)groupwithannoGroup.getName());
        Assert.assertNull((Object)groupwithannoGroup.getDisplayHeader());
        Assert.assertNull((Object)groupwithannoGroup.getDisplayDescription());
        Map annotations = groupwithannoGroup.getAnnotations();
        Assert.assertEquals((long)2L, (long)annotations.size());
        Assert.assertEquals((Object)"value1", annotations.get("anno1"));
        Assert.assertEquals((Object)"value2", annotations.get("anno2"));
    }

    @Test
    public void testCreateAndUpdateUser() {
        this.getTestingClient().server("test").run(UserProfileTest::testCreateAndUpdateUser);
    }

    private static void testCreateAndUpdateUser(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        UPConfig config = (UPConfig)JsonSerialization.readValue((String)provider.getConfiguration(), UPConfig.class);
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(new HashSet<String>(Arrays.asList("admin", "user")));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        attribute = new UPAttribute();
        attribute.setName("business.address");
        permissions = new UPAttributePermissions();
        permissions.setEdit(new HashSet<String>(Arrays.asList("admin", "user")));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        String userName = KeycloakModelUtils.generateId();
        attributes.put("username", userName);
        attributes.put("firstName", "Joe");
        attributes.put("lastName", "Doe");
        attributes.put(ATT_ADDRESS, "fixed-address");
        UserProfile profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        UserModel user = profile.create();
        Assert.assertEquals((Object)userName, (Object)user.getUsername());
        Assert.assertEquals((Object)"fixed-address", (Object)user.getFirstAttribute(ATT_ADDRESS));
        attributes.put("firstName", "Alice");
        attributes.put("lastName", "In Chains");
        attributes.put("email", "alice@keycloak.org");
        profile = provider.create(UserProfileContext.ACCOUNT, attributes, user);
        HashSet attributesUpdated = new HashSet();
        HashMap<String, String> attributesUpdatedOldValues = new HashMap<String, String>();
        attributesUpdatedOldValues.put("firstName", "Joe");
        attributesUpdatedOldValues.put("lastName", "Doe");
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> {
            Assert.assertTrue((boolean)attributesUpdated.add(attributeName));
            Assert.assertEquals(attributesUpdatedOldValues.get(attributeName), (Object)UserProfileTest.getSingleValue(oldValue));
            Assert.assertEquals(attributes.get(attributeName), (Object)userModel.getFirstAttribute(attributeName));
        }});
        MatcherAssert.assertThat(attributesUpdated, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"firstName", "lastName", "email"}));
        UserProfileTest.configureAuthenticationSession(session);
        attributes.put("business.address", "fixed-business-address");
        profile = provider.create(UserProfileContext.ACCOUNT, attributes, user);
        attributesUpdated.clear();
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> Assert.assertTrue((boolean)attributesUpdated.add(attributeName))});
        MatcherAssert.assertThat(attributesUpdated, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"business.address"}));
        Assert.assertEquals((Object)"fixed-business-address", (Object)user.getFirstAttribute("business.address"));
    }

    private static String getSingleValue(List<String> vals) {
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        return vals.get(0);
    }

    @Test
    public void testReadonlyUpdates() {
        this.getTestingClient().server("test").run(UserProfileTest::testReadonlyUpdates);
    }

    private static void testReadonlyUpdates(KeycloakSession session) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("username", KeycloakModelUtils.generateId());
        attributes.put(ATT_ADDRESS, Arrays.asList("fixed-address"));
        attributes.put("department", Arrays.asList("sales"));
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration("{\"attributes\": [{\"name\": \"department\", \"permissions\": {\"edit\": [\"admin\"]}}]}");
        UserProfile profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        UserModel user = profile.create();
        MatcherAssert.assertThat((Object)profile.getAttributes().nameSet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"username", "email", ATT_ADDRESS, "department"}));
        Assert.assertNull((Object)user.getFirstAttribute("department"));
        profile = provider.create(UserProfileContext.USER_API, attributes, user);
        HashSet attributesUpdated = new HashSet();
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> Assert.assertTrue((boolean)attributesUpdated.add(attributeName))});
        MatcherAssert.assertThat(attributesUpdated, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"department"}));
        Assert.assertEquals((Object)"sales", (Object)user.getFirstAttribute("department"));
        attributes.put("department", "cannot-change");
        profile = provider.create(UserProfileContext.ACCOUNT, attributes, user);
        try {
            profile.update(new AttributeChangeListener[0]);
            Assert.fail((String)"Should fail due to read only attribute");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"department"}));
        }
        Assert.assertEquals((Object)"sales", (Object)user.getFirstAttribute("department"));
        Assert.assertTrue((boolean)profile.getAttributes().isReadOnly("department"));
    }

    @Test
    public void testDoNotUpdateUndefinedAttributes() {
        this.getTestingClient().server("test").run(UserProfileTest::testDoNotUpdateUndefinedAttributes);
    }

    private static void testDoNotUpdateUndefinedAttributes(KeycloakSession session) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("username", KeycloakModelUtils.generateId());
        attributes.put(ATT_ADDRESS, Arrays.asList("fixed-address"));
        attributes.put("department", Arrays.asList("sales"));
        attributes.put("phone", Arrays.asList("fixed-phone"));
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration("{\"attributes\": [{\"name\": \"department\", \"permissions\": {\"edit\": [\"admin\"]}},{\"name\": \"phone\", \"permissions\": {\"edit\": [\"admin\"]}},{\"name\": \"address\", \"permissions\": {\"edit\": [\"admin\"]}}]}");
        UserProfile profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        UserModel user = profile.create();
        MatcherAssert.assertThat((Object)profile.getAttributes().nameSet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"username", "email", ATT_ADDRESS, "department", "phone"}));
        profile = provider.create(UserProfileContext.USER_API, attributes, user);
        HashSet attributesUpdated = new HashSet();
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> Assert.assertTrue((boolean)attributesUpdated.add(attributeName))});
        MatcherAssert.assertThat(attributesUpdated, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"department", ATT_ADDRESS, "phone"}));
        provider.setConfiguration("{\"attributes\": [{\"name\": \"department\", \"permissions\": {\"edit\": [\"admin\"]}},{\"name\": \"phone\", \"permissions\": {\"edit\": [\"admin\"]}}]}");
        attributesUpdated.clear();
        attributes.remove(ATT_ADDRESS);
        attributes.put("department", "foo");
        attributes.put("phone", "foo");
        profile = provider.create(UserProfileContext.USER_API, attributes, user);
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> Assert.assertTrue((boolean)attributesUpdated.add(attributeName))});
        MatcherAssert.assertThat(attributesUpdated, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"department", "phone"}));
        Assert.assertTrue((boolean)user.getAttributes().containsKey(ATT_ADDRESS));
        provider.setConfiguration("{\"attributes\": [{\"name\": \"department\", \"permissions\": {\"edit\": [\"admin\"]}},{\"name\": \"phone\", \"permissions\": {\"edit\": [\"admin\"]}},{\"name\": \"address\", \"permissions\": {\"edit\": [\"admin\"]}}]}");
        attributes.put("department", "foo");
        attributes.put("phone", "foo");
        attributes.put(ATT_ADDRESS, "bar");
        attributesUpdated.clear();
        profile = provider.create(UserProfileContext.USER_API, attributes, user);
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> Assert.assertTrue((boolean)attributesUpdated.add(attributeName))});
        MatcherAssert.assertThat(attributesUpdated, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ATT_ADDRESS}));
        Assert.assertEquals((Object)"bar", (Object)user.getFirstAttribute(ATT_ADDRESS));
        Assert.assertEquals((Object)"foo", (Object)user.getFirstAttribute("phone"));
        Assert.assertEquals((Object)"foo", (Object)user.getFirstAttribute("department"));
        attributes.remove(ATT_ADDRESS);
        attributesUpdated.clear();
        profile = provider.create(UserProfileContext.USER_API, attributes, user);
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> Assert.assertTrue((boolean)attributesUpdated.add(attributeName))});
        MatcherAssert.assertThat(attributesUpdated, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ATT_ADDRESS}));
        Assert.assertFalse((boolean)user.getAttributes().containsKey(ATT_ADDRESS));
        Assert.assertTrue((boolean)user.getAttributes().containsKey("phone"));
        Assert.assertTrue((boolean)user.getAttributes().containsKey("department"));
        String prefixedAttributeName = "user.attributes.".concat("prefixed");
        attributes.put(prefixedAttributeName, "foo");
        attributesUpdated.clear();
        profile = provider.create(UserProfileContext.USER_API, attributes, user);
        profile.update(new AttributeChangeListener[]{(attributeName, userModel, oldValue) -> Assert.assertTrue((boolean)attributesUpdated.add(attributeName))});
        Assert.assertTrue((boolean)attributesUpdated.isEmpty());
        Assert.assertFalse((boolean)user.getAttributes().containsKey("prefixedAttributeName"));
    }

    @Test
    public void testComponentModelId() {
        this.getTestingClient().server("test").run(UserProfileTest::testComponentModelId);
    }

    private static void testComponentModelId(KeycloakSession session) {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        Assert.assertEquals((Object)"declarative-user-profile", (Object)provider.getComponentModel().getProviderId());
    }

    @Test
    public void testInvalidConfiguration() {
        this.getTestingClient().server("test").run(UserProfileTest::testInvalidConfiguration);
    }

    private static void testInvalidConfiguration(KeycloakSession session) {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        try {
            provider.setConfiguration("{\"validateConfigAttribute\": true}");
            Assert.fail((String)"Should fail validation");
        }
        catch (ComponentValidationException componentValidationException) {
            // empty catch block
        }
    }

    @Test
    public void testConfigurationChunks() {
        this.getTestingClient().server("test").run(UserProfileTest::testConfigurationChunks);
    }

    private static void testConfigurationChunks(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        String newConfig = UserProfileTest.generateLargeProfileConfig();
        provider.setConfiguration(newConfig);
        component = provider.getComponentModel();
        Assert.assertEquals((Object)"2", (Object)component.get("config-pieces-count"));
        Assert.assertEquals((Object)newConfig, (Object)provider.getConfiguration());
    }

    @Test
    public void testResetConfiguration() {
        this.getTestingClient().server("test").run(UserProfileTest::testResetConfiguration);
    }

    private static void testResetConfiguration(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration(null);
        Assert.assertNull((Object)provider.getComponentModel().get("config-pieces-count"));
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        Assert.assertTrue((boolean)component.getConfig().isEmpty());
    }

    @Test
    public void testDefaultConfig() {
        this.getTestingClient().server("test").run(UserProfileTest::testDefaultConfig);
    }

    private static void testDefaultConfig(KeycloakSession session) {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration(null);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, Collections.emptyMap());
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"username"}));
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("firstName", "");
        attributes.put("lastName", " ");
        attributes.put("email", "");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"username"}));
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"firstName"}));
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"lastName"}));
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"email"}));
        }
        attributes.put("username", "jdoeusername");
        attributes.put("firstName", "John");
        attributes.put("lastName", "Doe");
        attributes.put("email", "jdoe@acme.org");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
    }

    @Test
    public void testCustomValidationForUsername() {
        this.getTestingClient().server("test").run(UserProfileTest::testCustomValidationForUsername);
    }

    private static void testCustomValidationForUsername(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName("username");
        HashMap<String, Integer> validatorConfig = new HashMap<String, Integer>();
        validatorConfig.put("min", 4);
        attribute.addValidation("length", validatorConfig);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "us");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"username"}));
            Assert.assertTrue((boolean)ve.hasError(new String[]{"error-invalid-length-too-short"}));
        }
        attributes.put("username", "user");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        provider.setConfiguration(null);
        attributes.put("username", "user");
        attributes.put("firstName", "Joe");
        attributes.put("lastName", "Doe");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
    }

    @Test
    public void testOptionalAttributes() {
        this.getTestingClient().server("test").run(UserProfileTest::testOptionalAttributes);
    }

    private static void testOptionalAttributes(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName("firstName");
        HashMap<String, Integer> validatorConfig = new HashMap<String, Integer>();
        validatorConfig.put("max", 4);
        attribute.addValidation("length", validatorConfig);
        config.addAttribute(attribute);
        attribute = new UPAttribute();
        attribute.setName("lastName");
        attribute.addValidation("length", validatorConfig);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        attributes.put("firstName", "");
        attributes.put("lastName", "");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        attributes.put("firstName", "John");
        attributes.put("lastName", "Doe");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        attributes.put("firstName", "JohnTooLong");
        attributes.put("lastName", "DoeTooLong");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"firstName"}));
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{"lastName"}));
        }
    }

    @Test
    public void testCustomAttributeRequired() {
        this.getTestingClient().server("test").run(UserProfileTest::testCustomAttributeRequired);
    }

    private static void testCustomAttributeRequired(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        HashMap<String, Integer> validatorConfig = new HashMap<String, Integer>();
        validatorConfig.put("min", 4);
        attribute.addValidation("length", validatorConfig);
        UPAttributeRequired requirements = new UPAttributeRequired();
        attribute.setRequired(requirements);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Collections.singleton("user"));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        attributes.put(ATT_ADDRESS, "adr");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        attributes.put(ATT_ADDRESS, "adress ok");
        attributes.put("firstName", "Joe");
        attributes.put("lastName", "Doe");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
    }

    @Test
    public void testCustomAttributeOptional() {
        this.getTestingClient().server("test").run(UserProfileTest::testCustomAttributeOptional);
    }

    private static void testCustomAttributeOptional(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        HashMap<String, Integer> validatorConfig = new HashMap<String, Integer>();
        validatorConfig.put("min", 4);
        attribute.addValidation("length", validatorConfig);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        attributes.put(ATT_ADDRESS, "");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        attributes.put(ATT_ADDRESS, "adr");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        attributes.put(ATT_ADDRESS, "adress ok");
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
    }

    @Test
    public void testRequiredIfUser() {
        this.getTestingClient().server("test").run(UserProfileTest::testRequiredIfUser);
    }

    private static void testRequiredIfUser(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributeRequired requirements = new UPAttributeRequired();
        requirements.setRoles(Collections.singleton("user"));
        attribute.setRequired(requirements);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Collections.singleton("user"));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        profile = provider.create(UserProfileContext.REGISTRATION_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        attributes.put("firstName", "Joe");
        attributes.put("lastName", "Doe");
        profile = provider.create(UserProfileContext.USER_API, attributes);
        profile.validate();
    }

    @Test
    public void testRequiredIfAdmin() {
        this.getTestingClient().server("test").run(UserProfileTest::testRequiredIfAdmin);
    }

    private static void testRequiredIfAdmin(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributeRequired requirements = new UPAttributeRequired();
        requirements.setRoles(Collections.singleton("admin"));
        attribute.setRequired(requirements);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Collections.singleton("admin"));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.REGISTRATION_PROFILE, attributes);
        profile.validate();
        try {
            profile = provider.create(UserProfileContext.USER_API, attributes);
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
    }

    @Test
    public void testNoValidationsIfUserReadOnly() {
        this.getTestingClient().server("test").run(UserProfileTest::testNoValidationsIfUserReadOnly);
    }

    private static void testNoValidationsIfUserReadOnly(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributeRequired requirements = new UPAttributeRequired();
        attribute.setRequired(requirements);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Collections.singleton("admin"));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        attributes.put("firstName", "user");
        attributes.put("lastName", "user");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        try {
            profile = provider.create(UserProfileContext.USER_API, attributes);
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
    }

    @Test
    public void testNoValidationsIfAdminReadOnly() {
        this.getTestingClient().server("test").run(UserProfileTest::testNoValidationsIfAdminReadOnly);
    }

    private static void testNoValidationsIfAdminReadOnly(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributeRequired requirements = new UPAttributeRequired();
        attribute.setRequired(requirements);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Collections.singleton("user"));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        try {
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        profile = provider.create(UserProfileContext.USER_API, attributes);
        profile.validate();
    }

    @Test
    public void testRequiredByClientScope() {
        this.getTestingClient().server("test").run(UserProfileTest::testRequiredByClientScope);
    }

    private static void testRequiredByClientScope(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributeRequired requirements = new UPAttributeRequired();
        requirements.setScopes(Collections.singleton("client-a"));
        attribute.setRequired(requirements);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Collections.singleton("user"));
        attribute.setPermissions(permissions);
        config.addAttribute(attribute);
        provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "user");
        attributes.put("email", "user@email.test");
        UserProfileTest.configureAuthenticationSession(session, "client-b", null);
        UserProfile profile = provider.create(UserProfileContext.USER_API, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.ACCOUNT_OLD, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.REGISTRATION_PROFILE, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.REGISTRATION_USER_CREATION, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.IDP_REVIEW, attributes);
        profile.validate();
        UserProfileTest.configureAuthenticationSession(session, "client-a", null);
        profile = provider.create(UserProfileContext.USER_API, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.ACCOUNT, attributes);
        profile.validate();
        profile = provider.create(UserProfileContext.ACCOUNT_OLD, attributes);
        profile.validate();
        try {
            profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        try {
            profile = provider.create(UserProfileContext.REGISTRATION_PROFILE, attributes);
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
        try {
            profile = provider.create(UserProfileContext.IDP_REVIEW, attributes);
            profile.validate();
            Assert.fail((String)"Should fail validation");
        }
        catch (ValidationException ve) {
            Assert.assertTrue((boolean)ve.isAttributeOnError(new String[]{ATT_ADDRESS}));
        }
    }

    @Test
    public void testConfigurationInvalidScope() {
        this.getTestingClient().server("test").run(UserProfileTest::testConfigurationInvalidScope);
    }

    private static void testConfigurationInvalidScope(KeycloakSession session) throws IOException {
        RealmModel realm = session.getContext().getRealm();
        DeclarativeUserProfileProvider provider = UserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        UPConfig config = new UPConfig();
        UPAttribute attribute = new UPAttribute();
        attribute.setName(ATT_ADDRESS);
        UPAttributeRequired requirements = new UPAttributeRequired();
        requirements.setScopes(Collections.singleton("invalid"));
        attribute.setRequired(requirements);
        attribute.setSelector(new UPAttributeSelector());
        attribute.getSelector().setScopes(Collections.singleton("invalid"));
        config.addAttribute(attribute);
        try {
            provider.setConfiguration(JsonSerialization.writeValueAsString((Object)config));
            Assert.fail((String)"Expected to fail due to invalid client scope");
        }
        catch (ComponentValidationException componentValidationException) {
            // empty catch block
        }
    }
}

