/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.user.profile;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.testsuite.arquillian.annotation.SetDefaultProvider;
import org.keycloak.testsuite.user.profile.AbstractUserProfileTest;
import org.keycloak.testsuite.user.profile.CustomUserProfileProvider;
import org.keycloak.userprofile.DeclarativeUserProfileProvider;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;

@SetDefaultProvider(spi="userProfile", providerId="custom-user-profile", defaultProvider="declarative-user-profile", onlyUpdateDefault=true)
public class CustomUserProfileTest
extends AbstractUserProfileTest {
    @Test
    public void testCustomUserProfileProviderIsActive() {
        this.getTestingClient().server("test").run(CustomUserProfileTest::testCustomUserProfileProviderIsActive);
    }

    private static void testCustomUserProfileProviderIsActive(KeycloakSession session) {
        DeclarativeUserProfileProvider provider = CustomUserProfileTest.getDynamicUserProfileProvider(session);
        Assert.assertEquals((Object)CustomUserProfileProvider.class.getName(), (Object)provider.getClass().getName());
        Assert.assertTrue((boolean)(provider instanceof CustomUserProfileProvider));
        Assert.assertEquals((Object)"custom-user-profile", (Object)provider.getComponentModel().getProviderId());
    }

    @Test
    public void testInvalidConfiguration() {
        this.getTestingClient().server("test").run(CustomUserProfileTest::testInvalidConfiguration);
    }

    private static void testInvalidConfiguration(KeycloakSession session) {
        DeclarativeUserProfileProvider provider = CustomUserProfileTest.getDynamicUserProfileProvider(session);
        try {
            provider.setConfiguration("{\"validateConfigAttribute\": true}");
            Assert.fail((String)"Should fail validation");
        }
        catch (ComponentValidationException componentValidationException) {
            // empty catch block
        }
    }

    @Test
    public void testConfigurationChunks() {
        this.getTestingClient().server("test").run(CustomUserProfileTest::testConfigurationChunks);
    }

    private static void testConfigurationChunks(KeycloakSession session) throws IOException {
        DeclarativeUserProfileProvider provider = CustomUserProfileTest.getDynamicUserProfileProvider(session);
        ComponentModel component = provider.getComponentModel();
        Assert.assertNotNull((Object)component);
        String newConfig = CustomUserProfileTest.generateLargeProfileConfig();
        provider.setConfiguration(newConfig);
        component = provider.getComponentModel();
        Assert.assertEquals((Object)"2", (Object)component.get("config-pieces-count"));
        Assert.assertEquals((Object)newConfig, (Object)provider.getConfiguration());
    }

    @Test
    public void testDefaultConfig() {
        this.getTestingClient().server("test").run(CustomUserProfileTest::testDefaultConfig);
    }

    private static void testDefaultConfig(KeycloakSession session) {
        DeclarativeUserProfileProvider provider = CustomUserProfileTest.getDynamicUserProfileProvider(session);
        provider.setConfiguration(null);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "jdoeusername");
        attributes.put("firstName", "John");
        attributes.put("lastName", "Doe");
        attributes.put("email", "jdoe@acme.org");
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, attributes);
        profile.validate();
    }
}

