/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.user.profile;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.userprofile.DeclarativeUserProfileProvider;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.config.UPAttribute;
import org.keycloak.userprofile.config.UPConfig;
import org.keycloak.util.JsonSerialization;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public abstract class AbstractUserProfileTest
extends AbstractTestRealmKeycloakTest {
    protected static void configureAuthenticationSession(KeycloakSession session) {
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("customer");
        AbstractUserProfileTest.configureAuthenticationSession(session, "client-a", scopes);
    }

    protected static void configureAuthenticationSession(KeycloakSession session, String clientId, Set<String> requestedScopes) {
        RealmModel realm = session.getContext().getRealm();
        session.getContext().setAuthenticationSession(AbstractUserProfileTest.createAuthenticationSession(realm.getClientByClientId(clientId), requestedScopes));
    }

    protected static DeclarativeUserProfileProvider getDynamicUserProfileProvider(KeycloakSession session) {
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        provider.setConfiguration(null);
        return (DeclarativeUserProfileProvider)provider;
    }

    protected static String generateLargeProfileConfig() throws IOException {
        UPConfig config = new UPConfig();
        for (int i = 0; i < 80; ++i) {
            UPAttribute attribute = new UPAttribute();
            attribute.setName("username" + i);
            HashMap<String, Integer> validatorConfig = new HashMap<String, Integer>();
            validatorConfig.put("min", 3);
            attribute.addValidation("length", validatorConfig);
            config.addAttribute(attribute);
        }
        String newConfig = JsonSerialization.writeValueAsString((Object)config);
        return newConfig;
    }

    protected static AuthenticationSessionModel createAuthenticationSession(final ClientModel client, final Set<String> scopes) {
        return new AuthenticationSessionModel(){

            public String getTabId() {
                return null;
            }

            public RootAuthenticationSessionModel getParentSession() {
                return null;
            }

            public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatus() {
                return null;
            }

            public void setExecutionStatus(String authenticator, CommonClientSessionModel.ExecutionStatus status) {
            }

            public void clearExecutionStatus() {
            }

            public UserModel getAuthenticatedUser() {
                return null;
            }

            public void setAuthenticatedUser(UserModel user) {
            }

            public Set<String> getRequiredActions() {
                return null;
            }

            public void addRequiredAction(String action) {
            }

            public void removeRequiredAction(String action) {
            }

            public void addRequiredAction(UserModel.RequiredAction action) {
            }

            public void removeRequiredAction(UserModel.RequiredAction action) {
            }

            public void setUserSessionNote(String name, String value) {
            }

            public Map<String, String> getUserSessionNotes() {
                return null;
            }

            public void clearUserSessionNotes() {
            }

            public String getAuthNote(String name) {
                return null;
            }

            public void setAuthNote(String name, String value) {
            }

            public void removeAuthNote(String name) {
            }

            public void clearAuthNotes() {
            }

            public String getClientNote(String name) {
                return null;
            }

            public void setClientNote(String name, String value) {
            }

            public void removeClientNote(String name) {
            }

            public Map<String, String> getClientNotes() {
                return null;
            }

            public void clearClientNotes() {
            }

            public Set<String> getClientScopes() {
                return scopes;
            }

            public void setClientScopes(Set<String> clientScopes) {
            }

            public String getRedirectUri() {
                return null;
            }

            public void setRedirectUri(String uri) {
            }

            public RealmModel getRealm() {
                return null;
            }

            public ClientModel getClient() {
                return client;
            }

            public String getAction() {
                return null;
            }

            public void setAction(String action) {
            }

            public String getProtocol() {
                return null;
            }

            public void setProtocol(String method) {
            }
        };
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        if (testRealm.getAttributes() == null) {
            testRealm.setAttributes(new HashMap());
        }
        testRealm.getAttributes().put("userProfileEnabled", Boolean.TRUE.toString());
    }
}

