/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.url;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.url.AbstractHostnameTest;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE, AuthServerContainerExclude.AuthServer.QUARKUS}, details="Quarkus supports its own hostname provider implementation similar to the default hostname provider")
public class FixedHostnameTest
extends AbstractHostnameTest {
    public static final String SAML_CLIENT_ID = "http://whatever.hostname:8280/app/";
    private String authServerUrl;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation test = RealmBuilder.create().name("test").client(ClientBuilder.create().name("direct-grant").clientId("direct-grant").enabled(true).secret("password").directAccessGrants()).user(UserBuilder.create().username("test-user@localhost").password("password")).build();
        testRealms.add(test);
        RealmRepresentation customHostname = RealmBuilder.create().name("hostname").client(ClientBuilder.create().name("direct-grant").clientId("direct-grant").enabled(true).secret("password").directAccessGrants()).user(UserBuilder.create().username("test-user@localhost").password("password")).attribute("hostname", "custom-domain.127.0.0.1.nip.io").build();
        testRealms.add(customHostname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fixedHostname() throws Exception {
        this.authServerUrl = OAuthClient.AUTH_SERVER_ROOT;
        this.oauth.baseUrl(this.authServerUrl);
        this.oauth.clientId("direct-grant");
        try (Keycloak testAdminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)ServerURLs.getAuthServerContextRoot());){
            this.assertWellKnown("test", ServerURLs.AUTH_SERVER_SCHEME + "://localhost:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertSamlIdPDescriptor("test", ServerURLs.AUTH_SERVER_SCHEME + "://localhost:" + ServerURLs.AUTH_SERVER_PORT);
            this.configureFixed("keycloak.127.0.0.1.nip.io", -1, -1, false);
            this.assertWellKnown("test", ServerURLs.AUTH_SERVER_SCHEME + "://keycloak.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertSamlIdPDescriptor("test", ServerURLs.AUTH_SERVER_SCHEME + "://keycloak.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertWellKnown("hostname", ServerURLs.AUTH_SERVER_SCHEME + "://custom-domain.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertSamlIdPDescriptor("hostname", ServerURLs.AUTH_SERVER_SCHEME + "://custom-domain.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertTokenIssuer("test", ServerURLs.AUTH_SERVER_SCHEME + "://keycloak.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertTokenIssuer("hostname", ServerURLs.AUTH_SERVER_SCHEME + "://custom-domain.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "test", ServerURLs.AUTH_SERVER_SCHEME + "://keycloak.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertSamlLogin(testAdminClient, "test", ServerURLs.AUTH_SERVER_SCHEME + "://keycloak.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "hostname", ServerURLs.AUTH_SERVER_SCHEME + "://custom-domain.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
            this.assertSamlLogin(testAdminClient, "hostname", ServerURLs.AUTH_SERVER_SCHEME + "://custom-domain.127.0.0.1.nip.io:" + ServerURLs.AUTH_SERVER_PORT);
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fixedHttpPort() throws Exception {
        this.authServerUrl = "http://localhost:8180/auth";
        this.oauth.baseUrl(this.authServerUrl);
        this.oauth.clientId("direct-grant");
        try (Keycloak testAdminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"http://localhost:8180");){
            this.assertWellKnown("test", "http://localhost:8180");
            this.assertSamlIdPDescriptor("test", "http://localhost:8180");
            this.configureFixed("keycloak.127.0.0.1.nip.io", 80, -1, false);
            this.assertWellKnown("test", "http://keycloak.127.0.0.1.nip.io");
            this.assertSamlIdPDescriptor("test", "http://keycloak.127.0.0.1.nip.io");
            this.assertWellKnown("hostname", "http://custom-domain.127.0.0.1.nip.io");
            this.assertSamlIdPDescriptor("hostname", "http://custom-domain.127.0.0.1.nip.io");
            this.assertTokenIssuer("test", "http://keycloak.127.0.0.1.nip.io");
            this.assertTokenIssuer("hostname", "http://custom-domain.127.0.0.1.nip.io");
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "test", "http://keycloak.127.0.0.1.nip.io");
            this.assertSamlLogin(testAdminClient, "test", "http://keycloak.127.0.0.1.nip.io");
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "hostname", "http://custom-domain.127.0.0.1.nip.io");
            this.assertSamlLogin(testAdminClient, "hostname", "http://custom-domain.127.0.0.1.nip.io");
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fixedHostnameAlwaysHttpsHttpsPort() throws Exception {
        this.authServerUrl = "http://localhost:8180/auth";
        this.oauth.baseUrl(this.authServerUrl);
        this.oauth.clientId("direct-grant");
        try (Keycloak testAdminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"http://localhost:8180");){
            this.assertWellKnown("test", "http://localhost:8180");
            this.assertSamlIdPDescriptor("test", "http://localhost:8180");
            this.configureFixed("keycloak.127.0.0.1.nip.io", -1, 443, true);
            this.assertWellKnown("test", "https://keycloak.127.0.0.1.nip.io");
            this.assertSamlIdPDescriptor("test", "https://keycloak.127.0.0.1.nip.io");
            this.assertWellKnown("hostname", "https://custom-domain.127.0.0.1.nip.io");
            this.assertSamlIdPDescriptor("hostname", "https://custom-domain.127.0.0.1.nip.io");
            this.assertTokenIssuer("test", "https://keycloak.127.0.0.1.nip.io");
            this.assertTokenIssuer("hostname", "https://custom-domain.127.0.0.1.nip.io");
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "test", "https://keycloak.127.0.0.1.nip.io");
            this.assertSamlLogin(testAdminClient, "test", "https://keycloak.127.0.0.1.nip.io");
            this.assertInitialAccessTokenFromMasterRealm(testAdminClient, "hostname", "https://custom-domain.127.0.0.1.nip.io");
            this.assertSamlLogin(testAdminClient, "hostname", "https://custom-domain.127.0.0.1.nip.io");
        }
        finally {
            this.reset();
        }
    }

    private void assertInitialAccessTokenFromMasterRealm(Keycloak testAdminClient, String realm, String expectedBaseUrl) throws JWSInputException, ClientRegistrationException {
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(1));
        rep.setExpiration(Integer.valueOf(10000));
        ClientInitialAccessPresentation initialAccess = testAdminClient.realm(realm).clientInitialAccess().create(rep);
        JsonWebToken token = (JsonWebToken)new JWSInput(initialAccess.getToken()).readJsonContent(JsonWebToken.class);
        Assert.assertEquals((Object)(expectedBaseUrl + "/auth/realms/" + realm), (Object)token.getIssuer());
        ClientRegistration clientReg = ClientRegistration.create().url(this.authServerUrl, realm).build();
        clientReg.auth(Auth.token((String)initialAccess.getToken()));
        ClientRepresentation client = new ClientRepresentation();
        client.setEnabled(Boolean.valueOf(true));
        ClientRepresentation response = clientReg.create(client);
        String registrationAccessToken = response.getRegistrationAccessToken();
        JsonWebToken registrationToken = (JsonWebToken)new JWSInput(registrationAccessToken).readJsonContent(JsonWebToken.class);
        Assert.assertEquals((Object)(expectedBaseUrl + "/auth/realms/" + realm), (Object)registrationToken.getIssuer());
    }

    private void assertTokenIssuer(String realm, String expectedBaseUrl) throws Exception {
        this.oauth.realm(realm);
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        AccessToken token = (AccessToken)new JWSInput(tokenResponse.getAccessToken()).readJsonContent(AccessToken.class);
        Assert.assertEquals((Object)(expectedBaseUrl + "/auth/realms/" + realm), (Object)token.getIssuer());
        String introspection = this.oauth.introspectAccessTokenWithClientCredential(this.oauth.getClientId(), "password", tokenResponse.getAccessToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode introspectionNode = objectMapper.readTree(introspection);
        Assert.assertTrue((boolean)introspectionNode.get("active").asBoolean());
        Assert.assertEquals((Object)(expectedBaseUrl + "/auth/realms/" + realm), (Object)introspectionNode.get("iss").asText());
    }

    private void assertWellKnown(String realm, String expectedBaseUrl) {
        OIDCConfigurationRepresentation config = this.oauth.doWellKnownRequest(realm);
        Assert.assertEquals((Object)(expectedBaseUrl + "/auth/realms/" + realm + "/protocol/openid-connect/token"), (Object)config.getTokenEndpoint());
    }

    private void assertSamlIdPDescriptor(String realm, String expectedBaseUrl) throws Exception {
        String realmUrl = expectedBaseUrl + "/auth/realms/" + realm;
        String baseSamlEndpointUrl = realmUrl + "/protocol/saml";
        String entityDescriptor = null;
        try (CloseableHttpClient client = HttpClientBuilder.create().build();
             CloseableHttpResponse resp = client.execute((HttpUriRequest)new HttpGet(baseSamlEndpointUrl + "/descriptor"));){
            entityDescriptor = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)GeneralConstants.SAML_CHARSET);
            Object metadataO = SAMLParser.getInstance().parse((InputStream)new ByteArrayInputStream(entityDescriptor.getBytes(GeneralConstants.SAML_CHARSET)));
            Assert.assertThat((Object)metadataO, (Matcher)org.hamcrest.Matchers.instanceOf(EntityDescriptorType.class));
            EntityDescriptorType ed = (EntityDescriptorType)metadataO;
            Assert.assertThat((Object)ed.getEntityID(), (Matcher)org.hamcrest.Matchers.is((Object)realmUrl));
            IDPSSODescriptorType idpDescriptor = ((EntityDescriptorType.EDTDescriptorChoiceType)((EntityDescriptorType.EDTChoiceType)ed.getChoiceType().get(0)).getDescriptors().get(0)).getIdpDescriptor();
            Assert.assertThat((Object)idpDescriptor, (Matcher)org.hamcrest.Matchers.notNullValue());
            List locations = idpDescriptor.getSingleSignOnService().stream().map(EndpointType::getLocation).map(URI::toString).collect(Collectors.toList());
            Assert.assertThat(locations, (Matcher)org.hamcrest.Matchers.everyItem((Matcher)org.hamcrest.Matchers.is((Object)baseSamlEndpointUrl)));
        }
        catch (Exception e) {
            this.log.errorf("Caught exception while parsing SAML descriptor %s", entityDescriptor);
        }
    }

    private void assertSamlLogin(Keycloak testAdminClient, String realm, String expectedBaseUrl) throws Exception {
        String realmUrl = expectedBaseUrl + "/auth/realms/" + realm;
        String baseSamlEndpointUrl = realmUrl + "/protocol/saml";
        Object entityDescriptor = null;
        RealmResource realmResource = testAdminClient.realm(realm);
        ClientRepresentation clientRep = ClientBuilder.create().protocol("saml").clientId(SAML_CLIENT_ID).enabled(true).attribute("saml.client.signature", "false").redirectUris("http://foo.bar/").build();
        try (Creator c = Creator.create((RealmResource)realmResource, (ClientRepresentation)clientRep);
             Creator u = Creator.create((RealmResource)realmResource, (UserRepresentation)UserBuilder.create().username("bicycle").password("race").enabled(true).build());){
            SAMLDocumentHolder samlResponse = new SamlClientBuilder().authnRequest(new URI(baseSamlEndpointUrl), SAML_CLIENT_ID, "http://foo.bar/", SamlClient.Binding.POST).build().login().user("bicycle", "race").build().getSamlResponse(SamlClient.Binding.POST);
            Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType response = (ResponseType)samlResponse.getSamlObject();
            Assert.assertThat((Object)response.getAssertions(), (Matcher)org.hamcrest.Matchers.hasSize((int)1));
            Assert.assertThat((Object)((ResponseType.RTChoiceType)response.getAssertions().get(0)).getAssertion().getIssuer().getValue(), (Matcher)org.hamcrest.Matchers.is((Object)realmUrl));
        }
        catch (Exception e) {
            this.log.errorf("Caught exception while parsing SAML descriptor %s", entityDescriptor);
        }
    }
}

