/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.ssl;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.util.ServerURLs;

public class TLSTest
extends AbstractTestRealmKeycloakTest {
    public static final String AUTH_SERVER_ROOT_WITHOUT_TLS = "http://localhost:" + System.getProperty("auth.server.http.port", "8180") + "/auth";

    @BeforeClass
    public static void checkIfTLSIsTurnedOn() {
        Assume.assumeTrue((boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    @Override
    protected boolean modifyRealmForSSL() {
        return false;
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setSslRequired(SslRequired.NONE.toString());
    }

    @Test
    public void testTurningTLSOn() throws Exception {
        this.oauth.baseUrl(AUTH_SERVER_ROOT_WITHOUT_TLS);
        OIDCConfigurationRepresentation config = this.oauth.doWellKnownRequest("test");
        Assert.assertTrue((boolean)config.getAuthorizationEndpoint().startsWith(AUTH_SERVER_ROOT_WITHOUT_TLS));
    }

    @Test
    public void testSSLAlwaysRequired() throws Exception {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        String origSslRequired = realmRep.getSslRequired();
        realmRep.setSslRequired(SslRequired.ALL.toString());
        this.testRealm().update(realmRep);
        this.oauth.baseUrl(AUTH_SERVER_ROOT_WITHOUT_TLS);
        OIDCConfigurationRepresentation config = this.oauth.doWellKnownRequest("test");
        Assert.assertNull((Object)config.getAuthorizationEndpoint());
        Assert.assertEquals((Object)"HTTPS required", config.getOtherClaims().get("error_description"));
        try {
            JSONWebKeySet keySet = this.oauth.doCertsRequest("test");
            Assert.fail((String)"This should not be successful");
        }
        catch (Exception exception) {
            // empty catch block
        }
        realmRep.setSslRequired(origSslRequired);
        this.testRealm().update(realmRep);
    }
}

