/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.session;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.timer.TimerProvider;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class LastSessionRefreshUnitTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @After
    public void cleanupPeriodicTask() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            timer.cancelTask("lastSessionRefreshes");
        });
    }

    @Test
    public void testLastSessionRefreshCounters() {
        this.testingClient.server().run((RunOnServer)new LastSessionRefreshServerCounterTest());
    }

    @Test
    public void testLastSessionRefreshIntervals() {
        this.testingClient.server().run((RunOnServer)new LastSessionRefreshServerIntervalsTest());
    }

    public static abstract class LastSessionRefreshServerTest
    implements RunOnServer {
        AtomicInteger counter = new AtomicInteger();

        CrossDCLastSessionRefreshStore createStoreInstance(KeycloakSession session, long timerIntervalMs, int maxIntervalBetweenMessagesSeconds) {
            CrossDCLastSessionRefreshStoreFactory factory = new CrossDCLastSessionRefreshStoreFactory(){

                protected CrossDCLastSessionRefreshStore createStoreInstance(int maxIntervalBetweenMessagesSeconds, int maxCount, String eventKey) {
                    return new CrossDCLastSessionRefreshStore(maxIntervalBetweenMessagesSeconds, maxCount, eventKey){

                        protected void sendMessage(KeycloakSession kcSession, Map<String, SessionData> refreshesToSend) {
                            counter.incrementAndGet();
                        }
                    };
                }
            };
            Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("sessions");
            return factory.createAndInit(session, cache, timerIntervalMs, maxIntervalBetweenMessagesSeconds, 10, false);
        }
    }

    public static class LastSessionRefreshServerIntervalsTest
    extends LastSessionRefreshServerTest {
        public void run(KeycloakSession session) {
            CrossDCLastSessionRefreshStore customStore1 = this.createStoreInstance(session, 100000L, 10);
            Time.setOffset((int)100);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException();
            }
            Assert.assertEquals((long)0L, (long)this.counter.get());
            CrossDCLastSessionRefreshStore customStore2 = this.createStoreInstance(session, 10L, 10);
            Time.setOffset((int)200);
            Retry.execute(() -> Assert.assertEquals((long)1L, (long)this.counter.get()), (int)100, (long)10L);
            Assert.assertEquals((long)1L, (long)this.counter.get());
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException();
            }
            Assert.assertEquals((long)1L, (long)this.counter.get());
            Time.setOffset((int)0);
        }
    }

    public static class LastSessionRefreshServerCounterTest
    extends LastSessionRefreshServerTest {
        public void run(KeycloakSession session) {
            int i;
            CrossDCLastSessionRefreshStore customStore = this.createStoreInstance(session, 1000000L, 1000);
            System.out.println("sss");
            int lastSessionRefresh = Time.currentTime();
            for (i = 0; i < 8; ++i) {
                customStore.putLastSessionRefresh(session, "session-" + i, "master", lastSessionRefresh);
            }
            Assert.assertEquals((long)0L, (long)this.counter.get());
            for (i = 8; i < 10; ++i) {
                customStore.putLastSessionRefresh(session, "session-" + i, "master", lastSessionRefresh);
            }
            Assert.assertEquals((long)1L, (long)this.counter.get());
            for (i = 10; i < 15; ++i) {
                customStore.putLastSessionRefresh(session, "session-" + i, "master", lastSessionRefresh);
            }
            Assert.assertEquals((long)1L, (long)this.counter.get());
            for (i = 15; i < 35; ++i) {
                customStore.putLastSessionRefresh(session, "session-" + i, "master", lastSessionRefresh);
            }
            Assert.assertEquals((long)3L, (long)this.counter.get());
        }
    }
}

