/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.script;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.PermissionsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.DecisionEffect;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyEvaluationRequest;
import org.keycloak.representations.idm.authorization.PolicyEvaluationResponse;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.authz.AbstractAuthzTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

public class DeployedScriptPolicyTest
extends AbstractAuthzTest {
    private static final String SCRIPT_DEPLOYMENT_NAME = "scripts.jar";
    @ArquillianResource
    private Deployer deployer;

    @Deployment(name="scripts.jar", managed=false, testable=false)
    @TargetsContainer(value="auth-server-current")
    public static JavaArchive deploy() throws IOException {
        ScriptProviderDescriptor representation = new ScriptProviderDescriptor();
        representation.addPolicy("Grant Policy", "policy-grant.js");
        representation.addPolicy("Deny Policy", "policy-deny.js");
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)SCRIPT_DEPLOYMENT_NAME)).addAsManifestResource((Asset)new StringAsset(JsonSerialization.writeValueAsPrettyString((Object)representation)), "keycloak-scripts.json")).addAsResource((Asset)new StringAsset("$evaluation.grant();"), "policy-grant.js")).addAsResource((Asset)new StringAsset("$evaluation.deny();"), "policy-deny.js");
    }

    @BeforeClass
    public static void verifyEnvironment() {
        ContainerAssume.assumeNotAuthServerUndertow();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build())).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization")).user(UserBuilder.create().username("kolo").password("password")).client(ClientBuilder.create().clientId("resource-server").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants()).build());
    }

    @Before
    public void onBefore() throws Exception {
        this.deployer.deploy(SCRIPT_DEPLOYMENT_NAME);
        this.reconnectAdminClient();
        AuthorizationResource authorization = this.getAuthorizationResource();
        authorization.resources().create(new ResourceRepresentation("Default Resource", new String[0]));
    }

    @After
    public void onAfter() throws Exception {
        this.deployer.undeploy(SCRIPT_DEPLOYMENT_NAME);
        this.reconnectAdminClient();
    }

    @Test
    @DisableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    public void testJSPolicyProviderNotAvailable() {
        Assert.assertFalse((boolean)this.getAuthorizationResource().policies().policyProviders().stream().anyMatch(rep -> "js".equals(rep.getType())));
    }

    @Test
    @UncaughtServerErrorExpected
    @DisableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    public void failCreateJSPolicy() {
        JSPolicyRepresentation grantPolicy = new JSPolicyRepresentation();
        grantPolicy.setName("JS Policy");
        grantPolicy.setType("js");
        grantPolicy.setCode("$evaluation.grant();");
        try (Response response = this.getAuthorizationResource().policies().js().create(grantPolicy);){
            Assert.assertEquals((long)500L, (long)response.getStatus());
        }
    }

    @Test
    public void testCreatePermission() {
        AuthorizationResource authorization = this.getAuthorizationResource();
        PolicyRepresentation grantPolicy = new PolicyRepresentation();
        grantPolicy.setName("Grant Policy");
        grantPolicy.setType("script-policy-grant.js");
        authorization.policies().create(grantPolicy).close();
        PolicyRepresentation denyPolicy = new PolicyRepresentation();
        denyPolicy.setName("Deny Policy");
        denyPolicy.setType("script-policy-deny.js");
        authorization.policies().create(denyPolicy).close();
        PermissionsResource permissions = authorization.permissions();
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName("Test Deployed JS Permission");
        permission.addResource("Default Resource");
        permission.addPolicy(new String[]{grantPolicy.getName()});
        permissions.resource().create(permission).close();
        PolicyEvaluationRequest request = new PolicyEvaluationRequest();
        request.setUserId("marta");
        request.addResource("Default Resource", new String[0]);
        PolicyEvaluationResponse response = authorization.policies().evaluate(request);
        Assert.assertEquals((Object)DecisionEffect.PERMIT, (Object)response.getStatus());
        permission = permissions.resource().findByName(permission.getName());
        permission.addPolicy(new String[]{denyPolicy.getName()});
        permissions.resource().findById(permission.getId()).update(permission);
        response = authorization.policies().evaluate(request);
        Assert.assertEquals((Object)DecisionEffect.DENY, (Object)response.getStatus());
        permission.addPolicy(new String[]{grantPolicy.getName()});
        permissions.resource().findById(permission.getId()).update(permission);
        response = authorization.policies().evaluate(request);
        Assert.assertEquals((Object)DecisionEffect.DENY, (Object)response.getStatus());
        permission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        permissions.resource().findById(permission.getId()).update(permission);
        response = authorization.policies().evaluate(request);
        Assert.assertEquals((Object)DecisionEffect.PERMIT, (Object)response.getStatus());
    }

    private AuthorizationResource getAuthorizationResource() {
        return this.getClient(this.realmsResouce().realm("authz-test"), "resource-server").authorization();
    }

    private ClientResource getClient(RealmResource realm, String clientId) {
        ClientsResource clients = realm.clients();
        return clients.findByClientId(clientId).stream().map(representation -> clients.get(representation.getId())).findFirst().orElseThrow(() -> new RuntimeException("Expected client [resource-server-test]"));
    }
}

