/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class SessionNotOnOrAfterTest
extends AbstractSamlTest {
    private static final int SSO_MAX_LIFESPAN = 3602;
    private static final int ACCESS_CODE_LIFESPAN = 600;
    private static final int ACCESS_TOKEN_LIFESPAN = 1200;

    private SAML2Object checkSessionNotOnOrAfter(SAML2Object ob, int ssoMaxLifespan, int accessCodeLifespan, int accessTokenLifespan) {
        Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)ob;
        Assert.assertNotNull((Object)resp);
        Assert.assertNotNull((Object)resp.getAssertions());
        Assert.assertThat((Object)resp.getAssertions().size(), (Matcher)org.hamcrest.Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertNotNull(resp.getAssertions().get(0));
        Assert.assertNotNull((Object)((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion());
        Assert.assertNotNull((Object)((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements());
        Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
        AuthnStatementType authType = statements.stream().filter(statement -> statement instanceof AuthnStatementType).map(s -> (AuthnStatementType)s).findFirst().orElse(null);
        Assert.assertThat((Object)authType, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)authType.getSessionNotOnOrAfter(), (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)authType.getSessionNotOnOrAfter(), (Matcher)org.hamcrest.Matchers.is((Object)XMLTimeUtil.add((XMLGregorianCalendar)authType.getAuthnInstant(), (long)((long)ssoMaxLifespan * 1000L))));
        Assert.assertNotNull((Object)((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getConditions());
        Assert.assertNotNull((Object)((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getConditions());
        ConditionsType condition = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getConditions();
        Assert.assertEquals((Object)XMLTimeUtil.add((XMLGregorianCalendar)condition.getNotBefore(), (long)((long)accessCodeLifespan * 1000L)), (Object)condition.getNotOnOrAfter());
        Assert.assertNotNull((Object)((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getSubject());
        Assert.assertNotNull((Object)((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getSubject().getConfirmation());
        List confirmations = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getSubject().getConfirmation();
        SubjectConfirmationDataType confirmationData = confirmations.stream().map(c -> c.getSubjectConfirmationData()).filter(c -> c != null).findFirst().orElse(null);
        Assert.assertNotNull((Object)confirmationData);
        Assert.assertEquals((Object)XMLTimeUtil.add((XMLGregorianCalendar)condition.getNotBefore(), (long)((long)accessTokenLifespan * 1000L)), (Object)confirmationData.getNotOnOrAfter());
        return null;
    }

    @Test
    public void testSamlResponseContainsSessionNotOnOrAfterIdpInitiatedLogin() throws Exception {
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.adminClient.realm("demo")).updateWith(r -> {
            r.setSsoSessionMaxLifespan(Integer.valueOf(3602));
            r.setAccessCodeLifespan(Integer.valueOf(600));
            r.setAccessTokenLifespan(Integer.valueOf(1200));
        })).update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(r -> this.checkSessionNotOnOrAfter(r, 3602, 600, 1200))).build().execute();
        }
    }

    @Test
    public void testMaxValuesForAllTimeouts() throws Exception {
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.adminClient.realm("demo")).updateWith(r -> {
            r.setSsoSessionMaxLifespan(Integer.valueOf(Integer.MAX_VALUE));
            r.setAccessCodeLifespan(Integer.valueOf(Integer.MAX_VALUE));
            r.setAccessTokenLifespan(Integer.valueOf(Integer.MAX_VALUE));
        })).update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(r -> this.checkSessionNotOnOrAfter(r, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE))).build().execute();
        }
    }

    @Test
    public void testSamlResponseContainsSessionNotOnOrAfterAuthnLogin() throws Exception {
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.adminClient.realm("demo")).updateWith(r -> {
            r.setSsoSessionMaxLifespan(Integer.valueOf(3602));
            r.setAccessCodeLifespan(Integer.valueOf(600));
            r.setAccessTokenLifespan(Integer.valueOf(1200));
        })).update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(r -> this.checkSessionNotOnOrAfter(r, 3602, 600, 1200))).build().execute();
        }
    }

    @Test
    public void testSamlResponseClientConfigurationIdpInitiatedLogin() throws Exception {
        int ssoMaxLifespan = this.adminClient.realm("demo").toRepresentation().getSsoSessionMaxLifespan();
        try (ServerResourceUpdater c = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.assertion.lifespan", "2000").update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(r -> this.checkSessionNotOnOrAfter(r, ssoMaxLifespan, 2000, 2000))).build().execute();
        }
    }

    @Test
    public void testSamlResponseClientConfigurationAfterAuthnLogin() throws Exception {
        int ssoMaxLifespan = this.adminClient.realm("demo").toRepresentation().getSsoSessionMaxLifespan();
        try (ServerResourceUpdater c = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.assertion.lifespan", "1800").update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(r -> this.checkSessionNotOnOrAfter(r, ssoMaxLifespan, 1800, 1800))).build().execute();
        }
    }
}

