/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.ReverseProxy;
import org.keycloak.testsuite.util.SamlClient;
import org.w3c.dom.Document;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class SamlReverseProxyTest
extends AbstractSamlTest {
    @ClassRule
    public static ReverseProxy proxy = new ReverseProxy();

    @Test
    public void testAuthnRequestWithReverseProxy() throws Exception {
        Document document = SAML2Request.convert((RequestAbstractType)SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, (URI)this.buildSamlProtocolUrl(proxy.getUrl())));
        this.testSendSamlRequest(document, Response.Status.BAD_REQUEST, (Matcher<String>)org.hamcrest.Matchers.containsString((String)"Invalid Request"));
        RealmRepresentation rep = this.adminClient.realm("demo").toRepresentation();
        try {
            if (rep.getAttributes() == null) {
                rep.setAttributes(new HashMap());
            }
            rep.getAttributes().put("frontendUrl", proxy.getUrl());
            this.adminClient.realm("demo").update(rep);
            this.testSendSamlRequest(document, Response.Status.OK, (Matcher<String>)org.hamcrest.Matchers.containsString((String)"login"));
        }
        finally {
            rep.getAttributes().remove("frontendUrl");
            this.adminClient.realm("demo").update(rep);
        }
    }

    @Test
    public void testLogoutRequestWithReverseProxy() throws Exception {
        Document document = new SAML2LogoutRequestBuilder().destination(this.buildSamlProtocolUrl(proxy.getUrl()).toString()).issuer("http://localhost:8280/sales-post/").buildDocument();
        this.testSendSamlRequest(document, Response.Status.BAD_REQUEST, (Matcher<String>)org.hamcrest.Matchers.containsString((String)"Invalid Request"));
        RealmRepresentation rep = this.adminClient.realm("demo").toRepresentation();
        try {
            if (rep.getAttributes() == null) {
                rep.setAttributes(new HashMap());
            }
            rep.getAttributes().put("frontendUrl", proxy.getUrl());
            this.adminClient.realm("demo").update(rep);
            this.testSendSamlRequest(document, Response.Status.OK, (Matcher<String>)org.hamcrest.Matchers.containsString((String)"login"));
        }
        finally {
            rep.getAttributes().remove("frontendUrl");
            this.adminClient.realm("demo").update(rep);
        }
    }

    private void testSendSamlRequest(Document doc, Response.Status expectedHttpCode, Matcher<String> pageTextMatcher) throws Exception {
        HttpUriRequest post = SamlClient.Binding.POST.createSamlUnsignedRequest(this.buildSamlProtocolUrl(proxy.getUrl()), null, doc);
        try (CloseableHttpClient client = HttpClientBuilder.create().setSSLHostnameVerifier((s, sslSession) -> true).setRedirectStrategy((RedirectStrategy)new SamlClient.RedirectStrategyWithSwitchableFollowRedirect()).build();
             CloseableHttpResponse response = client.execute(post);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)expectedHttpCode));
            Assert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), pageTextMatcher);
        }
    }

    private URI buildSamlProtocolUrl(String baseUri) {
        return RealmsResource.protocolUrl((UriBuilder)UriBuilder.fromUri((String)baseUri)).build(new Object[]{"demo", "saml"});
    }
}

