/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.admin.concurrency.AbstractConcurrencyTest;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class SamlRelayStateTest
extends AbstractSamlTest {
    private static final String RELAY_STATE = "/importantRelayState";

    @Test
    public void testRelayStateDoesNotRetainBetweenTwoRequestsPost() throws Exception {
        new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).relayState(RELAY_STATE).build().login().user(this.bburkeUser).build().assertSamlRelayState(SamlClient.Binding.POST, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)RELAY_STATE)))).authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().followOneRedirect().assertSamlRelayState(SamlClient.Binding.POST, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).execute();
    }

    @Test
    public void testRelayStateDoesNotRetainBetweenTwoRequestsRedirect() throws Exception {
        String url = (String)((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0)).getAttributes().get("saml_assertion_consumer_url_post");
        try (ServerResourceUpdater c = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_assertion_consumer_url_post", null).setAttribute("saml_assertion_consumer_url_redirect", url).update();){
            new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).relayState(RELAY_STATE).build().login().user(this.bburkeUser).build().assertSamlRelayState(SamlClient.Binding.REDIRECT, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)RELAY_STATE)))).authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).build().assertSamlRelayState(SamlClient.Binding.REDIRECT, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).execute();
        }
    }

    @Test
    public void testRelayStateDoesNotRetainBetweenTwoRequestsIdpInitiatedPost() throws Exception {
        new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").relayState(RELAY_STATE).build().login().user(this.bburkeUser).build().assertSamlRelayState(SamlClient.Binding.POST, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)RELAY_STATE)))).idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().assertSamlRelayState(SamlClient.Binding.POST, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).execute();
    }

    @Test
    public void testRelayStateDoesNotRetainBetweenTwoRequestsIdpInitiatedRedirect() throws Exception {
        String url = (String)((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0)).getAttributes().get("saml_assertion_consumer_url_post");
        try (ServerResourceUpdater c = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml_assertion_consumer_url_post", null).setAttribute("saml_assertion_consumer_url_redirect", url).update();){
            new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").relayState(RELAY_STATE).build().login().user(this.bburkeUser).build().assertSamlRelayState(SamlClient.Binding.REDIRECT, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)RELAY_STATE)))).idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().assertSamlRelayState(SamlClient.Binding.REDIRECT, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).execute();
        }
    }

    @Test
    public void testRelayStateForSameAuthSession() throws Exception {
        new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).relayState(RELAY_STATE).build().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().assertSamlRelayState(SamlClient.Binding.POST, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).execute();
    }

    @Test
    public void testRelayStateForSameAuthSessionIDPInitiated() throws Exception {
        new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").relayState(RELAY_STATE).build().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post").build().login().user(this.bburkeUser).build().assertSamlRelayState(SamlClient.Binding.POST, relayState -> MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).execute();
    }

    @Test
    @Ignore(value="KEYCLOAK-5179")
    public void relayStateConcurrencyTest() throws Exception {
        ThreadLocal tl = new ThreadLocal();
        List steps = new SamlClientBuilder().addStep(() -> tl.set(UUID.randomUUID())).authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).relayState(() -> ((UUID)tl.get()).toString()).build().login().user(this.bburkeUser).build().assertSamlRelayState(SamlClient.Binding.POST, relayState -> {
            MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)relayState, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((UUID)tl.get()).toString())));
        }).getSteps();
        SamlClient client = new SamlClient();
        client.execute(steps);
        steps.remove(2);
        AbstractConcurrencyTest.run(2, 10, this, (threadIndex, keycloak, realm) -> client.execute(steps));
    }
}

