/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.net.URI;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class SamlRedirectBindingTest
extends AbstractSamlTest {
    @Test
    public void testNoWhitespaceInLoginRequest() throws Exception {
        AuthnRequestType authnRequest = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)SAML_ASSERTION_CONSUMER_URL_SALES_POST, (URI)this.getAuthServerSamlEndpoint("demo"));
        HttpUriRequest req = SamlClient.Binding.REDIRECT.createSamlUnsignedRequest(this.getAuthServerSamlEndpoint("demo"), null, SAML2Request.convert((RequestAbstractType)authnRequest));
        String url = req.getURI().getQuery();
        Assert.assertThat((Object)url, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)" ")));
        Assert.assertThat((Object)url, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)"\n")));
        Assert.assertThat((Object)url, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)"\r")));
        Assert.assertThat((Object)url, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)"\t")));
    }

    @Test
    public void testQueryParametersInSamlProcessingUriRedirectWithSignature() throws Exception {
        SamlClient samlClient = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/", SAML_ASSERTION_CONSUMER_URL_SALES_POST_SIG + "?param1=value1&param2=value2", SamlClient.Binding.REDIRECT).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().user(this.bburkeUser).build().doNotFollowRedirects().execute(hr -> {
            try {
                SAMLDocumentHolder doc = SamlClient.Binding.REDIRECT.extractResponse(hr, "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB");
                Assert.assertThat((Object)doc.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
                Assert.assertThat((Object)doc.getSamlObject(), (Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
                ResponseType res = (ResponseType)doc.getSamlObject();
                Assert.assertThat((Object)res.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)(SAML_ASSERTION_CONSUMER_URL_SALES_POST_SIG + "?param1=value1&param2=value2")));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

