/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.w3c.dom.Document;

public class SamlConsentTest
extends AbstractSamlTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/testsaml.json"));
    }

    @Test
    public void rejectedConsentResponseTest() throws ParsingException, ConfigurationException, ProcessingException {
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        this.adminClient.realm("demo").clients().get(client.getId()).update(ClientBuilder.edit(client).consentRequired(true).attribute("saml_idp_initiated_sso_url_name", "sales-post").attribute("saml_assertion_consumer_url_post", SAML_ASSERTION_CONSUMER_URL_SALES_POST + "saml").attribute("saml.server.signature", "true").build());
        this.log.debug((Object)"Log in using idp initiated login");
        SAMLDocumentHolder documentHolder = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().consentRequired().approveConsent(false).build().getSamlResponse(SamlClient.Binding.POST);
        String samlDocumentString = IOUtil.documentToString((Document)documentHolder.getSamlDocument());
        Assert.assertThat((Object)samlDocumentString, (Matcher)CoreMatchers.containsString((String)"<dsig:Signature"));
        Assert.assertThat((Object)samlDocumentString, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<samlp:LogoutResponse")));
        Assert.assertThat((Object)samlDocumentString, (Matcher)CoreMatchers.containsString((String)"<samlp:Response"));
        Assert.assertThat((Object)samlDocumentString, (Matcher)CoreMatchers.containsString((String)"<samlp:Status"));
        Assert.assertThat((Object)samlDocumentString, (Matcher)CoreMatchers.containsString((String)"<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:RequestDenied\""));
    }
}

