/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.SamlClient;
import org.w3c.dom.Document;

public class SamlClientTest
extends AbstractSamlTest {
    @Test
    public void testLoginWithOIDCClient() throws ParsingException, ConfigurationException, ProcessingException, IOException {
        ClientRepresentation salesRep = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        this.adminClient.realm("demo").clients().get(salesRep.getId()).update(ClientBuilder.edit(salesRep).protocol("openid-connect").build());
        AuthnRequestType loginRep = this.createLoginRequestDocument("http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, "demo");
        Document samlRequest = SAML2Request.convert((RequestAbstractType)loginRep);
        SamlClient.RedirectStrategyWithSwitchableFollowRedirect strategy = new SamlClient.RedirectStrategyWithSwitchableFollowRedirect();
        URI samlEndpoint = this.getAuthServerSamlEndpoint("demo");
        try (CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)strategy).build();){
            HttpUriRequest post = SamlClient.Binding.POST.createSamlUnsignedRequest(samlEndpoint, null, samlRequest);
            CloseableHttpResponse response = this.sendPost(post, client);
            Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)400L);
            String s = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"Wrong client protocol."));
            response.close();
        }
        this.adminClient.realm("demo").clients().get(salesRep.getId()).update(ClientBuilder.edit(salesRep).protocol("saml").build());
    }

    private CloseableHttpResponse sendPost(HttpUriRequest post, CloseableHttpClient client) {
        CloseableHttpResponse response;
        try {
            HttpClientContext context = HttpClientContext.create();
            response = client.execute(post, (HttpContext)context);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return response;
    }
}

