/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.CreateAuthnRequestStepBuilder;
import org.keycloak.testsuite.util.saml.CreateLogoutRequestStepBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;

public class SOAPBindingTest
extends AbstractSamlTest {
    @Test
    public void soapBindingAuthnWithSignatureTest() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.SOAP).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").basicAuthentication(this.bburkeUser).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.SOAP).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(ResponseType.class));
        ResponseType rt = (ResponseType)response.getSamlObject();
        Assert.assertThat((Object)rt.getAssertions(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void soapBindingAuthnWithSignatureMissingDestinationTest() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.SOAP).transformObject(authnRequestType -> {
            authnRequestType.setDestination(null);
            return authnRequestType;
        })).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").basicAuthentication(this.bburkeUser).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.SOAP).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(ResponseType.class));
        ResponseType rt = (ResponseType)response.getSamlObject();
        Assert.assertThat((Object)rt.getAssertions(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void soapBindingAuthnWithoutSignatureTest() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/ecp-sp/").setAttribute("saml.server.signature", "false").setAttribute("saml.client.signature", "false").update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.SOAP).basicAuthentication(this.bburkeUser).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.SOAP).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(ResponseType.class));
        ResponseType rt = (ResponseType)response.getSamlObject();
        Assert.assertThat((Object)rt.getAssertions(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void soapBindingAuthnWithoutSignatureMissingDestinationTest() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/ecp-sp/").setAttribute("saml.server.signature", "false").setAttribute("saml.client.signature", "false").update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.SOAP).transformObject(authnRequestType -> {
            authnRequestType.setDestination(null);
            return authnRequestType;
        })).basicAuthentication(this.bburkeUser).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.SOAP).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(ResponseType.class));
        ResponseType rt = (ResponseType)response.getSamlObject();
        Assert.assertThat((Object)rt.getAssertions(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void soapBindingLogoutWithSignature() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.POST).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SamlClient.Binding.SOAP).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.POST).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(StatusResponseType.class));
    }

    @Test
    public void soapBindingLogoutWithoutSignature() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/ecp-sp/").setAttribute("saml.server.signature", "false").setAttribute("saml.client.signature", "false").update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SamlClient.Binding.SOAP).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.POST).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(StatusResponseType.class));
    }

    @Test
    public void soapBindingLogoutWithSignatureMissingDestinationTest() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)((CreateLogoutRequestStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.POST).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SamlClient.Binding.SOAP).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").transformObject(logoutRequestType -> {
            logoutRequestType.setDestination(null);
            return logoutRequestType;
        })).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.POST).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(StatusResponseType.class));
    }

    @Test
    public void soapBindingLogoutWithoutSignatureMissingDestinationTest() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/ecp-sp/").setAttribute("saml.server.signature", "false").setAttribute("saml.client.signature", "false").update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)((CreateLogoutRequestStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SAML_ASSERTION_CONSUMER_URL_ECP_SP, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/ecp-sp/", SamlClient.Binding.SOAP).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).transformObject(logoutRequestType -> {
            logoutRequestType.setDestination(null);
            return logoutRequestType;
        })).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.POST).extractResponse(arg_0));
        Assert.assertThat((Object)response.getSamlObject(), (Matcher)Matchers.instanceOf(StatusResponseType.class));
    }
}

