/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.protocol.saml.mappers.RoleNameMapper;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ProtocolMappersUpdater;
import org.keycloak.testsuite.updaters.RoleScopeUpdater;
import org.keycloak.testsuite.updaters.UserAttributeUpdater;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.SamlStreams;
import org.keycloak.testsuite.util.ServerURLs;

public class RoleMapperTest
extends AbstractSamlTest {
    public static final String ROLE_ATTRIBUTE_NAME = "Role";
    public static final String SAML_ASSERTION_CONSUMER_URL_EMPLOYEE_2 = ServerURLs.AUTH_SERVER_SCHEME + "://localhost:" + (ServerURLs.AUTH_SERVER_SSL_REQUIRED ? ServerURLs.AUTH_SERVER_PORT : Integer.valueOf(8080)) + "/employee2/";
    private ClientAttributeUpdater cau;
    private ProtocolMappersUpdater pmu;
    private static int COUNTER = 1;

    @Before
    public void cleanMappersAndScopes() {
        this.cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/employee2/").setDefaultClientScopes(Collections.EMPTY_LIST).update();
        this.pmu = (ProtocolMappersUpdater)this.cau.protocolMappers().clear().update();
    }

    @After
    public void revertCleanMappersAndScopes() throws IOException {
        this.pmu.close();
        this.cau.close();
    }

    public static ProtocolMapperRepresentation createSamlProtocolMapper(String protocolMapperProviderId, String ... configKeyValue) {
        ProtocolMapperRepresentation res = new ProtocolMapperRepresentation();
        res.setProtocol("saml");
        res.setName(protocolMapperProviderId + "-" + COUNTER++);
        res.setProtocolMapper(protocolMapperProviderId);
        HashMap<String, String> config = new HashMap<String, String>();
        for (int i = 0; i < configKeyValue.length - 1; i += 2) {
            String key = configKeyValue[i];
            String value = configKeyValue[i + 1];
            config.put(key, value);
        }
        res.setConfig(config);
        return res;
    }

    @Test
    public void singleRoleMapper() throws Exception {
        String newClientId = "http://localhost:8280/employee2/.empl.oyee";
        this.cau.setClientId("http://localhost:8280/employee2/.empl.oyee").update();
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-role-list-mapper", "attribute.name", ROLE_ATTRIBUTE_NAME, "attribute.nameformat", "Basic", "single", "true"), RoleMapperTest.createSamlProtocolMapper("saml-role-name-mapper", "role", "http://localhost:8280/employee2/.empl.oyee.empl.oyee", RoleNameMapper.NEW_ROLE_NAME, "blah")}).update();
        this.testExpectedRoles("http://localhost:8280/employee2/.empl.oyee", "user", "manager", "blah", "employee");
    }

    @Test
    public void singleRealmRoleWithDots() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-role-list-mapper", "attribute.name", ROLE_ATTRIBUTE_NAME, "attribute.nameformat", "Basic", "single", "true")}).update();
        RoleRepresentation roleWithDots = this.realmsResouce().realm("demo").roles().get("role.with.dots").toRepresentation();
        try (UserAttributeUpdater uau = (UserAttributeUpdater)UserAttributeUpdater.forUserByUsername((Keycloak)this.adminClient, (String)"demo", (String)this.bburkeUser.getUsername()).update();
             RoleScopeUpdater rsu = (RoleScopeUpdater)uau.realmRoleScope().removeByName("user").add(roleWithDots).update();){
            this.testExpectedRoles("http://localhost:8280/employee2/", "manager", "role.with.dots", "empl.oyee", "employee");
        }
    }

    @Test
    public void singleRealmRoleWithDotsRemapped() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-role-list-mapper", "attribute.name", ROLE_ATTRIBUTE_NAME, "attribute.nameformat", "Basic", "single", "true"), RoleMapperTest.createSamlProtocolMapper("saml-role-name-mapper", "role", "role.with.dots", RoleNameMapper.NEW_ROLE_NAME, "blahWithDots")}).update();
        RoleRepresentation roleWithDots = this.realmsResouce().realm("demo").roles().get("role.with.dots").toRepresentation();
        try (UserAttributeUpdater uau = (UserAttributeUpdater)UserAttributeUpdater.forUserByUsername((Keycloak)this.adminClient, (String)"demo", (String)this.bburkeUser.getUsername()).update();
             RoleScopeUpdater rsu = (RoleScopeUpdater)uau.realmRoleScope().removeByName("user").add(roleWithDots).update();){
            this.testExpectedRoles("http://localhost:8280/employee2/", "manager", "blahWithDots", "empl.oyee", "employee");
        }
    }

    @Test
    public void defaultRoleMapperSingleAttribute() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-role-list-mapper", "attribute.name", ROLE_ATTRIBUTE_NAME, "attribute.nameformat", "Basic", "single", "true")}).update();
        this.testExpectedRoles("http://localhost:8280/employee2/", "user", "manager", "empl.oyee", "employee");
    }

    @Test
    public void defaultRoleMapperMultipleAttributes() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-role-list-mapper", "attribute.name", ROLE_ATTRIBUTE_NAME, "attribute.nameformat", "Basic", "single", "false")}).update();
        this.testExpectedRoles("http://localhost:8280/employee2/", "user", "manager", "empl.oyee", "employee");
    }

    @Test
    public void noRoleMappers() throws Exception {
        this.testExpectedRoles("http://localhost:8280/employee2/", new String[0]);
    }

    public void testExpectedRoles(String clientId, String ... expectedRoles) {
        SAMLDocumentHolder document = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), clientId, SAML_ASSERTION_CONSUMER_URL_EMPLOYEE_2, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)document.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        Stream assertions = SamlStreams.assertionsUnencrypted((SAML2Object)document.getSamlObject());
        Stream attributes = SamlStreams.attributesUnecrypted((Stream)SamlStreams.attributeStatements((Stream)assertions));
        Set roles = attributes.filter(a -> a.getName().equals(ROLE_ATTRIBUTE_NAME)).flatMap(a -> a.getAttributeValue().stream()).map(Object::toString).collect(Collectors.toSet());
        Assert.assertThat(roles, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])expectedRoles));
    }
}

