/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.saml.RoleMapperTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ProtocolMappersUpdater;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.SamlStreams;

public class ProtocolMapperTest
extends AbstractSamlTest {
    private ClientAttributeUpdater cau;
    private ProtocolMappersUpdater pmu;

    @Before
    public void cleanMappersAndScopes() {
        this.cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/employee2/").setDefaultClientScopes(Collections.EMPTY_LIST).update();
        this.pmu = (ProtocolMappersUpdater)this.cau.protocolMappers().clear().update();
        this.getCleanup("demo").addCleanup((AutoCloseable)this.cau).addCleanup((AutoCloseable)this.pmu);
    }

    @Test
    public void hardcodedAttributeMapperWithNullValueTest() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-hardcode-attribute-mapper", "attribute.name", "HARDCODED_ATTRIBUTE", "attribute.nameformat", "Basic", "attribute.value", null)}).update();
        SAMLDocumentHolder samlResponse = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/employee2/", RoleMapperTest.SAML_ASSERTION_CONSUMER_URL_EMPLOYEE_2, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        Stream assertions = SamlStreams.assertionsUnencrypted((SAML2Object)samlResponse.getSamlObject());
        Stream attributes = SamlStreams.attributesUnecrypted((Stream)SamlStreams.attributeStatements((Stream)assertions));
        Set attributeValues = attributes.flatMap(a -> a.getAttributeValue().stream()).collect(Collectors.toSet());
        Assert.assertThat(attributeValues, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
        Assert.assertThat(attributeValues.iterator().next(), (Matcher)CoreMatchers.nullValue());
    }
}

