/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.saml.RoleMapperTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ProtocolMappersUpdater;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.ServerURLs;

public class NameIdMapperTest
extends AbstractSamlTest {
    public static final String SAML_ASSERTION_CONSUMER_URL_EMPLOYEE_2 = ServerURLs.AUTH_SERVER_SCHEME + "://localhost:" + (ServerURLs.AUTH_SERVER_SSL_REQUIRED ? ServerURLs.AUTH_SERVER_PORT : Integer.valueOf(8080)) + "/employee2/";
    private ClientAttributeUpdater cau;
    private ProtocolMappersUpdater pmu;

    @Before
    public void setNameIdConfigAndCleanMappers() {
        this.cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/employee2/").setAttribute("saml_name_id_format", "username").setAttribute("saml_force_name_id_format", "true").update();
        this.pmu = (ProtocolMappersUpdater)this.cau.protocolMappers().clear().update();
    }

    @After
    public void revertCleanMappersAndScopes() throws IOException {
        this.pmu.close();
        this.cau.close();
    }

    @Test
    public void testNameIdMapper() {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-user-attribute-nameid-mapper", "mapper.nameid.format", JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get(), "user.attribute", "email")}).update();
        this.testExpectedNameId(this.bburkeUser.getEmail());
    }

    @Test
    public void testNameIdMapperNotFound() {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-user-attribute-nameid-mapper", "mapper.nameid.format", JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get(), "user.attribute", "email")}).update();
        this.testExpectedNameId(this.bburkeUser.getUsername());
    }

    @Test
    public void testNameIdMapperValueIsNull() {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-user-attribute-nameid-mapper", "mapper.nameid.format", JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get(), "user.attribute", "keycloak")}).update();
        this.testExpectedStatusCode(JBossSAMLURIConstants.STATUS_INVALID_NAMEIDPOLICY.get());
    }

    private void testExpectedNameId(String expectedNameId) {
        ResponseType rt = this.getSamlResponseObject();
        NameIDType nameId = (NameIDType)((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion().getSubject().getSubType().getBaseID();
        Assert.assertEquals((Object)expectedNameId, (Object)nameId.getValue());
        Assert.assertEquals((Object)JBossSAMLURIConstants.STATUS_SUCCESS.get(), (Object)rt.getStatus().getStatusCode().getValue().toString());
    }

    private void testExpectedStatusCode(String expectedStatusCode) {
        Assert.assertEquals((Object)expectedStatusCode, (Object)this.getSamlResponseObject().getStatus().getStatusCode().getStatusCode().getValue().toString());
    }

    private ResponseType getSamlResponseObject() {
        SAMLDocumentHolder document = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/employee2/", SAML_ASSERTION_CONSUMER_URL_EMPLOYEE_2, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
        return (ResponseType)document.getSamlObject();
    }
}

