/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.CreateAuthnRequestStepBuilder;

public class AuthnRequestNameIdFormatTest
extends AbstractSamlTest {
    private void testLoginWithNameIdPolicy(SamlClient.Binding requestBinding, SamlClient.Binding responseBinding, NameIDPolicyType nameIDPolicy, Matcher<String> nameIdMatcher) throws Exception {
        SAMLDocumentHolder res = ((CreateAuthnRequestStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, requestBinding).transformObject(so -> {
            so.setProtocolBinding(requestBinding.getBindingUri());
            so.setNameIDPolicy(nameIDPolicy);
            return so;
        })).build().login().user(this.bburkeUser).build().getSamlResponse(responseBinding);
        Assert.assertThat((Object)res.getSamlObject(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)res.getSamlObject(), (Matcher)Matchers.instanceOf(ResponseType.class));
        ResponseType rt = (ResponseType)res.getSamlObject();
        Assert.assertThat((Object)rt.getAssertions(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThat((Object)((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion().getSubject().getSubType().getBaseID(), (Matcher)Matchers.instanceOf(NameIDType.class));
        NameIDType nameId = (NameIDType)((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion().getSubject().getSubType().getBaseID();
        Assert.assertThat((Object)nameId.getValue(), nameIdMatcher);
    }

    @Test
    public void testPostLoginNameIdPolicyUnspecified() throws Exception {
        NameIDPolicyType nameIdPolicy = new NameIDPolicyType();
        nameIdPolicy.setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.getUri());
        this.testLoginWithNameIdPolicy(SamlClient.Binding.POST, SamlClient.Binding.POST, nameIdPolicy, (Matcher<String>)Matchers.is((Object)"bburke"));
    }

    @Test
    public void testPostLoginNameIdPolicyEmail() throws Exception {
        NameIDPolicyType nameIdPolicy = new NameIDPolicyType();
        nameIdPolicy.setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.getUri());
        this.testLoginWithNameIdPolicy(SamlClient.Binding.POST, SamlClient.Binding.POST, nameIdPolicy, (Matcher<String>)Matchers.is((Object)"bburke@redhat.com"));
    }

    @Test
    public void testPostLoginNameIdPolicyPersistent() throws Exception {
        NameIDPolicyType nameIdPolicy = new NameIDPolicyType();
        nameIdPolicy.setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.getUri());
        this.testLoginWithNameIdPolicy(SamlClient.Binding.POST, SamlClient.Binding.POST, nameIdPolicy, (Matcher<String>)Matchers.startsWith((String)"G-"));
    }

    @Test
    public void testPostLoginNoNameIdPolicyUnset() throws Exception {
        this.testLoginWithNameIdPolicy(SamlClient.Binding.POST, SamlClient.Binding.POST, null, (Matcher<String>)Matchers.is((Object)"bburke"));
    }

    @Test
    public void testRedirectLoginNameIdPolicyUnspecified() throws Exception {
        NameIDPolicyType nameIdPolicy = new NameIDPolicyType();
        nameIdPolicy.setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.getUri());
        this.testLoginWithNameIdPolicy(SamlClient.Binding.REDIRECT, SamlClient.Binding.REDIRECT, nameIdPolicy, (Matcher<String>)Matchers.is((Object)"bburke"));
    }

    @Test
    public void testRedirectLoginNameIdPolicyEmail() throws Exception {
        NameIDPolicyType nameIdPolicy = new NameIDPolicyType();
        nameIdPolicy.setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.getUri());
        this.testLoginWithNameIdPolicy(SamlClient.Binding.REDIRECT, SamlClient.Binding.REDIRECT, nameIdPolicy, (Matcher<String>)Matchers.is((Object)"bburke@redhat.com"));
    }

    @Test
    public void testRedirectLoginNameIdPolicyPersistent() throws Exception {
        NameIDPolicyType nameIdPolicy = new NameIDPolicyType();
        nameIdPolicy.setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.getUri());
        this.testLoginWithNameIdPolicy(SamlClient.Binding.REDIRECT, SamlClient.Binding.REDIRECT, nameIdPolicy, (Matcher<String>)Matchers.startsWith((String)"G-"));
    }

    @Test
    public void testRedirectLoginNoNameIdPolicyUnset() throws Exception {
        this.testLoginWithNameIdPolicy(SamlClient.Binding.REDIRECT, SamlClient.Binding.REDIRECT, null, (Matcher<String>)Matchers.is((Object)"bburke"));
    }

    @Test
    public void testRedirectLoginNoNameIdPolicyForcePostBinding() throws Exception {
        ClientsResource clients = this.adminClient.realm("demo").clients();
        List foundClients = clients.findByClientId("http://localhost:8280/sales-post/");
        Assert.assertThat((Object)foundClients, (Matcher)Matchers.hasSize((int)1));
        ClientResource clientRes = clients.get(((ClientRepresentation)foundClients.get(0)).getId());
        ClientRepresentation client = clientRes.toRepresentation();
        client.getAttributes().put("saml.force.post.binding", "true");
        clientRes.update(client);
        this.testLoginWithNameIdPolicy(SamlClient.Binding.REDIRECT, SamlClient.Binding.POST, null, (Matcher<String>)Matchers.is((Object)"bburke"));
        client = clientRes.toRepresentation();
        client.getAttributes().put("saml.force.post.binding", "false");
        clientRes.update(client);
    }
}

