/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.saml.RoleMapperTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ProtocolMappersUpdater;
import org.keycloak.testsuite.updaters.RoleScopeUpdater;
import org.keycloak.testsuite.updaters.UserAttributeUpdater;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.ServerURLs;

public class AudienceProtocolMappersTest
extends AbstractSamlTest {
    public static final String SAML_ASSERTION_CONSUMER_URL_EMPLOYEE_2 = ServerURLs.AUTH_SERVER_SCHEME + "://localhost:" + (ServerURLs.AUTH_SERVER_SSL_REQUIRED ? ServerURLs.AUTH_SERVER_PORT : Integer.valueOf(8080)) + "/employee2/";
    private ProtocolMappersUpdater pmu;

    @Before
    public void cleanMappersAndScopes() {
        this.pmu = (ProtocolMappersUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/employee2/").protocolMappers().clear().update();
    }

    @After
    public void revertCleanMappersAndScopes() throws IOException {
        this.pmu.close();
    }

    public void testExpectedAudiences(String ... audiences) {
        SAMLDocumentHolder document = new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/employee2/", SAML_ASSERTION_CONSUMER_URL_EMPLOYEE_2, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertNotNull((Object)document.getSamlObject());
        Assert.assertThat((Object)document.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        Assert.assertNotNull((Object)((ResponseType)document.getSamlObject()).getAssertions());
        Assert.assertThat((Object)((ResponseType)document.getSamlObject()).getAssertions().size(), (Matcher)org.hamcrest.Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertNotNull(((ResponseType)document.getSamlObject()).getAssertions().get(0));
        Assert.assertNotNull((Object)((ResponseType.RTChoiceType)((ResponseType)document.getSamlObject()).getAssertions().get(0)).getAssertion());
        AudienceRestrictionType audience = ((ResponseType.RTChoiceType)((ResponseType)document.getSamlObject()).getAssertions().get(0)).getAssertion().getConditions().getConditions().stream().filter(AudienceRestrictionType.class::isInstance).map(AudienceRestrictionType.class::cast).findFirst().orElse(null);
        Assert.assertNotNull((Object)audience);
        Assert.assertNotNull((Object)audience.getAudience());
        List values = audience.getAudience().stream().map(uri -> uri.toString()).collect(Collectors.toList());
        Assert.assertThat(values, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])audiences));
    }

    @Test
    public void testDefaultAudience() throws Exception {
        this.testExpectedAudiences("http://localhost:8280/employee2/");
    }

    @Test
    public void testCustomAudience() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-audience-mapper", "included.custom.audience", "https://test.com/test")}).update();
        this.testExpectedAudiences("http://localhost:8280/employee2/", "https://test.com/test");
    }

    @Test
    public void testClientAudience() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-audience-mapper", "included.client.audience", "http://localhost:8280/sales-post/")}).update();
        this.testExpectedAudiences("http://localhost:8280/employee2/", "http://localhost:8280/sales-post/");
    }

    @Test
    public void testClientAndCustomAudience() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-audience-mapper", "included.client.audience", "http://localhost:8280/sales-post/", "included.custom.audience", "https://test.com/test")}).update();
        this.testExpectedAudiences("http://localhost:8280/employee2/", "http://localhost:8280/sales-post/");
    }

    @Test
    public void testAudienceResolveFullScope() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-audience-resolve-mapper", new String[0])}).update();
        this.testExpectedAudiences("http://localhost:8280/employee2/", "http://localhost:8280/employee/", "http://localhost:8280/employee-role-mapping/");
        String employeeId = ((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/employee/").get(0)).getId();
        Assert.assertNotNull((Object)employeeId);
        try (RoleScopeUpdater rsc = (RoleScopeUpdater)UserAttributeUpdater.forUserByUsername((Keycloak)this.adminClient, (String)"demo", (String)this.bburkeUser.getUsername()).clientRoleScope(employeeId).removeByName("employee").update();){
            this.testExpectedAudiences("http://localhost:8280/employee2/", "http://localhost:8280/employee-role-mapping/");
        }
    }

    @Test
    public void testAudienceResolveNoFullScope() throws Exception {
        this.pmu.add(new ProtocolMapperRepresentation[]{RoleMapperTest.createSamlProtocolMapper("saml-audience-resolve-mapper", new String[0])}).update();
        try (ClientAttributeUpdater cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/employee2/").setFullScopeAllowed(Boolean.valueOf(false)).update();){
            this.testExpectedAudiences("http://localhost:8280/employee2/");
            String employee2Id = ((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/employee2/").get(0)).getId();
            Assert.assertNotNull((Object)employee2Id);
            String employeeId = ((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/employee/").get(0)).getId();
            Assert.assertNotNull((Object)employeeId);
            List availables = this.adminClient.realm("demo").clients().get(employee2Id).getScopeMappings().clientLevel(employeeId).listAvailable();
            Assert.assertThat((Object)availables.size(), (Matcher)org.hamcrest.Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            try (RoleScopeUpdater ru = (RoleScopeUpdater)cau.clientRoleScope(employeeId).add((RoleRepresentation)availables.get(0)).update();){
                this.testExpectedAudiences("http://localhost:8280/employee2/", "http://localhost:8280/employee/");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAudienceResolveNoFullScopeClientScopes() throws Exception {
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("audience-mapper-test-client-scope");
        clientScope.setProtocol("saml");
        clientScope.setProtocolMappers(Collections.singletonList(RoleMapperTest.createSamlProtocolMapper("saml-audience-resolve-mapper", new String[0])));
        Response res = this.adminClient.realm("demo").clientScopes().create(clientScope);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)res.getStatus());
        String clientScopeId = ApiUtil.getCreatedId((Response)res);
        try {
            String employee2Id = ((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/employee2/").get(0)).getId();
            Assert.assertNotNull((Object)employee2Id);
            String employeeId = ((ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/employee/").get(0)).getId();
            Assert.assertNotNull((Object)employeeId);
            List availables = this.adminClient.realm("demo").clientScopes().get(clientScopeId).getScopeMappings().clientLevel(employeeId).listAvailable();
            Assert.assertThat((Object)availables.size(), (Matcher)org.hamcrest.Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            this.adminClient.realm("demo").clientScopes().get(clientScopeId).getScopeMappings().clientLevel(employeeId).add(availables);
            try (ClientAttributeUpdater cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/employee2/").setFullScopeAllowed(Boolean.valueOf(false)).addDefaultClientScope("audience-mapper-test-client-scope").update();){
                this.testExpectedAudiences("http://localhost:8280/employee2/", "http://localhost:8280/employee/");
            }
        }
        finally {
            this.adminClient.realm("demo").clientScopes().get(clientScopeId).remove();
        }
    }
}

