/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.saml;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.awaitility.Awaitility;
import org.hamcrest.MatcherAssert;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.NameIDMappingResponseType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.protocol.saml.util.ArtifactBindingUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.saml.AbstractSamlTest;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.util.InfinispanTestTimeServiceRule;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.SamlUtils;
import org.keycloak.testsuite.util.saml.HandleArtifactStepBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.util.saml.SamlMessageReceiver;
import org.keycloak.testsuite.util.saml.SessionStateChecker;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.w3c.dom.Document;

public class ArtifactBindingTest
extends AbstractSamlTest {
    @Rule
    public InfinispanTestTimeServiceRule ispnTestTimeService = new InfinispanTestTimeServiceRule(this);

    @Test
    public void testArtifactBindingTimesOutAfterCodeToTokenLifespan() throws Exception {
        this.getCleanup().addCleanup((AutoCloseable)new RealmAttributeUpdater(this.adminClient.realm("demo")).setAccessCodeLifespan(Integer.valueOf(1)).update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").setBeforeStepChecks(() -> this.setTimeOffset(1000)).build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testArtifactBindingWithResponseAndAssertionSignature() throws Exception {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-assertion-and-response-sig/", SAML_ASSERTION_CONSUMER_URL_SALES_POST_ASSERTION_AND_RESPONSE_SIG, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-assertion-and-response-sig/").signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        ResponseType samlResponse = (ResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)((ResponseType.RTChoiceType)samlResponse.getAssertions().get(0)).getAssertion().getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue()));
        SamlDeployment deployment = SamlUtils.getSamlDeploymentForClient((String)"sales-post-assertion-and-response-sig");
        SamlProtocolUtils.verifyDocumentSignature((Document)response.getSamlDocument(), (KeyLocator)deployment.getIDP().getSignatureValidationKeyLocator());
    }

    @Test
    public void testArtifactBindingWithEncryptedAssertion() throws Exception {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-enc/", SAML_ASSERTION_CONSUMER_URL_SALES_POST_ENC, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).signWith("MIICXQIBAAKBgQDb7kwJPkGdU34hicplwfp6/WmNcaLh94TSc7Jyr9Undp5pkyLgb0DE7EIE+6kSs4LsqCb8HDkB0nLD5DXbBJFd8n0WGoKstelvtg6FtVJMnwN7k7yZbfkPECWH9zF70VeOo9vbzrApNRnct8ZhH5fbflRB4JMA9L9R+LbURdoSKQIDAQABAoGBANtbZG9bruoSGp2s5zhzLzd4hczT6Jfk3o9hYjzNb5Z60ymN3Z1omXtQAdEiiNHkRdNxK+EM7TcKBfmoJqcaeTkW8cksVEAW23ip8W9/XsLqmbU2mRrJiKa+KQNDSHqJi1VGyimi4DDApcaqRZcaKDFXg2KDr/Qt5JFD/o9IIIPZAkEA+ZENdBIlpbUfkJh6Ln+bUTss/FZ1FsrcPZWu13rChRMrsmXsfzu9kZUWdUeQ2Dj5AoW2Q7L/cqdGXS7Mm5XhcwJBAOGZq9axJY5YhKrsksvYRLhQbStmGu5LG75suF+rc/44sFq+aQM7+oeRr4VY88Mvz7mk4esdfnk7ae+cCazqJvMCQQCx1L1cZw3yfRSn6S6u8XjQMjWE/WpjulujeoRiwPPY9WcesOgLZZtYIH8nRL6ehEJTnMnahbLmlPFbttxPRUanAkA11MtSIVcKzkhp2KV2ipZrPJWwI18NuVJXb+3WtjypTrGWFZVNNkSjkLnHIeCYlJIGhDd8OL9zAiBXEm6kmgLNAkBWAg0tK2hCjvzsaA505gWQb4X56uKWdb0IzN+fOLB3Qt7+fLqbVQNQoNGzqey6B4MoS1fUKAStqdGTFYPG/+9t", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDb7kwJPkGdU34hicplwfp6/WmNcaLh94TSc7Jyr9Undp5pkyLgb0DE7EIE+6kSs4LsqCb8HDkB0nLD5DXbBJFd8n0WGoKstelvtg6FtVJMnwN7k7yZbfkPECWH9zF70VeOo9vbzrApNRnct8ZhH5fbflRB4JMA9L9R+LbURdoSKQIDAQAB").build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-enc/").signWith("MIICXQIBAAKBgQDb7kwJPkGdU34hicplwfp6/WmNcaLh94TSc7Jyr9Undp5pkyLgb0DE7EIE+6kSs4LsqCb8HDkB0nLD5DXbBJFd8n0WGoKstelvtg6FtVJMnwN7k7yZbfkPECWH9zF70VeOo9vbzrApNRnct8ZhH5fbflRB4JMA9L9R+LbURdoSKQIDAQABAoGBANtbZG9bruoSGp2s5zhzLzd4hczT6Jfk3o9hYjzNb5Z60ymN3Z1omXtQAdEiiNHkRdNxK+EM7TcKBfmoJqcaeTkW8cksVEAW23ip8W9/XsLqmbU2mRrJiKa+KQNDSHqJi1VGyimi4DDApcaqRZcaKDFXg2KDr/Qt5JFD/o9IIIPZAkEA+ZENdBIlpbUfkJh6Ln+bUTss/FZ1FsrcPZWu13rChRMrsmXsfzu9kZUWdUeQ2Dj5AoW2Q7L/cqdGXS7Mm5XhcwJBAOGZq9axJY5YhKrsksvYRLhQbStmGu5LG75suF+rc/44sFq+aQM7+oeRr4VY88Mvz7mk4esdfnk7ae+cCazqJvMCQQCx1L1cZw3yfRSn6S6u8XjQMjWE/WpjulujeoRiwPPY9WcesOgLZZtYIH8nRL6ehEJTnMnahbLmlPFbttxPRUanAkA11MtSIVcKzkhp2KV2ipZrPJWwI18NuVJXb+3WtjypTrGWFZVNNkSjkLnHIeCYlJIGhDd8OL9zAiBXEm6kmgLNAkBWAg0tK2hCjvzsaA505gWQb4X56uKWdb0IzN+fOLB3Qt7+fLqbVQNQoNGzqey6B4MoS1fUKAStqdGTFYPG/+9t", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDb7kwJPkGdU34hicplwfp6/WmNcaLh94TSc7Jyr9Undp5pkyLgb0DE7EIE+6kSs4LsqCb8HDkB0nLD5DXbBJFd8n0WGoKstelvtg6FtVJMnwN7k7yZbfkPECWH9zF70VeOo9vbzrApNRnct8ZhH5fbflRB4JMA9L9R+LbURdoSKQIDAQAB").build().doNotFollowRedirects().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.ARTIFACT_RESPONSE).extractResponse(arg_0));
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        ResponseType loginResponse = (ResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)loginResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)((ResponseType.RTChoiceType)loginResponse.getAssertions().get(0)).getAssertion(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)((ResponseType.RTChoiceType)loginResponse.getAssertions().get(0)).getEncryptedAssertion(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue()));
        SamlDeployment deployment = SamlUtils.getSamlDeploymentForClient((String)"sales-post-enc");
        AssertionUtil.decryptAssertion((SAMLDocumentHolder)response, (ResponseType)loginResponse, (PrivateKey)deployment.getDecryptionKey());
        MatcherAssert.assertThat((Object)((ResponseType.RTChoiceType)loginResponse.getAssertions().get(0)).getAssertion(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((ResponseType.RTChoiceType)loginResponse.getAssertions().get(0)).getEncryptedAssertion(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)((ResponseType.RTChoiceType)loginResponse.getAssertions().get(0)).getAssertion().getIssuer().getValue(), (org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)this.getAuthServerRealmBase("demo").toString()));
    }

    @Test
    public void testArtifactBindingLoginCheckArtifactWithPost() throws NoSuchAlgorithmException {
        String response = (String)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().doNotFollowRedirects().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"SAMLart"));
        Pattern artifactPattern = Pattern.compile("NAME=\"SAMLart\" VALUE=\"((?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=))");
        Matcher m = artifactPattern.matcher(response);
        MatcherAssert.assertThat((Object)m.find(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)true));
        String artifactB64 = m.group(1);
        MatcherAssert.assertThat((Object)artifactB64, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.isEmptyOrNullString()));
        byte[] artifact = Base64.getDecoder().decode(artifactB64);
        MatcherAssert.assertThat((Object)artifact.length, (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)44));
        MatcherAssert.assertThat((Object)artifact[0], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)artifact[1], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)artifact[2], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)artifact[3], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)0));
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        byte[] source = sha1Digester.digest(this.getAuthServerRealmBase("demo").toString().getBytes(Charsets.UTF_8));
        for (int i = 0; i < 20; ++i) {
            MatcherAssert.assertThat((Object)source[i], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)artifact[i + 4]));
        }
    }

    @Test
    public void testArtifactBindingLoginFullExchangeWithPost() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        MatcherAssert.assertThat((Object)artifactResponse.getInResponseTo(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.isEmptyOrNullString()));
        ResponseType samlResponse = (ResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testArtifactBindingLoginCorrectSignature() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/", SAML_ASSERTION_CONSUMER_URL_SALES_POST_SIG, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/").signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue()));
        ResponseType samlResponse = (ResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)((ResponseType.RTChoiceType)samlResponse.getAssertions().get(0)).getAssertion().getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testArtifactBindingLoginIncorrectSignature() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/", SAML_ASSERTION_CONSUMER_URL_SALES_POST_SIG, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/").signWith("MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMrGzRp3HVf6Ti75rl5mPAPXua8APCCLANikzOd82VI0R8Ml0UAchkfRUBvBedobJIn9r8wwxMeXLmKsMynW52SYeC/Zx5b5K6ayMS3GWJIgqLpp/n1piUeI4sbJXlUj9UtW+QTpGhrHt9n7s7znwoNqGDUkjmyZiekEspjdfzzlAgMBAAECgYBJvPFo5lftXkCAJJucCGFapGAJm3RCAUpVfdhldakxk4FlHaNyRO0vwJX5AeplvekTpQUAo9trGTbs+uHAHT4XWOnwhHHyBRkWdiwXX9bzNdHnIwf/0SLIBBYUk0hoWEDvpklBPqllM215a0sEnB2ykYSsMDBSkFB7Ah+RK7zTAQJBAOw9v7SsfIhOXci9vnkQPuQpL8T4kwj7nWi+YtRGrXbF/bJGwjsgXN5i7otwBV/W+TNzI5H7s2opPUXdIxfP9C0CQQDbvIcxXjwjO1hjXXY4axiT1sxU8Oq1bds033atMoN9pib7IxkWh6ouOQZT8bxwQ2ElH0rswZ0/2CusrIUIekaZAkEAk9UUSQiDKXz4vSzXq8SZxodriDQRNtbVqv0wtSvBUwkU9+HFm+BlnRiFtCYWhuHsseCESs8ad/10hWqbkkQkxQJAZOvN2+rADB5xlhGS/o6RlzUMW+bapcFy8HHB/AI7SjZJqQaRuztL+jbOpTddqOIJeBdLPjoekvgh9wi1gRNH4QJBAMjfB1xYxmztfbUcUuOsATz3s7StprOAukd+hhBiMukxcKhi1IQp7tFhfFe/+xUY3fSh1a3KlyItFKxp68EdDRk=", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDKxs0adx1X+k4u+a5eZjwD17mvADwgiwDYpMznfNlSNEfDJdFAHIZH0VAbwXnaGySJ/a/MMMTHly5irDMp1udkmHgv2ceW+SumsjEtxliSIKi6af59aYlHiOLGyV5VI/VLVvkE6Roax7fZ+7O858KDahg1JI5smYnpBLKY3X885QIDAQAB").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue()));
    }

    @Test
    public void testArtifactBindingLoginGetArtifactResponseTwice() {
        SamlClientBuilder clientBuilder = new SamlClientBuilder();
        HandleArtifactStepBuilder handleArtifactBuilder = new HandleArtifactStepBuilder(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", clientBuilder);
        SAMLDocumentHolder response = (SAMLDocumentHolder)((ModifySamlResponseStepBuilder)clientBuilder.authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(handleArtifactBuilder).build().processSamlResponse(SamlClient.Binding.ARTIFACT_RESPONSE).transformObject(ob -> {
            MatcherAssert.assertThat((Object)ob, (org.hamcrest.Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            return null;
        })).build().handleArtifact(handleArtifactBuilder).replayPost(true).build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testArtifactSuccessfulAfterFirstUnsuccessfulRequest() {
        SamlClientBuilder clientBuilder = new SamlClientBuilder();
        AtomicReference artifact = new AtomicReference();
        SAMLDocumentHolder response = (SAMLDocumentHolder)clientBuilder.authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/").storeArtifact(artifact).build().assertResponse(r -> MatcherAssert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get())))).handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").useArtifact(artifact).build().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.ARTIFACT_RESPONSE).extractResponse(arg_0));
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
    }

    @Test
    public void testArtifactBindingLoginForceArtifactBinding() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        ResponseType samlResponse = (ResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testArtifactBindingLoginSignedArtifactResponse() throws Exception {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml.server.signature", "true").update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        MatcherAssert.assertThat((Object)artifactResponse.getInResponseTo(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.isEmptyOrNullString()));
        ResponseType samlResponse = (ResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        SamlDeployment deployment = SamlUtils.getSamlDeploymentForClient((String)"sales-post");
        SamlProtocolUtils.verifyDocumentSignature((Document)response.getSamlDocument(), (KeyLocator)deployment.getIDP().getSignatureValidationKeyLocator());
    }

    @Test
    public void testArtifactBindingLoginFullExchangeWithRedirect() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").verifyRedirect(true).build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        MatcherAssert.assertThat((Object)artifactResponse.getInResponseTo(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.isEmptyOrNullString()));
        ResponseType samlResponse = (ResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testArtifactResponseContainsCorrectInResponseTo() {
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").setArtifactResolveId("TestId").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class));
        MatcherAssert.assertThat((Object)artifactResponse.getInResponseTo(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)"TestId"));
    }

    @Test
    public void testArtifactBindingLogoutSingleClientCheckArtifact() throws NoSuchAlgorithmException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml.server.signature", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        String response = (String)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).build().doNotFollowRedirects().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"SAMLart"));
        Pattern artifactPattern = Pattern.compile("NAME=\"SAMLart\" VALUE=\"((?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=))");
        Matcher m = artifactPattern.matcher(response);
        MatcherAssert.assertThat((Object)true, (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)m.find()));
        String artifactB64 = m.group(1);
        MatcherAssert.assertThat((Object)artifactB64, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.isEmptyOrNullString()));
        byte[] artifact = Base64.getDecoder().decode(artifactB64);
        MatcherAssert.assertThat((Object)artifact.length, (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)44));
        MatcherAssert.assertThat((Object)artifact[0], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)artifact[1], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)artifact[2], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)artifact[3], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)0));
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        byte[] source = sha1Digester.digest(this.getAuthServerRealmBase("demo").toString().getBytes(Charsets.UTF_8));
        for (int i = 0; i < 20; ++i) {
            MatcherAssert.assertThat((Object)source[i], (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)artifact[i + 4]));
        }
    }

    @Test
    public void testArtifactBindingLogoutSingleClientPost() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(NameIDMappingResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
        StatusResponseType samlResponse = (StatusResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testArtifactBindingLogoutSingleClientRedirect() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").verifyRedirect(true).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.REDIRECT).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").verifyRedirect(true).build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(NameIDMappingResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
        StatusResponseType samlResponse = (StatusResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @Test
    public void testArtifactBindingLogoutTwoClientsPostWithSig() throws Exception {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post-sig/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SAML_ASSERTION_CONSUMER_URL_SALES_POST2, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/", SAML_ASSERTION_CONSUMER_URL_SALES_POST_SIG, SamlClient.Binding.POST).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().login().sso(true).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/").signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SamlClient.Binding.POST).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post-sig/").signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB").build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(LogoutRequestType.class));
        SamlDeployment deployment = SamlUtils.getSamlDeploymentForClient((String)"sales-post");
        SamlProtocolUtils.verifyDocumentSignature((Document)response.getSamlDocument(), (KeyLocator)deployment.getIDP().getSignatureValidationKeyLocator());
    }

    @Test
    public void testArtifactBindingLogoutTwoClientsRedirect() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update()).addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post2/").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SAML_ASSERTION_CONSUMER_URL_SALES_POST2, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.REDIRECT).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").verifyRedirect(true).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SamlClient.Binding.REDIRECT).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").verifyRedirect(true).build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(LogoutRequestType.class));
    }

    @Test
    public void testArtifactBindingWithBackchannelLogout() {
        try (SamlMessageReceiver backchannelLogoutReceiver = new SamlMessageReceiver(8082);
             ClientAttributeUpdater cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setFrontchannelLogout(Boolean.valueOf(false)).setAttribute("saml_single_logout_service_url_post", backchannelLogoutReceiver.getUrl()).update();){
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SAML_ASSERTION_CONSUMER_URL_SALES_POST2, SamlClient.Binding.POST).build().followOneRedirect().processSamlResponse(SamlClient.Binding.POST).transformObject(this::extractNameIdAndSessionIndexAndTerminate)).build().execute();
            new SamlClientBuilder().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SamlClient.Binding.POST).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).build().executeAndTransform(r -> {
                SAMLDocumentHolder saml2ObjectHolder = SamlClient.Binding.POST.extractResponse(r);
                MatcherAssert.assertThat((Object)saml2ObjectHolder.getSamlObject(), (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
                return null;
            });
            Awaitility.await().pollInterval(100L, TimeUnit.MILLISECONDS).atMost(1L, TimeUnit.MINUTES).until(() -> ((SamlMessageReceiver)backchannelLogoutReceiver).isMessageReceived());
            MatcherAssert.assertThat((Object)backchannelLogoutReceiver.isMessageReceived(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)true));
            SAMLDocumentHolder message = backchannelLogoutReceiver.getSamlDocumentHolder();
            MatcherAssert.assertThat((Object)message.getSamlObject(), (org.hamcrest.Matcher)Matchers.isSamlLogoutRequest((String)backchannelLogoutReceiver.getUrl()));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot run SamlMessageReceiver", e);
        }
    }

    @Test
    public void testArtifactResolveWithWrongIssuerFails() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_post", "http://url").update());
        new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/").build().execute(r -> MatcherAssert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get()))));
    }

    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    @Test
    public void testSessionStateDuringArtifactBindingLogoutWithOneClient() {
        ClientRepresentation salesRep = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        String clientId = salesRep.getId();
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        AtomicReference userSessionId = new AtomicReference();
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").setBeforeStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).storeUserSessionId(userSessionId).expectedState(UserSessionModel.State.LOGGED_IN).expectedClientSession(clientId).consumeUserSession((SerializableConsumer & Serializable)userSessionModel -> MatcherAssert.assertThat((Object)userSessionModel, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue())).consumeClientSession(clientId, (SerializableConsumer & Serializable)userSessionModel -> MatcherAssert.assertThat((Object)userSessionModel, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue()))).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").setBeforeStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).expectedUserSession(userSessionId).expectedState(UserSessionModel.State.LOGGED_OUT_UNCONFIRMED).expectedNumberOfClientSessions(1).expectedAction(clientId, CommonClientSessionModel.Action.LOGGING_OUT)).setAfterStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).consumeUserSession((SerializableConsumer & Serializable)userSessionModel -> MatcherAssert.assertThat((Object)userSessionModel, (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue())).setUserSessionProvider((SerializableFunction & Serializable)session -> (String)userSessionId.get())).build().doNotFollowRedirects().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(NameIDMappingResponseType.class)));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
        StatusResponseType samlResponse = (StatusResponseType)artifactResponse.getAny();
        MatcherAssert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
    }

    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    @Test
    public void testSessionStateDuringArtifactBindingLogoutWithMoreFrontChannelClients() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update()).addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post2/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_artifact", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        ClientRepresentation salesRep = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        String salesRepId = salesRep.getId();
        ClientRepresentation salesRep2 = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post2/").get(0);
        String salesRep2Id = salesRep2.getId();
        AtomicReference userSessionId = new AtomicReference();
        SAMLDocumentHolder response = (SAMLDocumentHolder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SAML_ASSERTION_CONSUMER_URL_SALES_POST2, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/").setBeforeStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).storeUserSessionId(userSessionId).expectedClientSession(salesRep2Id).expectedState(UserSessionModel.State.LOGGED_IN).expectedNumberOfClientSessions(1).consumeUserSession((SerializableConsumer & Serializable)userSessionModel -> MatcherAssert.assertThat((Object)userSessionModel, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue())).consumeClientSession(salesRep2Id, (SerializableConsumer & Serializable)clientSession -> MatcherAssert.assertThat((Object)clientSession, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue()))).verifyRedirect(true).build().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").setBeforeStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).expectedUserSession(userSessionId).expectedState(UserSessionModel.State.LOGGED_IN).expectedClientSession(salesRepId).expectedNumberOfClientSessions(2).expectedAction(salesRep2Id, null).expectedAction(salesRepId, null)).verifyRedirect(true).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/", SamlClient.Binding.REDIRECT).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").setBeforeStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).expectedUserSession(userSessionId).expectedState(UserSessionModel.State.LOGGING_OUT).expectedClientSession(salesRepId).expectedNumberOfClientSessions(2).expectedAction(salesRepId, CommonClientSessionModel.Action.LOGGING_OUT).expectedAction(salesRep2Id, CommonClientSessionModel.Action.LOGGING_OUT)).setAfterStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).setUserSessionProvider((SerializableFunction & Serializable)session -> (String)userSessionId.get()).expectedState(UserSessionModel.State.LOGGING_OUT).expectedNumberOfClientSessions(2).expectedAction(salesRepId, CommonClientSessionModel.Action.LOGGED_OUT).expectedAction(salesRep2Id, CommonClientSessionModel.Action.LOGGING_OUT)).verifyRedirect(true).build().doNotFollowRedirects().processSamlResponse(SamlClient.Binding.ARTIFACT_RESPONSE).transformDocument(doc -> {
            SAML2Object so = (SAML2Object)SAMLParser.getInstance().parse((Source)new DOMSource(doc));
            return new SAML2LogoutResponseBuilder().destination(this.getAuthServerSamlEndpoint("demo").toString()).issuer("http://localhost:8280/sales-post/").logoutRequestID(((LogoutRequestType)so).getID()).buildDocument();
        })).targetBinding(SamlClient.Binding.REDIRECT).targetAttributeSamlResponse().targetUri(this.getAuthServerSamlEndpoint("demo")).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post2/").verifyRedirect(true).setBeforeStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).expectedUserSession(userSessionId).expectedClientSession(salesRep2Id).expectedState(UserSessionModel.State.LOGGED_OUT_UNCONFIRMED).expectedNumberOfClientSessions(2).expectedAction(salesRepId, CommonClientSessionModel.Action.LOGGED_OUT).expectedAction(salesRep2Id, CommonClientSessionModel.Action.LOGGING_OUT)).setAfterStepChecks((Runnable)new SessionStateChecker(this.testingClient.server()).consumeUserSession((SerializableConsumer & Serializable)userSessionModel -> MatcherAssert.assertThat((Object)userSessionModel, (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue())).setUserSessionProvider((SerializableFunction & Serializable)session -> (String)userSessionId.get())).build().executeAndTransform(this::getArtifactResponse);
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class));
        ArtifactResponseType artifactResponse = (ArtifactResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)artifactResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)artifactResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)artifactResponse.getAny(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
    }

    @Test
    public void testArtifactBindingIsNotUsedForLogoutWhenLogoutUrlNotSetRedirect() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_redirect", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.REDIRECT).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").verifyRedirect(true).build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.REDIRECT).build().doNotFollowRedirects().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.REDIRECT).extractResponse(arg_0));
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
        StatusResponseType logoutResponse = (StatusResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)logoutResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class)));
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class)));
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(NameIDMappingResponseType.class)));
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
    }

    @Test
    public void testArtifactBindingIsNotUsedForLogoutWhenLogoutUrlNotSetPostTest() {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_single_logout_service_url_post", "http://url").setFrontchannelLogout(Boolean.valueOf(true)).update());
        SAMLDocumentHolder response = (SAMLDocumentHolder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SAML_ASSERTION_CONSUMER_URL_SALES_POST, SamlClient.Binding.POST).setProtocolBinding(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri()).build().login().user(this.bburkeUser).build().handleArtifact(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/").build().logoutRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/sales-post/", SamlClient.Binding.POST).build().doNotFollowRedirects().executeAndTransform(arg_0 -> ((SamlClient.Binding)SamlClient.Binding.POST).extractResponse(arg_0));
        MatcherAssert.assertThat((Object)response.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
        StatusResponseType logoutResponse = (StatusResponseType)response.getSamlObject();
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        MatcherAssert.assertThat((Object)logoutResponse.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class)));
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(ArtifactResponseType.class)));
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(NameIDMappingResponseType.class)));
        MatcherAssert.assertThat((Object)logoutResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class));
    }

    private SAMLDocumentHolder getArtifactResponse(CloseableHttpResponse response) throws IOException, ParsingException, ProcessingException {
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        Document soapBody = this.extractSoapMessage(response);
        return SAML2Request.getSAML2ObjectFromDocument((Document)soapBody);
    }

    private Document extractSoapMessage(CloseableHttpResponse response) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        Document soapBody = Soap.extractSoapMessage((InputStream)bais);
        response.close();
        return soapBody;
    }

    @Test
    public void testImportClientArtifactResolutionSingleServices() {
        Document doc = IOUtil.loadXML((InputStream)ArtifactBindingTest.class.getResourceAsStream("/saml/sp-metadata-artifact-simple.xml"));
        ClientRepresentation clientRep = this.adminClient.realm("demo").convertClientDescription(IOUtil.documentToString((Document)doc));
        MatcherAssert.assertThat(clientRep.getAttributes().get("saml_artifact_resolution_service_url"), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)"https://test.keycloak.com/auth/login/epd/callback/soap"));
        MatcherAssert.assertThat(clientRep.getAttributes().get("saml_artifact_binding_url"), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)"https://test.keycloak.com/auth/login/epd/callback/http-artifact"));
    }

    @Test
    public void testImportClientMultipleServices() {
        Document doc = IOUtil.loadXML((InputStream)ArtifactBindingTest.class.getResourceAsStream("/saml/sp-metadata-artifact-multiple.xml"));
        ClientRepresentation clientRep = this.adminClient.realm("demo").convertClientDescription(IOUtil.documentToString((Document)doc));
        MatcherAssert.assertThat(clientRep.getAttributes().get("saml_artifact_resolution_service_url"), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)"https://test.keycloak.com/auth/login/epd/callback/soap-1"));
        MatcherAssert.assertThat(clientRep.getAttributes().get("saml_artifact_binding_url"), (org.hamcrest.Matcher)org.hamcrest.Matchers.startsWith((String)"https://test.keycloak.com/auth/login/epd/callback/http-artifact"));
    }

    @Test
    public void testImportClientMultipleServicesWithDefault() {
        Document doc = IOUtil.loadXML((InputStream)ArtifactBindingTest.class.getResourceAsStream("/saml/sp-metadata-artifact-multiple-default.xml"));
        ClientRepresentation clientRep = this.adminClient.realm("demo").convertClientDescription(IOUtil.documentToString((Document)doc));
        MatcherAssert.assertThat(clientRep.getAttributes().get("saml_artifact_resolution_service_url"), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)"https://test.keycloak.com/auth/login/epd/callback/soap-9"));
        MatcherAssert.assertThat(clientRep.getAttributes().get("saml_artifact_binding_url"), (org.hamcrest.Matcher)org.hamcrest.Matchers.startsWith((String)"https://test.keycloak.com/auth/login/epd/callback/http-artifact"));
    }

    @Test
    public void testSPMetadataArtifactBindingNotUsedForLogout() throws ParsingException, URISyntaxException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_artifact_binding_url", "http://url.artifact.test").setAdminUrl("http://admin.url.test").update());
        SPSSODescriptorType spDescriptor = SamlUtils.getSPInstallationDescriptor((ClientsResource)this.adminClient.realm("demo").clients(), (String)"http://localhost:8280/sales-post/");
        MatcherAssert.assertThat((Object)((IndexedEndpointType)spDescriptor.getAssertionConsumerService().get(0)).getBinding(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri())));
        MatcherAssert.assertThat((Object)((IndexedEndpointType)spDescriptor.getAssertionConsumerService().get(0)).getLocation(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)new URI("http://url.artifact.test"))));
        MatcherAssert.assertThat((Object)((EndpointType)spDescriptor.getSingleLogoutService().get(0)).getBinding(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri())));
        MatcherAssert.assertThat((Object)((EndpointType)spDescriptor.getSingleLogoutService().get(0)).getLocation(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)new URI("http://admin.url.test"))));
    }

    @Test
    public void testSPMetadataArtifactBindingUsedForLogout() throws ParsingException, URISyntaxException {
        this.getCleanup().addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setAttribute("saml.artifact.binding", "true").setAttribute("saml_artifact_binding_url", "http://url.artifact.test").setAttribute("saml_single_logout_service_url_artifact", "http://url.artifact.test").setAdminUrl("http://admin.url.test").update());
        SPSSODescriptorType spDescriptor = SamlUtils.getSPInstallationDescriptor((ClientsResource)this.adminClient.realm("demo").clients(), (String)"http://localhost:8280/sales-post/");
        MatcherAssert.assertThat((Object)((IndexedEndpointType)spDescriptor.getAssertionConsumerService().get(0)).getBinding(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri())));
        MatcherAssert.assertThat((Object)((IndexedEndpointType)spDescriptor.getAssertionConsumerService().get(0)).getLocation(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)new URI("http://url.artifact.test"))));
        MatcherAssert.assertThat((Object)((EndpointType)spDescriptor.getSingleLogoutService().get(0)).getBinding(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri())));
        MatcherAssert.assertThat((Object)((EndpointType)spDescriptor.getSingleLogoutService().get(0)).getLocation(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)new URI("http://url.artifact.test"))));
    }

    @Test
    public void testArtifactBindingIdentifierChangedWhenClientIdChanged() throws IOException {
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        String oldIdentifier = (String)clientRepresentation.getAttributes().get("saml.artifact.binding.identifier");
        MatcherAssert.assertThat((Object)oldIdentifier, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        String newClientId = "new_client_id";
        try (ClientAttributeUpdater cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"demo", (String)"http://localhost:8280/sales-post/").setClientId("new_client_id").update();){
            clientRepresentation = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("new_client_id").get(0);
            String identifier = (String)clientRepresentation.getAttributes().get("saml.artifact.binding.identifier");
            MatcherAssert.assertThat((Object)identifier, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)oldIdentifier)));
            MatcherAssert.assertThat((Object)identifier, (org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)ArtifactBindingUtils.computeArtifactBindingIdentifierString((String)"new_client_id")));
        }
        clientRepresentation = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/sales-post/").get(0);
        MatcherAssert.assertThat(clientRepresentation.getAttributes().get("saml.artifact.binding.identifier"), (org.hamcrest.Matcher)org.hamcrest.Matchers.equalTo((Object)oldIdentifier));
    }
}

