/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.policy;

import java.util.function.Consumer;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.admin.ApiUtil;

public class PasswordHistoryPolicyTest
extends AbstractAuthTest {
    UserResource user;

    private void setPasswordHistory(String passwordHistory) {
        this.log.info((Object)String.format("Setting %s", passwordHistory));
        RealmRepresentation testRealmRepresentation = this.testRealmResource().toRepresentation();
        testRealmRepresentation.setPasswordPolicy(passwordHistory);
        this.testRealmResource().update(testRealmRepresentation);
    }

    private void setPasswordHistoryValue(String value) {
        this.setPasswordHistory(String.format("passwordHistory(%s)", value));
    }

    private void setPasswordHistoryValue(int value) {
        this.setPasswordHistoryValue(String.valueOf(value));
    }

    public UserRepresentation createUserRepresentation(String username) {
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setUsername(username);
        userRepresentation.setEmail(String.format("%s@email.test", userRepresentation.getUsername()));
        userRepresentation.setEmailVerified(Boolean.valueOf(true));
        return userRepresentation;
    }

    public UserResource createUser(UserRepresentation user) {
        String createdUserId;
        try (Response response = this.testRealmResource().users().create(user);){
            createdUserId = ApiUtil.getCreatedId((Response)response);
        }
        return this.testRealmResource().users().get(createdUserId);
    }

    public void resetUserPassword(UserResource userResource, String newPassword) {
        CredentialRepresentation newCredential = new CredentialRepresentation();
        newCredential.setType("password");
        newCredential.setValue(newPassword);
        newCredential.setTemporary(Boolean.valueOf(false));
        userResource.resetPassword(newCredential);
    }

    private void expectBadRequestException(Consumer<Void> f) {
        try {
            f.accept(null);
            throw new AssertionError((Object)"An expected BadRequestException was not thrown.");
        }
        catch (BadRequestException bre) {
            this.log.info((Object)"An expected BadRequestException was caught.");
            return;
        }
    }

    @Before
    public void before() {
        this.user = this.createUser(this.createUserRepresentation("test_user"));
    }

    @After
    public void after() {
        this.user.remove();
    }

    @Test
    public void testPasswordHistory_noHistory() {
        this.setPasswordHistory("");
        this.resetUserPassword(this.user, "secret");
        this.resetUserPassword(this.user, "secret");
    }

    @Test
    public void testPasswordHistory_length1() {
        this.setPasswordHistoryValue(1);
        this.resetUserPassword(this.user, "secret");
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret"));
        this.resetUserPassword(this.user, "secret_2");
    }

    @Test
    public void testPasswordHistory_length2() {
        this.setPasswordHistoryValue(2);
        this.resetUserPassword(this.user, "secret");
        this.resetUserPassword(this.user, "secret_2");
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_2"));
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret"));
        this.resetUserPassword(this.user, "secret_3");
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_3"));
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_2"));
        this.resetUserPassword(this.user, "secret");
    }

    @Test
    public void testPasswordHistory_length3() {
        this.setPasswordHistoryValue(3);
        this.resetUserPassword(this.user, "secret");
        this.resetUserPassword(this.user, "secret_2");
        this.resetUserPassword(this.user, "secret_3");
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_3"));
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_2"));
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret"));
        this.resetUserPassword(this.user, "secret_4");
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_4"));
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_3"));
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_2"));
        this.resetUserPassword(this.user, "secret");
    }

    @Test
    public void testPasswordHistory_lengthChange() {
        this.testPasswordHistory_length3();
        this.setPasswordHistoryValue(2);
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret"));
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_4"));
        this.resetUserPassword(this.user, "secret_2");
        this.setPasswordHistoryValue(1);
        this.expectBadRequestException(f -> this.resetUserPassword(this.user, "secret_2"));
        this.resetUserPassword(this.user, "secret");
        this.setPasswordHistory("");
        this.resetUserPassword(this.user, "secret");
    }

    @Test
    public void testInvalidPasswordHistoryPolicyValue_notANumber() {
        this.expectBadRequestException(f -> this.setPasswordHistoryValue("abc"));
        this.expectBadRequestException(f -> this.setPasswordHistoryValue("2-"));
        this.expectBadRequestException(f -> this.setPasswordHistoryValue("-2-"));
    }

    @Test
    @Ignore(value="KEYCLOAK-12673")
    public void testInvalidPasswordHistoryPolicyValue_zero() {
        this.expectBadRequestException(f -> this.setPasswordHistoryValue(0));
    }

    @Test
    @Ignore(value="KEYCLOAK-12673")
    public void testInvalidPasswordHistoryPolicyValue_negative() {
        this.expectBadRequestException(f -> this.setPasswordHistoryValue(-1));
        this.expectBadRequestException(f -> this.setPasswordHistoryValue(-2));
        this.expectBadRequestException(f -> this.setPasswordHistoryValue(-10));
    }
}

