/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.par;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.client.AbstractClientPoliciesTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientPoliciesUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.util.JsonSerialization;

public class ParTest
extends AbstractClientPoliciesTest {
    private static final String TEST_USER_NAME = "test-user@localhost";
    private static final String TEST_USER_PASSWORD = "password";
    private static final String TEST_USER2_NAME = "john-doh@localhost";
    private static final String TEST_USER2_PASSWORD = "password";
    private static final String CLIENT_NAME = "Zahlungs-App";
    private static final String CLIENT_REDIRECT_URI = "https://localhost:8543/auth/realms/test/app/auth/cb";
    private static final String IMAGINARY_REQUEST_URI = "urn:ietf:params:oauth:request_uri:AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    private static final int DEFAULT_REQUEST_URI_LIFESPAN = 60;
    private static final String VALID_CORS_URL = "http://localtest.me:8180";
    private static final String INVALID_CORS_URL = "http://invalid.localtest.me:8180";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        List users = realm.getUsers();
        LinkedList<CredentialRepresentation> credentials = new LinkedList<CredentialRepresentation>();
        CredentialRepresentation password = new CredentialRepresentation();
        password.setType("password");
        password.setValue("password");
        credentials.add(password);
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername("manage-clients");
        user.setCredentials(credentials);
        user.setClientRoles(Collections.singletonMap("realm-management", Collections.singletonList(AdminRoles.MANAGE_CLIENTS)));
        users.add(user);
        user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername("create-clients");
        user.setCredentials(credentials);
        user.setClientRoles(Collections.singletonMap("realm-management", Collections.singletonList(AdminRoles.CREATE_CLIENT)));
        user.setGroups(Arrays.asList("topGroup"));
        users.add(user);
        realm.setUsers(users);
        realm.getClients().add(ClientBuilder.create().redirectUris("http://localtest.me:8180/realms/master/app").addWebOrigin(VALID_CORS_URL).clientId("test-app2").publicClient().directAccessGrants().build());
        testRealms.add(realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessfulSinglePar() throws Exception {
        try {
            int requestUriLifespan = 45;
            this.setParRealmSettings(requestUriLifespan);
            String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
                clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
                clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
            });
            OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
            String clientSecret = oidcCRep.getClientSecret();
            Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
            Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
            Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
            this.oauth.clientId(clientId);
            this.oauth.redirectUri(CLIENT_REDIRECT_URI);
            OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
            Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
            String requestUri = pResp.getRequestUri();
            Assert.assertEquals((long)requestUriLifespan, (long)pResp.getExpiresIn());
            this.oauth.redirectUri(null);
            this.oauth.scope(null);
            this.oauth.responseType(null);
            this.oauth.requestUri(requestUri);
            String state = this.oauth.stateParamRandom().getState();
            this.oauth.stateParamHardcoded(state);
            OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
            Assert.assertEquals((Object)state, (Object)loginResponse.getState());
            String code = loginResponse.getCode();
            String sessionId = loginResponse.getSessionState();
            this.oauth.redirectUri(CLIENT_REDIRECT_URI);
            OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            AccessToken token = this.oauth.verifyToken(res.getAccessToken());
            String userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER_NAME).getId();
            Assert.assertEquals((Object)userId, (Object)token.getSubject());
            Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
            Assert.assertNotEquals((Object)TEST_USER_NAME, (Object)token.getSubject());
            Assert.assertEquals((Object)clientId, (Object)token.getIssuedFor());
            String refreshTokenString = res.getRefreshToken();
            RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
            Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
            Assert.assertEquals((Object)clientId, (Object)refreshToken.getIssuedFor());
            OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(refreshTokenString, clientSecret);
            Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
            AccessToken refreshedToken = this.oauth.verifyToken(refreshResponse.getAccessToken());
            RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshResponse.getRefreshToken());
            Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
            Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
            Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER_NAME).getId(), (Object)refreshedToken.getSubject());
            this.oauth.doLogout(refreshResponse.getRefreshToken(), clientSecret);
            refreshResponse = this.oauth.doRefreshTokenRequest(refreshResponse.getRefreshToken(), clientSecret);
            Assert.assertEquals((long)400L, (long)refreshResponse.getStatusCode());
        }
        finally {
            this.restoreParRealmSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrongSigningAlgorithmForRequestObject() throws Exception {
        try {
            int requestUriLifespan = 45;
            this.setParRealmSettings(requestUriLifespan);
            String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
                clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
                clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
                clientRep.setRequestObjectSigningAlg("PS256");
            });
            this.oauth.clientId(clientId);
            OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
            String clientSecret = oidcCRep.getClientSecret();
            Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
            Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
            Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
            requestObject.id(KeycloakModelUtils.generateId());
            requestObject.iat(Long.valueOf(Time.currentTime()));
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.setClientId(this.oauth.getClientId());
            requestObject.setResponseType("code");
            requestObject.setRedirectUriParam(CLIENT_REDIRECT_URI);
            requestObject.setScope("openid");
            requestObject.setNonce(KeycloakModelUtils.generateId());
            byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
            String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
            TestOIDCEndpointsApplicationResource client = this.testingClient.testApp().oidcClientEndpoints();
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
            ClientRepresentation clientRep2 = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setUseJwksUrl(true);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setJwksUrl(TestApplicationResourceUrls.clientJwksUri());
            clientResource.update(clientRep2);
            client.generateKeys("RS256");
            client.registerOIDCRequest(encodedRequestObject, "RS256");
            this.oauth.request(client.getOIDCRequest());
            this.oauth.responseType(null);
            this.oauth.redirectUri(null);
            this.oauth.scope(null);
            OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
            Assert.assertEquals((long)400L, (long)pResp.getStatusCode());
            Assert.assertEquals((Object)"invalid_request_object", (Object)pResp.getError());
        }
        finally {
            this.restoreParRealmSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessfulUsingRequestParameter() throws Exception {
        try {
            int requestUriLifespan = 45;
            this.setParRealmSettings(requestUriLifespan);
            String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
                clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
                clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
            });
            this.oauth.clientId(clientId);
            OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
            String clientSecret = oidcCRep.getClientSecret();
            Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
            Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
            Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
            requestObject.id(KeycloakModelUtils.generateId());
            requestObject.iat(Long.valueOf(Time.currentTime()));
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.setClientId(this.oauth.getClientId());
            requestObject.setResponseType("code");
            requestObject.setRedirectUriParam(CLIENT_REDIRECT_URI);
            requestObject.setScope("openid");
            requestObject.setNonce(KeycloakModelUtils.generateId());
            byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
            String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
            TestOIDCEndpointsApplicationResource client = this.testingClient.testApp().oidcClientEndpoints();
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
            ClientRepresentation clientRep2 = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setUseJwksUrl(true);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setJwksUrl(TestApplicationResourceUrls.clientJwksUri());
            clientResource.update(clientRep2);
            client.generateKeys("RS256");
            client.registerOIDCRequest(encodedRequestObject, "RS256");
            this.oauth.request(client.getOIDCRequest());
            this.oauth.responseType(null);
            this.oauth.redirectUri(null);
            this.oauth.scope(null);
            OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
            Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
            String requestUri = pResp.getRequestUri();
            Assert.assertEquals((long)requestUriLifespan, (long)pResp.getExpiresIn());
            this.oauth.redirectUri(null);
            this.oauth.scope(null);
            this.oauth.responseType(null);
            this.oauth.request(null);
            this.oauth.requestUri(requestUri);
            OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
            this.oauth.redirectUri(CLIENT_REDIRECT_URI);
            OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(loginResponse.getCode(), clientSecret);
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            this.oauth.verifyToken(res.getAccessToken());
            IDToken idToken = this.oauth.verifyIDToken(res.getIdToken());
            Assert.assertEquals((Object)requestObject.getNonce(), (Object)idToken.getNonce());
        }
        finally {
            this.restoreParRealmSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestParameterPrecedenceOverOtherParameters() throws Exception {
        try {
            int requestUriLifespan = 45;
            this.setParRealmSettings(requestUriLifespan);
            String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
                clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
                clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
            });
            this.oauth.clientId(clientId);
            OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
            String clientSecret = oidcCRep.getClientSecret();
            Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
            Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
            Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
            requestObject.id(KeycloakModelUtils.generateId());
            requestObject.iat(Long.valueOf(Time.currentTime()));
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.setClientId(this.oauth.getClientId());
            requestObject.setResponseType("code");
            requestObject.setRedirectUriParam(CLIENT_REDIRECT_URI);
            requestObject.setScope("openid");
            requestObject.setNonce(KeycloakModelUtils.generateId());
            requestObject.setState(this.oauth.stateParamRandom().getState());
            byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
            String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
            TestOIDCEndpointsApplicationResource client = this.testingClient.testApp().oidcClientEndpoints();
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
            ClientRepresentation clientRep2 = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setUseJwksUrl(true);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setJwksUrl(TestApplicationResourceUrls.clientJwksUri());
            clientResource.update(clientRep2);
            client.generateKeys("RS256");
            client.registerOIDCRequest(encodedRequestObject, "RS256");
            this.oauth.request(client.getOIDCRequest());
            this.oauth.responseType("code id_token");
            this.oauth.redirectUri("http://invalid");
            this.oauth.scope(null);
            this.oauth.nonce("12345");
            OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
            Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
            String requestUri = pResp.getRequestUri();
            Assert.assertEquals((long)requestUriLifespan, (long)pResp.getExpiresIn());
            this.oauth.scope("invalid");
            this.oauth.redirectUri("http://invalid");
            this.oauth.responseType("invalid");
            this.oauth.redirectUri(null);
            this.oauth.nonce("12345");
            this.oauth.request(null);
            this.oauth.requestUri(requestUri);
            String wrongState = this.oauth.stateParamRandom().getState();
            this.oauth.stateParamHardcoded(wrongState);
            OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
            Assert.assertEquals((Object)requestObject.getState(), (Object)loginResponse.getState());
            Assert.assertNotEquals((Object)requestObject.getState(), (Object)wrongState);
            this.oauth.redirectUri(CLIENT_REDIRECT_URI);
            OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(loginResponse.getCode(), clientSecret);
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            this.oauth.verifyToken(res.getAccessToken());
            IDToken idToken = this.oauth.verifyIDToken(res.getIdToken());
            Assert.assertEquals((Object)requestObject.getNonce(), (Object)idToken.getNonce());
        }
        finally {
            this.restoreParRealmSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoreParameterIfNotSetinRequestObject() throws Exception {
        try {
            int requestUriLifespan = 45;
            this.setParRealmSettings(requestUriLifespan);
            String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
                clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
                clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
            });
            this.oauth.clientId(clientId);
            OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
            String clientSecret = oidcCRep.getClientSecret();
            Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
            Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
            Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
            requestObject.id(KeycloakModelUtils.generateId());
            requestObject.iat(Long.valueOf(Time.currentTime()));
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.setClientId(this.oauth.getClientId());
            requestObject.setResponseType("code");
            requestObject.setRedirectUriParam(CLIENT_REDIRECT_URI);
            requestObject.setScope("openid");
            requestObject.setNonce(KeycloakModelUtils.generateId());
            byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
            String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
            TestOIDCEndpointsApplicationResource client = this.testingClient.testApp().oidcClientEndpoints();
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
            ClientRepresentation clientRep2 = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setUseJwksUrl(true);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setJwksUrl(TestApplicationResourceUrls.clientJwksUri());
            clientResource.update(clientRep2);
            client.generateKeys("RS256");
            client.registerOIDCRequest(encodedRequestObject, "RS256");
            this.oauth.request(client.getOIDCRequest());
            this.oauth.responseType("code id_token");
            this.oauth.redirectUri("http://invalid");
            this.oauth.scope(null);
            this.oauth.nonce("12345");
            OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
            Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
            String requestUri = pResp.getRequestUri();
            Assert.assertEquals((long)requestUriLifespan, (long)pResp.getExpiresIn());
            this.oauth.scope("invalid");
            this.oauth.redirectUri("http://invalid");
            this.oauth.responseType("invalid");
            this.oauth.redirectUri(null);
            this.oauth.nonce("12345");
            this.oauth.request(null);
            this.oauth.requestUri(requestUri);
            String wrongState = this.oauth.stateParamRandom().getState();
            this.oauth.stateParamHardcoded(wrongState);
            OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
            Assert.assertNull((Object)loginResponse.getState());
            Assert.assertNotEquals((Object)requestObject.getState(), (Object)wrongState);
            this.oauth.redirectUri(CLIENT_REDIRECT_URI);
            OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(loginResponse.getCode(), clientSecret);
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            this.oauth.verifyToken(res.getAccessToken());
            IDToken idToken = this.oauth.verifyIDToken(res.getIdToken());
            Assert.assertEquals((Object)requestObject.getNonce(), (Object)idToken.getNonce());
        }
        finally {
            this.restoreParRealmSettings();
        }
    }

    @Test
    public void testSuccessfulMultipleParBySameClient() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.FALSE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUriOne = pResp.getRequestUri();
        this.oauth.clientId(clientId);
        this.oauth.scope("microprofile-jwt profile");
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUriTwo = pResp.getRequestUri();
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUriTwo);
        String state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER2_NAME, "password");
        Assert.assertEquals((Object)state, (Object)loginResponse.getState());
        String code = loginResponse.getCode();
        String sessionId = loginResponse.getSessionState();
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        AccessToken token = this.oauth.verifyToken(res.getAccessToken());
        String userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER2_NAME).getId();
        Assert.assertEquals((Object)userId, (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertNotEquals((Object)TEST_USER2_NAME, (Object)token.getSubject());
        Assert.assertEquals((Object)clientId, (Object)token.getIssuedFor());
        Assert.assertTrue((boolean)token.getScope().contains("openid"));
        Assert.assertTrue((boolean)token.getScope().contains("microprofile-jwt"));
        Assert.assertTrue((boolean)token.getScope().contains("profile"));
        this.oauth.doLogout(res.getRefreshToken(), clientSecret);
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUriOne);
        state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
        Assert.assertEquals((Object)state, (Object)loginResponse.getState());
        code = loginResponse.getCode();
        sessionId = loginResponse.getSessionState();
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        token = this.oauth.verifyToken(res.getAccessToken());
        userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER_NAME).getId();
        Assert.assertEquals((Object)userId, (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertNotEquals((Object)TEST_USER_NAME, (Object)token.getSubject());
        Assert.assertEquals((Object)clientId, (Object)token.getIssuedFor());
        Assert.assertFalse((boolean)token.getScope().contains("microprofile-jwt"));
        Assert.assertTrue((boolean)token.getScope().contains("openid"));
    }

    @Test
    public void testSuccessfulMultipleParByMultipleClients() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.FALSE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
        this.authManageClients();
        String client2Id = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcC2Rep = this.getClientDynamically(client2Id);
        String client2Secret = oidcC2Rep.getClientSecret();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcC2Rep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcC2Rep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcC2Rep.getTokenEndpointAuthMethod());
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUriOne = pResp.getRequestUri();
        this.oauth.clientId(client2Id);
        this.oauth.scope("microprofile-jwt profile");
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        pResp = this.oauth.doPushedAuthorizationRequest(client2Id, client2Secret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUriTwo = pResp.getRequestUri();
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUriTwo);
        String state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER2_NAME, "password");
        Assert.assertEquals((Object)state, (Object)loginResponse.getState());
        String code = loginResponse.getCode();
        String sessionId = loginResponse.getSessionState();
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, client2Secret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        AccessToken token = this.oauth.verifyToken(res.getAccessToken());
        String userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER2_NAME).getId();
        Assert.assertEquals((Object)userId, (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertNotEquals((Object)TEST_USER2_NAME, (Object)token.getSubject());
        Assert.assertEquals((Object)client2Id, (Object)token.getIssuedFor());
        Assert.assertTrue((boolean)token.getScope().contains("openid"));
        Assert.assertTrue((boolean)token.getScope().contains("microprofile-jwt"));
        Assert.assertTrue((boolean)token.getScope().contains("profile"));
        this.oauth.doLogout(res.getRefreshToken(), client2Secret);
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUriOne);
        state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
        Assert.assertEquals((Object)state, (Object)loginResponse.getState());
        code = loginResponse.getCode();
        sessionId = loginResponse.getSessionState();
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        token = this.oauth.verifyToken(res.getAccessToken());
        userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER_NAME).getId();
        Assert.assertEquals((Object)userId, (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertNotEquals((Object)TEST_USER_NAME, (Object)token.getSubject());
        Assert.assertEquals((Object)clientId, (Object)token.getIssuedFor());
        Assert.assertFalse((boolean)token.getScope().contains("microprofile-jwt"));
        Assert.assertTrue((boolean)token.getScope().contains("openid"));
    }

    @Test
    public void testFailureNotIssuedParUsed() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI))));
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(IMAGINARY_REQUEST_URI);
        String state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertFalse((boolean)errorResponse.isRedirected());
    }

    @Test
    public void testFailureParUsedTwice() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUri = pResp.getRequestUri();
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUri);
        String state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
        Assert.assertEquals((Object)state, (Object)loginResponse.getState());
        String code = loginResponse.getCode();
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertFalse((boolean)errorResponse.isRedirected());
    }

    @Test
    public void testFailureParUsedByOtherClient() throws Exception {
        String victimClientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.FALSE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation victimOidcCRep = this.getClientDynamically(victimClientId);
        String victimClientSecret = victimOidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)victimOidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)victimOidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)victimOidcCRep.getTokenEndpointAuthMethod());
        this.authManageClients();
        String attackerClientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation attackerOidcCRep = this.getClientDynamically(attackerClientId);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)attackerOidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)attackerOidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)attackerOidcCRep.getTokenEndpointAuthMethod());
        this.oauth.clientId(victimClientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(victimClientId, victimClientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUri = pResp.getRequestUri();
        this.oauth.clientId(attackerClientId);
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUri);
        String state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertFalse((boolean)errorResponse.isRedirected());
    }

    @Test
    public void testFailureNotParByParRequiredCilent() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE));
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Pushed Authorization Request is only allowed.", this.oauth.getCurrentQuery().get("error_description"));
        this.updateClientDynamically(clientId, clientRep -> clientRep.setRequirePushedAuthorizationRequests(Boolean.FALSE));
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
        String code = loginResponse.getCode();
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testFailureParExpired() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI))));
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUri = pResp.getRequestUri();
        int expiresIn = pResp.getExpiresIn();
        this.setTimeOffset(expiresIn + 5);
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUri);
        String state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertFalse((boolean)errorResponse.isRedirected());
    }

    @Test
    public void testFailureClientAuthnFailed() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret + "abc");
        Assert.assertEquals((long)401L, (long)pResp.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)pResp.getError());
        Assert.assertEquals((Object)"Authentication failed.", (Object)pResp.getErrorDescription());
    }

    @Test
    public void testFailureParIncludesRequestUri() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.FALSE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        this.oauth.requestUri(IMAGINARY_REQUEST_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)400L, (long)pResp.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)pResp.getError());
        Assert.assertEquals((Object)"It is not allowed to include request_uri to PAR.", (Object)pResp.getErrorDescription());
    }

    @Test
    public void testFailureInvalidPar() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI))));
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        this.updateClientByAdmin(clientId, cRep -> OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)cRep).setRequestObjectRequired("request only"));
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)400L, (long)pResp.getStatusCode());
        Assert.assertEquals((Object)"invalid_request_object", (Object)pResp.getError());
    }

    @Test
    public void testFailureParIncludesInvalidRedirectUri() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(INVALID_CORS_URL);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)400L, (long)pResp.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)pResp.getError());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)pResp.getErrorDescription());
    }

    @Test
    public void testFailureParIncludesInvalidResponseType() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.FALSE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        this.oauth.responseType(null);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)400L, (long)pResp.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)pResp.getError());
        Assert.assertEquals((Object)"Missing parameter: response_type", (Object)pResp.getErrorDescription());
    }

    @Test
    public void testFailureParIncludesInvalidScope() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI))));
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        this.oauth.scope("not_registered_scope");
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)400L, (long)pResp.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)pResp.getError());
        Assert.assertEquals((Object)"Invalid scopes: openid not_registered_scope", (Object)pResp.getErrorDescription());
    }

    @Test
    public void testFailureParInvalidPkceSetting() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        this.updateClientByAdmin(clientId, cRep -> OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)cRep).setPkceCodeChallengeMethod("S256"));
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)400L, (long)pResp.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)pResp.getError());
        Assert.assertEquals((Object)"Missing parameter: code_challenge_method", (Object)pResp.getErrorDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParCorsRequestWithValidUrl() throws Exception {
        try {
            String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
                clientRep.setRequirePushedAuthorizationRequests(Boolean.FALSE);
                clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI, "http://localtest.me:8180/realms/master/app")));
            });
            OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
            String clientSecret = oidcCRep.getClientSecret();
            Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
            Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
            Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
            this.updateClientByAdmin(clientId, cRep -> cRep.setOrigin(VALID_CORS_URL));
            this.oauth.clientId(clientId);
            this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
            this.oauth.origin(VALID_CORS_URL);
            OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret, c -> ParTest.assertCors(c));
            Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
            String requestUri = pResp.getRequestUri();
            this.doNormalAuthzProcess(requestUri, "http://localtest.me:8180/realms/master/app", clientId, clientSecret);
        }
        finally {
            this.oauth.origin(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParCorsRequestWithInvalidUrlShouldFail() throws Exception {
        try {
            String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI, "http://localtest.me:8180/realms/master/app"))));
            OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
            String clientSecret = oidcCRep.getClientSecret();
            Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
            Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
            Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
            this.updateClientByAdmin(clientId, cRep -> cRep.setOrigin(VALID_CORS_URL));
            this.oauth.clientId(clientId);
            this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
            this.oauth.origin(INVALID_CORS_URL);
            OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret, c -> ParTest.assertNotCors(c));
            Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
            String requestUri = pResp.getRequestUri();
            this.doNormalAuthzProcess(requestUri, "http://localtest.me:8180/realms/master/app", clientId, clientSecret);
        }
        finally {
            this.oauth.origin(null);
        }
    }

    @Test
    public void testExtendedClientPolicyIntefacesForPar() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
            clientRep.setRequirePushedAuthorizationRequests(Boolean.TRUE);
            clientRep.setRedirectUris(new ArrayList<String>(Arrays.asList(CLIENT_REDIRECT_URI)));
        });
        OIDCClientRepresentation oidcCRep = this.getClientDynamically(clientId);
        String clientSecret = oidcCRep.getClientSecret();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)oidcCRep.getRequirePushedAuthorizationRequests());
        Assert.assertTrue((boolean)oidcCRep.getRedirectUris().contains(CLIENT_REDIRECT_URI));
        Assert.assertEquals((Object)"client_secret_basic", (Object)oidcCRep.getTokenEndpointAuthMethod());
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        String roleName = "sample-client-role-alpha";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politikken", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleName))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        clientResource.roles().create(RoleBuilder.create().name(roleName).build());
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(CLIENT_REDIRECT_URI);
        OAuthClient.ParResponse response = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)ClientPolicyEvent.PUSHED_AUTHORIZATION_REQUEST.toString(), (Object)response.getError());
        Assert.assertEquals((Object)"Exception thrown intentionally", (Object)response.getErrorDescription());
    }

    private void doNormalAuthzProcess(String requestUri, String redirectUrl, String clientId, String clientSecret) {
        this.oauth.redirectUri(null);
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.requestUri(requestUri);
        String state = this.oauth.stateParamRandom().getState();
        this.oauth.stateParamHardcoded(state);
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, "password");
        Assert.assertEquals((Object)state, (Object)loginResponse.getState());
        String code = loginResponse.getCode();
        String sessionId = loginResponse.getSessionState();
        this.oauth.redirectUri(redirectUrl);
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        AccessToken token = this.oauth.verifyToken(res.getAccessToken());
        String userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER_NAME).getId();
        Assert.assertEquals((Object)userId, (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertNotEquals((Object)TEST_USER_NAME, (Object)token.getSubject());
        Assert.assertEquals((Object)clientId, (Object)token.getIssuedFor());
        String refreshTokenString = res.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        Assert.assertEquals((Object)clientId, (Object)refreshToken.getIssuedFor());
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(refreshTokenString, clientSecret);
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
        AccessToken refreshedToken = this.oauth.verifyToken(refreshResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshResponse.getRefreshToken());
        Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)TEST_USER_NAME).getId(), (Object)refreshedToken.getSubject());
        this.oauth.doLogout(refreshResponse.getRefreshToken(), clientSecret);
        refreshResponse = this.oauth.doRefreshTokenRequest(refreshResponse.getRefreshToken(), clientSecret);
        Assert.assertEquals((long)400L, (long)refreshResponse.getStatusCode());
    }

    private void setParRealmSettings(int requestUriLifespan) {
        RealmRepresentation rep = this.adminClient.realm("test").toRepresentation();
        Map attributes = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
        attributes.put("parRequestUriLifespan", String.valueOf(requestUriLifespan));
        rep.setAttributes(attributes);
        this.adminClient.realm("test").update(rep);
    }

    private void restoreParRealmSettings() {
        this.setParRealmSettings(60);
    }

    private static void assertCors(CloseableHttpResponse response) {
        Assert.assertEquals((Object)"true", (Object)response.getHeaders("Access-Control-Allow-Credentials")[0].getValue());
        Assert.assertEquals((Object)VALID_CORS_URL, (Object)response.getHeaders("Access-Control-Allow-Origin")[0].getValue());
        Assert.assertEquals((Object)"Access-Control-Allow-Methods", (Object)response.getHeaders("Access-Control-Expose-Headers")[0].getValue());
    }

    private static void assertNotCors(CloseableHttpResponse response) {
        Assert.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Credentials").length);
        Assert.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Origin").length);
        Assert.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Expose-Headers").length);
    }
}

