/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.openshift;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ConsentPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@EnableFeature(value=Profile.Feature.OPENSHIFT_INTEGRATION, skipRestart=true)
public final class OpenshiftClientStorageTest
extends AbstractTestRealmKeycloakTest {
    private static Undertow OPENSHIFT_API_SERVER;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    private LoginPage loginPage;
    @Page
    private AppPage appPage;
    @Page
    private ConsentPage consentPage;
    @Page
    private ErrorPage errorPage;
    private String userId;
    private String clientStorageId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @BeforeClass
    public static void onBeforeClass() {
        OPENSHIFT_API_SERVER = Undertow.builder().addHttpListener(8880, "localhost", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String uri = exchange.getRequestURI();
                if (uri.endsWith("/version/openshift") || uri.endsWith("/version")) {
                    this.writeResponse("openshift-version.json", exchange);
                } else if (uri.endsWith("/oapi")) {
                    this.writeResponse("oapi-response.json", exchange);
                } else if (uri.endsWith("/apis")) {
                    this.writeResponse("apis-response.json", exchange);
                } else if (uri.endsWith("/api")) {
                    this.writeResponse("api.json", exchange);
                } else if (uri.endsWith("/api/v1")) {
                    this.writeResponse("api-v1.json", exchange);
                } else if (uri.endsWith("/oapi/v1")) {
                    this.writeResponse("oapi-v1.json", exchange);
                } else if (uri.contains("/apis/route.openshift.io/v1")) {
                    this.writeResponse("apis-route-v1.json", exchange);
                } else if (uri.endsWith("/api/v1/namespaces/default")) {
                    this.writeResponse("namespace-default.json", exchange);
                } else if (uri.endsWith("/oapi/v1/namespaces/default/routes/proxy")) {
                    this.writeResponse("route-response.json", exchange);
                } else if (uri.contains("/serviceaccounts/system")) {
                    this.writeResponse("sa-system.json", exchange);
                } else if (uri.contains("/serviceaccounts/")) {
                    this.writeResponse(uri.substring(uri.lastIndexOf(47) + 1) + ".json", exchange);
                }
            }

            private void writeResponse(String file, HttpServerExchange exchange) throws IOException {
                exchange.getResponseSender().send(StreamUtil.readString((InputStream)this.getClass().getResourceAsStream("/openshift/client-storage/" + file)));
            }
        }).build();
        OPENSHIFT_API_SERVER.start();
    }

    @AfterClass
    public static void onAfterClass() {
        if (OPENSHIFT_API_SERVER != null) {
            OPENSHIFT_API_SERVER.stop();
        }
    }

    @Before
    public void onBefore() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.OPENSHIFT_INTEGRATION);
        ComponentRepresentation provider = new ComponentRepresentation();
        provider.setName("openshift-client-storage");
        provider.setProviderId("openshift-oauth-client");
        provider.setProviderType(ClientStorageProvider.class.getName());
        provider.setConfig(new MultivaluedHashMap());
        provider.getConfig().putSingle((Object)"openshift.uri", (Object)"http://localhost:8880");
        provider.getConfig().putSingle((Object)"openshift.access_token", (Object)"token");
        provider.getConfig().putSingle((Object)"openshift.namespace.default", (Object)"default");
        provider.getConfig().putSingle((Object)"user.consent.require", (Object)"true");
        Response resp = this.adminClient.realm("test").components().add(provider);
        resp.close();
        this.clientStorageId = ApiUtil.getCreatedId((Response)resp);
        this.getCleanup().addComponentId(this.clientStorageId);
    }

    @Before
    public void clientConfiguration() {
        this.userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId();
    }

    @Test
    public void testCodeGrantFlowWithServiceAccountUsingOAuthRedirectReference() {
        String clientId = "system:serviceaccount:default:sa-oauth-redirect-reference";
        this.testCodeGrantFlow(clientId, "https://myapp.org/callback", () -> this.assertSuccessfulResponseWithoutConsent(clientId));
    }

    @Test
    public void failCodeGrantFlowWithServiceAccountUsingOAuthRedirectReference() throws Exception {
        this.testCodeGrantFlow("system:serviceaccount:default:sa-oauth-redirect-reference", "http://myapp.org/callback", () -> Assert.assertEquals((Object)"invalid_redirect_uri", (Object)this.events.poll().getError()));
    }

    @Test
    public void testCodeGrantFlowWithServiceAccountUsingOAuthRedirectUri() {
        String clientId = "system:serviceaccount:default:sa-oauth-redirect-uri";
        this.testCodeGrantFlow(clientId, "http://localhost:8180/auth/realms/master/app/auth", () -> this.assertSuccessfulResponseWithoutConsent(clientId));
        this.testCodeGrantFlow(clientId, "http://localhost:8180/auth/realms/master/app/auth/second", () -> this.assertSuccessfulResponseWithoutConsent(clientId));
        this.testCodeGrantFlow(clientId, "http://localhost:8180/auth/realms/master/app/auth/third", () -> this.assertSuccessfulResponseWithoutConsent(clientId));
    }

    @Test
    public void testCodeGrantFlowWithUserConsent() {
        String clientId = "system:serviceaccount:default:sa-oauth-redirect-uri";
        this.testCodeGrantFlow(clientId, "http://localhost:8180/auth/realms/master/app/auth", () -> this.assertSuccessfulResponseWithConsent(clientId), "user:info user:check-access");
        ComponentResource component = this.testRealm().components().component(this.clientStorageId);
        ComponentRepresentation representation = component.toRepresentation();
        representation.getConfig().put((Object)"user.consent.require", Arrays.asList("false"));
        component.update(representation);
        this.testCodeGrantFlow(clientId, "http://localhost:8180/auth/realms/master/app/auth", () -> this.assertSuccessfulResponseWithoutConsent(clientId), "user:info user:check-access");
        representation.getConfig().put((Object)"user.consent.require", Arrays.asList("true"));
        component.update(representation);
        this.testCodeGrantFlow(clientId, "http://localhost:8180/auth/realms/master/app/auth", () -> this.assertSuccessfulResponseWithoutConsent(clientId, "persistent_consent"), "user:info user:check-access");
        this.testRealm().users().get(this.userId).revokeConsent(clientId);
        this.testCodeGrantFlow(clientId, "http://localhost:8180/auth/realms/master/app/auth", () -> this.assertSuccessfulResponseWithConsent(clientId), "user:info user:check-access");
    }

    @Test
    public void failCodeGrantFlowWithServiceAccountUsingOAuthRedirectUri() throws Exception {
        this.testCodeGrantFlow("system:serviceaccount:default:sa-oauth-redirect-uri", "http://myapp.org/callback", () -> Assert.assertEquals((Object)"invalid_redirect_uri", (Object)this.events.poll().getError()));
    }

    private void testCodeGrantFlow(String clientId, String expectedRedirectUri, Runnable assertThat) {
        this.testCodeGrantFlow(clientId, expectedRedirectUri, assertThat, null);
    }

    private void testCodeGrantFlow(String clientId, String expectedRedirectUri, Runnable assertThat, String scope) {
        if (scope != null) {
            this.oauth.scope(scope);
        }
        this.oauth.clientId(clientId);
        this.oauth.redirectUri(expectedRedirectUri);
        this.driver.navigate().to(this.oauth.getLoginFormUrl());
        this.loginPage.assertCurrent();
        try {
            this.oauth.fillLoginForm("test-user@localhost", "password");
        }
        catch (Exception exception) {
            // empty catch block
        }
        assertThat.run();
    }

    private void assertSuccessfulResponseWithoutConsent(String clientId) {
        this.assertSuccessfulResponseWithoutConsent(clientId, null);
    }

    private void assertSuccessfulResponseWithoutConsent(String clientId, String consentDetail) {
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectLogin().client(clientId).detail("redirect_uri", this.oauth.getRedirectUri()).detail("username", "test-user@localhost");
        if (consentDetail != null) {
            expectedEvent.detail("consent", "persistent_consent");
        }
        expectedEvent.assertEvent();
        this.assertSuccessfulRedirect(new String[0]);
    }

    private void assertSuccessfulResponseWithConsent(String clientId) {
        this.consentPage.assertCurrent();
        this.driver.getPageSource().contains("user:info");
        this.driver.getPageSource().contains("user:check-access");
        this.consentPage.confirm();
        this.events.expectLogin().client(clientId).detail("redirect_uri", this.oauth.getRedirectUri()).detail("username", "test-user@localhost").detail("consent", "consent_granted").assertEvent();
        this.assertSuccessfulRedirect("user:info", "user:check-access");
    }

    private void assertSuccessfulRedirect(String ... expectedScopes) {
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, null);
        String accessToken = tokenResponse.getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        try {
            AccessToken token = (AccessToken)new JWSInput(accessToken).readJsonContent(AccessToken.class);
            for (String expectedScope : expectedScopes) {
                token.getScope().contains(expectedScope);
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to parse access token");
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        this.oauth.doLogout(tokenResponse.getRefreshToken(), null);
        this.events.clear();
    }
}

