/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.openshift;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.protocol.openshift.OpenShiftTokenReviewRequestRepresentation;
import org.keycloak.protocol.openshift.OpenShiftTokenReviewResponseRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@EnableFeature(value=Profile.Feature.OPENSHIFT_INTEGRATION, skipRestart=true)
public class OpenShiftTokenReviewEndpointTest
extends AbstractTestRealmKeycloakTest {
    private static boolean flowConfigured;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ClientRepresentation client = testRealm.getClients().stream().filter(r -> r.getClientId().equals("test-app")).findFirst().get();
        LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName("groups");
        mapper.setProtocolMapper("oidc-group-membership-mapper");
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("full.path", "false");
        config.put("claim.name", "groups");
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        mapper.setConfig(config);
        mappers.add(mapper);
        client.setProtocolMappers(mappers);
        client.setPublicClient(Boolean.valueOf(false));
        client.setClientAuthenticatorType("testsuite-client-dummy");
        testRealm.getUsers().add(UserBuilder.create().username("groups-user").password("password").addGroups("/topGroup", "/topGroup/level2group").role("account", "view-profile").build());
        testRealm.getUsers().add(UserBuilder.create().username("empty-audience").password("password").build());
    }

    @Before
    public void enablePassthroughAuthenticator() {
        if (!flowConfigured) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("newName", "testsuite-client-dummy");
            Response response = this.testRealm().flows().copy("clients", data);
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response.close();
            data = new HashMap();
            data.put("provider", "testsuite-client-dummy");
            data.put("requirement", "ALTERNATIVE");
            this.testRealm().flows().addExecution("testsuite-client-dummy", data);
            RealmRepresentation realmRep = this.testRealm().toRepresentation();
            realmRep.setClientAuthenticationFlow("testsuite-client-dummy");
            this.testRealm().update(realmRep);
            List executions = this.testRealm().flows().getExecutions("testsuite-client-dummy");
            for (AuthenticationExecutionInfoRepresentation e : executions) {
                if (!e.getProviderId().equals("testsuite-client-dummy")) continue;
                e.setRequirement("ALTERNATIVE");
                this.testRealm().flows().updateExecutions("testsuite-client-dummy", e);
            }
            flowConfigured = true;
        }
    }

    @Test
    public void basicTest() {
        Review r = new Review().invoke();
        String userId = ((UserRepresentation)this.testRealm().users().search(r.username).get(0)).getId();
        OpenShiftTokenReviewResponseRepresentation.User user = r.response.getStatus().getUser();
        Assert.assertEquals((Object)userId, (Object)user.getUid());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
        Assert.assertNotNull((Object)user.getExtra());
        r.assertScope(new String[]{"openid", "email", "profile"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void longExpiration() {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = client.toRepresentation();
        try {
            clientRep.getAttributes().put("access.token.lifespan", "-1");
            client.update(clientRep);
            this.setTimeOffset(1500);
            Review review = new Review();
            review.invoke().assertSuccess();
            this.setTimeOffset(3000);
            review.invoke().assertSuccess();
            this.setTimeOffset(4500);
            review.invoke().assertSuccess();
        }
        finally {
            clientRep.getAttributes().put("access.token.lifespan", null);
            client.update(clientRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void hs256() {
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        try {
            rep.setDefaultSignatureAlgorithm("HS256");
            realm.update(rep);
            Review r = new Review().algorithm("HS256").invoke().assertSuccess();
            String userId = ((UserRepresentation)this.testRealm().users().search(r.username).get(0)).getId();
            OpenShiftTokenReviewResponseRepresentation.User user = r.response.getStatus().getUser();
            Assert.assertEquals((Object)userId, (Object)user.getUid());
            Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
            Assert.assertNotNull((Object)user.getExtra());
            r.assertScope(new String[]{"openid", "email", "profile"});
        }
        finally {
            rep.setDefaultSignatureAlgorithm(null);
            realm.update(rep);
        }
    }

    @Test
    public void groups() {
        new Review().username("groups-user").invoke().assertSuccess().assertGroups(new String[]{"topGroup", "level2group"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customScopes() {
        String id;
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setProtocol("openid-connect");
        clientScope.setName("user:info");
        try (Response r = this.testRealm().clientScopes().create(clientScope);){
            id = ApiUtil.getCreatedId((Response)r);
        }
        ClientRepresentation clientRep = (ClientRepresentation)this.testRealm().clients().findByClientId("test-app").get(0);
        this.testRealm().clients().get(clientRep.getId()).addOptionalClientScope(id);
        try {
            this.oauth.scope("user:info");
            new Review().invoke().assertSuccess().assertScope(new String[]{"openid", "user:info", "profile", "email"});
        }
        finally {
            this.testRealm().clients().get(clientRep.getId()).removeOptionalClientScope(id);
        }
    }

    @Test
    public void emptyAudience() {
        new Review().username("empty-audience").invoke().assertError(401, "Token verification failure");
    }

    @Test
    public void expiredToken() {
        try {
            new Review().runAfterTokenRequest(i -> this.setTimeOffset(this.testRealm().toRepresentation().getAccessTokenLifespan() + 10)).invoke().assertError(401, "Token verification failure");
        }
        finally {
            this.resetTimeOffset();
        }
    }

    @Test
    public void invalidPublicKey() {
        new Review().runAfterTokenRequest(i -> {
            String header = i.token.split("\\.")[0];
            String s = new String(Base64Url.decode((String)header));
            s = s.replace(",\"kid\" : \"", ",\"kid\" : \"x");
            String newHeader = Base64Url.encode((byte[])s.getBytes());
            i.token = i.token.replaceFirst(header, newHeader);
        }).invoke().assertError(401, "Token verification failure");
    }

    @Test
    public void noUserSession() {
        new Review().runAfterTokenRequest(i -> {
            String userId = ((UserRepresentation)this.testRealm().users().search(i.username).get(0)).getId();
            this.testRealm().users().get(userId).logout();
        }).invoke().assertError(401, "Token verification failure");
    }

    @Test
    public void invalidTokenSignature() {
        new Review().runAfterTokenRequest(i -> {
            Review review = i;
            review.token = review.token + "x";
        }).invoke().assertError(401, "Token verification failure");
    }

    @Test
    public void realmDisabled() {
        RealmRepresentation r = this.testRealm().toRepresentation();
        try {
            new Review().runAfterTokenRequest(i -> {
                r.setEnabled(Boolean.valueOf(false));
                this.testRealm().update(r);
            }).invoke().assertError(401, null);
        }
        finally {
            r.setEnabled(Boolean.valueOf(true));
            this.testRealm().update(r);
        }
    }

    @Test
    public void publicClientNotPermitted() {
        ClientRepresentation clientRep = (ClientRepresentation)this.testRealm().clients().findByClientId("test-app").get(0);
        clientRep.setPublicClient(Boolean.valueOf(true));
        this.testRealm().clients().get(clientRep.getId()).update(clientRep);
        try {
            new Review().clientAuthMethod("client-secret").invoke().assertError(401, "Public client is not permitted to invoke token review endpoint");
        }
        finally {
            clientRep.setPublicClient(Boolean.valueOf(false));
            clientRep.setSecret("password");
            this.testRealm().clients().get(clientRep.getId()).update(clientRep);
        }
    }

    private static interface InvokeRunnable {
        public void run(Review var1);
    }

    private class Review {
        private String realm = "test";
        private String clientId = "test-app";
        private String username = "test-user@localhost";
        private String password = "password";
        private String algorithm = "RS256";
        private InvokeRunnable runAfterTokenRequest;
        private String token;
        private String clientAuthMethod = "testsuite-client-dummy";
        private int responseStatus;
        private OpenShiftTokenReviewResponseRepresentation response;

        private Review() {
        }

        public Review username(String username) {
            this.username = username;
            return this;
        }

        public Review algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Review clientAuthMethod(String clientAuthMethod) {
            this.clientAuthMethod = clientAuthMethod;
            return this;
        }

        public Review runAfterTokenRequest(InvokeRunnable runnable) {
            this.runAfterTokenRequest = runnable;
            return this;
        }

        public Review invoke() {
            try {
                if (this.token == null) {
                    String userId = ((UserRepresentation)OpenShiftTokenReviewEndpointTest.this.testRealm().users().search(this.username).get(0)).getId();
                    OpenShiftTokenReviewEndpointTest.this.oauth.doLogin(this.username, this.password);
                    EventRepresentation loginEvent = OpenShiftTokenReviewEndpointTest.this.events.expectLogin().user(userId).assertEvent();
                    String code = (String)OpenShiftTokenReviewEndpointTest.this.oauth.getCurrentQuery().get("code");
                    OAuthClient.AccessTokenResponse accessTokenResponse = OpenShiftTokenReviewEndpointTest.this.oauth.doAccessTokenRequest(code, "password");
                    OpenShiftTokenReviewEndpointTest.this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).detail("client_auth_method", this.clientAuthMethod).user(userId).assertEvent();
                    this.token = accessTokenResponse.getAccessToken();
                }
                Assert.assertEquals((Object)this.algorithm, (Object)new JWSInput(this.token).getHeader().getAlgorithm().name());
                if (this.runAfterTokenRequest != null) {
                    this.runAfterTokenRequest.run(this);
                }
                try (CloseableHttpClient client = HttpClientBuilder.create().build();){
                    String url = ServerURLs.getAuthServerContextRoot() + "/auth/realms/" + this.realm + "/protocol/openid-connect/ext/openshift-token-review/" + this.clientId;
                    OpenShiftTokenReviewRequestRepresentation request = new OpenShiftTokenReviewRequestRepresentation();
                    OpenShiftTokenReviewRequestRepresentation.Spec spec = new OpenShiftTokenReviewRequestRepresentation.Spec();
                    spec.setToken(this.token);
                    spec.setAudiences(new String[]{"account"});
                    request.setSpec(spec);
                    HttpPost post = new HttpPost(url);
                    post.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                    post.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
                    post.setEntity((HttpEntity)new StringEntity(JsonSerialization.writeValueAsString((Object)request)));
                    try (CloseableHttpResponse resp = client.execute((HttpUriRequest)post);){
                        this.responseStatus = resp.getStatusLine().getStatusCode();
                        this.response = (OpenShiftTokenReviewResponseRepresentation)JsonSerialization.readValue((InputStream)resp.getEntity().getContent(), OpenShiftTokenReviewResponseRepresentation.class);
                    }
                    Assert.assertEquals((Object)"authentication.k8s.io/v1beta1", (Object)this.response.getApiVersion());
                    Assert.assertEquals((Object)"TokenReview", (Object)this.response.getKind());
                }
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Review assertSuccess() {
            Assert.assertEquals((long)200L, (long)this.responseStatus);
            Assert.assertTrue((boolean)this.response.getStatus().isAuthenticated());
            Assert.assertNotNull((Object)this.response.getStatus().getUser());
            return this;
        }

        private Review assertError(int expectedStatus, String expectedReason) {
            Assert.assertEquals((long)expectedStatus, (long)this.responseStatus);
            Assert.assertFalse((boolean)this.response.getStatus().isAuthenticated());
            Assert.assertNull((Object)this.response.getStatus().getUser());
            if (expectedReason != null) {
                EventRepresentation poll = OpenShiftTokenReviewEndpointTest.this.events.poll();
                Assert.assertEquals((Object)expectedReason, poll.getDetails().get("reason"));
            }
            return this;
        }

        private void assertScope(String ... expectedScope) {
            List<String> actualScopes = Arrays.asList(this.response.getStatus().getUser().getExtra().getScopes());
            Assert.assertEquals((long)expectedScope.length, (long)actualScopes.size());
            MatcherAssert.assertThat(actualScopes, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedScope));
        }

        private void assertEmptyScope() {
            Assert.assertNull((Object)this.response.getStatus().getUser().getExtra());
        }

        private void assertGroups(String ... expectedGroups) {
            LinkedList actualGroups = new LinkedList(this.response.getStatus().getUser().getGroups());
            Assert.assertEquals((long)expectedGroups.length, (long)actualGroups.size());
            MatcherAssert.assertThat(actualGroups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedGroups));
        }
    }
}

