/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.flows;

import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.oidc.flows.AbstractOIDCResponseTypeTest;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCImplicitResponseTypeIDTokenTokenTest
extends AbstractOIDCResponseTypeTest {
    @Before
    public void clientConfiguration() {
        this.clientManagerBuilder().standardFlow(false).implicitFlow(true);
        this.oauth.clientId("test-app");
        this.oauth.responseType("id_token token");
    }

    @Override
    protected boolean isFragment() {
        return true;
    }

    @Override
    protected List<IDToken> testAuthzResponseAndRetrieveIDTokens(OAuthClient.AuthorizationEndpointResponse authzResponse, EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"id_token token", loginEvent.getDetails().get("response_type"));
        Assert.assertNotNull((Object)authzResponse.getAccessToken());
        String idTokenStr = authzResponse.getIdToken();
        IDToken idToken = this.oauth.verifyIDToken(idTokenStr);
        this.assertValidAccessTokenHash(idToken.getAccessTokenHash(), authzResponse.getAccessToken());
        Assert.assertNull((Object)idToken.getCodeHash());
        Assert.assertNotNull((Object)authzResponse.getTokenType());
        Assert.assertNotNull((Object)authzResponse.getExpiresIn());
        return Collections.singletonList(idToken);
    }

    @Test
    public void nonceNotUsedErrorExpected() {
        super.validateNonceNotUsedErrorExpected();
    }

    @Test
    public void errorImplicitFlowNotAllowed() throws Exception {
        super.validateErrorImplicitFlowNotAllowed();
    }
}

