/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.flows;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.oidc.flows.AbstractOIDCResponseTypeTest;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCHybridResponseTypeCodeIDTokenAsDetachedSigTest
extends AbstractOIDCResponseTypeTest {
    @Before
    public void clientConfiguration() {
        this.clientManagerBuilder().standardFlow(true).implicitFlow(true).updateAttribute("id.token.as.detached.signature", Boolean.TRUE.toString());
        this.oauth.clientId("test-app");
        this.oauth.responseType("code id_token");
    }

    @Override
    protected boolean isFragment() {
        return true;
    }

    @Override
    protected List<IDToken> testAuthzResponseAndRetrieveIDTokens(OAuthClient.AuthorizationEndpointResponse authzResponse, EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"code id_token", loginEvent.getDetails().get("response_type"));
        Assert.assertNull((Object)authzResponse.getAccessToken());
        String idTokenStr = authzResponse.getIdToken();
        IDToken idToken = this.oauth.verifyIDToken(idTokenStr);
        Assert.assertNull((Object)idToken.getEmailVerified());
        Assert.assertNull((Object)idToken.getName());
        Assert.assertNull((Object)idToken.getPreferredUsername());
        Assert.assertNull((Object)idToken.getGivenName());
        Assert.assertNull((Object)idToken.getFamilyName());
        Assert.assertNull((Object)idToken.getEmail());
        Assert.assertNull((Object)idToken.getAccessTokenHash());
        this.assertValidCodeHash(idToken.getCodeHash(), authzResponse.getCode());
        Assert.assertNotNull((Object)idToken.getStateHash());
        Assert.assertEquals((Object)idToken.getStateHash(), (Object)HashUtils.oidcHash((String)this.getIdTokenSignatureAlgorithm(), (String)authzResponse.getState()));
        Assert.assertNull((Object)authzResponse.getTokenType());
        Assert.assertNull((Object)authzResponse.getExpiresIn());
        IDToken idToken2 = this.sendTokenRequestAndGetIDToken(loginEvent);
        Assert.assertNotNull((Object)idToken2.getEmailVerified());
        Assert.assertNotNull((Object)idToken2.getName());
        Assert.assertNotNull((Object)idToken2.getPreferredUsername());
        Assert.assertNotNull((Object)idToken2.getGivenName());
        Assert.assertNotNull((Object)idToken2.getFamilyName());
        Assert.assertNotNull((Object)idToken2.getEmail());
        return Arrays.asList(idToken, idToken2);
    }

    @Test
    public void nonceNotUsedErrorExpected() {
        super.validateNonceNotUsedErrorExpected();
    }

    @Test
    public void errorStandardFlowNotAllowed() throws Exception {
        super.validateErrorStandardFlowNotAllowed();
    }

    @Test
    public void errorImplicitFlowNotAllowed() throws Exception {
        super.validateErrorImplicitFlowNotAllowed();
    }
}

