/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.flows;

import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.oidc.flows.AbstractOIDCResponseTypeTest;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCBasicResponseTypeCodeTest
extends AbstractOIDCResponseTypeTest {
    @Before
    public void clientConfiguration() {
        this.clientManagerBuilder().standardFlow(true).implicitFlow(false);
        this.oauth.clientId("test-app");
        this.oauth.responseType("code");
    }

    @Override
    protected boolean isFragment() {
        return false;
    }

    @Override
    protected List<IDToken> testAuthzResponseAndRetrieveIDTokens(OAuthClient.AuthorizationEndpointResponse authzResponse, EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"code", loginEvent.getDetails().get("response_type"));
        Assert.assertNull((Object)authzResponse.getAccessToken());
        Assert.assertNull((Object)authzResponse.getIdToken());
        OAuthClient.AccessTokenResponse authzResponse2 = this.sendTokenRequestAndGetResponse(loginEvent);
        IDToken idToken2 = this.oauth.verifyIDToken(authzResponse2.getIdToken());
        this.assertValidAccessTokenHash(idToken2.getAccessTokenHash(), authzResponse2.getAccessToken());
        Assert.assertNull((Object)authzResponse.getTokenType());
        Assert.assertNull((Object)authzResponse.getExpiresIn());
        return Collections.singletonList(idToken2);
    }

    @Test
    public void nonceNotUsed() {
        EventRepresentation loginEvent = this.loginUser(null);
        OAuthClient.AuthorizationEndpointResponse authzResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, false);
        List<IDToken> idTokens = this.testAuthzResponseAndRetrieveIDTokens(authzResponse, loginEvent);
        for (IDToken idToken : idTokens) {
            Assert.assertNull((Object)idToken.getNonce());
        }
    }

    @Test
    public void errorStandardFlowNotAllowed() throws Exception {
        super.validateErrorStandardFlowNotAllowed();
    }
}

