/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.representations.MTLSEndpointAliases;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.util.JsonSerialization;

public class OIDCWellKnownProviderTest
extends AbstractKeycloakTest {
    private CloseableHttpClient client;

    @Before
    public void before() {
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiscovery() {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            OIDCConfigurationRepresentation oidcConfig = this.getOIDCDiscoveryRepresentation((Client)client, OAuthClient.AUTH_SERVER_ROOT);
            org.junit.Assert.assertEquals((Object)oidcConfig.getAuthorizationEndpoint(), (Object)OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).build(new Object[]{"test"}).toString());
            org.junit.Assert.assertEquals((Object)oidcConfig.getTokenEndpoint(), (Object)this.oauth.getAccessTokenUrl());
            org.junit.Assert.assertEquals((Object)oidcConfig.getUserinfoEndpoint(), (Object)OIDCLoginProtocolService.userInfoUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).build(new Object[]{"test"}).toString());
            org.junit.Assert.assertEquals((Object)oidcConfig.getJwksUri(), (Object)this.oauth.getCertsUrl("test"));
            String registrationUri = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT).path(RealmsResource.class).path(RealmsResource.class, "getClientsService").path(ClientRegistrationService.class, "provider").build(new Object[]{"test", "openid-connect"}).toString();
            org.junit.Assert.assertEquals((Object)oidcConfig.getRegistrationEndpoint(), (Object)registrationUri);
            this.assertContains(oidcConfig.getResponseTypesSupported(), "code", "id_token", "id_token token", "code id_token", "code token", "code id_token token");
            this.assertContains(oidcConfig.getGrantTypesSupported(), "authorization_code", "implicit", "urn:ietf:params:oauth:grant-type:device_code");
            this.assertContains(oidcConfig.getResponseModesSupported(), "query", "fragment", "form_post", "jwt", "query.jwt", "fragment.jwt", "form_post.jwt");
            Assert.assertNames(oidcConfig.getSubjectTypesSupported(), "pairwise", "public");
            Assert.assertNames(oidcConfig.getIdTokenSigningAlgValuesSupported(), "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512");
            Assert.assertNames(oidcConfig.getUserInfoSigningAlgValuesSupported(), "none", "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512");
            Assert.assertNames(oidcConfig.getRequestObjectSigningAlgValuesSupported(), "none", "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512");
            Assert.assertNames(oidcConfig.getAuthorizationSigningAlgValuesSupported(), "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512");
            Assert.assertNames(oidcConfig.getRequestObjectEncryptionAlgValuesSupported(), "RSA-OAEP", "RSA-OAEP-256", "RSA1_5");
            Assert.assertNames(oidcConfig.getRequestObjectEncryptionEncValuesSupported(), "A256GCM", "A192GCM", "A128GCM", "A128CBC-HS256", "A192CBC-HS384", "A256CBC-HS512");
            Assert.assertNames(oidcConfig.getIdTokenEncryptionAlgValuesSupported(), "RSA1_5", "RSA-OAEP", "RSA-OAEP-256");
            Assert.assertNames(oidcConfig.getIdTokenEncryptionEncValuesSupported(), "A128CBC-HS256", "A128GCM", "A192CBC-HS384", "A192GCM", "A256CBC-HS512", "A256GCM");
            Assert.assertNames(oidcConfig.getAuthorizationEncryptionAlgValuesSupported(), "RSA1_5", "RSA-OAEP", "RSA-OAEP-256");
            Assert.assertNames(oidcConfig.getAuthorizationEncryptionEncValuesSupported(), "A128CBC-HS256", "A128GCM", "A192CBC-HS384", "A192GCM", "A256CBC-HS512", "A256GCM");
            Assert.assertNames(oidcConfig.getTokenEndpointAuthMethodsSupported(), "client_secret_basic", "client_secret_post", "private_key_jwt", "client_secret_jwt", "tls_client_auth");
            Assert.assertNames(oidcConfig.getTokenEndpointAuthSigningAlgValuesSupported(), "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512");
            Assert.assertNames(oidcConfig.getIntrospectionEndpointAuthSigningAlgValuesSupported(), "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512");
            this.assertContains(oidcConfig.getClaimsSupported(), "name", "email", "preferred_username", "family_name", "acr");
            Assert.assertNames(oidcConfig.getClaimTypesSupported(), "normal");
            Assert.assertTrue((boolean)oidcConfig.getClaimsParameterSupported());
            this.assertScopesSupportedMatchesWithRealm(oidcConfig);
            Assert.assertTrue((boolean)oidcConfig.getRequestParameterSupported());
            Assert.assertTrue((boolean)oidcConfig.getRequestUriParameterSupported());
            Assert.assertTrue((boolean)oidcConfig.getRequireRequestUriRegistration());
            Assert.assertNames(oidcConfig.getCodeChallengeMethodsSupported(), "plain", "S256");
            Assert.assertTrue((boolean)oidcConfig.getTlsClientCertificateBoundAccessTokens());
            MTLSEndpointAliases mtlsEndpointAliases = oidcConfig.getMtlsEndpointAliases();
            Assert.assertEquals((Object)oidcConfig.getTokenEndpoint(), (Object)mtlsEndpointAliases.getTokenEndpoint());
            Assert.assertEquals((Object)oidcConfig.getRevocationEndpoint(), (Object)mtlsEndpointAliases.getRevocationEndpoint());
            org.junit.Assert.assertEquals((Object)oidcConfig.getBackchannelAuthenticationEndpoint(), (Object)this.oauth.getBackchannelAuthenticationUrl());
            this.assertContains(oidcConfig.getGrantTypesSupported(), "urn:openid:params:grant-type:ciba");
            Assert.assertNames(oidcConfig.getBackchannelTokenDeliveryModesSupported(), "poll", "ping");
            Assert.assertNames(oidcConfig.getBackchannelAuthenticationRequestSigningAlgValuesSupported(), "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512");
            Assert.assertTrue((boolean)oidcConfig.getBackchannelLogoutSupported());
            Assert.assertTrue((boolean)oidcConfig.getBackchannelLogoutSessionSupported());
            org.junit.Assert.assertEquals((Object)oidcConfig.getRevocationEndpoint(), (Object)this.oauth.getTokenRevocationUrl());
            Assert.assertNames(oidcConfig.getRevocationEndpointAuthMethodsSupported(), "client_secret_basic", "client_secret_post", "private_key_jwt", "client_secret_jwt", "tls_client_auth");
            Assert.assertNames(oidcConfig.getRevocationEndpointAuthSigningAlgValuesSupported(), "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512");
            org.junit.Assert.assertEquals((Object)oidcConfig.getDeviceAuthorizationEndpoint(), (Object)this.oauth.getDeviceAuthorizationUrl());
            org.junit.Assert.assertEquals((Object)this.oauth.getParEndpointUrl(), (Object)oidcConfig.getPushedAuthorizationRequestEndpoint());
            org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)oidcConfig.getRequirePushedAuthorizationRequests());
            org.junit.Assert.assertTrue((boolean)oidcConfig.getFrontChannelLogoutSessionSupported());
            org.junit.Assert.assertTrue((boolean)oidcConfig.getFrontChannelLogoutSupported());
        }
    }

    @Test
    public void testHttpDiscovery() {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            OIDCConfigurationRepresentation oidcConfig = this.getOIDCDiscoveryRepresentation((Client)client, "http://localhost:8180/auth");
            Assert.assertNotNull((Object)oidcConfig.getJwksUri());
            Assert.assertNotNull((Object)oidcConfig.getRevocationEndpoint());
            Assert.assertNotNull((Object)oidcConfig.getRevocationEndpointAuthMethodsSupported());
            Assert.assertNotNull((Object)oidcConfig.getRevocationEndpointAuthSigningAlgValuesSupported());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssuerMatches() throws Exception {
        OAuthClient.AuthorizationEndpointResponse authzResp = this.oauth.doLogin("test-user@localhost", "password");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(authzResp.getCode(), "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            OIDCConfigurationRepresentation oidcConfig = this.getOIDCDiscoveryRepresentation((Client)client, OAuthClient.AUTH_SERVER_ROOT);
            org.junit.Assert.assertEquals((Object)idToken.getIssuer(), (Object)oidcConfig.getIssuer());
        }
    }

    @Test
    public void corsTest() {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI oidcDiscoveryUri = RealmsResource.wellKnownProviderUrl((UriBuilder)builder).build(new Object[]{"test", "openid-configuration"});
        WebTarget oidcDiscoveryTarget = client.target(oidcDiscoveryUri);
        Invocation.Builder request = oidcDiscoveryTarget.request();
        request.header("Origin", (Object)"http://somehost");
        Response response = request.get();
        org.junit.Assert.assertEquals((Object)"http://somehost", (Object)response.getHeaders().getFirst((Object)"Access-Control-Allow-Origin"));
        Invocation.Builder nullRequest = oidcDiscoveryTarget.request();
        nullRequest.header("Origin", (Object)"null");
        Response nullResponse = nullRequest.get();
        org.junit.Assert.assertEquals((Object)"null", (Object)nullResponse.getHeaders().getFirst((Object)"Access-Control-Allow-Origin"));
    }

    @Test
    public void certs() throws IOException {
        TokenSignatureUtil.registerKeyProvider((String)"ES256", (Keycloak)this.adminClient, (TestContext)this.testContext);
        OIDCConfigurationRepresentation representation = (OIDCConfigurationRepresentation)SimpleHttp.doGet((String)(this.getAuthServerRoot().toString() + "realms/test/.well-known/openid-configuration"), (HttpClient)this.client).asJson(OIDCConfigurationRepresentation.class);
        String jwksUri = representation.getJwksUri();
        JSONWebKeySet jsonWebKeySet = (JSONWebKeySet)SimpleHttp.doGet((String)jwksUri, (HttpClient)this.client).asJson(JSONWebKeySet.class);
        org.junit.Assert.assertEquals((long)2L, (long)jsonWebKeySet.getKeys().length);
    }

    @Test
    public void testIntrospectionEndpointClaim() throws IOException {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            ObjectNode oidcConfig = (ObjectNode)JsonSerialization.readValue((String)this.getOIDCDiscoveryConfiguration((Client)client, OAuthClient.AUTH_SERVER_ROOT), ObjectNode.class);
            org.junit.Assert.assertEquals((Object)oidcConfig.get("introspection_endpoint").asText(), (Object)this.getOIDCDiscoveryRepresentation((Client)client, OAuthClient.AUTH_SERVER_ROOT).getIntrospectionEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testDefaultProviderCustomizations() throws IOException {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        try {
            OIDCConfigurationRepresentation oidcConfig = this.getOIDCDiscoveryRepresentation((Client)client, OAuthClient.AUTH_SERVER_ROOT);
            MTLSEndpointAliases mtlsEndpointAliases = oidcConfig.getMtlsEndpointAliases();
            Assert.assertEquals((Object)"https://placeholder-host-set-by-testsuite-provider/registration", (Object)mtlsEndpointAliases.getRegistrationEndpoint());
            Assert.assertEquals((Object)"bar", oidcConfig.getOtherClaims().get("foo"));
            Assert.assertEquals((Object)"some-new-property-value", oidcConfig.getOtherClaims().get("some-new-property"));
            Assert.assertEquals((Object)"nested-value", ((Map)oidcConfig.getOtherClaims().get("some-new-property-compound")).get("nested1"));
            Assert.assertNames(oidcConfig.getIntrospectionEndpointAuthMethodsSupported(), "private_key_jwt", "client_secret_jwt", "tls_client_auth", "custom_nonexisting_authenticator");
            this.assertScopesSupportedMatchesWithRealm(oidcConfig);
            this.getTestingClient().testing().setSystemPropertyOnServer("oidc.wellknown.include.client.scopes", "false");
            oidcConfig = this.getOIDCDiscoveryRepresentation((Client)client, OAuthClient.AUTH_SERVER_ROOT);
            Assert.assertNull((Object)oidcConfig.getScopesSupported());
        }
        finally {
            this.getTestingClient().testing().setSystemPropertyOnServer("oidc.wellknown.include.client.scopes", null);
            client.close();
        }
    }

    private void assertScopesSupportedMatchesWithRealm(OIDCConfigurationRepresentation oidcConfig) {
        Assert.assertNames(oidcConfig.getScopesSupported(), "openid", "offline_access", "profile", "email", "phone", "address", "roles", "web-origins", "microprofile-jwt");
    }

    private OIDCConfigurationRepresentation getOIDCDiscoveryRepresentation(Client client, String uriTemplate) {
        try {
            return (OIDCConfigurationRepresentation)JsonSerialization.readValue((String)this.getOIDCDiscoveryConfiguration(client, uriTemplate), OIDCConfigurationRepresentation.class);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to parse OIDC configuration", cause);
        }
    }

    private String getOIDCDiscoveryConfiguration(Client client, String uriTemplate) {
        UriBuilder builder = UriBuilder.fromUri((String)uriTemplate);
        URI oidcDiscoveryUri = RealmsResource.wellKnownProviderUrl((UriBuilder)builder).build(new Object[]{"test", "openid-configuration"});
        WebTarget oidcDiscoveryTarget = client.target(oidcDiscoveryUri);
        Response response = oidcDiscoveryTarget.request().get();
        org.junit.Assert.assertEquals((Object)"no-cache, must-revalidate, no-transform, no-store", (Object)response.getHeaders().getFirst((Object)"Cache-Control"));
        return (String)response.readEntity(String.class);
    }

    private void assertContains(List<String> actual, String ... expected) {
        for (String exp : expected) {
            Assert.assertTrue((boolean)actual.contains(exp));
        }
    }
}

