/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.events.EventType;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AddressClaimSet;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.oidc.AbstractOIDCScopeTest;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class OIDCScopeTest
extends AbstractOIDCScopeTest {
    private static String userId = KeycloakModelUtils.generateId();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = UserBuilder.create().id(userId).username("john").enabled(true).email("john@email.cz").firstName("John").lastName("Doe").password("password").role("account", "manage-account").role("account", "view-profile").addRoles("role-1", "role-2").build();
        user.setEmailVerified(Boolean.valueOf(true));
        MultivaluedHashMap attrs = new MultivaluedHashMap();
        attrs.add((Object)"street", (Object)"Elm 5");
        attrs.add((Object)"phoneNumber", (Object)"111-222-333");
        attrs.add((Object)"phoneNumberVerified", (Object)"true");
        user.setAttributes((Map)attrs);
        testRealm.getUsers().add(user);
        RoleRepresentation role1 = new RoleRepresentation();
        role1.setName("role-1");
        testRealm.getRoles().getRealm().add(role1);
        RoleRepresentation role2 = new RoleRepresentation();
        role2.setName("role-2");
        testRealm.getRoles().getRealm().add(role2);
        RoleRepresentation roleParent = RoleBuilder.create().name("role-parent").realmComposite("role-1").build();
        testRealm.getRoles().getRealm().add(roleParent);
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group-role-1");
        group.setRealmRoles(Collections.singletonList("role-1"));
        testRealm.getGroups().add(group);
        user = UserBuilder.create().username("role-1-user").enabled(true).password("password").addRoles("role-1").build();
        testRealm.getUsers().add(user);
        user = UserBuilder.create().username("role-2-user").enabled(true).password("password").addRoles("role-2").build();
        testRealm.getUsers().add(user);
        user = UserBuilder.create().username("role-parent-user").enabled(true).password("password").addRoles("role-parent").build();
        testRealm.getUsers().add(user);
        user = UserBuilder.create().username("group-role-1-user").enabled(true).password("password").addGroups("group-role-1").build();
        testRealm.getUsers().add(user);
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
        this.oauth.scope(null);
        this.oauth.maxAge(null);
    }

    @After
    public void removePersistentConsentFromUser() {
        try {
            this.adminClient.realm("test").users().get(userId).revokeConsent("third-party");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testBuiltinOptionalScopes() throws Exception {
        this.oauth.doLogin("john", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid email profile", "test-app");
        IDToken idToken = tokens.idToken;
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, true);
        this.assertAddress(idToken, false);
        this.assertPhone(idToken, false);
        this.assertMicroprofile(idToken, false);
        this.assertMicroprofile((IDToken)tokens.accessToken, false);
        this.oauth.doLogout(tokens.refreshToken, "password");
        this.events.expectLogout(idToken.getSessionState()).client("test-app").user(userId).removeDetail("redirect_uri").assertEvent();
        this.oauth.scope("openid address phone microprofile-jwt");
        this.oauth.doLogin("john", "password");
        loginEvent = this.events.expectLogin().user(userId).assertEvent();
        tokens = this.sendTokenRequest(loginEvent, userId, "openid email profile address phone microprofile-jwt", "test-app");
        idToken = tokens.idToken;
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, true);
        this.assertAddress(idToken, true);
        this.assertPhone(idToken, true);
        this.assertMicroprofile(idToken, true);
        this.assertMicroprofile((IDToken)tokens.accessToken, true);
    }

    private void assertProfile(IDToken idToken, boolean claimsIn) {
        if (claimsIn) {
            Assert.assertEquals((Object)"john", (Object)idToken.getPreferredUsername());
            Assert.assertEquals((Object)"John", (Object)idToken.getGivenName());
            Assert.assertEquals((Object)"Doe", (Object)idToken.getFamilyName());
            Assert.assertEquals((Object)"John Doe", (Object)idToken.getName());
        } else {
            Assert.assertNull((Object)idToken.getPreferredUsername());
            Assert.assertNull((Object)idToken.getGivenName());
            Assert.assertNull((Object)idToken.getFamilyName());
            Assert.assertNull((Object)idToken.getName());
        }
    }

    private void assertEmail(IDToken idToken, boolean claimsIn) {
        if (claimsIn) {
            Assert.assertEquals((Object)"john@email.cz", (Object)idToken.getEmail());
            Assert.assertEquals((Object)true, (Object)idToken.getEmailVerified());
        } else {
            Assert.assertNull((Object)idToken.getEmail());
            Assert.assertNull((Object)idToken.getEmailVerified());
        }
    }

    private void assertAddress(IDToken idToken, boolean claimsIn) {
        AddressClaimSet address = idToken.getAddress();
        if (claimsIn) {
            Assert.assertNotNull((Object)address);
            Assert.assertEquals((Object)"Elm 5", (Object)address.getStreetAddress());
        } else {
            Assert.assertNull((Object)address);
        }
    }

    private void assertPhone(IDToken idToken, boolean claimsIn) {
        if (claimsIn) {
            Assert.assertEquals((Object)"111-222-333", (Object)idToken.getPhoneNumber());
            Assert.assertEquals((Object)true, (Object)idToken.getPhoneNumberVerified());
        } else {
            Assert.assertNull((Object)idToken.getPhoneNumber());
            Assert.assertNull((Object)idToken.getPhoneNumberVerified());
        }
    }

    private void assertMicroprofile(IDToken idToken, boolean claimsIn) {
        if (claimsIn) {
            Assert.assertTrue((boolean)idToken.getOtherClaims().containsKey("upn"));
            Assert.assertEquals((Object)"john", idToken.getOtherClaims().get("upn"));
            Assert.assertTrue((boolean)idToken.getOtherClaims().containsKey("groups"));
            List groups = (List)idToken.getOtherClaims().get("groups");
            Assert.assertNotNull((Object)groups);
            Assert.assertTrue((boolean)groups.containsAll(Arrays.asList("role-1", "role-2")));
        } else {
            Assert.assertFalse((boolean)idToken.getOtherClaims().containsKey("upn"));
            Assert.assertFalse((boolean)idToken.getOtherClaims().containsKey("groups"));
        }
    }

    @Test
    public void testRemoveScopes() throws Exception {
        String profileScopeId = ApiUtil.findClientScopeByName((RealmResource)this.testRealm(), (String)"profile").toRepresentation().getId();
        String emailScopeId = ApiUtil.findClientScopeByName((RealmResource)this.testRealm(), (String)"email").toRepresentation().getId();
        ClientResource testApp = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"test-app");
        testApp.removeDefaultClientScope(profileScopeId);
        testApp.removeDefaultClientScope(emailScopeId);
        testApp.addOptionalClientScope(profileScopeId);
        this.oauth.doLogin("john", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid", "test-app");
        IDToken idToken = tokens.idToken;
        this.assertProfile(idToken, false);
        this.assertEmail(idToken, false);
        this.assertAddress(idToken, false);
        this.assertPhone(idToken, false);
        this.oauth.doLogout(tokens.refreshToken, "password");
        this.events.expectLogout(idToken.getSessionState()).client("test-app").user(userId).removeDetail("redirect_uri").assertEvent();
        this.oauth.scope("openid profile");
        this.oauth.doLogin("john", "password");
        loginEvent = this.events.expectLogin().user(userId).assertEvent();
        tokens = this.sendTokenRequest(loginEvent, userId, "openid profile", "test-app");
        idToken = tokens.idToken;
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, false);
        this.assertAddress(idToken, false);
        this.assertPhone(idToken, false);
        testApp.removeOptionalClientScope(profileScopeId);
        testApp.addDefaultClientScope(profileScopeId);
        testApp.addDefaultClientScope(emailScopeId);
    }

    @Test
    public void testOptionalScopesWithConsentRequired() throws Exception {
        ClientScopeResource addressScope = ApiUtil.findClientScopeByName((RealmResource)this.testRealm(), (String)"address");
        ClientScopeRepresentation addressScopeRep = addressScope.toRepresentation();
        addressScopeRep.getAttributes().put("display.on.consent.screen", "false");
        addressScope.update(addressScopeRep);
        this.oauth.clientId("third-party");
        this.oauth.doLoginGrant("john", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).client("third-party").detail("consent", "consent_granted").assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid email profile", "third-party");
        IDToken idToken = tokens.idToken;
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, true);
        this.assertAddress(idToken, false);
        this.assertPhone(idToken, false);
        this.oauth.doLogout(tokens.refreshToken, "password");
        this.events.expectLogout(idToken.getSessionState()).client("third-party").user(userId).removeDetail("redirect_uri").assertEvent();
        this.oauth.scope("openid address phone");
        this.oauth.doLoginGrant("john", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"Phone number"});
        this.grantPage.accept();
        loginEvent = this.events.expectLogin().client("third-party").detail("consent", "consent_granted").user(userId).assertEvent();
        tokens = this.sendTokenRequest(loginEvent, userId, "openid email profile address phone", "third-party");
        idToken = tokens.idToken;
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, true);
        this.assertAddress(idToken, true);
        this.assertPhone(idToken, true);
        addressScopeRep.getAttributes().put("display.on.consent.screen", "true");
        addressScope.update(addressScopeRep);
    }

    @Test
    public void testClientDisplayedOnConsentScreen() throws Exception {
        ClientResource thirdParty = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"third-party");
        ClientRepresentation thirdPartyRep = thirdParty.toRepresentation();
        thirdPartyRep.getAttributes().put("display.on.consent.screen", "true");
        thirdPartyRep.getAttributes().put("consent.screen.text", "ThirdParty permissions");
        thirdParty.update(thirdPartyRep);
        this.oauth.clientId("third-party");
        this.oauth.doLoginGrant("john", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles", "ThirdParty permissions"});
        this.grantPage.accept();
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).client("third-party").detail("consent", "consent_granted").assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid email profile", "third-party");
        IDToken idToken = tokens.idToken;
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, true);
        this.assertAddress(idToken, false);
        this.assertPhone(idToken, false);
        thirdPartyRep.getAttributes().put("display.on.consent.screen", "false");
        thirdParty.update(thirdPartyRep);
    }

    @Test
    public void testClientDisplayedOnConsentScreenWithEmptyConsentText() throws Exception {
        ClientResource thirdParty = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"third-party");
        ClientRepresentation thirdPartyRep = thirdParty.toRepresentation();
        thirdPartyRep.getAttributes().put("display.on.consent.screen", "true");
        thirdPartyRep.getAttributes().put("consent.screen.text", "");
        thirdParty.update(thirdPartyRep);
        ClientScopeResource profileScope = ApiUtil.findClientScopeByName((RealmResource)this.testRealm(), (String)"profile");
        ClientScopeRepresentation profileScopeRep = profileScope.toRepresentation();
        profileScopeRep.getAttributes().put("consent.screen.text", " ");
        profileScope.update(profileScopeRep);
        this.oauth.clientId("third-party");
        this.oauth.doLoginGrant("john", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"profile", "Email address", "User roles", "third-party"});
        this.grantPage.accept();
        profileScopeRep.getAttributes().put("consent.screen.text", "${profileScopeConsentText}");
        profileScope.update(profileScopeRep);
        thirdPartyRep.getAttributes().put("display.on.consent.screen", "false");
        thirdParty.update(thirdPartyRep);
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void testRefreshTokenWithConsentRequired() {
        this.oauth.clientId("third-party");
        this.oauth.doLoginGrant("john", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).client("third-party").detail("consent", "consent_granted").assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid email profile", "third-party");
        IDToken idToken = tokens.idToken;
        RefreshToken refreshToken1 = this.oauth.parseRefreshToken(tokens.refreshToken);
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, true);
        this.assertAddress(idToken, false);
        this.assertPhone(idToken, false);
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(tokens.refreshToken, "password");
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
        idToken = this.oauth.verifyIDToken(refreshResponse.getIdToken());
        this.assertProfile(idToken, true);
        this.assertEmail(idToken, true);
        this.assertAddress(idToken, false);
        this.assertPhone(idToken, false);
        this.events.expectRefresh(refreshToken1.getId(), idToken.getSessionState()).user(userId).client("third-party").assertEvent();
        this.accountAppsPage.open();
        this.events.clear();
        this.accountAppsPage.revokeGrant("third-party");
        this.events.expect(EventType.REVOKE_GRANT).client("account").user(userId).detail("revoked_client", "third-party").assertEvent();
        refreshResponse = this.oauth.doRefreshTokenRequest(refreshResponse.getRefreshToken(), "password");
        org.junit.Assert.assertEquals((long)400L, (long)refreshResponse.getStatusCode());
        this.events.expectRefresh(refreshToken1.getId(), idToken.getSessionState()).client("third-party").user(userId).removeDetail("token_id").removeDetail("refresh_token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
    }

    @Test
    public void testTwoRefreshTokensWithDifferentScopes() {
        ClientScopeRepresentation clientScope1 = new ClientScopeRepresentation();
        clientScope1.setName("scope-role-1");
        clientScope1.setProtocol("openid-connect");
        Response response = this.testRealm().clientScopes().create(clientScope1);
        String scope1Id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientScopeId(scope1Id);
        response.close();
        ClientScopeRepresentation clientScope2 = new ClientScopeRepresentation();
        clientScope2.setName("scope-role-2");
        clientScope2.setProtocol("openid-connect");
        response = this.testRealm().clientScopes().create(clientScope2);
        String scope2Id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientScopeId(scope2Id);
        response.close();
        RoleRepresentation role1 = this.testRealm().roles().get("role-1").toRepresentation();
        this.testRealm().clientScopes().get(scope1Id).getScopeMappings().realmLevel().add(Arrays.asList(role1));
        RoleRepresentation role2 = this.testRealm().roles().get("role-2").toRepresentation();
        this.testRealm().clientScopes().get(scope2Id).getScopeMappings().realmLevel().add(Arrays.asList(role2));
        ClientResource testApp = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"test-app");
        ClientRepresentation testAppRep = testApp.toRepresentation();
        testAppRep.setFullScopeAllowed(Boolean.valueOf(false));
        testApp.update(testAppRep);
        testApp.addOptionalClientScope(scope1Id);
        testApp.addOptionalClientScope(scope2Id);
        this.oauth.scope("scope-role-1");
        this.oauth.doLogin("john", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).assertEvent();
        AbstractOIDCScopeTest.Tokens tokens1 = this.sendTokenRequest(loginEvent, userId, "openid email profile scope-role-1", "test-app");
        Assert.assertTrue((boolean)tokens1.accessToken.getRealmAccess().isUserInRole("role-1"));
        Assert.assertFalse((boolean)tokens1.accessToken.getRealmAccess().isUserInRole("role-2"));
        this.oauth.scope("scope-role-2");
        this.oauth.openLoginForm();
        loginEvent = this.events.expectLogin().user(userId).removeDetail("username").client("test-app").assertEvent();
        AbstractOIDCScopeTest.Tokens tokens2 = this.sendTokenRequest(loginEvent, userId, "openid email profile scope-role-2", "test-app");
        Assert.assertFalse((boolean)tokens2.accessToken.getRealmAccess().isUserInRole("role-1"));
        Assert.assertTrue((boolean)tokens2.accessToken.getRealmAccess().isUserInRole("role-2"));
        OAuthClient.AccessTokenResponse refreshResponse1 = this.oauth.doRefreshTokenRequest(tokens1.refreshToken, "password");
        Assert.assertEquals((long)200L, (long)refreshResponse1.getStatusCode());
        AccessToken accessToken1 = this.oauth.verifyToken(refreshResponse1.getAccessToken());
        Assert.assertTrue((boolean)accessToken1.getRealmAccess().isUserInRole("role-1"));
        Assert.assertFalse((boolean)accessToken1.getRealmAccess().isUserInRole("role-2"));
        OAuthClient.AccessTokenResponse refreshResponse2 = this.oauth.doRefreshTokenRequest(tokens2.refreshToken, "password");
        Assert.assertEquals((long)200L, (long)refreshResponse2.getStatusCode());
        AccessToken accessToken2 = this.oauth.verifyToken(refreshResponse2.getAccessToken());
        Assert.assertFalse((boolean)accessToken2.getRealmAccess().isUserInRole("role-1"));
        Assert.assertTrue((boolean)accessToken2.getRealmAccess().isUserInRole("role-2"));
        testAppRep.setFullScopeAllowed(Boolean.valueOf(true));
        testApp.update(testAppRep);
        testApp.removeOptionalClientScope(scope1Id);
        testApp.removeOptionalClientScope(scope2Id);
    }

    @Test
    public void testClientScopesPermissions() {
        ClientScopeRepresentation clientScope1 = new ClientScopeRepresentation();
        clientScope1.setName("scope-role-1");
        clientScope1.setProtocol("openid-connect");
        Response response = this.testRealm().clientScopes().create(clientScope1);
        String scope1Id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientScopeId(scope1Id);
        response.close();
        ClientScopeRepresentation clientScopeParent = new ClientScopeRepresentation();
        clientScopeParent.setName("scope-role-parent");
        clientScopeParent.setProtocol("openid-connect");
        response = this.testRealm().clientScopes().create(clientScopeParent);
        String scopeParentId = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientScopeId(scopeParentId);
        response.close();
        RoleRepresentation role1 = this.testRealm().roles().get("role-1").toRepresentation();
        this.testRealm().clientScopes().get(scope1Id).getScopeMappings().realmLevel().add(Arrays.asList(role1));
        RoleRepresentation roleParent = this.testRealm().roles().get("role-parent").toRepresentation();
        this.testRealm().clientScopes().get(scopeParentId).getScopeMappings().realmLevel().add(Arrays.asList(roleParent));
        ClientResource testApp = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"test-app");
        ClientRepresentation testAppRep = testApp.toRepresentation();
        testApp.update(testAppRep);
        testApp.addDefaultClientScope(scope1Id);
        testApp.addDefaultClientScope(scopeParentId);
        this.testLoginAndClientScopesPermissions("role-1-user", "scope-role-1 scope-role-parent", "role-1");
        this.testLoginAndClientScopesPermissions("role-2-user", "", "role-2");
        this.testLoginAndClientScopesPermissions("role-parent-user", "scope-role-1 scope-role-parent", "role-1", "role-parent");
        this.testLoginAndClientScopesPermissions("group-role-1-user", "scope-role-1 scope-role-parent", "role-1");
        testApp.removeOptionalClientScope(scope1Id);
        testApp.removeOptionalClientScope(scopeParentId);
    }

    private void testLoginAndClientScopesPermissions(String username, String expectedRoleScopes, String ... expectedRoles) {
        String userId = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)username).getId();
        this.oauth.openLoginForm();
        this.oauth.doLogin(username, "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid email profile " + expectedRoleScopes, "test-app");
        Assert.assertNames(tokens.accessToken.getRealmAccess().getRoles(), expectedRoles);
        this.oauth.doLogout(tokens.refreshToken, "password");
        this.events.expectLogout(tokens.idToken.getSessionState()).client("test-app").user(userId).removeDetail("redirect_uri").assertEvent();
    }
}

