/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.UriUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.events.EventType;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.mappers.ClaimsParameterTokenMapper;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.UserInfo;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.util.CertificateInfoHelper;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.KeyUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserInfoClientUtil;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class OIDCAdvancedRequestParamsTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Override
    protected void afterAbstractKeycloakTestRealmImport() {
        String realmId = this.testRealm().toRepresentation().getId();
        ComponentRepresentation keys = new ComponentRepresentation();
        keys.setName("enc-generated");
        keys.setProviderType(KeyProvider.class.getName());
        keys.setProviderId("rsa-generated");
        keys.setParentId(realmId);
        keys.setConfig(new MultivaluedHashMap());
        keys.getConfig().putSingle((Object)"priority", (Object)"150");
        keys.getConfig().putSingle((Object)"keyUse", (Object)KeyUse.ENC.getSpecName());
        keys.getConfig().putSingle((Object)"algorithm", (Object)"RS256");
        try (Response response = this.testRealm().components().add(keys);){
            org.junit.Assert.assertEquals((long)201L, (long)response.getStatus());
        }
        keys = new ComponentRepresentation();
        keys.setName("enc-generated");
        keys.setProviderType(KeyProvider.class.getName());
        keys.setProviderId("rsa-generated");
        keys.setParentId(realmId);
        keys.setConfig(new MultivaluedHashMap());
        keys.getConfig().putSingle((Object)"priority", (Object)"200");
        keys.getConfig().putSingle((Object)"keyUse", (Object)KeyUse.ENC.getSpecName());
        keys.getConfig().putSingle((Object)"algorithm", (Object)"PS256");
        response = this.testRealm().components().add(keys);
        var4_4 = null;
        try {
            org.junit.Assert.assertEquals((long)201L, (long)response.getStatus());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (response != null) {
                if (var4_4 != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    response.close();
                }
            }
        }
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true).setRequestUris(TestApplicationResourceUrls.clientRequestUri());
        this.oauth.clientId("test-app");
        this.oauth.maxAge(null);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void testMaxAge1() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime = idToken.getAuthTime();
        int currentTime = Time.currentTime();
        Assert.assertTrue((authTime <= currentTime && authTime + 3 >= currentTime ? 1 : 0) != 0);
        this.setTimeOffset(10);
        this.oauth.maxAge("1");
        this.oauth.doLogin("test-user@localhost", "password");
        loginEvent = this.events.expectLogin().assertEvent();
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTimeUpdated = idToken.getAuthTime();
        Assert.assertTrue((authTime + 10 <= authTimeUpdated ? 1 : 0) != 0);
    }

    @Test
    public void testMaxAge10000() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime = idToken.getAuthTime();
        int currentTime = Time.currentTime();
        Assert.assertTrue((authTime <= currentTime && authTime + 3 >= currentTime ? 1 : 0) != 0);
        this.setTimeOffset(10);
        this.oauth.maxAge("10000");
        this.oauth.openLoginForm();
        loginEvent = this.events.expectLogin().assertEvent();
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTimeUpdated = idToken.getAuthTime();
        Assert.assertEquals((long)authTime, (long)authTimeUpdated);
    }

    @Test
    public void promptNoneNotLogged() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.events.assertEmpty();
        OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNull((Object)resp.getCode());
        Assert.assertEquals((Object)"login_required", (Object)resp.getError());
    }

    @Test
    public void promptNoneSuccess() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime = idToken.getAuthTime();
        this.setTimeOffset(10);
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        loginEvent = this.events.expectLogin().removeDetail("username").assertEvent();
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        int authTime2 = idToken.getAuthTime();
        Assert.assertEquals((long)authTime, (long)authTime2);
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void promptNoneConsentRequired() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").consentRequired(true);
        try {
            this.profilePage.open();
            org.junit.Assert.assertTrue((boolean)this.loginPage.isCurrent());
            this.loginPage.login("test-user@localhost", "password");
            this.profilePage.assertCurrent();
            this.events.expectLogin().client("account").removeDetail("redirect_uri").detail("username", "test-user@localhost").assertEvent();
            this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
            org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertNull((Object)resp.getCode());
            Assert.assertEquals((Object)"interaction_required", (Object)resp.getError());
            this.driver.navigate().to(this.oauth.getLoginFormUrl());
            this.grantPage.assertCurrent();
            this.grantPage.accept();
            this.events.expectLogin().detail("username", "test-user@localhost").detail("consent", "consent_granted").assertEvent();
            this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=none");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertNotNull((Object)resp.getCode());
            Assert.assertNull((Object)resp.getError());
            this.events.expectLogin().detail("username", "test-user@localhost").detail("consent", "persistent_consent").assertEvent();
        }
        finally {
            UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
            user.revokeConsent("test-app");
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").consentRequired(false);
        }
    }

    @Test
    public void promptLogin() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken oldIdToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        this.setTimeOffset(10);
        this.driver.navigate().to(this.oauth.getLoginFormUrl());
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken newIdToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        Assert.assertEquals((long)oldIdToken.getAuthTime(), (long)newIdToken.getAuthTime());
        this.setTimeOffset(20);
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=login");
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        newIdToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        Assert.assertTrue((String)("Expected auth time to change. old auth time: " + oldIdToken.getAuthTime() + " , new auth time: " + newIdToken.getAuthTime()), (oldIdToken.getAuthTime() + 20 <= newIdToken.getAuthTime() ? 1 : 0) != 0);
        Assert.assertEquals((Object)oldIdToken.getSessionState(), (Object)newIdToken.getSessionState());
    }

    @Test
    public void promptLoginDifferentUser() throws Exception {
        String sss = this.oauth.getLoginFormUrl();
        System.out.println(sss);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&prompt=login");
        this.loginPage.assertCurrent();
        this.loginPage.login("john-doh@localhost", "password");
        this.errorPage.assertCurrent();
        Assert.assertTrue((boolean)this.errorPage.getError().startsWith("You are already authenticated as different user"));
    }

    @Test
    public void promptConsent() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").consentRequired(true);
        try {
            this.loginPage.open();
            this.loginPage.login("test-user@localhost", "password");
            this.grantPage.assertCurrent();
            this.grantPage.accept();
            this.appPage.assertCurrent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            this.events.expectLogin().detail("username", "test-user@localhost").detail("consent", "consent_granted").assertEvent();
            this.driver.navigate().to(this.oauth.getLoginFormUrl());
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            this.events.expectLogin().detail("username", "test-user@localhost").detail("consent", "persistent_consent").assertEvent();
            String loginFormUri = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl()).queryParam("prompt", new Object[]{"consent"}).build(new Object[0]).toString();
            this.driver.navigate().to(loginFormUri);
            this.grantPage.assertCurrent();
            this.grantPage.accept();
            this.appPage.assertCurrent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            this.events.expectLogin().detail("username", "test-user@localhost").detail("consent", "consent_granted").assertEvent();
        }
        finally {
            UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
            user.revokeConsent("test-app");
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").consentRequired(false);
        }
    }

    @Test
    public void nonSupportedParams() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&display=popup&foo=foobar&claims_locales=fr");
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        Assert.assertNotNull((Object)idToken);
    }

    @Test
    public void requestObjectNotRequiredNotProvided() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
    }

    @Test
    public void requestObjectNotRequiredProvidedInRequestParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", "mystate2", Algorithm.none.toString());
        this.oauth.request(oidcClientEndpointsResource.getOIDCRequest());
        OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response1.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response1.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
    }

    @Test
    public void requestObjectNotRequiredProvidedInRequestUriParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", "mystate2", Algorithm.none.toString());
        this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        OAuthClient.AuthorizationEndpointResponse response2 = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response2.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response2.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
    }

    @Test
    public void requestObjectRequiredNotProvided() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request or request_uri");
        clientResource.update(clientRep);
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredProvidedInRequestParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request or request_uri");
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", "mystate2", Algorithm.none.toString());
        this.oauth.request(oidcClientEndpointsResource.getOIDCRequest());
        OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response1.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response1.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredProvidedInRequestUriParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request or request_uri");
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", "mystate2", Algorithm.none.toString());
        this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        OAuthClient.AuthorizationEndpointResponse response2 = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response2.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response2.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredAsRequestParamNotProvided() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request only");
        clientResource.update(clientRep);
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredAsRequestParamProvidedInRequestParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request only");
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", "mystate2", Algorithm.none.toString());
        this.oauth.request(oidcClientEndpointsResource.getOIDCRequest());
        OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response1.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response1.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredAsRequestParamProvidedInRequestUriParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request only");
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", Algorithm.none.toString());
        this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredAsRequestUriParamNotProvided() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request_uri only");
        clientResource.update(clientRep);
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredAsRequestUriParamProvidedInRequestParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request_uri only");
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", Algorithm.none.toString());
        this.oauth.request(oidcClientEndpointsResource.getOIDCRequest());
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestObjectRequiredAsRequestUriParamProvidedInRequestUriParam() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired("request_uri only");
        clientResource.update(clientRep);
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", this.oauth.getRedirectUri(), "10", "mystate2", Algorithm.none.toString());
        this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response1.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response1.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectRequired(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestParamUnsigned() throws Exception {
        this.oauth.stateParamHardcoded("mystate2");
        String validRedirectUri = this.oauth.getRedirectUri();
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", "http://invalid", null, Algorithm.none.toString());
        String requestStr = oidcClientEndpointsResource.getOIDCRequest();
        this.oauth.request(requestStr);
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        this.oauth.redirectUri("http://invalid");
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", validRedirectUri, "10", "mystate2", Algorithm.none.toString());
        requestStr = oidcClientEndpointsResource.getOIDCRequest();
        this.oauth.request(requestStr);
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertEquals((Object)"mystate2", (Object)response.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
    }

    @Test
    public void requestUriParamUnsigned() throws Exception {
        String validRedirectUri = this.oauth.getRedirectUri();
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", "http://invalid", null, "mystate1", Algorithm.none.toString());
        this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        this.oauth.redirectUri("http://invalid");
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", validRedirectUri, "10", "mystate1", Algorithm.none.toString());
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertEquals((Object)"mystate1", (Object)response.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
    }

    @Test
    public void requestUriParamWithAllowedRequestUris() throws Exception {
        String validRedirectUri = this.oauth.getRedirectUri();
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", validRedirectUri, "10", "mystate1", Algorithm.none.toString());
        ClientManager.ClientManagerBuilder clientMgrBuilder = ClientManager.realm(this.adminClient.realm("test")).clientId("test-app");
        this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        String absoluteRequestUri = TestApplicationResourceUrls.clientRequestUri();
        String requestUri = absoluteRequestUri.substring(UriUtils.getOrigin((String)absoluteRequestUri).length());
        clientMgrBuilder.setRequestUris(requestUri);
        this.oauth.openLoginForm();
        Assert.assertFalse((boolean)this.errorPage.isCurrent());
        this.loginPage.assertCurrent();
        requestUri = requestUri.replace("/get-oidc-request", "/*");
        clientMgrBuilder.setRequestUris(requestUri);
        this.oauth.openLoginForm();
        Assert.assertFalse((boolean)this.errorPage.isCurrent());
        this.loginPage.assertCurrent();
        requestUri = absoluteRequestUri.replace("/get-oidc-request", "/*");
        clientMgrBuilder.setRequestUris(requestUri);
        this.oauth.openLoginForm();
        Assert.assertFalse((boolean)this.errorPage.isCurrent());
        this.loginPage.assertCurrent();
        clientMgrBuilder.setRequestUris("*");
        this.oauth.openLoginForm();
        Assert.assertFalse((boolean)this.errorPage.isCurrent());
        this.loginPage.assertCurrent();
        clientMgrBuilder.setRequestUris("/foo", requestUri);
        this.oauth.openLoginForm();
        Assert.assertFalse((boolean)this.errorPage.isCurrent());
        this.loginPage.assertCurrent();
        clientMgrBuilder.setRequestUris("/foo", requestUri.replace("/*", "/foo"));
        this.oauth.openLoginForm();
        this.errorPage.assertCurrent();
        clientMgrBuilder.setRequestUris(new String[0]);
        this.oauth.openLoginForm();
        this.errorPage.assertCurrent();
        clientMgrBuilder.setRequestUris(TestApplicationResourceUrls.clientRequestUri());
    }

    @Test
    public void requestUriParamSigned() throws Exception {
        String validRedirectUri = this.oauth.getRedirectUri();
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectSignatureAlg(Algorithm.RS256);
        clientResource.update(clientRep);
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", validRedirectUri, "10", Algorithm.none.toString());
        this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        String clientPublicKeyPem = (String)oidcClientEndpointsResource.generateKeys("RS256").get("publicKey");
        oidcClientEndpointsResource.setOIDCRequest("test", "test-app", validRedirectUri, "10", "mystate3", Algorithm.RS256.toString());
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        clientRep = clientResource.toRepresentation();
        CertificateRepresentation cert = new CertificateRepresentation();
        cert.setPublicKey(clientPublicKeyPem);
        CertificateInfoHelper.updateClientRepresentationCertificateInfo((ClientRepresentation)clientRep, (CertificateRepresentation)cert, (String)"jwt.credential");
        clientResource.update(clientRep);
        this.setTimeOffset(20);
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertEquals((Object)"mystate3", (Object)response.getState());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectSignatureAlg(null);
        clientResource.update(clientRep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestUriParamSignedIn(Algorithm expectedAlgorithm, Algorithm actualAlgorithm) throws Exception {
        ClientRepresentation clientRep;
        ClientResource clientResource;
        block4: {
            clientResource = null;
            clientRep = null;
            try {
                String validRedirectUri = this.oauth.getRedirectUri();
                TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
                clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
                clientRep = clientResource.toRepresentation();
                OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectSignatureAlg(expectedAlgorithm);
                clientResource.update(clientRep);
                if (Algorithm.none != actualAlgorithm) {
                    oidcClientEndpointsResource.generateKeys(actualAlgorithm.name());
                }
                oidcClientEndpointsResource.setOIDCRequest("test", "test-app", validRedirectUri, "10", "mystate3", actualAlgorithm.name());
                clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
                clientRep = clientResource.toRepresentation();
                OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
                String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
                OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(jwksUrl);
                clientResource.update(clientRep);
                this.setTimeOffset(20);
                this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
                if (expectedAlgorithm == null || expectedAlgorithm == actualAlgorithm) {
                    OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
                    Assert.assertNotNull((Object)response.getCode());
                    Assert.assertEquals((Object)"mystate3", (Object)response.getState());
                    org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
                    break block4;
                }
                this.oauth.openLoginForm();
                Assert.assertTrue((boolean)this.errorPage.isCurrent());
                org.junit.Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
            }
            catch (Throwable throwable) {
                OIDCAdvancedConfigWrapper.fromClientRepresentation(clientRep).setRequestObjectSignatureAlg(null);
                OIDCAdvancedConfigWrapper.fromClientRepresentation(clientRep).setUseJwksUrl(false);
                OIDCAdvancedConfigWrapper.fromClientRepresentation(clientRep).setJwksUrl(null);
                clientResource.update(clientRep);
                throw throwable;
            }
        }
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectSignatureAlg(null);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(false);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(null);
        clientResource.update(clientRep);
    }

    @Test
    public void requestUriParamSignedExpectedES256ActualRS256() throws Exception {
        this.requestUriParamSignedIn(Algorithm.ES256, Algorithm.RS256);
    }

    @Test
    public void requestUriParamSignedExpectedNoneActualES256() throws Exception {
        this.requestUriParamSignedIn(Algorithm.none, Algorithm.ES256);
    }

    @Test
    public void requestUriParamSignedExpectedNoneActualNone() throws Exception {
        this.requestUriParamSignedIn(Algorithm.none, Algorithm.none);
    }

    @Test
    public void requestUriParamSignedExpectedES256ActualES256() throws Exception {
        this.requestUriParamSignedIn(Algorithm.ES256, Algorithm.ES256);
    }

    @Test
    public void requestUriParamSignedExpectedES384ActualES384() throws Exception {
        this.requestUriParamSignedIn(Algorithm.ES384, Algorithm.ES384);
    }

    @Test
    public void requestUriParamSignedExpectedES512ActualES512() throws Exception {
        this.requestUriParamSignedIn(Algorithm.ES512, Algorithm.ES512);
    }

    @Test
    public void requestUriParamSignedExpectedRS384ActualRS384() throws Exception {
        this.requestUriParamSignedIn(Algorithm.RS384, Algorithm.RS384);
    }

    @Test
    public void requestUriParamSignedExpectedRS512ActualRS512() throws Exception {
        this.requestUriParamSignedIn(Algorithm.RS512, Algorithm.RS512);
    }

    @Test
    public void requestUriParamSignedExpectedPS256ActualPS256() throws Exception {
        this.requestUriParamSignedIn(Algorithm.PS256, Algorithm.PS256);
    }

    @Test
    public void requestUriParamSignedExpectedPS384ActualPS384() throws Exception {
        this.requestUriParamSignedIn(Algorithm.PS384, Algorithm.PS384);
    }

    @Test
    public void requestUriParamSignedExpectedPS512ActualPS512() throws Exception {
        this.requestUriParamSignedIn(Algorithm.PS512, Algorithm.PS512);
    }

    @Test
    public void requestUriParamSignedExpectedAnyActualES256() throws Exception {
        this.requestUriParamSignedIn(null, Algorithm.ES256);
    }

    @Test
    public void loginHint() {
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&" + "login_hint" + "=test-user%40localhost");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginPage.getUsername());
        this.loginPage.login("password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void processClaimsQueryParam() throws IOException {
        ImmutableMap claims = ImmutableMap.of((Object)"id_token", (Object)ImmutableMap.of((Object)"test_claim", (Object)ImmutableMap.of((Object)"essential", (Object)true)));
        String claimsJson = JsonSerialization.writeValueAsString((Object)claims);
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&" + "claims" + "=" + claimsJson);
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        String sessionId = loginEvent.getSessionId();
        String clientId = loginEvent.getClientId();
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            String clientUuid = realmModel.getClientByClientId(clientId).getId();
            UserSessionModel userSession = session.sessions().getUserSession(realmModel, sessionId);
            AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)userSession.getAuthenticatedClientSessions().get(clientUuid);
            String claimsInSession = clientSession.getNote("claims");
            org.junit.Assert.assertEquals((Object)claimsJson, (Object)claimsInSession);
        });
    }

    @Test
    public void processClaimsRequestParam() throws Exception {
        ImmutableMap claims = ImmutableMap.of((Object)"id_token", (Object)ImmutableMap.of((Object)"test_claim", (Object)ImmutableMap.of((Object)"essential", (Object)true)));
        String claimsJson = JsonSerialization.writeValueAsString((Object)claims);
        HashMap<String, String> oidcRequest = new HashMap<String, String>();
        oidcRequest.put("client_id", "test-app");
        oidcRequest.put("response_type", "code");
        oidcRequest.put("redirect_uri", this.oauth.getRedirectUri());
        oidcRequest.put("claims", (String)claims);
        String request = new JWSBuilder().jsonContent(oidcRequest).none();
        this.driver.navigate().to(this.oauth.getLoginFormUrl() + "&" + "request" + "=" + request);
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        String sessionId = loginEvent.getSessionId();
        String clientId = loginEvent.getClientId();
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> {
            RealmModel realmModel = session.getContext().getRealm();
            String clientUuid = realmModel.getClientByClientId(clientId).getId();
            UserSessionModel userSession = session.sessions().getUserSession(realmModel, sessionId);
            AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(clientUuid);
            String claimsInSession = clientSession.getNote("claims");
            org.junit.Assert.assertEquals((Object)claimsJson, (Object)claimsInSession);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void processClaimsRequestParamSupported() throws Exception {
        String clientScopeId = null;
        try {
            UserInfo userInfo;
            Response response;
            for (ClientScopeRepresentation rep : this.adminClient.realm("test").clientScopes().findAll()) {
                if (!rep.getName().equals("profile")) continue;
                clientScopeId = rep.getId();
                break;
            }
            ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").removeDefaultClientScope(clientScopeId);
            ClientResource app = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            ProtocolMappersResource res = app.getProtocolMappers();
            res.createMapper(ModelToRepresentation.toRepresentation((ProtocolMapperModel)ClaimsParameterTokenMapper.createMapper((String)"claimsParameterTokenMapper", (boolean)true, (boolean)false))).close();
            ImmutableMap claims = ImmutableMap.of((Object)"id_token", (Object)ImmutableMap.of((Object)"email", (Object)ImmutableMap.of((Object)"essential", (Object)true), (Object)"preferred_username", (Object)ImmutableMap.of((Object)"essential", (Object)true), (Object)"family_name", (Object)ImmutableMap.of((Object)"essential", (Object)false), (Object)"given_name", (Object)ImmutableMap.of((Object)"wesentlich", (Object)true), (Object)"name", (Object)ImmutableMap.of((Object)"essential", (Object)true)), (Object)"userinfo", (Object)ImmutableMap.of((Object)"preferred_username", (Object)ImmutableMap.of((Object)"essential", (Object)"Ja"), (Object)"family_name", (Object)ImmutableMap.of((Object)"essential", (Object)true), (Object)"given_name", (Object)ImmutableMap.of((Object)"essential", (Object)true)));
            HashMap<String, String> oidcRequest = new HashMap<String, String>();
            oidcRequest.put("client_id", "test-app");
            oidcRequest.put("response_type", "code");
            oidcRequest.put("redirect_uri", this.oauth.getRedirectUri());
            oidcRequest.put("claims", (String)claims);
            oidcRequest.put("scope", "openid");
            String request = new JWSBuilder().jsonContent(oidcRequest).none();
            this.oauth = this.oauth.request(request);
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            OAuthClient.AccessTokenResponse accessTokenResponse = this.sendTokenRequestAndGetResponse(loginEvent);
            IDToken idToken = this.oauth.verifyIDToken(accessTokenResponse.getIdToken());
            org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)idToken.getEmail());
            org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)idToken.getPreferredUsername());
            org.junit.Assert.assertNull((Object)idToken.getFamilyName());
            org.junit.Assert.assertNull((Object)idToken.getGivenName());
            org.junit.Assert.assertEquals((Object)"Tom Brady", (Object)idToken.getName());
            ResteasyClient client = AdminClientUtil.createResteasyClient();
            try {
                response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getAccessToken());
                userInfo = (UserInfo)response.readEntity(UserInfo.class);
                org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)userInfo.getEmail());
                org.junit.Assert.assertNull((Object)userInfo.getPreferredUsername());
                org.junit.Assert.assertEquals((Object)"Brady", (Object)userInfo.getFamilyName());
                org.junit.Assert.assertEquals((Object)"Tom", (Object)userInfo.getGivenName());
                org.junit.Assert.assertNull((Object)userInfo.getName());
            }
            finally {
                this.events.expect(EventType.USER_INFO_REQUEST).session(accessTokenResponse.getSessionState()).client("test-app").assertEvent();
                client.close();
            }
            this.oauth.doLogout(accessTokenResponse.getRefreshToken(), "password");
            this.events.expectLogout(accessTokenResponse.getSessionState()).client("test-app").clearDetails().assertEvent();
            claims = ImmutableMap.of((Object)"id_token", (Object)ImmutableMap.of((Object)"test_claim", (Object)ImmutableMap.of((Object)"essential", (Object)true)), (Object)"access_token", (Object)ImmutableMap.of((Object)"email", (Object)ImmutableMap.of((Object)"essential", (Object)true), (Object)"preferred_username", (Object)ImmutableMap.of((Object)"essential", (Object)true), (Object)"family_name", (Object)ImmutableMap.of((Object)"essential", (Object)true), (Object)"given_name", (Object)ImmutableMap.of((Object)"essential", (Object)true), (Object)"name", (Object)ImmutableMap.of((Object)"essential", (Object)true)));
            oidcRequest = new HashMap();
            oidcRequest.put("client_id", "test-app");
            oidcRequest.put("response_type", "code");
            oidcRequest.put("redirect_uri", this.oauth.getRedirectUri());
            oidcRequest.put("claims", (String)claims);
            oidcRequest.put("scope", "openid");
            request = new JWSBuilder().jsonContent(oidcRequest).none();
            this.oauth = this.oauth.request(request);
            this.oauth.doLogin("test-user@localhost", "password");
            loginEvent = this.events.expectLogin().assertEvent();
            accessTokenResponse = this.sendTokenRequestAndGetResponse(loginEvent);
            idToken = this.oauth.verifyIDToken(accessTokenResponse.getIdToken());
            org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)idToken.getEmail());
            org.junit.Assert.assertNull((Object)idToken.getPreferredUsername());
            org.junit.Assert.assertNull((Object)idToken.getFamilyName());
            org.junit.Assert.assertNull((Object)idToken.getGivenName());
            org.junit.Assert.assertNull((Object)idToken.getName());
            client = AdminClientUtil.createResteasyClient();
            try {
                response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getAccessToken());
                userInfo = (UserInfo)response.readEntity(UserInfo.class);
                org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)userInfo.getEmail());
                org.junit.Assert.assertNull((Object)userInfo.getPreferredUsername());
                org.junit.Assert.assertNull((Object)userInfo.getFamilyName());
                org.junit.Assert.assertNull((Object)userInfo.getGivenName());
                org.junit.Assert.assertNull((Object)userInfo.getName());
            }
            finally {
                client.close();
            }
        }
        catch (Throwable throwable) {
            ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").addDefaultClientScope(clientScopeId);
            throw throwable;
        }
        ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").addDefaultClientScope(clientScopeId);
    }

    @Test
    public void testSignedRequestObject() throws IOException {
        this.oauth = this.oauth.request(this.createAndSignRequestObject());
        this.oauth.doLogin("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void testWrongEncryptionAlgorithm() throws Exception {
        try {
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
            ClientRepresentation clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectEncryptionAlg("RSA-OAEP-256");
            clientResource.update(clientRep);
            this.oauth.request(this.createEncryptedRequestObject("RSA-OAEP"));
            this.oauth.doLogin("test-user@localhost", "password");
            org.junit.Assert.fail((String)"Should fail due to invalid encryption algorithm");
        }
        catch (Exception ignore) {
            org.junit.Assert.assertTrue((boolean)this.errorPage.isCurrent());
            this.oauth.request(this.createEncryptedRequestObject("RSA-OAEP-256"));
            this.oauth.doLogin("test-user@localhost", "password");
            org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        }
        finally {
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
            ClientRepresentation clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectEncryptionAlg(null);
            clientResource.update(clientRep);
        }
        this.oauth.openLogout();
        this.oauth = this.oauth.request(this.createEncryptedRequestObject("RSA-OAEP-256"));
        this.oauth.doLogin("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrongContentEncryptionAlgorithm() throws Exception {
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
        ClientRepresentation clientRep = clientResource.toRepresentation();
        try {
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectEncryptionAlg("RSA-OAEP-256");
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectEncryptionEnc("A192GCM");
            clientResource.update(clientRep);
            clientRep = clientResource.toRepresentation();
            org.junit.Assert.assertEquals((Object)"A192GCM", (Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).getRequestObjectEncryptionEnc());
            this.oauth.request(this.createEncryptedRequestObject("RSA-OAEP-256"));
            this.oauth.doLogin("test-user@localhost", "password");
            org.junit.Assert.fail((String)"Should fail due to invalid content encryption algorithm");
        }
        catch (Exception ignore) {
            org.junit.Assert.assertTrue((boolean)this.errorPage.isCurrent());
            this.oauth.request(this.createEncryptedRequestObject("RSA-OAEP-256"));
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectEncryptionEnc("A256GCM");
            clientResource.update(clientRep);
            clientRep = clientResource.toRepresentation();
            org.junit.Assert.assertEquals((Object)"A256GCM", (Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).getRequestObjectEncryptionEnc());
            this.oauth.doLogin("test-user@localhost", "password");
            org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        }
        finally {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectEncryptionAlg(null);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectEncryptionEnc(null);
            clientResource.update(clientRep);
        }
        this.oauth.openLogout();
        this.oauth = this.oauth.request(this.createEncryptedRequestObject("RSA-OAEP-256"));
        this.oauth.doLogin("test-user@localhost", "password");
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        clientRep = clientResource.toRepresentation();
        org.junit.Assert.assertNull((Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).getRequestObjectEncryptionAlg());
        org.junit.Assert.assertNull((Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).getRequestObjectEncryptionEnc());
    }

    @Test
    public void testSignedAndEncryptedRequestObject() throws IOException, JWEException {
        this.oauth = this.oauth.request(this.createEncryptedRequestObject("RSA-OAEP-256"));
        this.oauth.doLogin("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
    }

    private String createEncryptedRequestObject(String encAlg) throws IOException, JWEException {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            OIDCConfigurationRepresentation representation = (OIDCConfigurationRepresentation)SimpleHttp.doGet((String)(this.getAuthServerRoot().toString() + "realms/" + this.oauth.getRealm() + "/.well-known/openid-configuration"), (HttpClient)httpClient).asJson(OIDCConfigurationRepresentation.class);
            String jwksUri = representation.getJwksUri();
            JSONWebKeySet jsonWebKeySet = (JSONWebKeySet)SimpleHttp.doGet((String)jwksUri, (HttpClient)httpClient).asJson(JSONWebKeySet.class);
            Map keysForUse = JWKSUtils.getKeysForUse((JSONWebKeySet)jsonWebKeySet, (JWK.Use)JWK.Use.ENCRYPTION);
            String keyId = null;
            if (keyId == null) {
                KeysMetadataRepresentation.KeyMetadataRepresentation encKey = KeyUtils.getActiveEncKey((KeysMetadataRepresentation)this.testRealm().keys().getKeyMetadata(), (String)"PS256");
                keyId = encKey.getKid();
            }
            PublicKey decryptionKEK = (PublicKey)keysForUse.get(keyId);
            JWE jwe = new JWE().header(new JWEHeader(encAlg, "A256GCM", null)).content(this.createAndSignRequestObject().getBytes());
            jwe.getKeyStorage().setEncryptionKey((Key)decryptionKEK);
            String string = jwe.encodeJwe();
            return string;
        }
    }

    @Test
    public void testRealmPublicKeyEncryptedRequestObjectUsingRSA_OAEP_256WithA256GCM() throws Exception {
        this.assertRequestObjectEncryption(new JWEHeader("RSA-OAEP-256", "A256GCM", null));
    }

    @Test
    public void testRealmPublicKeyEncryptedRequestObjectUsingRSA_OAEPWithA128CBC_HS256() throws Exception {
        this.assertRequestObjectEncryption(new JWEHeader("RSA-OAEP", "A128CBC-HS256", null));
    }

    @Test
    public void testRealmPublicKeyEncryptedRequestObjectUsingKid() throws Exception {
        KeysMetadataRepresentation.KeyMetadataRepresentation encKey = KeyUtils.getActiveEncKey((KeysMetadataRepresentation)this.testRealm().keys().getKeyMetadata(), (String)"RS256");
        JWEHeader jweHeader = new JWEHeader("RSA-OAEP", "A128CBC-HS256", null, encKey.getKid());
        this.assertRequestObjectEncryption(jweHeader);
    }

    private String createAndSignRequestObject() throws IOException {
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
        requestObject.id(KeycloakModelUtils.generateId());
        requestObject.iat(Long.valueOf(Time.currentTime()));
        requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
        requestObject.nbf(requestObject.getIat());
        requestObject.setClientId(this.oauth.getClientId());
        requestObject.setResponseType("code");
        requestObject.setRedirectUriParam(this.oauth.getRedirectUri());
        requestObject.setScope("openid");
        byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
        String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
        TestOIDCEndpointsApplicationResource client = this.testingClient.testApp().oidcClientEndpoints();
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(TestApplicationResourceUrls.clientJwksUri());
        clientResource.update(clientRep);
        client.generateKeys("RS256");
        client.registerOIDCRequest(encodedRequestObject, "RS256");
        String oidcRequest = client.getOIDCRequest();
        return oidcRequest;
    }

    private void assertRequestObjectEncryption(JWEHeader jweHeader) throws Exception {
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
        requestObject.id(KeycloakModelUtils.generateId());
        requestObject.iat(Long.valueOf(Time.currentTime()));
        requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
        requestObject.nbf(requestObject.getIat());
        requestObject.setClientId(this.oauth.getClientId());
        requestObject.setResponseType("code");
        requestObject.setRedirectUriParam(this.oauth.getRedirectUri());
        requestObject.setScope("openid");
        byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            OIDCConfigurationRepresentation representation = (OIDCConfigurationRepresentation)SimpleHttp.doGet((String)(this.getAuthServerRoot().toString() + "realms/" + this.oauth.getRealm() + "/.well-known/openid-configuration"), (HttpClient)httpClient).asJson(OIDCConfigurationRepresentation.class);
            String jwksUri = representation.getJwksUri();
            JSONWebKeySet jsonWebKeySet = (JSONWebKeySet)SimpleHttp.doGet((String)jwksUri, (HttpClient)httpClient).asJson(JSONWebKeySet.class);
            Map keysForUse = JWKSUtils.getKeysForUse((JSONWebKeySet)jsonWebKeySet, (JWK.Use)JWK.Use.ENCRYPTION);
            String keyId = jweHeader.getKeyId();
            if (keyId == null) {
                KeysMetadataRepresentation.KeyMetadataRepresentation encKey = KeyUtils.getActiveEncKey((KeysMetadataRepresentation)this.testRealm().keys().getKeyMetadata(), (String)"PS256");
                keyId = encKey.getKid();
            }
            PublicKey decryptionKEK = (PublicKey)keysForUse.get(keyId);
            JWE jwe = new JWE().header(jweHeader).content(contentBytes);
            jwe.getKeyStorage().setEncryptionKey((Key)decryptionKEK);
            this.oauth = this.oauth.request(jwe.encodeJwe());
            this.oauth.doLogin("test-user@localhost", "password");
            this.events.expectLogin().assertEvent();
        }
    }
}

