/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AuthorizationResponseToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.By;

public class AuthorizationTokenResponseModeTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Test
    public void authorizationRequestQueryJWTResponseMode() throws Exception {
        this.oauth.responseMode(OIDCResponseMode.QUERY_JWT.value());
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(response.getResponse());
        Assert.assertEquals((Object)"test-app", (Object)responseToken.getAudience()[0]);
        Assert.assertNotNull(responseToken.getOtherClaims().get("code"));
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", responseToken.getOtherClaims().get("state"));
        Assert.assertNull(responseToken.getOtherClaims().get("error"));
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestJWTResponseMode() throws Exception {
        this.oauth.responseMode("jwt");
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(response.getResponse());
        Assert.assertEquals((Object)"test-app", (Object)responseToken.getAudience()[0]);
        Assert.assertNotNull(responseToken.getOtherClaims().get("code"));
        Assert.assertFalse((boolean)responseToken.getOtherClaims().containsKey("scope"));
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", responseToken.getOtherClaims().get("state"));
        Assert.assertNull(responseToken.getOtherClaims().get("error"));
        URI currentUri = new URI(this.driver.getCurrentUrl());
        Assert.assertNotNull((Object)currentUri.getRawQuery());
        Assert.assertNull((Object)currentUri.getRawFragment());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestFragmentJWTResponseMode() throws Exception {
        this.oauth.responseMode(OIDCResponseMode.FRAGMENT_JWT.value());
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(response.getResponse());
        Assert.assertEquals((Object)"test-app", (Object)responseToken.getAudience()[0]);
        Assert.assertNotNull(responseToken.getOtherClaims().get("code"));
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", responseToken.getOtherClaims().get("state"));
        Assert.assertNull(responseToken.getOtherClaims().get("error"));
        URI currentUri = new URI(this.driver.getCurrentUrl());
        Assert.assertNull((Object)currentUri.getRawQuery());
        Assert.assertNotNull((Object)currentUri.getRawFragment());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestFormPostJWTResponseMode() throws IOException {
        this.oauth.responseMode(OIDCResponseMode.FORM_POST_JWT.value());
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        String sources = this.driver.getPageSource();
        System.out.println(sources);
        String responseTokenEncoded = this.driver.findElement(By.id((String)"response")).getText();
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(responseTokenEncoded);
        Assert.assertEquals((Object)"test-app", (Object)responseToken.getAudience()[0]);
        Assert.assertNotNull(responseToken.getOtherClaims().get("code"));
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", responseToken.getOtherClaims().get("state"));
        Assert.assertNull(responseToken.getOtherClaims().get("error"));
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestJWTResponseModeIdTokenResponseType() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").implicitFlow(true);
        this.oauth.responseMode("jwt");
        this.oauth.responseType("code id_token");
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.nonce("123456");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(response.getResponse());
        Assert.assertEquals((Object)"test-app", (Object)responseToken.getAudience()[0]);
        Assert.assertNotNull(responseToken.getOtherClaims().get("code"));
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", responseToken.getOtherClaims().get("state"));
        Assert.assertNull(responseToken.getOtherClaims().get("error"));
        Assert.assertNotNull(responseToken.getOtherClaims().get("id_token"));
        String idTokenEncoded = (String)responseToken.getOtherClaims().get("id_token");
        IDToken idToken = this.oauth.verifyIDToken(idTokenEncoded);
        Assert.assertEquals((Object)"123456", (Object)idToken.getNonce());
        URI currentUri = new URI(this.driver.getCurrentUrl());
        Assert.assertNull((Object)currentUri.getRawQuery());
        Assert.assertNotNull((Object)currentUri.getRawFragment());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestJWTResponseModeAccessTokenResponseType() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").implicitFlow(true);
        this.oauth.responseMode("jwt");
        this.oauth.responseType("token id_token");
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.nonce("123456");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(response.getResponse());
        Assert.assertEquals((Object)"test-app", (Object)responseToken.getAudience()[0]);
        Assert.assertNull(responseToken.getOtherClaims().get("code"));
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", responseToken.getOtherClaims().get("state"));
        Assert.assertNull(responseToken.getOtherClaims().get("error"));
        Assert.assertNotNull(responseToken.getOtherClaims().get("id_token"));
        String idTokenEncoded = (String)responseToken.getOtherClaims().get("id_token");
        IDToken idToken = this.oauth.verifyIDToken(idTokenEncoded);
        Assert.assertEquals((Object)"123456", (Object)idToken.getNonce());
        Assert.assertNotNull(responseToken.getOtherClaims().get("access_token"));
        String accessTokenEncoded = (String)responseToken.getOtherClaims().get("access_token");
        AccessToken accessToken = this.oauth.verifyToken(accessTokenEncoded);
        Assert.assertEquals((Object)"123456", (Object)accessToken.getNonce());
        URI currentUri = new URI(this.driver.getCurrentUrl());
        Assert.assertNull((Object)currentUri.getRawQuery());
        Assert.assertNotNull((Object)currentUri.getRawFragment());
    }

    @Test
    public void authorizationRequestFailInvalidResponseModeQueryJWT() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").implicitFlow(true);
        this.oauth.responseMode("query.jwt");
        this.oauth.responseType("code id_token");
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.nonce("123456");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(errorResponse.getResponse());
        Assert.assertEquals((Object)"invalid_request", responseToken.getOtherClaims().get("error"));
        Assert.assertEquals((Object)"Response_mode 'query.jwt' is allowed only when the authorization response token is encrypted", responseToken.getOtherClaims().get("error_description"));
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void testErrorObjectExpectedClaims() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").implicitFlow(true);
        this.oauth.responseMode("query.jwt");
        this.oauth.responseType("code id_token");
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.nonce("123456");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        AuthorizationResponseToken responseToken = this.oauth.verifyAuthorizationResponseToken(errorResponse.getResponse());
        Assert.assertNotNull((Object)responseToken.getIssuer());
        Assert.assertNotNull((Object)responseToken.getExp());
        Assert.assertNotNull((Object)responseToken.getAudience());
        Assert.assertNotEquals((long)0L, (long)responseToken.getAudience().length);
        Assert.assertTrue((boolean)responseToken.getOtherClaims().containsKey("error"));
        Assert.assertTrue((boolean)responseToken.getOtherClaims().containsKey("error_description"));
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

