/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Map;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.AesCbcHmacShaContentEncryptionProvider;
import org.keycloak.crypto.AesGcmContentEncryptionProvider;
import org.keycloak.crypto.RsaCekManagementProvider;
import org.keycloak.jose.JOSEHeader;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AuthorizationResponseToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;

public class AuthorizationTokenEncryptionTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA1_5EncA128CBC_HS256() {
        TokenSignatureUtil.registerKeyProvider((String)"P-256", (Keycloak)this.adminClient, (TestContext)this.testContext);
        this.testAuthorizationTokenSignatureAndEncryption("ES256", "RSA1_5", "A128CBC-HS256");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA1_5EncA192CBC_HS384() {
        this.testAuthorizationTokenSignatureAndEncryption("PS256", "RSA1_5", "A192CBC-HS384");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA1_5EncA256CBC_HS512() {
        this.testAuthorizationTokenSignatureAndEncryption("PS384", "RSA1_5", "A256CBC-HS512");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA1_5EncA128GCM() {
        this.testAuthorizationTokenSignatureAndEncryption("RS384", "RSA1_5", "A128GCM");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA1_5EncA192GCM() {
        this.testAuthorizationTokenSignatureAndEncryption("RS512", "RSA1_5", "A192GCM");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA1_5EncA256GCM() {
        this.testAuthorizationTokenSignatureAndEncryption("RS256", "RSA1_5", "A256GCM");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEPEncA128CBC_HS256() {
        TokenSignatureUtil.registerKeyProvider((String)"P-521", (Keycloak)this.adminClient, (TestContext)this.testContext);
        this.testAuthorizationTokenSignatureAndEncryption("ES512", "RSA-OAEP", "A128CBC-HS256");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEPEncA192CBC_HS384() {
        this.testAuthorizationTokenSignatureAndEncryption("PS256", "RSA-OAEP", "A192CBC-HS384");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEPEncA256CBC_HS512() {
        this.testAuthorizationTokenSignatureAndEncryption("PS512", "RSA-OAEP", "A256CBC-HS512");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEP256EncA128CBC_HS256() {
        TokenSignatureUtil.registerKeyProvider((String)"P-521", (Keycloak)this.adminClient, (TestContext)this.testContext);
        this.testAuthorizationTokenSignatureAndEncryption("ES512", "RSA-OAEP-256", "A128CBC-HS256");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEP256EncA192CBC_HS384() {
        this.testAuthorizationTokenSignatureAndEncryption("PS256", "RSA-OAEP-256", "A192CBC-HS384");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEP256EncA256CBC_HS512() {
        this.testAuthorizationTokenSignatureAndEncryption("PS512", "RSA-OAEP-256", "A256CBC-HS512");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEPEncA128GCM() {
        TokenSignatureUtil.registerKeyProvider((String)"P-256", (Keycloak)this.adminClient, (TestContext)this.testContext);
        this.testAuthorizationTokenSignatureAndEncryption("ES256", "RSA-OAEP", "A128GCM");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEPEncA192GCM() {
        this.testAuthorizationTokenSignatureAndEncryption("PS384", "RSA-OAEP", "A192GCM");
    }

    @Test
    public void testAuthorizationEncryptionAlgRSA_OAEPEncA256GCM() {
        this.testAuthorizationTokenSignatureAndEncryption("PS512", "RSA-OAEP", "A256GCM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAuthorizationTokenSignatureAndEncryption(String sigAlgorithm, String algAlgorithm, String encAlgorithm) {
        try {
            TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
            oidcClientEndpointsResource.generateKeys(algAlgorithm);
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            ClientRepresentation clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationSignedResponseAlg(sigAlgorithm);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseAlg(algAlgorithm);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseEnc(encAlgorithm);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
            String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(jwksUrl);
            clientResource.update(clientRep);
            this.oauth.responseMode("jwt");
            this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
            OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
            String jweStr = response.getResponse();
            String[] parts = jweStr.split("\\.");
            Assert.assertEquals((long)parts.length, (long)5L);
            Map keyPair = oidcClientEndpointsResource.getKeysAsPem();
            PrivateKey decryptionKEK = PemUtils.decodePrivateKey((String)((String)keyPair.get("privateKey")));
            JWEAlgorithmProvider algorithmProvider = this.getJweAlgorithmProvider(algAlgorithm);
            JWEEncryptionProvider encryptionProvider = this.getJweEncryptionProvider(encAlgorithm);
            byte[] decodedString = TokenUtil.jweKeyEncryptionVerifyAndDecode((Key)decryptionKEK, (String)jweStr, (JWEAlgorithmProvider)algorithmProvider, (JWEEncryptionProvider)encryptionProvider);
            String authorizationTokenString = new String(decodedString, "UTF-8");
            JWEHeader jweHeader = (JWEHeader)this.getHeader(parts[0]);
            Assert.assertEquals((Object)"JWT", (Object)jweHeader.getContentType());
            AuthorizationResponseToken authorizationToken = this.oauth.verifyAuthorizationResponseToken(authorizationTokenString);
            Assert.assertEquals((Object)"test-app", (Object)authorizationToken.getAudience()[0]);
            Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", authorizationToken.getOtherClaims().get("state"));
            Assert.assertNotNull(authorizationToken.getOtherClaims().get("code"));
        }
        catch (UnsupportedEncodingException | JWEException e) {
            Assert.fail();
        }
        finally {
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            ClientRepresentation clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationSignedResponseAlg("RS256");
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseAlg(null);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseEnc(null);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(false);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(null);
            clientResource.update(clientRep);
        }
    }

    private JWEAlgorithmProvider getJweAlgorithmProvider(String algAlgorithm) {
        JWEAlgorithmProvider jweAlgorithmProvider = null;
        if ("RSA1_5".equals(algAlgorithm) || "RSA-OAEP".equals(algAlgorithm) || "RSA-OAEP-256".equals(algAlgorithm)) {
            jweAlgorithmProvider = new RsaCekManagementProvider(null, algAlgorithm).jweAlgorithmProvider();
        }
        return jweAlgorithmProvider;
    }

    private JWEEncryptionProvider getJweEncryptionProvider(String encAlgorithm) {
        JWEEncryptionProvider jweEncryptionProvider = null;
        switch (encAlgorithm) {
            case "A128GCM": 
            case "A192GCM": 
            case "A256GCM": {
                jweEncryptionProvider = new AesGcmContentEncryptionProvider(null, encAlgorithm).jweEncryptionProvider();
                break;
            }
            case "A128CBC-HS256": 
            case "A192CBC-HS384": 
            case "A256CBC-HS512": {
                jweEncryptionProvider = new AesCbcHmacShaContentEncryptionProvider(null, encAlgorithm).jweEncryptionProvider();
            }
        }
        return jweEncryptionProvider;
    }

    private JOSEHeader getHeader(String base64Header) {
        try {
            byte[] decodedHeader = Base64Url.decode((String)base64Header);
            return (JOSEHeader)JsonSerialization.readValue((byte[])decodedHeader, JWEHeader.class);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @UncaughtServerErrorExpected
    public void testAuthorizationEncryptionWithoutEncryptionKEK() throws MalformedURLException, URISyntaxException {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
            oidcClientEndpointsResource.generateKeys("RS256");
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationSignedResponseAlg("RS256");
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseAlg("RSA1_5");
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseEnc("A128CBC-HS256");
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
            String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(jwksUrl);
            clientResource.update(clientRep);
            this.oauth.responseMode("jwt");
            this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
            OAuthClient.AuthorizationEndpointResponse errorResponse = this.oauth.doLogin("test-user@localhost", "password");
            System.out.println(this.driver.getPageSource().contains("Unexpected error when handling authentication request to identity provider."));
        }
        finally {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationSignedResponseAlg("RS256");
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseAlg(null);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setAuthorizationEncryptedResponseEnc(null);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(false);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(null);
            clientResource.update(clientRep);
        }
    }
}

