/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.oidc.AbstractOIDCScopeTest;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AudienceTest
extends AbstractOIDCScopeTest {
    private static final String userId = KeycloakModelUtils.generateId();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ClientRepresentation client1 = new ClientRepresentation();
        client1.setClientId("service-client");
        client1.setProtocol("openid-connect");
        client1.setBearerOnly(Boolean.valueOf(true));
        client1.setBaseUrl("http://foo/service-client");
        testRealm.getClients().add(client1);
        RoleRepresentation role1 = new RoleRepresentation();
        role1.setName("role1");
        testRealm.getRoles().getClient().put("service-client", Arrays.asList(role1));
        ClientRepresentation testApp = testRealm.getClients().stream().filter(client -> "test-app".equals(client.getClientId())).findFirst().get();
        testApp.setFullScopeAllowed(Boolean.valueOf(false));
        UserRepresentation user = UserBuilder.create().id(userId).username("john").enabled(true).email("john@email.cz").firstName("John").lastName("Doe").password("password").role("account", "manage-account").role("account", "view-profile").role("service-client", "role1").build();
        testRealm.getUsers().add(user);
    }

    @Before
    public void beforeTest() {
        ClientScopeResource clientScopeRes = ApiUtil.findClientScopeByName((RealmResource)this.testRealm(), (String)"audience-scope");
        if (clientScopeRes != null) {
            return;
        }
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("audience-scope");
        clientScope.setProtocol("openid-connect");
        Response resp = this.testRealm().clientScopes().create(clientScope);
        String clientScopeId = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"test-app");
        client.addOptionalClientScope(clientScopeId);
    }

    @Test
    public void testAudienceProtocolMapperWithClientAudience() throws Exception {
        ProtocolMapperRepresentation audienceMapper = ProtocolMapperUtil.createAudienceMapper("audience mapper", "service-client", null, true, false);
        ClientScopeResource clientScope = ApiUtil.findClientScopeByName((RealmResource)this.testRealm(), (String)"audience-scope");
        Response resp = clientScope.getProtocolMappers().createMapper(audienceMapper);
        String mapperId = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        this.oauth.scope("openid audience-scope");
        this.oauth.doLogin("john", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid profile email audience-scope", "test-app");
        this.assertAudiences((JsonWebToken)tokens.accessToken, "service-client");
        this.assertAudiences((JsonWebToken)tokens.idToken, "test-app");
        clientScope.getProtocolMappers().delete(mapperId);
    }

    @Test
    public void testAudienceProtocolMapperWithCustomAudience() throws Exception {
        ProtocolMapperRepresentation audienceMapper = ProtocolMapperUtil.createAudienceMapper("audience mapper 1", null, "http://host/service/ctx1", true, false);
        ClientScopeResource clientScope = ApiUtil.findClientScopeByName((RealmResource)this.testRealm(), (String)"audience-scope");
        Response resp = clientScope.getProtocolMappers().createMapper(audienceMapper);
        String mapper1Id = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        audienceMapper = ProtocolMapperUtil.createAudienceMapper("audience mapper 2", null, "http://host/service/ctx2", true, true);
        resp = clientScope.getProtocolMappers().createMapper(audienceMapper);
        String mapper2Id = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        this.oauth.scope("openid audience-scope");
        this.oauth.doLogin("john", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).assertEvent();
        AbstractOIDCScopeTest.Tokens tokens = this.sendTokenRequest(loginEvent, userId, "openid profile email audience-scope", "test-app");
        this.assertAudiences((JsonWebToken)tokens.accessToken, "http://host/service/ctx1", "http://host/service/ctx2");
        this.assertAudiences((JsonWebToken)tokens.idToken, "test-app", "http://host/service/ctx2");
        clientScope.getProtocolMappers().delete(mapper1Id);
        clientScope.getProtocolMappers().delete(mapper2Id);
    }

    private void assertAudiences(JsonWebToken token, String ... expectedAudience) {
        List audiences = token.getAudience() == null ? Collections.emptyList() : Arrays.asList(token.getAudience());
        List<String> expectedAudiences = Arrays.asList(expectedAudience);
        Assert.assertTrue((String)("Not matched. expectedAudiences: " + expectedAudiences + ", audiences: " + audiences), (expectedAudiences.containsAll(audiences) && audiences.containsAll(expectedAudiences) ? 1 : 0) != 0);
    }
}

