/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Rule;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.OAuthClient;

public abstract class AbstractOIDCScopeTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected AccountApplicationsPage accountAppsPage;
    @Page
    protected ErrorPage errorPage;

    protected Tokens sendTokenRequest(EventRepresentation loginEvent, String userId, String expectedScope, String clientId) {
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.log.info((Object)("expectedScopes = " + expectedScope));
        this.log.info((Object)("responseScopes = " + response.getScope()));
        AbstractOIDCScopeTest.assertScopes(expectedScope, response.getScope());
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        AbstractOIDCScopeTest.assertScopes(expectedScope, accessToken.getScope());
        EventRepresentation codeToTokenEvent = this.events.expectCodeToToken(codeId, sessionId).user(userId).client(clientId).assertEvent();
        AbstractOIDCScopeTest.assertScopes(expectedScope, (String)codeToTokenEvent.getDetails().get("scope"));
        return new Tokens(idToken, accessToken, response.getRefreshToken());
    }

    public static void assertScopes(String expectedScope, String receivedScope) {
        List<String> expectedScopes = Arrays.asList(expectedScope.split(" "));
        List<String> receivedScopes = Arrays.asList(receivedScope.split(" "));
        Assert.assertTrue((String)("Not matched. expectedScope: " + expectedScope + ", receivedScope: " + receivedScope), (expectedScopes.containsAll(receivedScopes) && receivedScopes.containsAll(expectedScopes) ? 1 : 0) != 0);
    }

    static class Tokens {
        final IDToken idToken;
        final AccessToken accessToken;
        final String refreshToken;

        private Tokens(IDToken idToken, AccessToken accessToken, String refreshToken) {
            this.idToken = idToken;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
        }
    }
}

