/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.oidc.AbstractOIDCScopeTest;
import org.keycloak.testsuite.oidc.OIDCScopeTest;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

public class TokenIntrospectionTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ClientRepresentation confApp = KeycloakModelUtils.createClient(testRealm, "confidential-cli");
        confApp.setSecret("secret1");
        confApp.setServiceAccountsEnabled(Boolean.TRUE);
        ClientRepresentation pubApp = KeycloakModelUtils.createClient(testRealm, "public-cli");
        pubApp.setPublicClient(Boolean.TRUE);
        ClientRepresentation samlApp = KeycloakModelUtils.createClient(testRealm, "saml-client");
        samlApp.setSecret("secret2");
        samlApp.setServiceAccountsEnabled(Boolean.TRUE);
        samlApp.setProtocol("saml");
        UserRepresentation user = new UserRepresentation();
        user.setUsername("no-permissions");
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        ArrayList<CredentialRepresentation> creds = new ArrayList<CredentialRepresentation>();
        creds.add(credential);
        user.setCredentials(creds);
        user.setEnabled(Boolean.TRUE);
        ArrayList<String> realmRoles = new ArrayList<String>();
        realmRoles.add("user");
        user.setRealmRoles(realmRoles);
        testRealm.getUsers().add(user);
    }

    @Override
    protected void afterAbstractKeycloakTestRealmImport() {
        ClientScopesResource clientScopesResource = this.testRealm().clientScopes();
        List clientScopeRepresentations = clientScopesResource.findAll();
        for (ClientScopeRepresentation scope : clientScopeRepresentations) {
            List mappers = scope.getProtocolMappers();
            if (mappers == null) continue;
            for (ProtocolMapperRepresentation mapper : mappers) {
                if (!"username".equals(mapper.getName())) continue;
                Map config = mapper.getConfig();
                config.put("user.attribute", "username");
                config.put("claim.name", "preferred_username12");
                clientScopesResource.get(scope.getId()).getProtocolMappers().update(mapper.getId(), mapper);
            }
        }
    }

    @Test
    public void testConfidentialClientCredentialsBasicAuthentication() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        org.junit.Assert.assertTrue((boolean)jsonNode.get("active").asBoolean());
        org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)jsonNode.get("username").asText());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)jsonNode.get("client_id").asText());
        org.junit.Assert.assertTrue((boolean)jsonNode.has("exp"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("iat"));
        org.junit.Assert.assertFalse((boolean)jsonNode.has("nbf"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("sub"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("aud"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("iss"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("jti"));
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertTrue((boolean)rep.isActive());
        org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        org.junit.Assert.assertEquals((long)jsonNode.get("exp").asInt(), (long)rep.getExpiration());
        org.junit.Assert.assertEquals((long)jsonNode.get("iat").asInt(), (long)rep.getIssuedAt());
        org.junit.Assert.assertEquals((Object)jsonNode.get("nbf"), (Object)rep.getNbf());
        org.junit.Assert.assertEquals((Object)jsonNode.get("sub").asText(), (Object)rep.getSubject());
        ArrayList<String> audiences = new ArrayList<String>();
        org.junit.Assert.assertTrue((boolean)(jsonNode.get("aud") instanceof TextNode));
        audiences.add(jsonNode.get("aud").asText());
        Assert.assertNames(audiences, rep.getAudience());
        org.junit.Assert.assertEquals((Object)jsonNode.get("iss").asText(), (Object)rep.getIssuer());
        org.junit.Assert.assertEquals((Object)jsonNode.get("jti").asText(), (Object)rep.getId());
    }

    @Test
    public void testInvalidClientCredentials() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "bad_credential", accessTokenResponse.getAccessToken());
        OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)JsonSerialization.readValue((String)tokenResponse, OAuth2ErrorRepresentation.class);
        Assert.assertEquals((Object)"Authentication failed.", (Object)errorRep.getErrorDescription());
        Assert.assertEquals((Object)"invalid_request", (Object)errorRep.getError());
    }

    @Test
    public void testIntrospectRefreshToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getRefreshToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        org.junit.Assert.assertTrue((boolean)jsonNode.get("active").asBoolean());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)jsonNode.get("session_state").asText());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)jsonNode.get("client_id").asText());
        org.junit.Assert.assertTrue((boolean)jsonNode.has("exp"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("iat"));
        org.junit.Assert.assertFalse((boolean)jsonNode.has("nbf"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("sub"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("aud"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("iss"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("jti"));
        org.junit.Assert.assertTrue((boolean)jsonNode.has("typ"));
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertTrue((boolean)rep.isActive());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        org.junit.Assert.assertEquals((Object)jsonNode.get("session_state").asText(), (Object)rep.getSessionState());
        org.junit.Assert.assertEquals((long)jsonNode.get("exp").asInt(), (long)rep.getExpiration());
        org.junit.Assert.assertEquals((long)jsonNode.get("iat").asInt(), (long)rep.getIssuedAt());
        org.junit.Assert.assertEquals((Object)jsonNode.get("nbf"), (Object)rep.getNbf());
        org.junit.Assert.assertEquals((Object)jsonNode.get("iss").asText(), (Object)rep.getIssuer());
        org.junit.Assert.assertEquals((Object)jsonNode.get("jti").asText(), (Object)rep.getId());
        org.junit.Assert.assertEquals((Object)jsonNode.get("typ").asText(), (Object)"Refresh");
    }

    @Test
    public void testIntrospectRefreshTokenAfterUserSessionLogoutAndLoginAgain() throws Exception {
        OAuthClient.AccessTokenResponse accessTokenResponse = this.loginAndForceNewLoginPage();
        String refreshToken1 = accessTokenResponse.getRefreshToken();
        this.oauth.doLogout(refreshToken1, "password");
        this.events.clear();
        this.setTimeOffset(2);
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        Assert.assertFalse((boolean)this.loginPage.isCurrent());
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse2 = this.oauth.doAccessTokenRequest(code, "password");
        String introspectResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", tokenResponse2.getRefreshToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(introspectResponse);
        org.junit.Assert.assertTrue((boolean)jsonNode.get("active").asBoolean());
        introspectResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", refreshToken1);
        jsonNode = objectMapper.readTree(introspectResponse);
        org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
    }

    @Test
    public void testPublicClientCredentialsNotAllowed() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("public-cli", "it_doesnt_matter", accessTokenResponse.getAccessToken());
        OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)JsonSerialization.readValue((String)tokenResponse, OAuth2ErrorRepresentation.class);
        Assert.assertEquals((Object)"Client not allowed.", (Object)errorRep.getErrorDescription());
        Assert.assertEquals((Object)"invalid_request", (Object)errorRep.getError());
    }

    @Test
    public void testInactiveAccessToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String inactiveAccessToken = "eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICJGSjg2R2NGM2pUYk5MT2NvNE52WmtVQ0lVbWZZQ3FvcXRPUWVNZmJoTmxFIn0.eyJqdGkiOiI5NjgxZTRlOC01NzhlLTQ3M2ItOTIwNC0yZWE5OTdhYzMwMTgiLCJleHAiOjE0NzYxMDY4NDksIm5iZiI6MCwiaWF0IjoxNDc2MTA2NTQ5LCJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgxODAvYXV0aC9yZWFsbXMvdGVzdCIsImF1ZCI6InRlc3QtYXBwIiwic3ViIjoiZWYyYzk0NjAtZDRkYy00OTk5LWJlYmUtZWVmYWVkNmJmMGU3IiwidHlwIjoiQmVhcmVyIiwiYXpwIjoidGVzdC1hcHAiLCJhdXRoX3RpbWUiOjE0NzYxMDY1NDksInNlc3Npb25fc3RhdGUiOiI1OGY4M2MzMi03MDhkLTQzNjktODhhNC05YjI5OGRjMDY5NzgiLCJhY3IiOiIxIiwiY2xpZW50X3Nlc3Npb24iOiI2NTYyOTVkZC1kZWNkLTQyZDAtYWJmYy0zZGJjZjJlMDE3NzIiLCJhbGxvd2VkLW9yaWdpbnMiOlsiaHR0cDovL2xvY2FsaG9zdDo4MTgwIl0sInJlYWxtX2FjY2VzcyI6eyJyb2xlcyI6WyJ1c2VyIl19LCJyZXNvdXJjZV9hY2Nlc3MiOnsidGVzdC1hcHAiOnsicm9sZXMiOlsiY3VzdG9tZXItdXNlciJdfSwiYWNjb3VudCI6eyJyb2xlcyI6WyJtYW5hZ2UtYWNjb3VudCIsInZpZXctcHJvZmlsZSJdfX0sIm5hbWUiOiJUb20gQnJhZHkiLCJwcmVmZXJyZWRfdXNlcm5hbWUiOiJ0ZXN0LXVzZXJAbG9jYWxob3N0IiwiZ2l2ZW5fbmFtZSI6IlRvbSIsImZhbWlseV9uYW1lIjoiQnJhZHkiLCJlbWFpbCI6InRlc3QtdXNlckBsb2NhbGhvc3QifQ.LYU7opqZsc9e-ZmdsIhcecjHL3kQkpP13VpwO4MHMqEVNeJsZI1WOkTM5HGVAihcPfQazhaYvcik0gFTF_6ZcKzDqanjx80TGhSIrV5FoCeUrbp7w_66VKDH7ImPc8T2kICQGHh2d521WFBnvXNifw7P6AR1rGg4qrUljHdf_KU";
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", inactiveAccessToken);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertFalse((boolean)rep.isActive());
        org.junit.Assert.assertNull((Object)rep.getUserName());
        org.junit.Assert.assertNull((Object)rep.getClientId());
        org.junit.Assert.assertNull((Object)rep.getSubject());
    }

    @Test
    public void testUnsupportedToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String inactiveAccessToken = "unsupported";
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", inactiveAccessToken);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertFalse((boolean)rep.isActive());
        org.junit.Assert.assertNull((Object)rep.getUserName());
        org.junit.Assert.assertNull((Object)rep.getClientId());
        org.junit.Assert.assertNull((Object)rep.getSubject());
    }

    @Test
    public void testIntrospectAccessToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertTrue((boolean)rep.isActive());
        org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        org.junit.Assert.assertEquals((Object)loginEvent.getUserId(), (Object)rep.getSubject());
        AbstractOIDCScopeTest.assertScopes("openid email profile", rep.getScope());
    }

    @Test
    public void testIntrospectAccessTokenES256() throws Exception {
        this.testIntrospectAccessToken("ES256");
    }

    @Test
    public void testIntrospectAccessTokenPS256() throws Exception {
        this.testIntrospectAccessToken("PS256");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntrospectAccessToken(String jwaAlgorithm) throws Exception {
        try {
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)jwaAlgorithm);
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((Object)jwaAlgorithm, (Object)new JWSInput(accessTokenResponse.getAccessToken()).getHeader().getAlgorithm().name());
            String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
            TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
            org.junit.Assert.assertTrue((boolean)rep.isActive());
            org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
            org.junit.Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
            org.junit.Assert.assertEquals((Object)loginEvent.getUserId(), (Object)rep.getSubject());
            OIDCScopeTest.assertScopes("openid email profile", rep.getScope());
        }
        finally {
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)"RS256");
        }
    }

    @Test
    public void testIntrospectAccessTokenSessionInvalid() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.oauth.doLogout(accessTokenResponse.getRefreshToken(), "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertFalse((boolean)rep.isActive());
        org.junit.Assert.assertNull((Object)rep.getUserName());
        org.junit.Assert.assertNull((Object)rep.getClientId());
        org.junit.Assert.assertNull((Object)rep.getSubject());
    }

    @Test
    public void testIntrospectAccessTokenOfflineAccess() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(86400);
        accessTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertTrue((boolean)rep.isActive());
        org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        this.testingClient.testing().removeExpired("test");
        accessTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), "password");
        tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertTrue((boolean)rep.isActive());
        org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
    }

    @Test
    public void testIntrospectDoesntExtendTokenLifespan() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        accessTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), "password");
        this.setTimeOffset(1200);
        String tokenResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getRefreshToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertTrue((boolean)rep.isActive());
        org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        org.junit.Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        this.setTimeOffset(2400);
        accessTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), "password");
        org.junit.Assert.assertEquals((long)400L, (long)accessTokenResponse.getStatusCode());
        org.junit.Assert.assertEquals((Object)"Token is not active", (Object)accessTokenResponse.getErrorDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntrospectAccessTokenUserDisabled() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        UserRepresentation userRep = new UserRepresentation();
        try {
            userRep.setEnabled(Boolean.valueOf(false));
            this.adminClient.realm(this.oauth.getRealm()).users().get(loginEvent.getUserId()).update(userRep);
            String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
            TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
            org.junit.Assert.assertFalse((boolean)rep.isActive());
            org.junit.Assert.assertNull((Object)rep.getUserName());
            org.junit.Assert.assertNull((Object)rep.getClientId());
            org.junit.Assert.assertNull((Object)rep.getSubject());
        }
        finally {
            userRep.setEnabled(Boolean.valueOf(true));
            this.adminClient.realm(this.oauth.getRealm()).users().get(loginEvent.getUserId()).update(userRep);
        }
    }

    @Test
    public void testIntrospectAccessTokenExpired() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(this.adminClient.realm(this.oauth.getRealm()).toRepresentation().getAccessTokenLifespan() + 1);
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertFalse((boolean)rep.isActive());
        org.junit.Assert.assertNull((Object)rep.getUserName());
        org.junit.Assert.assertNull((Object)rep.getClientId());
        org.junit.Assert.assertNull((Object)rep.getSubject());
    }

    @Test
    public void testIntrospectWithSamlClient() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.events.expectLogin().assertEvent();
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("saml-client", "secret2", accessTokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertEquals((Object)"invalid_client", rep.getOtherClaims().get("error"));
        org.junit.Assert.assertNull((Object)rep.getSubject());
    }

    private OAuthClient.AccessTokenResponse loginAndForceNewLoginPage() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(1);
        String loginFormUri = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl()).queryParam("prompt", new Object[]{"login"}).build(new Object[0]).toString();
        this.driver.navigate().to(loginFormUri);
        this.loginPage.assertCurrent();
        return tokenResponse;
    }

    @Test
    public void testIntrospectionRequestParamsMoreThanOnce() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        accessTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), "password");
        String tokenResponse = this.introspectAccessTokenWithDuplicateParams("confidential-cli", "secret1", accessTokenResponse.getAccessToken());
        OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)JsonSerialization.readValue((String)tokenResponse, OAuth2ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"duplicated parameter", (Object)errorRep.getErrorDescription());
        org.junit.Assert.assertEquals((Object)"invalid_request", (Object)errorRep.getError());
    }

    @Test
    public void testIntrospectRevokeRefreshToken() throws Exception {
        RealmRepresentation realm = this.adminClient.realm(this.oauth.getRealm()).toRepresentation();
        realm.setRevokeRefreshToken(Boolean.valueOf(true));
        this.adminClient.realm(this.oauth.getRealm()).update(realm);
        try {
            JsonNode jsonNode = this.introspectRevokedToken();
            org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
        }
        finally {
            realm.setRevokeRefreshToken(Boolean.valueOf(false));
            this.adminClient.realm(this.oauth.getRealm()).update(realm);
        }
    }

    @Test
    public void testIntrospectRevokeOfflineToken() throws Exception {
        RealmRepresentation realm = this.adminClient.realm(this.oauth.getRealm()).toRepresentation();
        realm.setRevokeRefreshToken(Boolean.valueOf(true));
        this.adminClient.realm(this.oauth.getRealm()).update(realm);
        try {
            this.oauth.scope("offline_access");
            JsonNode jsonNode = this.introspectRevokedToken();
            org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
        }
        finally {
            realm.setRevokeRefreshToken(Boolean.valueOf(false));
            this.adminClient.realm(this.oauth.getRealm()).update(realm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntrospectRefreshTokenAfterRefreshTokenRequest() throws Exception {
        RealmRepresentation realm = this.adminClient.realm(this.oauth.getRealm()).toRepresentation();
        realm.setRevokeRefreshToken(Boolean.valueOf(true));
        realm.setRefreshTokenMaxReuse(Integer.valueOf(1));
        this.adminClient.realm(this.oauth.getRealm()).update(realm);
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            String oldRefreshToken = accessTokenResponse.getRefreshToken();
            this.setTimeOffset(1);
            accessTokenResponse = this.oauth.doRefreshTokenRequest(oldRefreshToken, "password");
            accessTokenResponse = this.oauth.doRefreshTokenRequest(oldRefreshToken, "password");
            String newRefreshToken = accessTokenResponse.getRefreshToken();
            String tokenResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", newRefreshToken);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(tokenResponse);
            org.junit.Assert.assertTrue((boolean)jsonNode.get("active").asBoolean());
            accessTokenResponse = this.oauth.doRefreshTokenRequest(newRefreshToken, "password");
            tokenResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", oldRefreshToken);
            jsonNode = objectMapper.readTree(tokenResponse);
            org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
        }
        finally {
            realm.setRevokeRefreshToken(Boolean.valueOf(false));
            realm.setRefreshTokenMaxReuse(Integer.valueOf(0));
            this.adminClient.realm(this.oauth.getRealm()).update(realm);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String introspectAccessTokenWithDuplicateParams(String clientId, String clientSecret, String tokenToIntrospect) {
        UrlEncodedFormEntity formEntity;
        HttpPost post = new HttpPost(this.oauth.getTokenIntrospectionUrl());
        String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
        post.setHeader("Authorization", authorization);
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("token", tokenToIntrospect));
        parameters.add(new BasicNameValuePair("token", "foo"));
        parameters.add(new BasicNameValuePair("token_type_hint", "access_token"));
        try {
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setEntity((HttpEntity)formEntity);
        try (CloseableHttpResponse response = HttpClientBuilder.create().build().execute((HttpUriRequest)post);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)out);
            String string = new String(out.toByteArray());
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve access token", e);
        }
    }

    private JsonNode introspectRevokedToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String stringRefreshToken = accessTokenResponse.getRefreshToken();
        accessTokenResponse = this.oauth.doRefreshTokenRequest(stringRefreshToken, "password");
        String tokenResponse = this.oauth.introspectRefreshTokenWithClientCredential("confidential-cli", "secret1", stringRefreshToken);
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(tokenResponse);
    }
}

