/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.mappers.SHA256PairwiseSubMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.UserInfo;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class ServiceAccountTest
extends AbstractKeycloakTest {
    private static String userId;
    private static String userName;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name("test").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").testEventListener();
        ClientRepresentation enabledApp = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("service-account-cl-refresh-on").secret("secret1").serviceAccountsEnabled(true).attribute("client_credentials.use_refresh_token", "true").build();
        realm.client(enabledApp);
        ClientRepresentation enabledAppWithSkipRefreshToken = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("service-account-cl").secret("secret1").serviceAccountsEnabled(true).build();
        realm.client(enabledAppWithSkipRefreshToken);
        ClientRepresentation disabledApp = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("service-account-disabled").secret("secret1").build();
        realm.client(disabledApp);
        UserBuilder defaultUser = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("test-user@localhost");
        realm.user(defaultUser);
        userId = KeycloakModelUtils.generateId();
        userName = "service-account-" + enabledApp.getClientId();
        UserBuilder serviceAccountUser = UserBuilder.create().id(userId).username(userName).serviceAccountId(enabledApp.getClientId());
        realm.user(serviceAccountUser);
        testRealms.add(realm.build());
    }

    @Test
    public void clientCredentialsAuthSuccess() throws Exception {
        this.oauth.clientId("service-account-cl-refresh-on");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        List clientSessionStats = this.getAdminClient().realm(this.oauth.getRealm()).getClientSessionStats();
        Assert.assertThat((Object)clientSessionStats, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
        Map sessionStats = (Map)clientSessionStats.get(0);
        Assert.assertEquals(sessionStats.get("clientId"), (Object)this.oauth.getClientId());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        this.events.expectClientLogin().client("service-account-cl-refresh-on").user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", userName).assertEvent();
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        System.out.println("Access token other claims: " + accessToken.getOtherClaims());
        Assert.assertEquals((Object)"service-account-cl-refresh-on", accessToken.getOtherClaims().get("clientId"));
        Assert.assertTrue((boolean)accessToken.getOtherClaims().containsKey("clientAddress"));
        Assert.assertTrue((boolean)accessToken.getOtherClaims().containsKey("clientHost"));
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshedResponse.getRefreshToken());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client("service-account-cl-refresh-on").assertEvent();
    }

    @Test
    public void clientCredentialsLogout() throws Exception {
        this.oauth.clientId("service-account-cl-refresh-on");
        this.events.clear();
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        this.events.expectClientLogin().client("service-account-cl-refresh-on").user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", userName).detail("client_auth_method", "client-secret").assertEvent();
        CloseableHttpResponse logoutResponse = this.oauth.doLogout(response.getRefreshToken(), "secret1");
        Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        this.events.expectLogout(accessToken.getSessionState()).client("service-account-cl-refresh-on").user(userId).removeDetail("redirect_uri").assertEvent();
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).client("service-account-cl-refresh-on").user(userId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
    }

    @Test
    public void clientCredentialsInvalidClientCredentials() throws Exception {
        this.oauth.clientId("service-account-cl");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret2");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectClientLogin().client("service-account-cl").session((String)null).clearDetails().error("invalid_client_credentials").user((String)null).assertEvent();
    }

    @Test
    public void clientCredentialsDisabledServiceAccount() throws Exception {
        this.oauth.clientId("service-account-disabled");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectClientLogin().client("service-account-disabled").user((String)null).session((String)null).removeDetail("username").removeDetail("response_type").error("invalid_client").assertEvent();
    }

    @Test
    public void changeClientIdTest() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl-refresh-on").renameTo("updated-client");
        this.oauth.clientId("updated-client");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)"updated-client", accessToken.getOtherClaims().get("clientId"));
        this.events.expectClientLogin().client("updated-client").user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("username", "service-account-updated-client").assertEvent();
        ClientManager.realm(this.adminClient.realm("test")).clientId("updated-client").renameTo("service-account-cl-refresh-on");
    }

    @Test
    public void refreshTokenRefreshForDisabledServiceAccount() throws Exception {
        try {
            this.oauth.clientId("service-account-cl");
            OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl").setServiceAccountsEnabled(false);
            response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
        }
        finally {
            ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl").setServiceAccountsEnabled(true);
            UserRepresentation userRepresentation = ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl").getServiceAccountUser();
        }
    }

    @Test
    public void clientCredentialsAuthRequest_ClientES256_RealmPS256() throws Exception {
        this.conductClientCredentialsAuthRequestWithRefreshToken("HS256", "ES256", "PS256");
    }

    @Test
    public void failManagePassword() {
        UserResource serviceAccount = this.adminClient.realm("test").users().get(userId);
        UserRepresentation representation = serviceAccount.toRepresentation();
        CredentialRepresentation password = new CredentialRepresentation();
        password.setValue("password");
        password.setType("password");
        password.setTemporary(Boolean.valueOf(false));
        representation.setCredentials(Arrays.asList(password));
        this.expectedException.expect(org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.instanceOf(ClientErrorException.class), (Matcher)org.hamcrest.Matchers.hasProperty((String)"response", (Matcher)org.hamcrest.Matchers.hasProperty((String)"status", (Matcher)org.hamcrest.Matchers.is((Object)400)))));
        this.expectedException.reportMissingExceptionWithMessage("Should fail, should not be possible to manage credentials for service accounts");
        serviceAccount.update(representation);
    }

    @Test
    public void clientCredentialsAuthSuccessWithoutRefreshToken_revokeToken() throws Exception {
        String tokenString = this.clientCredentialsAuthSuccessWithoutRefreshTokenImpl();
        AccessToken accessToken = this.oauth.verifyToken(tokenString);
        CloseableHttpResponse response1 = this.oauth.doTokenRevoke(tokenString, "access_token", "secret1");
        Assert.assertThat((Object)response1, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        response1.close();
        this.events.expect(EventType.REVOKE_GRANT).client("service-account-cl").user(AssertEvents.isUUID()).session((Matcher<String>)org.hamcrest.Matchers.isEmptyOrNullString()).detail("token_id", accessToken.getId()).assertEvent();
        Assert.assertFalse((boolean)this.getIntrospectionResponse("service-account-cl", "secret1", tokenString));
        this.events.expect(EventType.INTROSPECT_TOKEN).client("service-account-cl").user((Matcher<String>)org.hamcrest.Matchers.isEmptyOrNullString()).session((Matcher<String>)org.hamcrest.Matchers.isEmptyOrNullString()).assertEvent();
    }

    @Test
    public void clientCredentialsAuthSuccessWithoutRefreshToken_pairWiseSubject() throws Exception {
        ProtocolMapperRepresentation pairwiseProtMapper = SHA256PairwiseSubMapper.createPairwiseMapper(null, null);
        ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl").addRedirectUris(this.oauth.getRedirectUri()).addProtocolMapper(pairwiseProtMapper);
        this.clientCredentialsAuthSuccessWithoutRefreshTokenImpl();
        ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl").removeProtocolMapper(pairwiseProtMapper.getName());
    }

    private String clientCredentialsAuthSuccessWithoutRefreshTokenImpl() throws Exception {
        this.oauth.clientId("service-account-cl");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        String tokenString = response.getAccessToken();
        Assert.assertNotNull((String)"Access-Token should be present", (Object)tokenString);
        AccessToken accessToken = this.oauth.verifyToken(tokenString);
        Assert.assertNull((Object)accessToken.getSessionState());
        Assert.assertNull((String)"Refresh-Token should not be present", (Object)response.getRefreshToken());
        this.events.expectClientLogin().client("service-account-cl").user(AssertEvents.isUUID()).session(AssertEvents.isUUID()).detail("token_id", accessToken.getId()).detail("username", "service-account-service-account-cl").assertEvent();
        List clientSessionStats = this.getAdminClient().realm(this.oauth.getRealm()).getClientSessionStats();
        Assert.assertThat((Object)clientSessionStats, (Matcher)org.hamcrest.Matchers.empty());
        Assert.assertTrue((boolean)this.getIntrospectionResponse("service-account-cl", "secret1", tokenString));
        this.events.expect(EventType.INTROSPECT_TOKEN).client("service-account-cl").user(AssertEvents.isUUID()).user((Matcher<String>)org.hamcrest.Matchers.isEmptyOrNullString()).session((Matcher<String>)org.hamcrest.Matchers.isEmptyOrNullString()).assertEvent();
        return tokenString;
    }

    private boolean getIntrospectionResponse(String clientId, String clientSecret, String tokenString) throws IOException {
        String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential(clientId, clientSecret, tokenString);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(introspectionResponse);
        return jsonNode.get("active").asBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conductClientCredentialsAuthRequestWithRefreshToken(String expectedRefreshAlg, String expectedAccessAlg, String realmTokenAlg) throws Exception {
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)realmTokenAlg);
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"service-account-cl-refresh-on"), (String)expectedAccessAlg);
            this.clientCredentialsAuthSuccessWithRefreshToken(expectedRefreshAlg, expectedAccessAlg);
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"service-account-cl-refresh-on"), (String)"RS256");
        }
    }

    private void clientCredentialsAuthSuccessWithRefreshToken(String expectedRefreshAlg, String expectedAccessAlg) throws Exception {
        this.oauth.clientId("service-account-cl-refresh-on");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        JWSHeader header = new JWSInput(response.getAccessToken()).getHeader();
        Assert.assertEquals((Object)expectedAccessAlg, (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getRefreshToken()).getHeader();
        Assert.assertEquals((Object)expectedRefreshAlg, (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertNull((Object)header.getContentType());
        this.events.expectClientLogin().client("service-account-cl-refresh-on").user(userId).session(accessToken.getSessionState()).detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", userName).assertEvent();
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        System.out.println("Access token other claims: " + accessToken.getOtherClaims());
        Assert.assertEquals((Object)"service-account-cl-refresh-on", accessToken.getOtherClaims().get("clientId"));
        Assert.assertTrue((boolean)accessToken.getOtherClaims().containsKey("clientAddress"));
        Assert.assertTrue((boolean)accessToken.getOtherClaims().containsKey("clientHost"));
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshedResponse.getRefreshToken());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client("service-account-cl-refresh-on").assertEvent();
    }

    @Test
    public void userInfoForServiceAccountWithoutRefreshTokenImpl() throws Exception {
        this.oauth.clientId("service-account-cl");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertNull((Object)response.getRefreshToken());
        UserInfo info = this.oauth.doUserInfoRequest(response.getAccessToken());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"service-account-service-account-cl", (Object)info.getPreferredUsername());
    }

    @Test
    public void userInfoForServiceAccountWithRefreshTokenImpl() throws Exception {
        this.oauth.clientId("service-account-cl-refresh-on");
        OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertNotNull((Object)response.getRefreshToken());
        UserInfo info = this.oauth.doUserInfoRequest(response.getAccessToken());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"service-account-service-account-cl-refresh-on", (Object)info.getPreferredUsername());
        CloseableHttpResponse logoutResponse = this.oauth.doLogout(response.getRefreshToken(), "secret1");
        Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
    }
}

