/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.UriUtils;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.protocol.oidc.mappers.AddressMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.UserInfo;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ProtocolMappersUpdater;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.keycloak.testsuite.util.UserInfoClientUtil;

public class OIDCProtocolMappersTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
    }

    private void deleteMappers(ProtocolMappersResource protocolMappers) {
        ProtocolMapperRepresentation mapper = ProtocolMapperUtil.getMapperByNameAndProtocol(protocolMappers, "openid-connect", "Realm roles mapper");
        if (mapper != null) {
            protocolMappers.delete(mapper.getId());
        }
        if ((mapper = ProtocolMapperUtil.getMapperByNameAndProtocol(protocolMappers, "openid-connect", "Client roles mapper")) != null) {
            protocolMappers.delete(mapper.getId());
        }
        if ((mapper = ProtocolMapperUtil.getMapperByNameAndProtocol(protocolMappers, "openid-connect", "group-value")) != null) {
            protocolMappers.delete(mapper.getId());
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    @EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    public void testTokenScriptMapping() {
        ClientResource app = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createScriptMapper("test-script-mapper1", "computed-via-script", "computed-via-script", "String", true, true, "'hello_' + user.username", false)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createScriptMapper("test-script-mapper2", "multiValued-via-script", "multiValued-via-script", "String", true, true, "new java.util.ArrayList(['A','B'])", true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createScriptMapper("test-script-mapper3", "computed-json-via-script", "computed-json-via-script", "JSON", true, true, "var x = {'int':42, 'bool': true, 'string': 'test'}; x", false)).close();
        Response response = app.getProtocolMappers().createMapper(ProtocolMapperUtil.createScriptMapper("test-script-mapper3", "syntax-error-script", "syntax-error-script", "String", true, true, "func_tion foo(){ return 'fail';} foo()", false));
        MatcherAssert.assertThat((Object)response.getStatusInfo().getFamily(), (Matcher)Matchers.is((Object)Response.Status.Family.CLIENT_ERROR));
        response.close();
        OAuthClient.AccessTokenResponse response2 = this.browserLogin("password", "test-user@localhost", "password");
        AccessToken accessToken = this.oauth.verifyToken(response2.getAccessToken());
        org.junit.Assert.assertEquals((Object)"hello_test-user@localhost", accessToken.getOtherClaims().get("computed-via-script"));
        org.junit.Assert.assertEquals(Arrays.asList("A", "B"), accessToken.getOtherClaims().get("multiValued-via-script"));
        Object o = accessToken.getOtherClaims().get("computed-json-via-script");
        org.junit.Assert.assertTrue((String)"Computed json object should be a map", (boolean)(o instanceof Map));
        Map map = (Map)o;
        org.junit.Assert.assertEquals(map.get("int"), (Object)42);
        org.junit.Assert.assertEquals(map.get("bool"), (Object)true);
        org.junit.Assert.assertEquals(map.get("string"), (Object)"test");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testTokenMapping() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserRepresentation user = userResource.toRepresentation();
        user.singleAttribute("street", "5 Yawkey Way");
        user.singleAttribute("locality", "Boston");
        user.singleAttribute("region_some", "MA");
        user.singleAttribute("postal_code", "02115");
        user.singleAttribute("country", "USA");
        user.singleAttribute("formatted", "6 Foo Street");
        user.singleAttribute("phone", "617-777-6666");
        user.singleAttribute("json-attribute", "{\"a\": 1, \"b\": 2, \"c\": [{\"a\": 1, \"b\": 2}], \"d\": {\"a\": 1, \"b\": 2}}");
        user.getAttributes().put("json-attribute-multi", Arrays.asList("{\"a\": 1, \"b\": 2, \"c\": [{\"a\": 1, \"b\": 2}], \"d\": {\"a\": 1, \"b\": 2}}", "{\"a\": 1, \"b\": 2, \"c\": [{\"a\": 1, \"b\": 2}], \"d\": {\"a\": 1, \"b\": 2}}"));
        List<String> departments = Arrays.asList("finance", "development");
        user.getAttributes().put("departments", departments);
        userResource.update(user);
        ClientResource app = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ProtocolMapperRepresentation mapper = ProtocolMapperUtil.createAddressMapper(true, true, true);
        mapper.getConfig().put(AddressMapper.getModelPropertyName((String)"region"), "region_some");
        mapper.getConfig().put(AddressMapper.getModelPropertyName((String)"country"), "country_some");
        mapper.getConfig().remove(AddressMapper.getModelPropertyName((String)"postal_code"));
        app.getProtocolMappers().createMapper(mapper).close();
        ProtocolMapperRepresentation hard = ProtocolMapperUtil.createHardcodedClaim("hard", "hard", "coded", "String", true, true);
        app.getProtocolMappers().createMapper(hard).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedClaim("hard-nested", "nested.hard", "coded-nested", "String", true, true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("custom phone", "phone", "home_phone", "String", true, true, true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("nested phone", "phone", "home.phone", "String", true, true, true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("dotted phone", "phone", "home\\.phone", "String", true, true, true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("departments", "departments", "department", "String", true, true, true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("firstDepartment", "departments", "firstDepartment", "String", true, true, false)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedRole("hard-realm", "hardcoded")).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedRole("hard-app", "app.hardcoded")).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createRoleNameMapper("rename-app-role", "test-app.customer-user", "realm-user")).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createScriptMapper("test-script-mapper1", "computed-via-script", "computed-via-script", "String", true, true, "'hello_' + user.username", false)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createScriptMapper("test-script-mapper2", "multiValued-via-script", "multiValued-via-script", "String", true, true, "new java.util.ArrayList(['A','B'])", true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("json-attribute-mapper", "json-attribute", "claim-from-json-attribute", "JSON", true, true, false)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("json-attribute-mapper-multi", "json-attribute-multi", "claim-from-json-attribute-multi", "JSON", true, true, true)).close();
        Response response = app.getProtocolMappers().createMapper(ProtocolMapperUtil.createScriptMapper("test-script-mapper3", "syntax-error-script", "syntax-error-script", "String", true, true, "func_tion foo(){ return 'fail';} foo()", false));
        MatcherAssert.assertThat((Object)response.getStatusInfo().getFamily(), (Matcher)Matchers.is((Object)Response.Status.Family.CLIENT_ERROR));
        response.close();
        OAuthClient.AccessTokenResponse response2 = this.browserLogin("password", "test-user@localhost", "password");
        IDToken idToken = this.oauth.verifyIDToken(response2.getIdToken());
        org.junit.Assert.assertNotNull((Object)idToken.getAddress());
        org.junit.Assert.assertEquals((Object)idToken.getName(), (Object)"Tom Brady");
        org.junit.Assert.assertEquals((Object)idToken.getAddress().getStreetAddress(), (Object)"5 Yawkey Way");
        org.junit.Assert.assertEquals((Object)idToken.getAddress().getLocality(), (Object)"Boston");
        org.junit.Assert.assertEquals((Object)idToken.getAddress().getRegion(), (Object)"MA");
        org.junit.Assert.assertEquals((Object)idToken.getAddress().getPostalCode(), (Object)"02115");
        org.junit.Assert.assertNull((Object)idToken.getAddress().getCountry());
        org.junit.Assert.assertEquals((Object)idToken.getAddress().getFormattedAddress(), (Object)"6 Foo Street");
        org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("home_phone"));
        MatcherAssert.assertThat((Object)((List)idToken.getOtherClaims().get("home_phone")), (Matcher)Matchers.hasItems((Object[])new String[]{"617-777-6666"}));
        org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("home.phone"));
        MatcherAssert.assertThat((Object)((List)idToken.getOtherClaims().get("home.phone")), (Matcher)Matchers.hasItems((Object[])new String[]{"617-777-6666"}));
        org.junit.Assert.assertEquals((Object)"coded", idToken.getOtherClaims().get("hard"));
        Map nested = (Map)idToken.getOtherClaims().get("nested");
        org.junit.Assert.assertEquals((Object)"coded-nested", nested.get("hard"));
        nested = (Map)idToken.getOtherClaims().get("home");
        MatcherAssert.assertThat((Object)((List)nested.get("phone")), (Matcher)Matchers.hasItems((Object[])new String[]{"617-777-6666"}));
        List departments2 = (List)idToken.getOtherClaims().get("department");
        MatcherAssert.assertThat((Object)departments2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"finance", "development"}));
        Object firstDepartment = idToken.getOtherClaims().get("firstDepartment");
        MatcherAssert.assertThat(firstDepartment, (Matcher)Matchers.instanceOf(String.class));
        MatcherAssert.assertThat(firstDepartment, (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"finance"), (Matcher)Matchers.is((Object)"development")));
        Map jsonClaim = (Map)idToken.getOtherClaims().get("claim-from-json-attribute");
        MatcherAssert.assertThat(jsonClaim.get("a"), (Matcher)Matchers.instanceOf(Integer.TYPE));
        MatcherAssert.assertThat(jsonClaim.get("c"), (Matcher)Matchers.instanceOf(Collection.class));
        MatcherAssert.assertThat(jsonClaim.get("d"), (Matcher)Matchers.instanceOf(Map.class));
        List jsonClaims = (List)idToken.getOtherClaims().get("claim-from-json-attribute-multi");
        org.junit.Assert.assertEquals((long)2L, (long)jsonClaims.size());
        MatcherAssert.assertThat(((Map)jsonClaims.get(0)).get("a"), (Matcher)Matchers.instanceOf(Integer.TYPE));
        MatcherAssert.assertThat(((Map)jsonClaims.get(1)).get("c"), (Matcher)Matchers.instanceOf(Collection.class));
        MatcherAssert.assertThat(((Map)jsonClaims.get(1)).get("d"), (Matcher)Matchers.instanceOf(Map.class));
        AccessToken accessToken = this.oauth.verifyToken(response2.getAccessToken());
        org.junit.Assert.assertEquals((Object)accessToken.getName(), (Object)"Tom Brady");
        org.junit.Assert.assertNotNull((Object)accessToken.getAddress());
        org.junit.Assert.assertEquals((Object)accessToken.getAddress().getStreetAddress(), (Object)"5 Yawkey Way");
        org.junit.Assert.assertEquals((Object)accessToken.getAddress().getLocality(), (Object)"Boston");
        org.junit.Assert.assertEquals((Object)accessToken.getAddress().getRegion(), (Object)"MA");
        org.junit.Assert.assertEquals((Object)accessToken.getAddress().getPostalCode(), (Object)"02115");
        org.junit.Assert.assertNull((Object)idToken.getAddress().getCountry());
        org.junit.Assert.assertEquals((Object)idToken.getAddress().getFormattedAddress(), (Object)"6 Foo Street");
        org.junit.Assert.assertNotNull(accessToken.getOtherClaims().get("home_phone"));
        MatcherAssert.assertThat((Object)((List)accessToken.getOtherClaims().get("home_phone")), (Matcher)Matchers.hasItems((Object[])new String[]{"617-777-6666"}));
        org.junit.Assert.assertEquals((Object)"coded", accessToken.getOtherClaims().get("hard"));
        nested = (Map)accessToken.getOtherClaims().get("nested");
        org.junit.Assert.assertEquals((Object)"coded-nested", nested.get("hard"));
        nested = (Map)accessToken.getOtherClaims().get("home");
        MatcherAssert.assertThat((Object)((List)nested.get("phone")), (Matcher)Matchers.hasItems((Object[])new String[]{"617-777-6666"}));
        departments2 = (List)idToken.getOtherClaims().get("department");
        org.junit.Assert.assertEquals((long)2L, (long)departments2.size());
        org.junit.Assert.assertTrue((departments2.contains("finance") && departments2.contains("development") ? 1 : 0) != 0);
        org.junit.Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains("hardcoded"));
        org.junit.Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains("realm-user"));
        Assert.assertNull((Object)accessToken.getResourceAccess("test-app"));
        org.junit.Assert.assertTrue((boolean)accessToken.getResourceAccess("app").getRoles().contains("hardcoded"));
        Assert.assertThat((Object)accessToken.getAudience(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"app", "account"}));
        Assert.assertNames(accessToken.getAllowedOrigins(), "http://localhost:8180", "https://localhost:8543");
        jsonClaim = (Map)accessToken.getOtherClaims().get("claim-from-json-attribute");
        MatcherAssert.assertThat(jsonClaim.get("a"), (Matcher)Matchers.instanceOf(Integer.TYPE));
        MatcherAssert.assertThat(jsonClaim.get("c"), (Matcher)Matchers.instanceOf(Collection.class));
        MatcherAssert.assertThat(jsonClaim.get("d"), (Matcher)Matchers.instanceOf(Map.class));
        this.oauth.openLogout();
        ClientResource app2 = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = app2.toRepresentation();
        for (ProtocolMapperRepresentation model : clientRepresentation.getProtocolMappers()) {
            if (!model.getName().equals("address") && !model.getName().equals("hard") && !model.getName().equals("hard-nested") && !model.getName().equals("custom phone") && !model.getName().equals("dotted phone") && !model.getName().equals("departments") && !model.getName().equals("firstDepartment") && !model.getName().equals("nested phone") && !model.getName().equals("rename-app-role") && !model.getName().equals("hard-realm") && !model.getName().equals("hard-app") && !model.getName().equals("test-script-mapper") && !model.getName().equals("json-attribute-mapper")) continue;
            app2.getProtocolMappers().delete(model.getId());
        }
        this.events.clear();
        response2 = this.browserLogin("password", "test-user@localhost", "password");
        idToken = this.oauth.verifyIDToken(response2.getIdToken());
        org.junit.Assert.assertNull((Object)idToken.getAddress());
        org.junit.Assert.assertNull(idToken.getOtherClaims().get("home_phone"));
        org.junit.Assert.assertNull(idToken.getOtherClaims().get("hard"));
        org.junit.Assert.assertNull(idToken.getOtherClaims().get("nested"));
        org.junit.Assert.assertNull(idToken.getOtherClaims().get("department"));
        this.oauth.openLogout();
        this.events.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testTokenPropertiesMapping() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserRepresentation user = userResource.toRepresentation();
        user.singleAttribute("userid", "123456789");
        user.getAttributes().put("useraud", Arrays.asList("test-app", "other"));
        userResource.update(user);
        ClientResource app = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("userid-as-sub", "userid", "sub", "String", true, true, false)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("useraud", "useraud", "aud", "String", true, true, true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedClaim("website-hardcoded", "website", "http://localhost", "String", true, true)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedClaim("iat-hardcoded", "iat", "123", "long", true, false)).close();
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        org.junit.Assert.assertEquals((Object)user.firstAttribute("userid"), (Object)idToken.getSubject());
        org.junit.Assert.assertEquals((Object)"http://localhost", (Object)idToken.getWebsite());
        org.junit.Assert.assertNotNull((Object)idToken.getAudience());
        MatcherAssert.assertThat(Arrays.asList(idToken.getAudience()), (Matcher)Matchers.hasItems((Object[])new String[]{"test-app", "other"}));
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        org.junit.Assert.assertEquals((Object)user.firstAttribute("userid"), (Object)accessToken.getSubject());
        org.junit.Assert.assertEquals((Object)"http://localhost", (Object)accessToken.getWebsite());
        org.junit.Assert.assertNotNull((Object)accessToken.getAudience());
        MatcherAssert.assertThat(Arrays.asList(accessToken.getAudience()), (Matcher)Matchers.hasItems((Object[])new String[]{"test-app", "other"}));
        org.junit.Assert.assertNotEquals((long)123L, (long)accessToken.getIat());
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            Response userInfoResponse = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)response.getAccessToken());
            UserInfo userInfo = (UserInfo)userInfoResponse.readEntity(UserInfo.class);
            org.junit.Assert.assertEquals((Object)user.firstAttribute("userid"), (Object)userInfo.getSubject());
            org.junit.Assert.assertEquals((Object)user.getEmail(), (Object)userInfo.getEmail());
            org.junit.Assert.assertEquals((Object)user.getUsername(), (Object)userInfo.getPreferredUsername());
            org.junit.Assert.assertEquals((Object)user.getLastName(), (Object)userInfo.getFamilyName());
            org.junit.Assert.assertEquals((Object)user.getFirstName(), (Object)userInfo.getGivenName());
            org.junit.Assert.assertEquals((Object)"http://localhost", (Object)userInfo.getWebsite());
            org.junit.Assert.assertNotNull((Object)accessToken.getAudience());
            MatcherAssert.assertThat(Arrays.asList(accessToken.getAudience()), (Matcher)Matchers.hasItems((Object[])new String[]{"test-app", "other"}));
        }
        this.oauth.openLogout();
        app = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = app.toRepresentation();
        for (ProtocolMapperRepresentation model : clientRepresentation.getProtocolMappers()) {
            if (!model.getName().equals("userid-as-sub") && !model.getName().equals("website-hardcoded") && !model.getName().equals("iat-hardcoded") && !model.getName().equals("useraud")) continue;
            app.getProtocolMappers().delete(model.getId());
        }
        this.events.clear();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testNullOrEmptyTokenMapping() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserRepresentation user = userResource.toRepresentation();
        user.singleAttribute("empty", "");
        user.singleAttribute("null", null);
        userResource.update(user);
        ClientResource app = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("empty", "empty", "empty", "String", true, true, false)).close();
        app.getProtocolMappers().createMapper(ProtocolMapperUtil.createClaimMapper("null", "null", "null", "String", true, true, false)).close();
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Object empty = idToken.getOtherClaims().get("empty");
        MatcherAssert.assertThat((Object)(empty == null ? null : (String)empty), (Matcher)Matchers.isEmptyOrNullString());
        Object nulll = idToken.getOtherClaims().get("null");
        org.junit.Assert.assertNull(nulll);
        this.oauth.verifyToken(response.getAccessToken());
        this.oauth.openLogout();
        ClientResource app2 = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = app2.toRepresentation();
        for (ProtocolMapperRepresentation model : clientRepresentation.getProtocolMappers()) {
            if (!model.getName().equals("empty") && !model.getName().equals("null")) continue;
            app2.getProtocolMappers().delete(model.getId());
        }
        this.events.clear();
        response = this.browserLogin("password", "test-user@localhost", "password");
        idToken = this.oauth.verifyIDToken(response.getIdToken());
        org.junit.Assert.assertNull((Object)idToken.getAddress());
        org.junit.Assert.assertNull(idToken.getOtherClaims().get("empty"));
        org.junit.Assert.assertNull(idToken.getOtherClaims().get("null"));
        this.oauth.openLogout();
        this.events.clear();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testUserRoleToAttributeMappers() throws Exception {
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper("test-app", null, "Client roles mapper", "roles-custom.test-app", true, true);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(realmMapper, clientMapper));
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm", "test-app"}));
        String realmRoleMappings = (String)roleMappings.get("realm");
        String testAppMappings = (String)roleMappings.get("test-app");
        this.assertRolesString(realmRoleMappings, "pref.user", "pref.offline_access");
        this.assertRolesString(testAppMappings, "customer-user");
        this.deleteMappers(protocolMappers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testUserRolesMovedFromAccessTokenProperties() throws Exception {
        RealmResource realm = this.adminClient.realm("test");
        ClientScopeResource rolesScope = ApiUtil.findClientScopeByName((RealmResource)realm, (String)"roles");
        ProtocolMapperRepresentation realmRolesMapper = null;
        ProtocolMapperRepresentation clientRolesMapper = null;
        for (ProtocolMapperRepresentation rep : rolesScope.getProtocolMappers().getMappers()) {
            if ("realm roles".equals(rep.getName())) {
                realmRolesMapper = rep;
                continue;
            }
            if (!"client roles".equals(rep.getName())) continue;
            clientRolesMapper = rep;
        }
        String realmRolesTokenClaimOrig = (String)realmRolesMapper.getConfig().get("claim.name");
        String clientRolesTokenClaimOrig = (String)clientRolesMapper.getConfig().get("claim.name");
        realmRolesMapper.getConfig().put("claim.name", "custom.roles");
        rolesScope.getProtocolMappers().update(realmRolesMapper.getId(), realmRolesMapper);
        clientRolesMapper.getConfig().put("claim.name", "custom.roles");
        rolesScope.getProtocolMappers().update(clientRolesMapper.getId(), clientRolesMapper);
        Response resp = rolesScope.getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedRole("hard-realm", "hardcoded"));
        String hardcodedMapperId = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
            Assert.assertNull((Object)accessToken.getRealmAccess());
            Assert.assertTrue((boolean)accessToken.getResourceAccess().isEmpty());
            String accessTokenJson = new String(new JWSInput(response.getAccessToken()).getContent(), StandardCharsets.UTF_8);
            Assert.assertFalse((boolean)accessTokenJson.contains("realm_access"));
            Assert.assertFalse((boolean)accessTokenJson.contains("resource_access"));
            Map cst1 = (Map)accessToken.getOtherClaims().get("custom");
            List roles = (List)cst1.get("roles");
            Assert.assertNames(roles, "offline_access", "user", "customer-user", "hardcoded", "view-profile", "manage-account", "manage-account-links");
            Assert.assertNames(Arrays.asList(accessToken.getAudience()), "account");
        }
        finally {
            rolesScope.getProtocolMappers().delete(hardcodedMapperId);
            realmRolesMapper.getConfig().put("claim.name", realmRolesTokenClaimOrig);
            rolesScope.getProtocolMappers().update(realmRolesMapper.getId(), realmRolesMapper);
            clientRolesMapper.getConfig().put("claim.name", clientRolesTokenClaimOrig);
            rolesScope.getProtocolMappers().update(clientRolesMapper.getId(), clientRolesMapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRolesAndAllowedOriginsRemovedFromAccessToken() throws Exception {
        RealmResource realm = this.adminClient.realm("test");
        ClientScopeRepresentation allowedOriginsScope = ApiUtil.findClientScopeByName((RealmResource)realm, (String)"web-origins").toRepresentation();
        ClientScopeRepresentation rolesScope = ApiUtil.findClientScopeByName((RealmResource)realm, (String)"roles").toRepresentation();
        ClientResource testApp = ApiUtil.findClientByClientId((RealmResource)realm, (String)"test-app");
        testApp.removeDefaultClientScope(allowedOriginsScope.getId());
        testApp.removeDefaultClientScope(rolesScope.getId());
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
            Assert.assertNull((Object)accessToken.getAllowedOrigins());
            Assert.assertNull((Object)accessToken.getRealmAccess());
            Assert.assertTrue((boolean)accessToken.getResourceAccess().isEmpty());
            Assert.assertEquals((Object)"test-app", (Object)accessToken.getIssuedFor());
            Assert.assertFalse((boolean)accessToken.hasAudience("test-app"));
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            Assert.assertEquals((Object)"test-app", (Object)idToken.getIssuedFor());
            Assert.assertTrue((boolean)idToken.hasAudience("test-app"));
        }
        finally {
            testApp.addDefaultClientScope(allowedOriginsScope.getId());
            testApp.addDefaultClientScope(rolesScope.getId());
        }
    }

    @Test
    public void testUserRoleToAttributeMappersWithMultiValuedRoles() throws Exception {
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper("test-app", null, "Client roles mapper", "roles-custom.test-app", true, true, true);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(realmMapper, clientMapper));
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm", "test-app"}));
        Assert.assertThat(roleMappings.get("realm"), (Matcher)CoreMatchers.instanceOf(List.class));
        Assert.assertThat(roleMappings.get("test-app"), (Matcher)CoreMatchers.instanceOf(List.class));
        List realmRoleMappings = (List)roleMappings.get("realm");
        List testAppMappings = (List)roleMappings.get("test-app");
        this.assertRoles(realmRoleMappings, "pref.user", "pref.offline_access");
        this.assertRoles(testAppMappings, "customer-user");
        this.deleteMappers(protocolMappers);
    }

    @Test
    public void testUserRoleToAttributeMappersWithFullScopeDisabled() throws Exception {
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper("test-app", null, "Client roles mapper", "roles-custom.test-app", true, true, true);
        ClientResource client = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation rep = client.toRepresentation();
        rep.setFullScopeAllowed(Boolean.valueOf(false));
        client.update(rep);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(realmMapper, clientMapper));
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm", "test-app"}));
        Assert.assertThat(roleMappings.get("realm"), (Matcher)CoreMatchers.instanceOf(List.class));
        Assert.assertThat(roleMappings.get("test-app"), (Matcher)CoreMatchers.instanceOf(List.class));
        List realmRoleMappings = (List)roleMappings.get("realm");
        List testAppMappings = (List)roleMappings.get("test-app");
        this.assertRoles(realmRoleMappings, "pref.user");
        this.assertRoles(testAppMappings, "customer-user");
        this.deleteMappers(protocolMappers);
        rep = client.toRepresentation();
        rep.setFullScopeAllowed(Boolean.valueOf(true));
        client.update(rep);
    }

    @Test
    public void testRoleMapperWithRoleInheritedFromMoreGroups() throws Exception {
        String clientId = "test-app";
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper(clientId, null, "Client roles mapper", "roles-custom.test-app", true, true);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId).getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(clientMapper));
        GroupRepresentation level2Group2 = this.adminClient.realm("test").getGroupByPath("/topGroup/level2group2");
        UserResource level2GroupUser = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"level2GroupUser");
        level2GroupUser.joinGroup(level2Group2.getId());
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "level2GroupUser", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{clientId}));
        String testAppScopeMappings = (String)roleMappings.get(clientId);
        this.assertRolesString(testAppScopeMappings, "customer-user");
        level2GroupUser.leaveGroup(level2Group2.getId());
        this.deleteMappers(protocolMappers);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testUserGroupRoleToAttributeMappers() throws Exception {
        String clientId = "test-app";
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper(clientId, "ta.", "Client roles mapper", "roles-custom.test-app", true, true);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId).getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(realmMapper, clientMapper));
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "rich.roles@redhat.com", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm", clientId}));
        String realmRoleMappings = (String)roleMappings.get("realm");
        String testAppMappings = (String)roleMappings.get(clientId);
        this.assertRolesString(realmRoleMappings, "pref.admin", "pref.user", "pref.customer-user-premium", "pref.realm-composite-role", "pref.sample-realm-role");
        this.assertRolesString(testAppMappings, "ta.customer-user", "ta.customer-admin-composite-role", "ta.customer-admin", "ta.sample-client-role");
        this.deleteMappers(protocolMappers);
    }

    @Test
    public void testUserGroupRoleToAttributeMappersNotScopedOtherApp() throws Exception {
        String clientId = "test-app-authz";
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper(clientId, null, "Client roles mapper", "roles-custom." + clientId, true, true);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId).getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(realmMapper, clientMapper));
        ClientManager.realm(this.adminClient.realm("test")).clientId(clientId).directAccessGrant(true);
        this.oauth.clientId(clientId);
        String oldRedirectUri = this.oauth.getRedirectUri();
        this.oauth.redirectUri(UriUtils.getOrigin((String)oldRedirectUri) + "/test-app-authz");
        OAuthClient.AccessTokenResponse response = this.browserLogin("secret", "rich.roles@redhat.com", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        this.oauth.redirectUri(oldRedirectUri);
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm"}));
        String realmRoleMappings = (String)roleMappings.get("realm");
        String testAppAuthzMappings = (String)roleMappings.get(clientId);
        this.assertRolesString(realmRoleMappings, "pref.admin", "pref.user", "pref.customer-user-premium", "pref.realm-composite-role", "pref.sample-realm-role");
        org.junit.Assert.assertNull((Object)testAppAuthzMappings);
        this.deleteMappers(protocolMappers);
    }

    @Test
    public void testUserGroupRoleToAttributeMappersScoped() throws Exception {
        String clientId = "test-app-scope";
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper(clientId, null, "Client roles mapper", "roles-custom.test-app-scope", true, true);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId).getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(realmMapper, clientMapper));
        ClientManager.realm(this.adminClient.realm("test")).clientId(clientId).directAccessGrant(true);
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "rich.roles@redhat.com", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm", clientId}));
        String realmRoleMappings = (String)roleMappings.get("realm");
        String testAppScopeMappings = (String)roleMappings.get(clientId);
        this.assertRolesString(realmRoleMappings, "pref.admin", "pref.user", "pref.customer-user-premium");
        this.assertRolesString(testAppScopeMappings, "test-app-allowed-by-scope", "test-app-disallowed-by-scope");
        this.deleteMappers(protocolMappers);
    }

    @Test
    public void testUserGroupRoleToAttributeMappersScopedClientNotSet() throws Exception {
        String clientId = "test-app-scope";
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper(null, null, "Client roles mapper", "roles-custom.test-app-scope", true, true);
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId).getProtocolMappers();
        protocolMappers.createMapper(Arrays.asList(realmMapper, clientMapper));
        ClientManager.realm(this.adminClient.realm("test")).clientId(clientId).directAccessGrant(true);
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.browserLogin("password", "rich.roles@redhat.com", "password");
        IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
        Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
        Assert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm", clientId}));
        String realmRoleMappings = (String)roleMappings.get("realm");
        String testAppScopeMappings = (String)roleMappings.get(clientId);
        this.assertRolesString(realmRoleMappings, "pref.admin", "pref.user", "pref.customer-user-premium");
        this.assertRolesString(testAppScopeMappings, "test-app-allowed-by-scope", "test-app-disallowed-by-scope");
        this.deleteMappers(protocolMappers);
    }

    @Test
    public void testUserGroupRoleToAttributeMappersScopedWithDifferentClient() throws Exception {
        String clientId = "test-app-scope";
        String diffClient = "test-app";
        String realmName = "test";
        ProtocolMapperRepresentation realmMapper = ProtocolMapperUtil.createUserRealmRoleMappingMapper("pref.", "Realm roles mapper", "roles-custom.realm", true, true);
        ProtocolMapperRepresentation clientMapper = ProtocolMapperUtil.createUserClientRoleMappingMapper("test-app", null, "Client roles mapper", "roles-custom.test-app", true, true);
        try (ClientAttributeUpdater cau = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"test", (String)"test-app-scope").setDirectAccessGrantsEnabled(Boolean.valueOf(true));
             ProtocolMappersUpdater protocolMappers = new ProtocolMappersUpdater(((ClientResource)cau.getResource()).getProtocolMappers());){
            protocolMappers.add(new ProtocolMapperRepresentation[]{realmMapper, clientMapper}).update();
            this.oauth.clientId("test-app-scope");
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "rich.roles@redhat.com", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            Map roleMappings = (Map)idToken.getOtherClaims().get("roles-custom");
            org.junit.Assert.assertNotNull((Object)roleMappings);
            MatcherAssert.assertThat(roleMappings.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"realm", "test-app"}));
            String realmRoleMappings = (String)roleMappings.get("realm");
            String testAppScopeMappings = (String)roleMappings.get("test-app");
            this.assertRolesString(realmRoleMappings, "pref.admin", "pref.user", "pref.customer-user-premium");
            this.assertRolesString(testAppScopeMappings, "customer-admin-composite-role", "customer-admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeUserOneGroupNoMultivalueNoAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserRepresentation user = userResource.toRepresentation();
        user.setAttributes(new HashMap());
        user.getAttributes().put("group-value", Arrays.asList("user-value1", "user-value2"));
        userResource.update(user);
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, false, false)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof String));
            org.junit.Assert.assertTrue(("user-value1".equals(idToken.getOtherClaims().get("group-value")) || "user-value2".equals(idToken.getOtherClaims().get("group-value")) ? 1 : 0) != 0);
        }
        finally {
            user.getAttributes().remove("group-value");
            userResource.update(user);
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeUserOneGroupMultivalueNoAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserRepresentation user = userResource.toRepresentation();
        user.setAttributes(new HashMap());
        user.getAttributes().put("group-value", Arrays.asList("user-value1", "user-value2"));
        userResource.update(user);
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, true, false)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof List));
            org.junit.Assert.assertEquals((long)2L, (long)((List)idToken.getOtherClaims().get("group-value")).size());
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("user-value1"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("user-value2"));
        }
        finally {
            user.getAttributes().remove("group-value");
            userResource.update(user);
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeUserOneGroupMultivalueAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserRepresentation user = userResource.toRepresentation();
        user.setAttributes(new HashMap());
        user.getAttributes().put("group-value", Arrays.asList("user-value1", "user-value2"));
        userResource.update(user);
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, true, true)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof List));
            org.junit.Assert.assertEquals((long)4L, (long)((List)idToken.getOtherClaims().get("group-value")).size());
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("user-value1"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("user-value2"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value1"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value2"));
        }
        finally {
            user.getAttributes().remove("group-value");
            userResource.update(user);
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeOneGroupNoMultivalueNoAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, false, false)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof String));
            org.junit.Assert.assertTrue(("value1".equals(idToken.getOtherClaims().get("group-value")) || "value2".equals(idToken.getOtherClaims().get("group-value")) ? 1 : 0) != 0);
        }
        finally {
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeOneGroupMultiValueNoAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, true, false)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof List));
            org.junit.Assert.assertEquals((long)2L, (long)((List)idToken.getOtherClaims().get("group-value")).size());
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value1"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value2"));
        }
        finally {
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeOneGroupMultiValueAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, true, true)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof List));
            org.junit.Assert.assertEquals((long)2L, (long)((List)idToken.getOtherClaims().get("group-value")).size());
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value1"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value2"));
        }
        finally {
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeTwoGroupNoMultivalueNoAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        GroupRepresentation group2 = new GroupRepresentation();
        group2.setName("group2");
        group2.setAttributes(new HashMap());
        group2.getAttributes().put("group-value", Arrays.asList("value2", "value3"));
        this.adminClient.realm("test").groups().add(group2);
        group2 = this.adminClient.realm("test").getGroupByPath("/group2");
        userResource.joinGroup(group2.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, false, false)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof String));
            org.junit.Assert.assertTrue(("value1".equals(idToken.getOtherClaims().get("group-value")) || "value2".equals(idToken.getOtherClaims().get("group-value")) || "value3".equals(idToken.getOtherClaims().get("group-value")) ? 1 : 0) != 0);
        }
        finally {
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            userResource.leaveGroup(group2.getId());
            this.adminClient.realm("test").groups().group(group2.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeTwoGroupMultiValueNoAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        GroupRepresentation group2 = new GroupRepresentation();
        group2.setName("group2");
        group2.setAttributes(new HashMap());
        group2.getAttributes().put("group-value", Arrays.asList("value2", "value3"));
        this.adminClient.realm("test").groups().add(group2);
        group2 = this.adminClient.realm("test").getGroupByPath("/group2");
        userResource.joinGroup(group2.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, true, false)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof List));
            org.junit.Assert.assertEquals((long)2L, (long)((List)idToken.getOtherClaims().get("group-value")).size());
            org.junit.Assert.assertTrue((((List)idToken.getOtherClaims().get("group-value")).contains("value1") && ((List)idToken.getOtherClaims().get("group-value")).contains("value2") || ((List)idToken.getOtherClaims().get("group-value")).contains("value2") && ((List)idToken.getOtherClaims().get("group-value")).contains("value3") ? 1 : 0) != 0);
        }
        finally {
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            userResource.leaveGroup(group2.getId());
            this.adminClient.realm("test").groups().group(group2.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupAttributeTwoGroupMultiValueAggregate() throws Exception {
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        this.adminClient.realm("test").groups().add(group1);
        group1 = this.adminClient.realm("test").getGroupByPath("/group1");
        userResource.joinGroup(group1.getId());
        GroupRepresentation group2 = new GroupRepresentation();
        group2.setName("group2");
        group2.setAttributes(new HashMap());
        group2.getAttributes().put("group-value", Arrays.asList("value2", "value3"));
        this.adminClient.realm("test").groups().add(group2);
        group2 = this.adminClient.realm("test").getGroupByPath("/group2");
        userResource.joinGroup(group2.getId());
        ProtocolMappersResource protocolMappers = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").getProtocolMappers();
        protocolMappers.createMapper(ProtocolMapperUtil.createClaimMapper("group-value", "group-value", "group-value", "String", true, true, true, true)).close();
        try {
            OAuthClient.AccessTokenResponse response = this.browserLogin("password", "test-user@localhost", "password");
            IDToken idToken = this.oauth.verifyIDToken(response.getIdToken());
            org.junit.Assert.assertNotNull((Object)idToken.getOtherClaims());
            org.junit.Assert.assertNotNull(idToken.getOtherClaims().get("group-value"));
            org.junit.Assert.assertTrue((boolean)(idToken.getOtherClaims().get("group-value") instanceof List));
            org.junit.Assert.assertEquals((long)3L, (long)((List)idToken.getOtherClaims().get("group-value")).size());
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value1"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value2"));
            org.junit.Assert.assertTrue((boolean)((List)idToken.getOtherClaims().get("group-value")).contains("value3"));
        }
        finally {
            userResource.leaveGroup(group1.getId());
            this.adminClient.realm("test").groups().group(group1.getId()).remove();
            userResource.leaveGroup(group2.getId());
            this.adminClient.realm("test").groups().group(group2.getId()).remove();
            this.deleteMappers(protocolMappers);
        }
    }

    private void assertRoles(List<String> actualRoleList, String ... expectedRoles) {
        Assert.assertNames(actualRoleList, expectedRoles);
    }

    private void assertRolesString(String actualRoleString, String ... expectedRoles) {
        Assert.assertThat((Object)actualRoleString.matches("^\\[.*\\]$"), (Matcher)Matchers.is((Object)true));
        String[] roles = actualRoleString.substring(1, actualRoleString.length() - 1).split(",\\s*");
        if (expectedRoles == null || expectedRoles.length == 0) {
            Assert.assertThat((Object)roles, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{""}));
        } else {
            Assert.assertThat((Object)roles, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])expectedRoles));
        }
    }

    private ProtocolMapperRepresentation makeMapper(String name, String mapperType, Map<String, String> config) {
        ProtocolMapperRepresentation rep = new ProtocolMapperRepresentation();
        rep.setProtocol("openid-connect");
        rep.setName(name);
        rep.setProtocolMapper(mapperType);
        rep.setConfig(config);
        return rep;
    }

    private OAuthClient.AccessTokenResponse browserLogin(String clientSecret, String username, String password) {
        OAuthClient.AuthorizationEndpointResponse authzEndpointResponse = this.oauth.doLogin(username, password);
        return this.oauth.doAccessTokenRequest(authzEndpointResponse.getCode(), clientSecret);
    }
}

