/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;

public class OAuthRedirectUriTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginPage loginPage;
    private HttpServer server;

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.server = HttpServer.create(new InetSocketAddress(8280), 0);
        this.server.createContext("/", new MyHandler());
        this.server.setExecutor(null);
        this.server.start();
    }

    @Override
    public void afterAbstractKeycloakTest() throws Exception {
        super.afterAbstractKeycloakTest();
        this.server.stop(0);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        ClientBuilder installedApp = ClientBuilder.create().clientId("test-installed").name("test-installed").redirectUris("urn:ietf:wg:oauth:2.0:oob", "http://localhost").secret("password");
        realm.client(installedApp);
        ClientBuilder installedApp2 = ClientBuilder.create().clientId("test-installed2").name("test-installed2").redirectUris("http://localhost/myapp").secret("password");
        realm.client(installedApp2);
        ClientBuilder installedApp3 = ClientBuilder.create().clientId("test-wildcard").name("test-wildcard").redirectUris("http://example.com/foo/*", "http://with-dash.example.local/foo/*", "http://localhost:8280/foo/*").secret("password");
        realm.client(installedApp3);
        ClientBuilder installedApp4 = ClientBuilder.create().clientId("test-dash").name("test-dash").redirectUris("http://with-dash.example.local", "http://with-dash.example.local/foo").secret("password");
        realm.client(installedApp4);
        ClientBuilder installedApp5 = ClientBuilder.create().clientId("test-root-url").name("test-root-url").rootUrl("http://with-dash.example.local").redirectUris("/foo").secret("password");
        realm.client(installedApp5);
        ClientBuilder installedApp6 = ClientBuilder.create().clientId("test-relative-url").name("test-relative-url").rootUrl("").redirectUris("/auth").secret("password");
        realm.client(installedApp6);
        ClientBuilder installedApp7 = ClientBuilder.create().clientId("test-query-component").name("test-query-component").redirectUris("http://localhost?foo=bar", "http://localhost?foo=bar*").secret("password");
        realm.client(installedApp7);
        ClientBuilder installedApp8 = ClientBuilder.create().clientId("test-fragment").name("test-fragment").redirectUris("http://localhost:8180/*", "https://localhost:8543/*").secret("password");
        realm.client(installedApp8);
        ClientBuilder installedAppCustomScheme = ClientBuilder.create().clientId("custom-scheme").name("custom-scheme").redirectUris("android-app://org.keycloak.examples.cordova/https/keycloak-cordova-example.github.io/login").secret("password");
        realm.client(installedAppCustomScheme);
        ClientBuilder installedAppLoopback = ClientBuilder.create().clientId("test-installed-loopback").name("test-installed-loopback").redirectUris("http://127.0.0.1").secret("password");
        realm.client(installedAppLoopback);
        ClientBuilder installedAppLoopback2 = ClientBuilder.create().clientId("test-installed-loopback2").name("test-installed-loopback2").redirectUris("http://127.0.0.1/myapp").secret("password");
        realm.client(installedAppLoopback2);
        testRealms.add(realm.build());
    }

    @Test
    public void testNoParam() throws IOException {
        this.oauth.redirectUri(null);
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
    }

    @Test
    public void testRelativeUri() throws IOException {
        this.oauth.redirectUri("/foo/../bar");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
    }

    @Test
    public void testFileUri() throws IOException {
        this.oauth.redirectUri("file://test");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
    }

    @Test
    public void testNoParamMultipleValidUris() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/app2");
        try {
            this.oauth.redirectUri(null);
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        }
        catch (Throwable throwable) {
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/app2");
            throw throwable;
        }
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/app2");
    }

    @Test
    public void testNoParamNoValidUris() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
        try {
            this.oauth.redirectUri(null);
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        }
        catch (Throwable throwable) {
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
            throw throwable;
        }
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
    }

    @Test
    public void testNoValidUris() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
        try {
            this.oauth.redirectUri(null);
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        }
        catch (Throwable throwable) {
            ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
            throw throwable;
        }
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("http://localhost:8180/auth/realms/master/app/auth/*");
    }

    @Test
    public void testValid() throws IOException {
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        URL url = new URL(this.driver.getCurrentUrl());
        Assert.assertTrue((boolean)url.toString().startsWith(OAuthClient.APP_ROOT));
        Assert.assertTrue((boolean)url.getQuery().contains("code="));
        Assert.assertTrue((boolean)url.getQuery().contains("state="));
    }

    @Test
    public void testInvalid() throws IOException {
        this.oauth.redirectUri("http://localhost:8180/app2");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
    }

    @Test
    public void testWithParams() throws IOException {
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth?key=value");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        URL url = new URL(this.driver.getCurrentUrl());
        Assert.assertTrue((boolean)url.toString().startsWith(OAuthClient.APP_ROOT));
        Assert.assertTrue((boolean)url.getQuery().contains("key=value"));
        Assert.assertTrue((boolean)url.getQuery().contains("state="));
        Assert.assertTrue((boolean)url.getQuery().contains("code="));
    }

    @Test
    public void testWithFragment() throws IOException {
        this.oauth.clientId("test-fragment");
        this.oauth.responseMode("fragment");
        this.oauth.redirectUri(OAuthClient.APP_ROOT + "/auth#key=value");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        URL url = new URL(this.driver.getCurrentUrl());
        Assert.assertTrue((boolean)url.toString().startsWith(OAuthClient.APP_ROOT));
        Assert.assertTrue((boolean)url.toString().contains("key=value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithCustomScheme() throws IOException {
        this.oauth.clientId("custom-scheme");
        this.oauth.redirectUri("android-app://org.keycloak.examples.cordova/https/keycloak-cordova-example.github.io/login");
        this.oauth.openLoginForm();
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("best-match").build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        String loginUrl = this.driver.getCurrentUrl();
        try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(globalConfig).setDefaultCookieStore((CookieStore)cookieStore).build();){
            String loginPage = SimpleHttp.doGet((String)loginUrl, (HttpClient)client).asString();
            String formAction = loginPage.split("action=\"")[1].split("\"")[0].replaceAll("&amp;", "&");
            SimpleHttp.Response response = SimpleHttp.doPost((String)formAction, (HttpClient)client).param("username", "test-user@localhost").param("password", "password").asResponse();
            response.getStatus();
            Assert.assertThat((Object)response.getFirstHeader("Location"), (Matcher)Matchers.startsWith((String)"android-app://org.keycloak.examples.cordova/https/keycloak-cordova-example.github.io/login"));
        }
    }

    @Test
    public void testQueryComponents() throws IOException {
        this.oauth.clientId("test-query-component");
        this.checkRedirectUri("http://localhost?foo=bar", true);
        this.checkRedirectUri("http://localhost?foo=bara", false);
        this.checkRedirectUri("http://localhost?foo=bar/", false);
        this.checkRedirectUri("http://localhost?foo2=bar2&foo=bar", false);
        this.checkRedirectUri("http://localhost?foo=b", false);
        this.checkRedirectUri("http://localhost?foo", false);
        this.checkRedirectUri("http://localhost?foo=bar&bar=foo", false);
        this.checkRedirectUri("http://localhost?foo&bar=foo", false);
        this.checkRedirectUri("http://localhost?foo&bar", false);
        this.checkRedirectUri("http://localhost", false);
        this.oauth.clientId("test-installed");
        this.checkRedirectUri("http://localhost?foo=bar", false);
    }

    @Test
    public void testWildcard() throws IOException {
        this.oauth.clientId("test-wildcard");
        this.checkRedirectUri("http://example.com", false);
        this.checkRedirectUri("http://localhost:8080", false, true);
        this.checkRedirectUri("http://example.com/foo", true);
        this.checkRedirectUri("http://example.com/foo/bar", true);
        this.checkRedirectUri("http://localhost:8280/foo", true, true);
        this.checkRedirectUri("http://localhost:8280/foo/bar", true, true);
        this.checkRedirectUri("http://example.com/foobar", false);
        this.checkRedirectUri("http://localhost:8280/foobar", false, true);
    }

    @Test
    public void testDash() throws IOException {
        this.oauth.clientId("test-dash");
        this.checkRedirectUri("http://with-dash.example.local/foo", true);
    }

    @Test
    public void testDifferentCaseInHostname() throws IOException {
        this.oauth.clientId("test-dash");
        this.checkRedirectUri("http://with-dash.example.local", true);
        this.checkRedirectUri("http://wiTh-dAsh.example.local", true);
        this.checkRedirectUri("http://with-dash.example.local/foo", true);
        this.checkRedirectUri("http://wiTh-dAsh.example.local/foo", true);
        this.checkRedirectUri("http://with-dash.example.local/foo", true);
        this.checkRedirectUri("http://wiTh-dAsh.example.local/foo", true);
        this.checkRedirectUri("http://wiTh-dAsh.example.local/Foo", false);
        this.checkRedirectUri("http://wiTh-dAsh.example.local/foO", false);
    }

    @Test
    public void testDifferentCaseInScheme() throws IOException {
        this.oauth.clientId("test-dash");
        this.checkRedirectUri("HTTP://with-dash.example.local", true);
        this.checkRedirectUri("Http://wiTh-dAsh.example.local", true);
    }

    @Test
    public void testRelativeWithRoot() throws IOException {
        this.oauth.clientId("test-root-url");
        this.checkRedirectUri("http://with-dash.example.local/foo", true);
        this.checkRedirectUri("http://localhost:8180/foo", false);
    }

    @Test
    public void testRelative() throws IOException {
        this.oauth.clientId("test-relative-url");
        this.checkRedirectUri("http://with-dash.example.local/foo", false);
        this.checkRedirectUri("http://localhost:8180/auth", true);
    }

    @Test
    public void testLocalhost() throws IOException {
        this.oauth.clientId("test-installed");
        this.checkRedirectUri("urn:ietf:wg:oauth:2.0:oob", true, true);
        this.checkRedirectUri("http://localhost", true);
        this.checkRedirectUri("http://localhost:8280", true, true);
        this.checkRedirectUri("http://localhosts", false);
        this.checkRedirectUri("http://localhost/myapp", false);
        this.checkRedirectUri("http://localhost:8180/myapp", false, true);
        this.oauth.clientId("test-installed2");
        this.checkRedirectUri("http://localhost/myapp", true);
        this.checkRedirectUri("http://localhost:8280/myapp", true, true);
        this.checkRedirectUri("http://localhosts/myapp", false);
        this.checkRedirectUri("http://localhost", false);
        this.checkRedirectUri("http://localhost/myapp2", false);
    }

    @Test
    public void testLoopback() throws IOException {
        this.oauth.clientId("test-installed-loopback");
        this.checkRedirectUri("http://127.0.0.1", true);
        this.checkRedirectUri("http://127.0.0.1:8280", true, true);
        this.checkRedirectUri("http://127.0.0.1/myapp", false);
        this.checkRedirectUri("http://127.0.0.1:8180/myapp", false, true);
        this.oauth.clientId("test-installed-loopback2");
        this.checkRedirectUri("http://127.0.0.1/myapp", true);
        this.checkRedirectUri("http://127.0.0.1:8280/myapp", true, true);
        this.checkRedirectUri("http://127.0.0.1", false);
        this.checkRedirectUri("http://127.0.0.1/myapp2", false);
    }

    @Test
    public void okThenNull() throws IOException {
        this.oauth.clientId("test-wildcard");
        this.oauth.redirectUri("http://localhost:8280/foo");
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        Assert.assertNotNull((Object)code);
        this.oauth.redirectUri(null);
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((String)"Expected 400, but got something else", (long)400L, (long)tokenResponse.getStatusCode());
    }

    private void checkRedirectUri(String redirectUri, boolean expectValid) throws IOException {
        this.checkRedirectUri(redirectUri, expectValid, false);
    }

    private void checkRedirectUri(String redirectUri, boolean expectValid, boolean checkCodeToToken) throws IOException {
        this.oauth.redirectUri(redirectUri);
        if (!expectValid) {
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.errorPage.isCurrent());
            Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        } else if (!checkCodeToToken) {
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
        } else {
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            Assert.assertNotNull((Object)code);
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            Assert.assertEquals((String)("Expected success, but got error: " + tokenResponse.getError()), (long)200L, (long)tokenResponse.getStatusCode());
            this.oauth.doLogout(tokenResponse.getRefreshToken(), "password");
        }
    }

    static class MyHandler
    implements HttpHandler {
        MyHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String response = "Hello";
            t.sendResponseHeaders(200, response.length());
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }
}

