/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.openqa.selenium.By;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class OAuthGrantTest
extends AbstractKeycloakTest {
    public static final String THIRD_PARTY_APP = "third-party";
    public static final String REALM_NAME = "test";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected AccountApplicationsPage accountAppsPage;
    @Page
    protected AppPage appPage;
    @Page
    protected ErrorPage errorPage;
    private static String ROLE_USER = "Have User privileges";
    private static String ROLE_CUSTOMER = "Have Customer User privileges";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRepresentation);
    }

    @Test
    public void oauthGrantAcceptTest() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        Assert.assertTrue((boolean)this.oauth.getCurrentQuery().containsKey("code"));
        EventRepresentation loginEvent = this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String sessionId = loginEvent.getSessionId();
        OAuthClient.AccessTokenResponse accessToken = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "password");
        String tokenString = accessToken.getAccessToken();
        Assert.assertNotNull((Object)tokenString);
        AccessToken token = this.oauth.verifyToken(tokenString);
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        AccessToken.Access realmAccess = token.getRealmAccess();
        Assert.assertEquals((long)1L, (long)realmAccess.getRoles().size());
        Assert.assertTrue((boolean)realmAccess.isUserInRole("user"));
        Map resourceAccess = token.getResourceAccess();
        Assert.assertEquals((long)1L, (long)resourceAccess.size());
        Assert.assertEquals((long)1L, (long)((AccessToken.Access)resourceAccess.get("test-app")).getRoles().size());
        Assert.assertTrue((boolean)((AccessToken.Access)resourceAccess.get("test-app")).isUserInRole("customer-user"));
        this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).client(THIRD_PARTY_APP).assertEvent();
        this.accountAppsPage.open();
        Assert.assertEquals((long)1L, (long)this.driver.findElements(By.id((String)"revoke-third-party")).size());
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        Assert.assertEquals((long)0L, (long)this.driver.findElements(By.id((String)"revoke-third-party")).size());
    }

    @Test
    public void oauthGrantCancelTest() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.cancel();
        Assert.assertTrue((boolean)this.oauth.getCurrentQuery().containsKey("error"));
        Assert.assertEquals((Object)"access_denied", this.oauth.getCurrentQuery().get("error"));
        this.events.expectLogin().client(THIRD_PARTY_APP).error("rejected_by_user").removeDetail("consent").session((Matcher<String>)Matchers.nullValue(String.class)).assertEvent();
    }

    @Test
    public void oauthGrantNotShownWhenAlreadyGranted() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        AccountApplicationsPage.AppEntry thirdPartyEntry = (AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP);
        thirdPartyEntry.getClientScopesGranted().contains("User profile");
        thirdPartyEntry.getClientScopesGranted().contains("Email address");
        this.oauth.openLoginForm();
        this.appPage.assertCurrent();
        this.events.expectLogin().detail("auth_method", "openid-connect").detail("consent", "persistent_consent").removeDetail("username").client(THIRD_PARTY_APP).assertEvent();
        this.accountAppsPage.open();
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        this.oauth.openLoginForm();
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
    }

    @Test
    public void oauthGrantAddAnotherScope() {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        RealmResource appRealm = this.adminClient.realm(REALM_NAME);
        ClientScopeRepresentation scope1 = new ClientScopeRepresentation();
        scope1.setName("foo-scope");
        scope1.setProtocol("openid-connect");
        Response response = appRealm.clientScopes().create(scope1);
        String fooScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.getCleanup().addClientScopeId(fooScopeId);
        ClientResource thirdParty = ApiUtil.findClientByClientId((RealmResource)appRealm, (String)THIRD_PARTY_APP);
        thirdParty.addDefaultClientScope(fooScopeId);
        this.grantPage.assertCurrent();
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        AccountApplicationsPage.AppEntry appEntry = (AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP);
        Assert.assertFalse((boolean)appEntry.getClientScopesGranted().contains("foo-scope"));
        this.oauth.openLoginForm();
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"foo-scope"});
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        appEntry = (AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP);
        Assert.assertTrue((boolean)appEntry.getClientScopesGranted().contains("foo-scope"));
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        thirdParty.removeDefaultClientScope(fooScopeId);
    }

    @Test
    public void oauthGrantScopeParamRequired() throws Exception {
        RealmResource appRealm = this.adminClient.realm(REALM_NAME);
        ClientResource thirdParty = ApiUtil.findClientByClientId((RealmResource)appRealm, (String)THIRD_PARTY_APP);
        ClientScopeRepresentation scope1 = new ClientScopeRepresentation();
        scope1.setName("foo-scope");
        scope1.setProtocol("openid-connect");
        Response response = appRealm.clientScopes().create(scope1);
        String fooScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.getCleanup().addClientScopeId(fooScopeId);
        thirdParty.addOptionalClientScope(fooScopeId);
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        List grants = this.grantPage.getDisplayedGrants();
        Assert.assertFalse((boolean)grants.contains("foo-scope"));
        this.grantPage.cancel();
        this.events.expectLogin().client(THIRD_PARTY_APP).error("rejected_by_user").removeDetail("consent").session((Matcher<String>)Matchers.nullValue(String.class)).assertEvent();
        this.oauth.scope("foo-scope");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        grants = this.grantPage.getDisplayedGrants();
        Assert.assertTrue((boolean)grants.contains("foo-scope"));
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        this.oauth.scope(null);
        thirdParty.removeOptionalClientScope(fooScopeId);
    }

    @Test
    public void oauthGrantClientScopeMappers() throws Exception {
        RealmResource appRealm = this.adminClient.realm(REALM_NAME);
        ClientScopeRepresentation scope1 = new ClientScopeRepresentation();
        scope1.setName("foo-addr");
        scope1.setProtocol("openid-connect");
        Response response = appRealm.clientScopes().create(scope1);
        String fooScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        ProtocolMapperRepresentation protocolMapper = ProtocolMapperUtil.createAddressMapper(true, true, true);
        response = appRealm.clientScopes().get(fooScopeId).getProtocolMappers().createMapper(protocolMapper);
        response.close();
        ClientResource thirdParty = ApiUtil.findClientByClientId((RealmResource)appRealm, (String)THIRD_PARTY_APP);
        thirdParty.addDefaultClientScope(fooScopeId);
        this.getCleanup().addClientScopeId(fooScopeId);
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"Email address", "User profile", "User roles", "foo-addr"});
        this.grantPage.accept();
        this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        this.accountAppsPage.open();
        Assert.assertTrue((boolean)this.accountAppsPage.isCurrent());
        Map apps = this.accountAppsPage.getApplications();
        Assert.assertTrue((boolean)apps.containsKey(THIRD_PARTY_APP));
        Assert.assertTrue((boolean)((AccountApplicationsPage.AppEntry)apps.get(THIRD_PARTY_APP)).getClientScopesGranted().contains("foo-addr"));
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)appRealm, (String)"test-user@localhost");
        List consents = user.getConsents();
        Assert.assertEquals((long)1L, (long)consents.size());
        this.oauth.openLoginForm();
        this.appPage.assertCurrent();
        this.events.expectLogin().detail("auth_method", "openid-connect").detail("consent", "persistent_consent").removeDetail("username").client(THIRD_PARTY_APP).assertEvent();
        this.accountAppsPage.open();
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", THIRD_PARTY_APP).assertEvent();
        thirdParty.removeDefaultClientScope(fooScopeId);
    }

    @Test
    public void oauthGrantExpiredAuthSession() throws Exception {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        this.driver.manage().deleteAllCookies();
        this.grantPage.accept();
        this.errorPage.assertCurrent();
        String backToAppLink = this.errorPage.getBackToApplicationLink();
        ClientRepresentation thirdParty = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(REALM_NAME), (String)THIRD_PARTY_APP).toRepresentation();
        Assert.assertEquals((Object)backToAppLink, (Object)thirdParty.getBaseUrl());
    }

    @Test
    public void oauthGrantOrderedClientScopes() throws Exception {
        RealmResource appRealm = this.adminClient.realm(REALM_NAME);
        ClientScopeResource emailScope = ApiUtil.findClientScopeByName((RealmResource)appRealm, (String)"email");
        ClientScopeRepresentation emailRep = emailScope.toRepresentation();
        emailRep.getAttributes().put("gui.order", "1");
        emailScope.update(emailRep);
        ClientScopeResource profileScope = ApiUtil.findClientScopeByName((RealmResource)appRealm, (String)"profile");
        ClientScopeRepresentation profileRep = profileScope.toRepresentation();
        profileRep.getAttributes().put("gui.order", "2");
        profileScope.update(profileRep);
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        List displayedScopes = this.grantPage.getDisplayedGrants();
        Assert.assertEquals((Object)"Email address", displayedScopes.get(0));
        Assert.assertEquals((Object)"User profile", displayedScopes.get(1));
        this.grantPage.accept();
        this.accountAppsPage.open();
        displayedScopes = ((AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP)).getClientScopesGranted();
        Assert.assertEquals((Object)"Email address", displayedScopes.get(0));
        Assert.assertEquals((Object)"User profile", displayedScopes.get(1));
        emailRep = emailScope.toRepresentation();
        emailRep.getAttributes().put("gui.order", "3");
        emailScope.update(emailRep);
        this.accountAppsPage.open();
        displayedScopes = ((AccountApplicationsPage.AppEntry)this.accountAppsPage.getApplications().get(THIRD_PARTY_APP)).getClientScopesGranted();
        Assert.assertEquals((Object)"User profile", displayedScopes.get(0));
        Assert.assertEquals((Object)"Email address", displayedScopes.get(1));
        this.accountAppsPage.revokeGrant(THIRD_PARTY_APP);
        this.oauth.openLoginForm();
        this.grantPage.assertCurrent();
        displayedScopes = this.grantPage.getDisplayedGrants();
        Assert.assertEquals((Object)"User profile", displayedScopes.get(0));
        Assert.assertEquals((Object)"Email address", displayedScopes.get(1));
    }

    @Test
    public void oauthGrantUserNotLoggedOutAfterConsentRevoke() throws Exception {
        this.oauth.clientId(THIRD_PARTY_APP);
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        Assert.assertTrue((boolean)this.oauth.getCurrentQuery().containsKey("code"));
        EventRepresentation loginEvent = this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        String sessionId = loginEvent.getSessionId();
        this.adminClient.realm(REALM_NAME).users().get(loginEvent.getUserId()).revokeConsent(THIRD_PARTY_APP);
        this.oauth.openLoginForm();
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        loginEvent = this.events.expectLogin().client(THIRD_PARTY_APP).detail("consent", "consent_granted").assertEvent();
        String sessionId2 = loginEvent.getSessionId();
        Assert.assertEquals((Object)sessionId, (Object)sessionId2);
        this.adminClient.realm(REALM_NAME).users().get(loginEvent.getUserId()).revokeConsent(THIRD_PARTY_APP);
    }
}

