/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.OAuth2DeviceVerificationPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class OAuth2DeviceAuthorizationGrantTest
extends AbstractKeycloakTest {
    private static String userId;
    public static final String REALM_NAME = "test";
    public static final String DEVICE_APP = "test-device";
    public static final String DEVICE_APP_PUBLIC = "test-device-public";
    public static final String DEVICE_APP_PUBLIC_CUSTOM_CONSENT = "test-device-public-custom-consent";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected OAuth2DeviceVerificationPage verificationPage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name(REALM_NAME).privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").testEventListener();
        ClientRepresentation app = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId(DEVICE_APP).secret("secret").attribute("oauth2.device.authorization.grant.enabled", "true").build();
        realm.client(app);
        ClientRepresentation appPublic = ClientBuilder.create().id(KeycloakModelUtils.generateId()).publicClient().clientId(DEVICE_APP_PUBLIC).attribute("oauth2.device.authorization.grant.enabled", "true").build();
        realm.client(appPublic);
        ClientRepresentation appPublicCustomConsent = ClientBuilder.create().id(KeycloakModelUtils.generateId()).publicClient().clientId(DEVICE_APP_PUBLIC_CUSTOM_CONSENT).attribute("oauth2.device.authorization.grant.enabled", "true").consentRequired(true).attribute("display.on.consent.screen", "true").attribute("consent.screen.text", "This is the custom consent screen text.").build();
        realm.client(appPublicCustomConsent);
        userId = KeycloakModelUtils.generateId();
        UserRepresentation user = UserBuilder.create().id(userId).username("device-login").email("device-login@localhost").password("password").build();
        realm.user(user);
        testRealms.add(realm.build());
    }

    @Before
    public void resetConfig() {
        RealmRepresentation realm = this.getAdminClient().realm(REALM_NAME).toRepresentation();
        realm.setOAuth2DeviceCodeLifespan(Integer.valueOf(60));
        realm.setOAuth2DevicePollingInterval(Integer.valueOf(5));
        this.getAdminClient().realm(REALM_NAME).update(realm);
    }

    @Test
    public void testConfidentialClient() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUri());
        this.verificationPage.assertCurrent();
        this.verificationPage.submit(response.getUserCode());
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("device-login", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        this.verificationPage.assertApprovedPage();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        String tokenString = tokenResponse.getAccessToken();
        org.junit.Assert.assertNotNull((Object)tokenString);
        AccessToken token = this.oauth.verifyToken(tokenString);
        org.junit.Assert.assertNotNull((Object)token);
    }

    @Test
    public void testPublicClient() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP_PUBLIC);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP_PUBLIC, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUriComplete());
        this.oauth.fillLoginForm("device-login", "password");
        this.grantPage.accept();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP_PUBLIC, null, response.getDeviceCode());
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        String tokenString = tokenResponse.getAccessToken();
        org.junit.Assert.assertNotNull((Object)tokenString);
        AccessToken token = this.oauth.verifyToken(tokenString);
        org.junit.Assert.assertNotNull((Object)token);
    }

    @Test
    public void testPublicClientCustomConsent() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP_PUBLIC_CUSTOM_CONSENT);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP_PUBLIC_CUSTOM_CONSENT, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUriComplete());
        this.oauth.fillLoginForm("device-login", "password");
        Assert.assertTrue((boolean)this.grantPage.getDisplayedGrants().contains("This is the custom consent screen text."));
        this.grantPage.accept();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP_PUBLIC_CUSTOM_CONSENT, null, response.getDeviceCode());
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        String tokenString = tokenResponse.getAccessToken();
        org.junit.Assert.assertNotNull((Object)tokenString);
        AccessToken token = this.oauth.verifyToken(tokenString);
        org.junit.Assert.assertNotNull((Object)token);
    }

    @Test
    public void testNoRefreshToken() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(REALM_NAME), (String)DEVICE_APP);
        ClientRepresentation clientRepresentation = client.toRepresentation();
        clientRepresentation.getAttributes().put("use.refresh.tokens", "false");
        client.update(clientRepresentation);
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        this.openVerificationPage(response.getVerificationUri());
        this.verificationPage.submit(response.getUserCode());
        this.oauth.fillLoginForm("device-login", "password");
        this.grantPage.accept();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        org.junit.Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        org.junit.Assert.assertNull((Object)tokenResponse.getRefreshToken());
        clientRepresentation.getAttributes().put("use.refresh.tokens", "true");
        client.update(clientRepresentation);
    }

    @Test
    public void testConsentCancel() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUriComplete());
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("device-login", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.cancel();
        this.verificationPage.assertDeniedPage();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertEquals((Object)"access_denied", (Object)tokenResponse.getError());
    }

    @Test
    public void testInvalidUserCode() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUri());
        this.verificationPage.submit("x");
        this.verificationPage.assertInvalidUserCodePage();
    }

    @Test
    public void testExpiredUserCodeTest() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        try {
            this.setTimeOffset(610);
            this.openVerificationPage(response.getVerificationUriComplete());
        }
        finally {
            this.resetTimeOffset();
        }
        this.verificationPage.assertExpiredUserCodePage();
    }

    @Test
    public void testInvalidDeviceCode() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUriComplete());
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("device-login", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", "x");
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)tokenResponse.getError());
    }

    @Test
    public void testSuccessVerificationUriComplete() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUriComplete());
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("device-login", "password");
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        this.verificationPage.assertApprovedPage();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
    }

    @Test
    public void testExpiredDeviceCode() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        try {
            this.setTimeOffset(610);
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"expired_token", (Object)tokenResponse.getError());
        }
        finally {
            this.resetTimeOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeviceCodeLifespanPerClient() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(REALM_NAME), (String)DEVICE_APP);
        ClientRepresentation clientRepresentation = client.toRepresentation();
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        clientRepresentation.getAttributes().put(OAuth2DeviceConfig.OAUTH2_DEVICE_CODE_LIFESPAN_PER_CLIENT, "120");
        clientRepresentation.getAttributes().put(OAuth2DeviceConfig.OAUTH2_DEVICE_POLLING_INTERVAL_PER_CLIENT, "600000");
        client.update(clientRepresentation);
        response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)120L, (long)response.getExpiresIn());
        try {
            this.setTimeOffset(100);
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"authorization_pending", (Object)tokenResponse.getError());
            this.setTimeOffset(125);
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"expired_token", (Object)tokenResponse.getError());
        }
        finally {
            this.resetTimeOffset();
        }
        clientRepresentation.getAttributes().put(OAuth2DeviceConfig.OAUTH2_DEVICE_CODE_LIFESPAN_PER_CLIENT, "");
        clientRepresentation.getAttributes().put(OAuth2DeviceConfig.OAUTH2_DEVICE_POLLING_INTERVAL_PER_CLIENT, "");
        client.update(clientRepresentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDevicePollingIntervalPerClient() throws Exception {
        this.getTestingClient().testing().setTestingInfinispanTimeService();
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(REALM_NAME), (String)DEVICE_APP);
        ClientRepresentation clientRepresentation = client.toRepresentation();
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        clientRepresentation.getAttributes().put(OAuth2DeviceConfig.OAUTH2_DEVICE_POLLING_INTERVAL_PER_CLIENT, "10");
        client.update(clientRepresentation);
        response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)10L, (long)response.getInterval());
        try {
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"authorization_pending", (Object)tokenResponse.getError());
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"slow_down", (Object)tokenResponse.getError());
            this.setTimeOffset(7);
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"slow_down", (Object)tokenResponse.getError());
            this.setTimeOffset(10);
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"authorization_pending", (Object)tokenResponse.getError());
        }
        finally {
            this.getTestingClient().testing().revertTestingInfinispanTimeService();
            clientRepresentation.getAttributes().put(OAuth2DeviceConfig.OAUTH2_DEVICE_POLLING_INTERVAL_PER_CLIENT, "");
            client.update(clientRepresentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPooling() throws Exception {
        this.getTestingClient().testing().setTestingInfinispanTimeService();
        try {
            RealmRepresentation realm = this.getAdminClient().realm(REALM_NAME).toRepresentation();
            realm.setOAuth2DeviceCodeLifespan(Integer.valueOf(600));
            this.getAdminClient().realm(REALM_NAME).update(realm);
            this.oauth.realm(REALM_NAME);
            this.oauth.clientId(DEVICE_APP);
            OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
            Assert.assertEquals((long)600L, (long)response.getExpiresIn());
            Assert.assertEquals((long)5L, (long)response.getInterval());
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"authorization_pending", (Object)tokenResponse.getError());
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"slow_down", (Object)tokenResponse.getError());
            this.setTimeOffset(5);
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"authorization_pending", (Object)tokenResponse.getError());
            realm.setOAuth2DevicePollingInterval(Integer.valueOf(10));
            this.getAdminClient().realm(REALM_NAME).update(realm);
            response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
            Assert.assertEquals((long)600L, (long)response.getExpiresIn());
            Assert.assertEquals((long)10L, (long)response.getInterval());
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"authorization_pending", (Object)tokenResponse.getError());
            this.setTimeOffset(10);
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"slow_down", (Object)tokenResponse.getError());
            this.setTimeOffset(15);
            tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
            Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            Assert.assertEquals((Object)"authorization_pending", (Object)tokenResponse.getError());
        }
        finally {
            this.getTestingClient().testing().revertTestingInfinispanTimeService();
        }
    }

    @Test
    public void testUpdateConfig() {
        RealmResource realm = this.getAdminClient().realm(REALM_NAME);
        RealmRepresentation rep = realm.toRepresentation();
        rep.setOAuth2DevicePollingInterval(Integer.valueOf(5));
        rep.setOAuth2DeviceCodeLifespan(Integer.valueOf(600));
        realm.update(rep);
        rep = realm.toRepresentation();
        Assert.assertEquals((long)5L, (long)rep.getOAuth2DevicePollingInterval().intValue());
        Assert.assertEquals((long)600L, (long)rep.getOAuth2DeviceCodeLifespan().intValue());
        rep.setOAuth2DevicePollingInterval(Integer.valueOf(10));
        rep.setOAuth2DeviceCodeLifespan(Integer.valueOf(15));
        realm.update(rep);
        rep = realm.toRepresentation();
        Assert.assertEquals((long)10L, (long)rep.getOAuth2DevicePollingInterval().intValue());
        Assert.assertEquals((long)15L, (long)rep.getOAuth2DeviceCodeLifespan().intValue());
    }

    @Test
    public void testConsentCancelCannotBeReused() throws Exception {
        this.oauth.realm(REALM_NAME);
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getDeviceCode());
        org.junit.Assert.assertNotNull((Object)response.getUserCode());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUri());
        org.junit.Assert.assertNotNull((Object)response.getVerificationUriComplete());
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        Assert.assertEquals((long)5L, (long)response.getInterval());
        this.openVerificationPage(response.getVerificationUriComplete());
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("device-login", "password");
        this.grantPage.assertCurrent();
        this.grantPage.cancel();
        this.verificationPage.assertDeniedPage();
        this.openVerificationPage(response.getVerificationUriComplete());
        this.verificationPage.assertInvalidUserCodePage();
    }

    private void openVerificationPage(String verificationUri) {
        this.driver.navigate().to(verificationUri);
    }
}

