/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.URLAssert;

public class LogoutTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        testRealms.add(realm.build());
    }

    @Test
    public void postLogout() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = tokenResponse.getRefreshToken();
        try (CloseableHttpResponse response = this.oauth.doLogout(refreshTokenString, "password");){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
            org.junit.Assert.assertNotNull((Object)this.testingClient.testApp().getAdminLogoutAction());
        }
    }

    @Test
    public void postLogoutExpiredRefreshToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = tokenResponse.getRefreshToken();
        this.adminClient.realm("test").update(RealmBuilder.create().notBefore(Time.currentTime() + 1).build());
        try (CloseableHttpResponse response = this.oauth.doLogout(refreshTokenString, "password");){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
            org.junit.Assert.assertNotNull((Object)this.testingClient.testApp().getAdminLogoutAction());
        }
    }

    @Test
    public void logoutIDTokenHint() {
        this.oauth.doLogin("test-user@localhost", "password");
        String sessionId = this.events.expectLogin().assertEvent().getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String idToken = tokenResponse.getIdToken();
        this.events.clear();
        this.driver.navigate().to(this.oauth.getLogoutUrl().redirectUri(OAuthClient.APP_AUTH_ROOT).idTokenHint(idToken).build());
        this.events.expectLogout(sessionId).detail("redirect_uri", OAuthClient.APP_AUTH_ROOT).assertEvent();
        URLAssert.assertCurrentUrlEquals(OAuthClient.APP_AUTH_ROOT);
    }

    @Test
    public void browserLogoutWithAccessToken() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String accessToken = tokenResponse.getAccessToken();
        this.events.clear();
        this.driver.navigate().to(this.oauth.getLogoutUrl().redirectUri(OAuthClient.APP_AUTH_ROOT).idTokenHint(accessToken).build());
        this.events.expectLogoutError("invalid_token").assertEvent();
    }

    @Test
    public void postLogoutWithRefreshTokenAfterUserSessionLogoutAndLoginAgain() throws Exception {
        OAuthClient.AccessTokenResponse accessTokenResponse = this.loginAndForceNewLoginPage();
        String refreshToken1 = accessTokenResponse.getRefreshToken();
        this.oauth.doLogout(refreshToken1, "password");
        this.setTimeOffset(2);
        this.oauth.fillLoginForm("test-user@localhost", "password");
        Assert.assertFalse((boolean)this.loginPage.isCurrent());
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse2 = this.oauth.doAccessTokenRequest(code, "password");
        try (CloseableHttpResponse response = this.oauth.doLogout(refreshToken1, "password");){
            org.junit.Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusLine().getStatusCode());
        }
        String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(accessTokenResponse.getIdToken()).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
        try (CloseableHttpClient c = HttpClientBuilder.create().disableRedirectHandling().build();
             CloseableHttpResponse response = c.execute((HttpUriRequest)new HttpGet(logoutUrl));){
            org.junit.Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusLine().getStatusCode());
        }
        var7_9 = null;
        try (CloseableHttpResponse response = this.oauth.doLogout(tokenResponse2.getRefreshToken(), "password");){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
            org.junit.Assert.assertNotNull((Object)this.testingClient.testApp().getAdminLogoutAction());
        }
        catch (Throwable throwable) {
            var7_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void postLogoutFailWithCredentialsOfDifferentClient() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = tokenResponse.getRefreshToken();
        this.oauth.clientId("test-app-scope");
        try (CloseableHttpResponse response = this.oauth.doLogout(refreshTokenString, "password");){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
        }
        this.oauth.clientId("test-app");
    }

    @Test
    public void postLogoutWithValidIdToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String idTokenString = tokenResponse.getIdToken();
        String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
        try (CloseableHttpClient c = HttpClientBuilder.create().disableRedirectHandling().build();
             CloseableHttpResponse response = c.execute((HttpUriRequest)new HttpGet(logoutUrl));){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
            org.junit.Assert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)org.hamcrest.Matchers.is((Object)OAuthClient.APP_AUTH_ROOT));
        }
    }

    @Test
    public void postLogoutWithExpiredIdToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String idTokenString = tokenResponse.getIdToken();
        this.setTimeOffset(86400);
        String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
        try (CloseableHttpClient c = HttpClientBuilder.create().disableRedirectHandling().build();
             CloseableHttpResponse response = c.execute((HttpUriRequest)new HttpGet(logoutUrl));){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
            org.junit.Assert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)org.hamcrest.Matchers.is((Object)OAuthClient.APP_AUTH_ROOT));
        }
    }

    @Test
    public void postLogoutWithValidIdTokenWhenLoggedOutByAdmin() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String idTokenString = tokenResponse.getIdToken();
        this.adminClient.realm("test").logoutAll();
        String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
        try (CloseableHttpClient c = HttpClientBuilder.create().disableRedirectHandling().build();
             CloseableHttpResponse response = c.execute((HttpUriRequest)new HttpGet(logoutUrl));){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
            org.junit.Assert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)org.hamcrest.Matchers.is((Object)OAuthClient.APP_AUTH_ROOT));
        }
    }

    private void backchannelLogoutRequest(String expectedRefreshAlg, String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String idTokenString = tokenResponse.getIdToken();
        JWSHeader header = new JWSInput(tokenResponse.getAccessToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedAccessAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(tokenResponse.getIdToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedIdTokenAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(tokenResponse.getRefreshToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedRefreshAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
        try (CloseableHttpClient c = HttpClientBuilder.create().disableRedirectHandling().build();
             CloseableHttpResponse response = c.execute((HttpUriRequest)new HttpGet(logoutUrl));){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
            org.junit.Assert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)org.hamcrest.Matchers.is((Object)OAuthClient.APP_AUTH_ROOT));
        }
    }

    @Test
    public void backchannelLogoutRequest_RealmRS384_ClientRS512() throws Exception {
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS384");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)"RS512");
            this.backchannelLogoutRequest("HS256", "RS512", "RS384");
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)"RS256");
        }
    }

    @Test
    public void successfulKLogoutAfterEmptyBackChannelUrl() throws Exception {
        ClientsResource clients = this.adminClient.realm(this.oauth.getRealm()).clients();
        ClientRepresentation rep = (ClientRepresentation)clients.findByClientId(this.oauth.getClientId()).get(0);
        rep.getAttributes().put("backchannel.logout.url", "");
        clients.get(rep.getId()).update(rep);
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String idTokenString = tokenResponse.getIdToken();
        String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
        try (CloseableHttpClient c = HttpClientBuilder.create().disableRedirectHandling().build();
             CloseableHttpResponse response = c.execute((HttpUriRequest)new HttpGet(logoutUrl));){
            org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
            org.junit.Assert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)org.hamcrest.Matchers.is((Object)OAuthClient.APP_AUTH_ROOT));
        }
        org.junit.Assert.assertNotNull((Object)this.testingClient.testApp().getAdminLogoutAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backChannelPreferenceOverKLogout() throws Exception {
        ClientsResource clients = this.adminClient.realm(this.oauth.getRealm()).clients();
        ClientRepresentation rep = (ClientRepresentation)clients.findByClientId(this.oauth.getClientId()).get(0);
        rep.getAttributes().put("backchannel.logout.url", OAuthClient.APP_ROOT + "/admin/backchannelLogout");
        ClientResource clientResource = clients.get(rep.getId());
        clientResource.update(rep);
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            this.oauth.clientSessionState("client-session");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            String idTokenString = tokenResponse.getIdToken();
            String logoutUrl = this.oauth.getLogoutUrl().idTokenHint(idTokenString).postLogoutRedirectUri(OAuthClient.APP_AUTH_ROOT).build();
            try (CloseableHttpClient c = HttpClientBuilder.create().disableRedirectHandling().build();
                 CloseableHttpResponse response = c.execute((HttpUriRequest)new HttpGet(logoutUrl));){
                org.junit.Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
                org.junit.Assert.assertThat((Object)response.getFirstHeader("Location").getValue(), (Matcher)org.hamcrest.Matchers.is((Object)OAuthClient.APP_AUTH_ROOT));
            }
            org.junit.Assert.assertNotNull((Object)this.testingClient.testApp().getBackChannelLogoutToken());
        }
        finally {
            rep.getAttributes().put("backchannel.logout.url", "");
            clientResource.update(rep);
        }
    }

    private OAuthClient.AccessTokenResponse loginAndForceNewLoginPage() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(1);
        String loginFormUri = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl()).queryParam("prompt", new Object[]{"login"}).build(new Object[0]).toString();
        this.driver.navigate().to(loginFormUri);
        this.loginPage.assertCurrent();
        return tokenResponse;
    }
}

