/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;

public class LogoutCorsTest
extends AbstractKeycloakTest {
    private static final String VALID_CORS_URL = "http://localtest.me:8180";
    private static final String INVALID_CORS_URL = "http://invalid.localtest.me:8180";

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addWebOrigins(VALID_CORS_URL);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        testRealms.add(realm.build());
    }

    @Test
    public void postLogout_validRequestWithValidOrigin() throws Exception {
        OAuthClient.AccessTokenResponse tokenResponse = this.loginUser();
        String refreshTokenString = tokenResponse.getRefreshToken();
        this.oauth.origin(VALID_CORS_URL);
        try (CloseableHttpResponse response = this.oauth.doLogout(refreshTokenString, "password");){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
            LogoutCorsTest.assertCors(response);
        }
    }

    @Test
    public void postLogout_validRequestWithInValidOriginShouldFail() throws Exception {
        OAuthClient.AccessTokenResponse tokenResponse = this.loginUser();
        String refreshTokenString = tokenResponse.getRefreshToken();
        this.oauth.origin(INVALID_CORS_URL);
        try (CloseableHttpResponse response = this.oauth.doLogout(refreshTokenString, "password");){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
            LogoutCorsTest.assertNotCors(response);
        }
    }

    @Test
    public void postLogout_invalidRequestWithValidOrigin() throws Exception {
        OAuthClient.AccessTokenResponse tokenResponse = this.loginUser();
        String refreshTokenString = tokenResponse.getRefreshToken();
        this.oauth.origin(VALID_CORS_URL);
        try (CloseableHttpResponse response = this.oauth.doLogout("invalid-refresh-token", "password");){
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusLine().getStatusCode());
            LogoutCorsTest.assertCors(response);
        }
        response = this.oauth.doLogout(refreshTokenString, "invalid-secret");
        var4_4 = null;
        try {
            Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatusLine().getStatusCode());
            LogoutCorsTest.assertCors(response);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (response != null) {
                if (var4_4 != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    response.close();
                }
            }
        }
    }

    private OAuthClient.AccessTokenResponse loginUser() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        return this.oauth.doAccessTokenRequest(code, "password");
    }

    private static void assertCors(CloseableHttpResponse response) {
        Assert.assertEquals((Object)"true", (Object)response.getFirstHeader("Access-Control-Allow-Credentials").getValue());
        Assert.assertEquals((Object)VALID_CORS_URL, (Object)response.getFirstHeader("Access-Control-Allow-Origin").getValue());
        Assert.assertEquals((Object)"Access-Control-Allow-Methods", (Object)response.getFirstHeader("Access-Control-Expose-Headers").getValue());
    }

    private static void assertNotCors(CloseableHttpResponse response) {
        Assert.assertNull((Object)response.getFirstHeader("Access-Control-Allow-Credentials"));
        Assert.assertNull((Object)response.getFirstHeader("Access-Control-Allow-Origin"));
        Assert.assertNull((Object)response.getFirstHeader("Access-Control-Expose-Headers"));
    }
}

