/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.oidc.PkceGenerator;
import org.keycloak.testsuite.runonserver.FetchOnServerWrapper;
import org.keycloak.testsuite.runonserver.ServerVersion;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class LoginStatusIframeEndpointTest
extends AbstractKeycloakTest {
    @Test
    public void checkIframe() throws IOException {
        BasicCookieStore cookieStore = new BasicCookieStore();
        try (CloseableHttpClient client = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();){
            String redirectUri = URLEncoder.encode(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/admin/master/console", "UTF-8");
            PkceGenerator pkce = new PkceGenerator();
            HttpGet get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/auth?response_type=code&client_id=" + "security-admin-console" + "&redirect_uri=" + redirectUri + "&scope=openid&code_challenge_method=S256&code_challenge=" + pkce.getCodeChallenge());
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String s = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            response.close();
            String action = ActionURIUtils.getActionURIFromPageSource((String)s);
            HttpPost post = new HttpPost(action);
            LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("username", "admin"));
            params.add(new BasicNameValuePair("password", "admin"));
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            response = client.execute((HttpUriRequest)post);
            Assert.assertEquals((Object)"CP=\"This is not a P3P policy!\"", (Object)response.getFirstHeader("P3P").getValue());
            Header setIdentityCookieHeader = null;
            Header setSessionCookieHeader = null;
            for (Header h : response.getAllHeaders()) {
                if (!h.getName().equals("Set-Cookie")) continue;
                if (h.getValue().contains("KEYCLOAK_SESSION")) {
                    setSessionCookieHeader = h;
                    continue;
                }
                if (!h.getValue().contains("KEYCLOAK_IDENTITY")) continue;
                setIdentityCookieHeader = h;
            }
            Assert.assertNotNull(setIdentityCookieHeader);
            Assert.assertTrue((boolean)setIdentityCookieHeader.getValue().contains("HttpOnly"));
            Assert.assertNotNull(setSessionCookieHeader);
            Assert.assertFalse((boolean)setSessionCookieHeader.getValue().contains("HttpOnly"));
            response.close();
            Cookie sessionCookie = null;
            for (Cookie cookie : cookieStore.getCookies()) {
                if (!cookie.getName().equals("KEYCLOAK_SESSION")) continue;
                sessionCookie = cookie;
                break;
            }
            Assert.assertNotNull(sessionCookie);
            get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html");
            response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            s = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            Assert.assertTrue((boolean)s.contains("function getCookie()"));
            Assert.assertEquals((Object)"CP=\"This is not a P3P policy!\"", (Object)response.getFirstHeader("P3P").getValue());
            Assert.assertNull((Object)response.getFirstHeader(BrowserSecurityHeaders.X_FRAME_OPTIONS.getHeaderName()));
            Assert.assertEquals((Object)"frame-src 'self'; object-src 'none';", (Object)response.getFirstHeader(BrowserSecurityHeaders.CONTENT_SECURITY_POLICY.getHeaderName()).getValue());
            Assert.assertEquals((Object)"none", (Object)response.getFirstHeader(BrowserSecurityHeaders.X_ROBOTS_TAG.getHeaderName()).getValue());
            response.close();
            get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html/init");
            response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)response.getStatusLine().getStatusCode());
            response.close();
            get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html/init?client_id=invalid&origin=" + this.suiteContext.getAuthServerInfo().getContextRoot());
            response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)response.getStatusLine().getStatusCode());
            response.close();
            get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html/init?client_id=" + "security-admin-console" + "&origin=http://invalid");
            response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)response.getStatusLine().getStatusCode());
            response.close();
            get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html/init?client_id=" + "security-admin-console" + "&origin=" + this.suiteContext.getAuthServerInfo().getContextRoot());
            response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)204L, (long)response.getStatusLine().getStatusCode());
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkIframeWildcardOrigin() throws IOException {
        String id = ((ClientRepresentation)this.adminClient.realm("master").clients().findByClientId("security-admin-console").get(0)).getId();
        ClientResource master = this.adminClient.realm("master").clients().get(id);
        ClientRepresentation rep = master.toRepresentation();
        List org = rep.getWebOrigins();
        try (CloseableHttpClient client = HttpClients.createDefault();){
            rep.setWebOrigins(Collections.singletonList("*"));
            master.update(rep);
            HttpGet get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html/init?client_id=" + "security-admin-console" + "&origin=http://anything");
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
                Assert.assertEquals((long)204L, (long)response.getStatusLine().getStatusCode());
            }
        }
        finally {
            rep.setWebOrigins(org);
            master.update(rep);
        }
    }

    @Test
    public void checkIframeCache() throws IOException {
        String version = (String)this.testingClient.server().fetch((FetchOnServerWrapper)new ServerVersion());
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html");
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"no-cache, must-revalidate, no-transform, no-store", (Object)response.getHeaders("Cache-Control")[0].getValue());
            get = new HttpGet(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/protocol/openid-connect/login-status-iframe.html?version=" + version);
            response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)response.getHeaders("Cache-Control")[0].getValue().contains("max-age"));
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }
}

