/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.adapters.authentication.JWTClientSecretCredentialsProvider;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.UriUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientAuthSecretSignedJWTTest
extends AbstractKeycloakTest {
    private static final Logger logger = Logger.getLogger(ClientAuthSecretSignedJWTTest.class);
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/client-auth-test/testrealm-jwt-client-secret.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void testCodeToTokenRequestSuccess() throws Exception {
        this.testCodeToTokenRequestSuccess("HS256");
    }

    @Test
    public void testCodeToTokenRequestSuccessHS384() throws Exception {
        this.testCodeToTokenRequestSuccess("HS384");
    }

    @Test
    public void testCodeToTokenRequestSuccessHS512() throws Exception {
        this.testCodeToTokenRequestSuccess("HS512");
    }

    @Test
    public void testInvalidIssuer() throws Exception {
        this.oauth.clientId("test-app");
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        JWTClientSecretCredentialsProvider jwtProvider = new JWTClientSecretCredentialsProvider(){

            protected JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
                JsonWebToken jwt = super.createRequestToken(clientId, realmInfoUrl);
                jwt.issuer("bad-issuer");
                return jwt;
            }
        };
        String algorithm = "HS256";
        jwtProvider.setClientSecret("password", algorithm);
        String jwt = jwtProvider.createSignedRequestToken(this.oauth.getClientId(), this.getRealmInfoUrl(), algorithm);
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequest(code, jwt);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_client", (Object)response.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCodeToTokenRequestFailureHS384Enforced() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        String realmName = "test";
        String clientId = "test-app";
        try {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setTokenEndpointAuthSigningAlg("HS384");
            clientResource.update(clientRep);
            this.testCodeToTokenRequestSuccess("HS384");
        }
        catch (Exception e) {
            Assert.fail();
        }
        finally {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setTokenEndpointAuthSigningAlg(null);
            clientResource.update(clientRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCodeToTokenRequestFailureHS512Enforced() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        String realmName = "test";
        String clientId = "test-app";
        String clientSecret = "password";
        try {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setTokenEndpointAuthSigningAlg("HS512");
            clientResource.update(clientRep);
            this.oauth.clientId("test-app");
            this.oauth.doLogin("test-user@localhost", "password");
            this.events.expectLogin().client("test-app").assertEvent();
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.doAccessTokenRequest(code, this.getClientSignedJWT("password", 20, "HS256"));
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_client", (Object)response.getError());
        }
        catch (Exception e) {
            Assert.fail();
        }
        finally {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setTokenEndpointAuthSigningAlg(null);
            clientResource.update(clientRep);
        }
    }

    private void testCodeToTokenRequestSuccess(String algorithm) throws Exception {
        this.oauth.clientId("test-app");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("test-app").assertEvent();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequest(code, this.getClientSignedJWT("password", 20, algorithm));
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.oauth.verifyToken(response.getAccessToken());
        this.oauth.parseRefreshToken(response.getRefreshToken());
        this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).client(this.oauth.getClientId()).detail("client_auth_method", "client-secret-jwt").assertEvent();
    }

    @Test
    public void testAssertionInvalidSignature() throws Exception {
        this.oauth.clientId("test-app");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("test-app").assertEvent();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequest(code, this.getClientSignedJWT("ppassswordd", 20));
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
    }

    @Test
    public void testAssertionReuse() throws Exception {
        this.oauth.clientId("test-app");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("test-app").assertEvent();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String clientSignedJWT = this.getClientSignedJWT("password", 20);
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequest(code, clientSignedJWT);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).client(this.oauth.getClientId()).detail("client_auth_method", "client-secret-jwt").assertEvent();
        this.oauth.openLoginForm();
        loginEvent = this.events.expectLogin().client("test-app").assertEvent();
        String code2 = (String)this.oauth.getCurrentQuery().get("code");
        response = this.doAccessTokenRequest(code2, clientSignedJWT);
        this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).error("invalid_client_credentials").clearDetails().user((String)null).session((String)null).assertEvent();
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
    }

    private String getClientSignedJWT(String secret, int timeout) {
        return this.getClientSignedJWT(secret, timeout, "HS256");
    }

    private String getClientSignedJWT(String secret, int timeout, String algorithm) {
        JWTClientSecretCredentialsProvider jwtProvider = new JWTClientSecretCredentialsProvider();
        jwtProvider.setClientSecret(secret, algorithm);
        return jwtProvider.createSignedRequestToken(this.oauth.getClientId(), this.getRealmInfoUrl(), algorithm);
    }

    private String getRealmInfoUrl() {
        String authServerBaseUrl = UriUtils.getOrigin((String)this.oauth.getRedirectUri()) + "/auth";
        return KeycloakUriBuilder.fromUri((String)authServerBaseUrl).path("/realms/{realm-name}").build(new Object[]{"test"}).toString();
    }

    private OAuthClient.AccessTokenResponse doAccessTokenRequest(String code, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        parameters.add((NameValuePair)new BasicNameValuePair("code", code));
        parameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        CloseableHttpResponse response = this.sendRequest(this.oauth.getAccessTokenUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpResponse sendRequest(String requestUrl, List<NameValuePair> parameters) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost(requestUrl);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
        finally {
            this.oauth.closeClient((CloseableHttpClient)client);
        }
    }
}

