/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.Base64Url;
import org.keycloak.crypto.ECDSASignatureProvider;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.mappers.HardcodedClaim;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.UserInfoClientUtil;
import org.keycloak.testsuite.util.UserManager;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;
import org.openqa.selenium.By;

public class AccessTokenTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @BeforeClass
    public static void addBouncyCastleProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        UserBuilder user = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("no-permissions").addRoles("user").password("password");
        realm.getUsers().add(user.build());
        realm.getClients().stream().filter(clientRepresentation -> "test-app".equals(clientRepresentation.getClientId())).forEach(clientRepresentation -> clientRepresentation.setFullScopeAllowed(Boolean.valueOf(false)));
        testRealms.add(realm);
    }

    @Test
    public void loginFormUsernameOrEmailLabel() throws Exception {
        this.oauth.openLoginForm();
        org.junit.Assert.assertEquals((Object)"Username or email", (Object)this.driver.findElement(By.xpath((String)"//label[@for='username']")).getText());
    }

    @Test
    public void accessTokenRequest() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertThat((Object)response.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        org.junit.Assert.assertThat((Object)response.getRefreshExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1750)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1800))));
        org.junit.Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        String expectedKid = this.oauth.doCertsRequest("test").getKeys()[0].getKeyId();
        JWSHeader header = new JWSInput(response.getAccessToken()).getHeader();
        org.junit.Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getIdToken()).getHeader();
        org.junit.Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getRefreshToken()).getHeader();
        org.junit.Assert.assertEquals((Object)"HS256", (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        org.junit.Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId(), (Object)token.getSubject());
        org.junit.Assert.assertNotEquals((Object)"test-user@localhost", (Object)token.getSubject());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        JWSInput idToken = new JWSInput(response.getIdToken());
        ObjectMapper mapper = JsonSerialization.mapper;
        JsonParser parser = mapper.getFactory().createParser(idToken.readContentAsString());
        TreeNode treeNode = mapper.readTree(parser);
        String sid = ((TextNode)treeNode.get("sid")).asText();
        org.junit.Assert.assertEquals((Object)sessionId, (Object)sid);
        org.junit.Assert.assertNull((Object)token.getNbf());
        org.junit.Assert.assertEquals((long)0L, (long)token.getNotBefore());
        org.junit.Assert.assertNotNull((Object)token.getIat());
        org.junit.Assert.assertEquals((long)token.getIat().intValue(), (long)token.getIssuedAt());
        org.junit.Assert.assertNotNull((Object)token.getExp());
        org.junit.Assert.assertEquals((long)token.getExp().intValue(), (long)token.getExpiration());
        org.junit.Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("user"));
        org.junit.Assert.assertEquals((long)1L, (long)token.getResourceAccess(this.oauth.getClientId()).getRoles().size());
        org.junit.Assert.assertTrue((boolean)token.getResourceAccess(this.oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation event = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        org.junit.Assert.assertEquals((Object)token.getId(), event.getDetails().get("token_id"));
        org.junit.Assert.assertEquals((Object)this.oauth.parseRefreshToken(response.getRefreshToken()).getId(), event.getDetails().get("refresh_token_id"));
        org.junit.Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
    }

    @Test
    public void accessTokenWrongCode() throws Exception {
        this.oauth.openLoginForm();
        String actionURI = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
        String loginPageCode = (String)ActionURIUtils.parseQueryParamsFromActionURI((String)actionURI).get("code");
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(loginPageCode, "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertNull((Object)response.getRefreshToken());
    }

    @Test
    public void accessTokenInvalidClientCredentials() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "invalid");
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).error("invalid_client_credentials").clearDetails().user((String)null).session((String)null);
        expectedEvent.assertEvent();
    }

    @Test
    public void accessTokenMissingClientCredentials() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).error("invalid_client_credentials").clearDetails().user((String)null).session((String)null);
        expectedEvent.assertEvent();
    }

    @Test
    public void accessTokenInvalidRedirectUri() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String redirectUri = this.oauth.getRedirectUri();
        this.oauth.redirectUri("http://invalid");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        org.junit.Assert.assertEquals((Object)"Incorrect redirect_uri", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).error("invalid_code").removeDetail("token_id").removeDetail("refresh_token_id").removeDetail("refresh_token_type").assertEvent();
        this.oauth.redirectUri(redirectUri);
    }

    @Test
    public void accessTokenUserSessionExpired() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String sessionId = loginEvent.getSessionId();
        this.testingClient.testing().removeUserSession("test", sessionId);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        org.junit.Assert.assertNull((Object)tokenResponse.getAccessToken());
        org.junit.Assert.assertNull((Object)tokenResponse.getRefreshToken());
        this.events.expectCodeToToken(codeId, sessionId).removeDetail("token_id").user((String)null).removeDetail("refresh_token_id").removeDetail("refresh_token_type").error("invalid_code").assertEvent();
        this.events.clear();
    }

    @Test
    public void accessTokenCodeExpired() {
        RealmManager.realm(this.adminClient.realm("test")).accessCodeLifeSpan(1);
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.setTimeOffset(0);
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, codeId);
        expectedEvent.error("expired_code").removeDetail("token_id").removeDetail("refresh_token_id").removeDetail("refresh_token_type").user((String)null);
        expectedEvent.assertEvent();
        this.events.clear();
        RealmManager.realm(this.adminClient.realm("test")).accessCodeLifeSpan(60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void accessTokenCodeUsed() throws IOException {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        String accessToken = response.getAccessToken();
        try (ResteasyClient jaxrsClient = AdminClientUtil.createResteasyClient();){
            Response userInfoResponse = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)jaxrsClient, (String)accessToken);
            UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)userInfoResponse, (String)"test-user@localhost", (String)"test-user@localhost");
            String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", accessToken);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(introspectionResponse);
            org.junit.Assert.assertEquals((Object)true, (Object)jsonNode.get("active").asBoolean());
            org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)jsonNode.get("email").asText());
            this.events.clear();
            response = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            AssertEvents.ExpectedEvent expectedEvent = this.events.expectCodeToToken(codeId, codeId);
            expectedEvent.error("invalid_code").removeDetail("token_id").removeDetail("refresh_token_id").removeDetail("refresh_token_type").user((String)null);
            expectedEvent.assertEvent();
            userInfoResponse = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)jaxrsClient, (String)accessToken);
            org.junit.Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)userInfoResponse.getStatus());
            userInfoResponse.close();
            introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", accessToken);
            objectMapper = new ObjectMapper();
            jsonNode = objectMapper.readTree(introspectionResponse);
            org.junit.Assert.assertEquals((Object)false, (Object)jsonNode.get("active").asBoolean());
            org.junit.Assert.assertNull((Object)jsonNode.get("email"));
            this.events.clear();
            RealmManager.realm(this.adminClient.realm("test")).accessCodeLifeSpan(60);
        }
    }

    @Test
    public void accessTokenCodeRoleMissing() {
        RealmResource realmResource = this.adminClient.realm("test");
        RoleRepresentation role = RoleBuilder.create().name("tmp-role").build();
        realmResource.roles().create(role);
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)realmResource, (String)"test-user@localhost");
        UserManager.realm(realmResource).user(user).assignRoles(role.getName());
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        realmResource.roles().deleteRole("tmp-role");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        org.junit.Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("user"));
        this.events.clear();
    }

    @Test
    public void accessTokenCodeHasRequiredAction() {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserManager.realm(this.adminClient.realm("test")).user(user).addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE.toString());
        this.oauth.doLogin("test-user@localhost", "password");
        String actionURI = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
        String code = (String)ActionURIUtils.parseQueryParamsFromActionURI((String)actionURI).get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        EventRepresentation event = this.events.poll();
        org.junit.Assert.assertNull(event.getDetails().get("code_id"));
        UserManager.realm(this.adminClient.realm("test")).user(user).removeRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE.toString());
    }

    @Test
    public void testGrantAccessToken() throws Exception {
        JsonNode jsonNode;
        ObjectMapper objectMapper2;
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        RealmResource realmsResource = this.adminClient.realm("test");
        RealmRepresentation realmRepresentation = realmsResource.toRepresentation();
        realmRepresentation.setSslRequired(SslRequired.ALL.toString());
        realmsResource.update(realmRepresentation);
        Response response = this.executeGrantAccessTokenRequest(grantTarget);
        org.junit.Assert.assertEquals((long)(ServerURLs.AUTH_SERVER_SSL_REQUIRED ? 200L : 403L), (long)response.getStatus());
        response.close();
        RealmResource realmsResource2 = this.realmsResouce().realm("test");
        RealmRepresentation realmRepresentation2 = realmsResource2.toRepresentation();
        realmRepresentation2.setSslRequired(SslRequired.EXTERNAL.toString());
        realmsResource2.update(realmRepresentation2);
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("password", "password");
        Response response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        org.junit.Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        org.junit.Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        form.param("password", "invalid");
        response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        org.junit.Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        response2 = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        org.junit.Assert.assertEquals((long)401L, (long)response2.getStatus());
        response2.close();
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = clientResource.toRepresentation();
        clientRepresentation.setBearerOnly(Boolean.valueOf(true));
        clientResource.update(clientRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        ClientResource clientResource2 = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation2 = clientResource2.toRepresentation();
        clientRepresentation2.setBearerOnly(Boolean.valueOf(false));
        clientRepresentation2.setSecret("password");
        clientResource2.update(clientRepresentation2);
        realmsResource = this.realmsResouce().realm("test");
        realmRepresentation = realmsResource.toRepresentation();
        realmRepresentation.setEnabled(Boolean.valueOf(false));
        realmsResource.update(realmRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        org.junit.Assert.assertEquals((long)403L, (long)response.getStatus());
        response.close();
        realmsResource2 = this.realmsResouce().realm("test");
        realmRepresentation2 = realmsResource2.toRepresentation();
        realmRepresentation2.setEnabled(Boolean.valueOf(true));
        realmsResource2.update(realmRepresentation2);
        clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        clientRepresentation = clientResource.toRepresentation();
        clientRepresentation.setEnabled(Boolean.valueOf(false));
        clientResource.update(clientRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        clientResource2 = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        clientRepresentation2 = clientResource2.toRepresentation();
        clientRepresentation2.setEnabled(Boolean.valueOf(true));
        clientResource2.update(clientRepresentation2);
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        Object userRepresentation = userResource.toRepresentation();
        userRepresentation.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        userResource.update((UserRepresentation)userRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        userRepresentation = null;
        try {
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatus());
            objectMapper2 = new ObjectMapper();
            jsonNode = objectMapper2.readTree((String)response.readEntity(String.class));
            org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)jsonNode.get("error").asText());
            org.junit.Assert.assertEquals((Object)"Account is not fully set up", (Object)jsonNode.get("error_description").asText());
        }
        catch (Throwable objectMapper2) {
            userRepresentation = objectMapper2;
            throw objectMapper2;
        }
        finally {
            if (response != null) {
                if (userRepresentation != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable objectMapper2) {
                        ((Throwable)userRepresentation).addSuppressed(objectMapper2);
                    }
                } else {
                    response.close();
                }
            }
        }
        response = this.executeGrantAccessTokenRequestWrongPassword(grantTarget);
        userRepresentation = null;
        try {
            org.junit.Assert.assertEquals((long)401L, (long)response.getStatus());
            objectMapper2 = new ObjectMapper();
            jsonNode = objectMapper2.readTree((String)response.readEntity(String.class));
            org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)jsonNode.get("error").asText());
            org.junit.Assert.assertEquals((Object)"Invalid user credentials", (Object)jsonNode.get("error_description").asText());
        }
        catch (Throwable objectMapper3) {
            userRepresentation = objectMapper3;
            throw objectMapper3;
        }
        finally {
            if (response != null) {
                if (userRepresentation != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable objectMapper3) {
                        ((Throwable)userRepresentation).addSuppressed(objectMapper3);
                    }
                } else {
                    response.close();
                }
            }
        }
        userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        userRepresentation = userResource.toRepresentation();
        userRepresentation.getRequiredActions().remove(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        userResource.update((UserRepresentation)userRepresentation);
        userResource = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        userRepresentation = userResource.toRepresentation();
        userRepresentation.setEnabled(Boolean.valueOf(false));
        userResource.update((UserRepresentation)userRepresentation);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        UserResource userResource2 = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost");
        UserRepresentation userRepresentation2 = userResource2.toRepresentation();
        userRepresentation2.setEnabled(Boolean.valueOf(true));
        userResource2.update(userRepresentation2);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        client.close();
        this.events.clear();
    }

    @Test
    public void testKeycloak2221() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        clientResource.getProtocolMappers().createMapper(ProtocolMapperUtil.createRoleNameMapper("rename-role", "user", "realm-user"));
        clientResource.getProtocolMappers().createMapper(ProtocolMapperUtil.createRoleNameMapper("rename-role2", "admin", "the-admin"));
        Response response = this.executeGrantRequest(grantTarget, "no-permissions", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        AccessToken accessToken = this.getAccessToken(tokenResponse);
        org.junit.Assert.assertEquals((long)accessToken.getRealmAccess().getRoles().size(), (long)1L);
        org.junit.Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains("realm-user"));
        response.close();
        ClientResource app = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = app.toRepresentation();
        for (ProtocolMapperRepresentation protocolRep : clientRepresentation.getProtocolMappers()) {
            if (!protocolRep.getName().startsWith("rename-role")) continue;
            clientResource.getProtocolMappers().delete(protocolRep.getId());
        }
        this.events.clear();
    }

    @Test
    public void testClientScope() throws Exception {
        RealmResource realm = this.adminClient.realm("test");
        RoleRepresentation realmRole = new RoleRepresentation();
        realmRole.setName("realm-test-role");
        realm.roles().create(realmRole);
        realmRole = realm.roles().get("realm-test-role").toRepresentation();
        RoleRepresentation realmRole2 = new RoleRepresentation();
        realmRole2.setName("realm-test-role2");
        realm.roles().create(realmRole2);
        realmRole2 = realm.roles().get("realm-test-role2").toRepresentation();
        List users = realm.users().search("test-user@localhost", Integer.valueOf(-1), Integer.valueOf(-1));
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        UserRepresentation user = (UserRepresentation)users.get(0);
        LinkedList<RoleRepresentation> addRoles = new LinkedList<RoleRepresentation>();
        addRoles.add(realmRole);
        addRoles.add(realmRole2);
        realm.users().get(user.getId()).roles().realmLevel().add(addRoles);
        ClientScopeRepresentation rep = new ClientScopeRepresentation();
        rep.setName("scope");
        rep.setProtocol("openid-connect");
        Response response = realm.clientScopes().create(rep);
        org.junit.Assert.assertEquals((long)201L, (long)response.getStatus());
        URI scopeUri = response.getLocation();
        String clientScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        ClientScopeResource clientScopeResource = (ClientScopeResource)this.adminClient.proxy(ClientScopeResource.class, scopeUri);
        ProtocolMapperModel hard = HardcodedClaim.create((String)"hard", (String)"hard", (String)"coded", (String)"String", (boolean)true, (boolean)true);
        ProtocolMapperRepresentation mapper = ModelToRepresentation.toRepresentation((ProtocolMapperModel)hard);
        response = clientScopeResource.getProtocolMappers().createMapper(mapper);
        org.junit.Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        ClientRepresentation clientRep = ApiUtil.findClientByClientId((RealmResource)realm, (String)"test-app").toRepresentation();
        realm.clients().get(clientRep.getId()).addDefaultClientScope(clientScopeId);
        clientRep.setFullScopeAllowed(Boolean.valueOf(false));
        realm.clients().get(clientRep.getId()).update(clientRep);
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        response = this.executeGrantAccessTokenRequest(grantTarget);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        IDToken idToken = this.getIdToken(tokenResponse);
        org.junit.Assert.assertEquals((Object)"coded", idToken.getOtherClaims().get("hard"));
        AccessToken accessToken = this.getAccessToken(tokenResponse);
        org.junit.Assert.assertEquals((Object)"coded", accessToken.getOtherClaims().get("hard"));
        org.junit.Assert.assertFalse((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole.getName()));
        org.junit.Assert.assertFalse((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client.close();
        LinkedList<RoleRepresentation> addRole1 = new LinkedList<RoleRepresentation>();
        addRole1.add(realmRole);
        clientScopeResource.getScopeMappings().realmLevel().add(addRole1);
        ResteasyClient client2 = AdminClientUtil.createResteasyClient();
        UriBuilder builder2 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri2 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder2).build(new Object[]{"test"});
        WebTarget grantTarget2 = client2.target(grantUri2);
        response = this.executeGrantAccessTokenRequest(grantTarget2);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse2 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        accessToken = this.getAccessToken(tokenResponse2);
        org.junit.Assert.assertNotNull((Object)accessToken.getRealmAccess());
        org.junit.Assert.assertTrue((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole.getName()));
        org.junit.Assert.assertFalse((boolean)accessToken.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client2.close();
        LinkedList<RoleRepresentation> addRole2 = new LinkedList<RoleRepresentation>();
        addRole2.add(realmRole2);
        realm.clients().get(clientRep.getId()).getScopeMappings().realmLevel().add(addRole2);
        ResteasyClient client3 = AdminClientUtil.createResteasyClient();
        UriBuilder builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        WebTarget grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        AccessToken accessToken2 = this.getAccessToken(tokenResponse3);
        org.junit.Assert.assertNotNull((Object)accessToken2.getRealmAccess());
        org.junit.Assert.assertTrue((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole.getName()));
        org.junit.Assert.assertTrue((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client3.close();
        clientScopeResource.getScopeMappings().realmLevel().remove(addRole1);
        realm.clients().get(clientRep.getId()).getScopeMappings().realmLevel().remove(addRole2);
        client3 = AdminClientUtil.createResteasyClient();
        builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        accessToken2 = this.getAccessToken(tokenResponse3);
        org.junit.Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole.getName()));
        org.junit.Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole2.getName()));
        response.close();
        client3.close();
        realm.clients().get(clientRep.getId()).removeDefaultClientScope(clientScopeId);
        clientScopeResource.getScopeMappings().realmLevel().add(addRole1);
        clientScopeResource.getScopeMappings().realmLevel().add(addRole2);
        client3 = AdminClientUtil.createResteasyClient();
        builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        accessToken2 = this.getAccessToken(tokenResponse3);
        org.junit.Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole.getName()));
        org.junit.Assert.assertFalse((boolean)accessToken2.getRealmAccess().getRoles().contains(realmRole2.getName()));
        org.junit.Assert.assertNull(accessToken2.getOtherClaims().get("hard"));
        IDToken idToken2 = this.getIdToken(tokenResponse3);
        org.junit.Assert.assertNull(idToken2.getOtherClaims().get("hard"));
        response.close();
        client3.close();
        realm.users().get(user.getId()).roles().realmLevel().remove(addRoles);
        realm.roles().get(realmRole.getName()).remove();
        realm.roles().get(realmRole2.getName()).remove();
        clientScopeResource.remove();
        client3 = AdminClientUtil.createResteasyClient();
        builder3 = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        grantUri3 = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder3).build(new Object[]{"test"});
        grantTarget3 = client3.target(grantUri3);
        response = this.executeGrantAccessTokenRequest(grantTarget3);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        tokenResponse3 = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        IDToken idToken3 = this.getIdToken(tokenResponse3);
        org.junit.Assert.assertNull(idToken3.getOtherClaims().get("hard"));
        AccessToken accessToken3 = this.getAccessToken(tokenResponse3);
        org.junit.Assert.assertNull(accessToken3.getOtherClaims().get("hard"));
        response.close();
        client3.close();
        this.events.clear();
    }

    @Test
    public void testAuthorizationNegotiateHeaderIgnored() throws Exception {
        this.adminClient.realm("test").clients().create(ClientBuilder.create().clientId("sample-public-client").authenticatorType("client-secret").redirectUris(this.oauth.getRedirectUri() + "/*").publicClient().build());
        this.oauth.clientId("sample-public-client");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("sample-public-client").assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost post = new HttpPost(this.oauth.getAccessTokenUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
            parameters.add(new BasicNameValuePair("code", code));
            parameters.add(new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
            parameters.add(new BasicNameValuePair("client_id", this.oauth.getClientId()));
            post.setHeader("Authorization", "Negotiate something-which-will-be-ignored");
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(client.execute((HttpUriRequest)post));
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            AccessToken token = this.oauth.verifyToken(response.getAccessToken());
            this.events.expectCodeToToken(codeId, sessionId).client("sample-public-client").assertEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void expiration() throws Exception {
        int sessionMax = (int)TimeUnit.MINUTES.toSeconds(30L);
        int sessionIdle = (int)TimeUnit.MINUTES.toSeconds(30L);
        int tokenLifespan = (int)TimeUnit.MINUTES.toSeconds(5L);
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        Integer originalSessionMax = rep.getSsoSessionMaxLifespan();
        rep.setSsoSessionMaxLifespan(Integer.valueOf(sessionMax));
        realm.update(rep);
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), sessionIdle);
            Assert.assertExpiration(response.getExpiresIn(), tokenLifespan);
            this.setTimeOffset(sessionMax - 60);
            response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), 60);
            Assert.assertExpiration(response.getExpiresIn(), 60);
        }
        finally {
            rep.setSsoSessionMaxLifespan(originalSessionMax);
            realm.update(rep);
        }
    }

    @Test
    public void accessTokenResponseHeader() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Map headers = response.getHeaders();
        org.junit.Assert.assertEquals((Object)"application/json", headers.get("Content-Type"));
        org.junit.Assert.assertEquals((Object)"no-store", headers.get("Cache-Control"));
        org.junit.Assert.assertEquals((Object)"no-cache", headers.get("Pragma"));
    }

    private IDToken getIdToken(AccessTokenResponse tokenResponse) throws JWSInputException {
        JWSInput input = new JWSInput(tokenResponse.getIdToken());
        return (IDToken)input.readJsonContent(IDToken.class);
    }

    private AccessToken getAccessToken(AccessTokenResponse tokenResponse) throws JWSInputException {
        JWSInput input = new JWSInput(tokenResponse.getToken());
        return (AccessToken)input.readJsonContent(AccessToken.class);
    }

    protected Response executeGrantAccessTokenRequest(WebTarget grantTarget) {
        String username = "test-user@localhost";
        String password = "password";
        return this.executeGrantRequest(grantTarget, username, password);
    }

    protected Response executeGrantAccessTokenRequestWrongPassword(WebTarget grantTarget) {
        return this.executeGrantRequest(grantTarget, "test-user@localhost", "bad-password");
    }

    protected Response executeGrantRequest(WebTarget grantTarget, String username, String password) {
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", username).param("password", password).param("scope", "openid");
        return grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientAccessTokenLifespanOverride() {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = client.toRepresentation();
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        int sessionMax = rep.getSsoSessionMaxLifespan();
        int accessTokenLifespan = rep.getAccessTokenLifespan();
        org.junit.Assert.assertNotEquals((long)accessTokenLifespan, (long)500L);
        try {
            clientRep.getAttributes().put("access.token.lifespan", "500");
            client.update(clientRep);
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), 500);
            clientRep.getAttributes().put("access.token.lifespan", "-1");
            client.update(clientRep);
            String refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), sessionMax);
        }
        finally {
            clientRep.getAttributes().put("access.token.lifespan", null);
            client.update(clientRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSessionMaxLifespan() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        int accessTokenLifespan = rep.getAccessTokenLifespan();
        Integer originalClientSessionMaxLifespan = rep.getClientSessionMaxLifespan();
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), accessTokenLifespan);
            rep.setClientSessionMaxLifespan(Integer.valueOf(accessTokenLifespan - 100));
            realm.update(rep);
            String refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), accessTokenLifespan - 100);
            clientRepresentation.getAttributes().put("client.session.max.lifespan", Integer.toString(accessTokenLifespan - 200));
            client.update(clientRepresentation);
            refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), accessTokenLifespan - 200);
        }
        finally {
            rep.setClientSessionMaxLifespan(originalClientSessionMaxLifespan);
            realm.update(rep);
            clientRepresentation.getAttributes().put("client.session.max.lifespan", null);
            client.update(clientRepresentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientOfflineSessionMaxLifespan() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        int accessTokenLifespan = rep.getAccessTokenLifespan();
        Boolean originalOfflineSessionMaxLifespanEnabled = rep.getOfflineSessionMaxLifespanEnabled();
        Integer originalClientOfflineSessionMaxLifespan = rep.getClientOfflineSessionMaxLifespan();
        try {
            rep.setOfflineSessionMaxLifespanEnabled(Boolean.valueOf(true));
            realm.update(rep);
            this.oauth.scope("offline_access");
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), accessTokenLifespan);
            rep.setClientOfflineSessionMaxLifespan(Integer.valueOf(accessTokenLifespan - 100));
            realm.update(rep);
            String refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), accessTokenLifespan - 100);
            clientRepresentation.getAttributes().put("client.offline.session.max.lifespan", Integer.toString(accessTokenLifespan - 200));
            client.update(clientRepresentation);
            refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getExpiresIn(), accessTokenLifespan - 200);
        }
        finally {
            rep.setOfflineSessionMaxLifespanEnabled(originalOfflineSessionMaxLifespanEnabled);
            rep.setClientOfflineSessionMaxLifespan(originalClientOfflineSessionMaxLifespan);
            realm.update(rep);
            clientRepresentation.getAttributes().put("client.offline.session.max.lifespan", null);
            client.update(clientRepresentation);
        }
    }

    @Test
    public void accessTokenRequestNoRefreshToken() {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        clientRepresentation.getAttributes().put("use.refresh.tokens", "false");
        client.update(clientRepresentation);
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getAccessToken());
        org.junit.Assert.assertNull((Object)response.getRefreshToken());
        clientRepresentation.getAttributes().put("use.refresh.tokens", "true");
        client.update(clientRepresentation);
    }

    @Test
    public void accessTokenRequest_ClientPS384_RealmRS256() throws Exception {
        this.conductAccessTokenRequest("HS256", "PS384", "RS256");
    }

    @Test
    public void accessTokenRequest_ClientPS256_RealmPS256() throws Exception {
        this.conductAccessTokenRequest("HS256", "PS256", "PS256");
    }

    @Test
    public void accessTokenRequest_ClientPS512_RealmPS256() throws Exception {
        this.conductAccessTokenRequest("HS256", "PS512", "PS256");
    }

    @Test
    public void accessTokenRequest_ClientRS384_RealmRS256() throws Exception {
        this.conductAccessTokenRequest("HS256", "RS384", "RS256");
    }

    @Test
    public void accessTokenRequest_ClientRS512_RealmRS512() throws Exception {
        this.conductAccessTokenRequest("HS256", "RS512", "RS512");
    }

    @Test
    public void accessTokenRequest_ClientES256_RealmPS256() throws Exception {
        this.conductAccessTokenRequest("HS256", "ES256", "PS256");
    }

    @Test
    public void accessTokenRequest_ClientES384_RealmES384() throws Exception {
        this.conductAccessTokenRequest("HS256", "ES384", "ES384");
    }

    @Test
    public void accessTokenRequest_ClientES512_RealmRS256() throws Exception {
        this.conductAccessTokenRequest("HS256", "ES512", "RS256");
    }

    @Test
    public void validateECDSASignatures() {
        this.validateTokenECDSASignature("ES256");
        this.validateTokenECDSASignature("ES384");
        this.validateTokenECDSASignature("ES512");
    }

    private void validateTokenECDSASignature(String expectedAlg) {
        MatcherAssert.assertThat((Object)ECDSASignatureProvider.ECDSA.values(), (Matcher)Matchers.hasItemInArray((Object)ECDSASignatureProvider.ECDSA.valueOf((String)expectedAlg)));
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)expectedAlg);
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)expectedAlg);
            this.validateTokenSignatureLength(ECDSASignatureProvider.ECDSA.valueOf((String)expectedAlg).getSignatureLength());
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)"RS256");
        }
    }

    private void validateTokenSignatureLength(int expectedLength) {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        String token = response.getAccessToken();
        this.oauth.verifyToken(token);
        String encodedSignature = token.split("\\.", 3)[2];
        byte[] signature = Base64Url.decode((String)encodedSignature);
        org.junit.Assert.assertEquals((long)expectedLength, (long)signature.length);
        this.oauth.openLogout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conductAccessTokenRequest(String expectedRefreshAlg, String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)expectedIdTokenAlg);
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)expectedAccessAlg);
            this.tokenRequest(expectedRefreshAlg, expectedAccessAlg, expectedIdTokenAlg);
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)"RS256");
        }
    }

    private void tokenRequest(String expectedRefreshAlg, String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        JWSHeader header = new JWSInput(response.getAccessToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedAccessAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getIdToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedIdTokenAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getRefreshToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedRefreshAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        org.junit.Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId(), (Object)token.getSubject());
        org.junit.Assert.assertNotEquals((Object)"test-user@localhost", (Object)token.getSubject());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        EventRepresentation event = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        org.junit.Assert.assertEquals((Object)token.getId(), event.getDetails().get("token_id"));
        org.junit.Assert.assertEquals((Object)this.oauth.parseRefreshToken(response.getRefreshToken()).getId(), event.getDetails().get("refresh_token_id"));
        org.junit.Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
    }

    @Test
    public void tokenRequestParamsMoreThanOnce() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost post = new HttpPost(this.oauth.getAccessTokenUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
            parameters.add(new BasicNameValuePair("code", code));
            parameters.add(new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
            parameters.add(new BasicNameValuePair("client_id", this.oauth.getClientId()));
            parameters.add(new BasicNameValuePair("client_id", "foo"));
            String authorization = BasicAuthHelper.createHeader((String)"client_id", (String)"password");
            post.setHeader("Authorization", authorization);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(client.execute((HttpUriRequest)post));
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
            org.junit.Assert.assertEquals((Object)"duplicated parameter", (Object)response.getErrorDescription());
        }
    }
}

