/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserBuilder;

public class AccessTokenResponseTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        UserBuilder user = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("no-permissions").addRoles("user").password("password");
        realm.getUsers().add(user.build());
        ProtocolMapperRepresentation customClaimHardcodedMapper = new ProtocolMapperRepresentation();
        customClaimHardcodedMapper.setName("custom-claim-hardcoded-mapper");
        customClaimHardcodedMapper.setProtocol("openid-connect");
        customClaimHardcodedMapper.setProtocolMapper("oidc-hardcoded-claim-mapper");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", "custom_hardcoded_claim");
        config.put("claim.value", "custom_claim");
        config.put("access.tokenResponse.claim", "true");
        customClaimHardcodedMapper.setConfig(config);
        realm.getClients().stream().filter(clientRepresentation -> "test-app".equals(clientRepresentation.getClientId())).forEach(clientRepresentation -> {
            clientRepresentation.setProtocolMappers(Collections.singletonList(customClaimHardcodedMapper));
            clientRepresentation.setFullScopeAllowed(Boolean.valueOf(false));
        });
        testRealms.add(realm);
    }

    @Test
    public void accessTokenRequest() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"custom_claim", response.getOtherClaims().get("custom_hardcoded_claim"));
    }
}

