/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.By;

public class AccessTokenNoEmailLoginTest
extends AbstractKeycloakTest {
    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        this.oauth.clientId("test-app");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        realm.setLoginWithEmailAllowed(Boolean.valueOf(false));
        testRealms.add(realm);
    }

    @Test
    public void loginFormUsernameLabel() throws Exception {
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"Username", (Object)this.driver.findElement(By.xpath((String)"//label[@for='username']")).getText());
    }

    @Test
    public void loginWithUsername() throws Exception {
        this.oauth.doLogin("non-duplicate-email-user", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"non-duplicate-email-user").getId(), (Object)token.getSubject());
        Assert.assertEquals((Object)"non-duplicate-email-user@localhost", (Object)token.getEmail());
    }

    @Test
    public void loginWithEmail() throws Exception {
        this.oauth.doLoginGrant("non-duplicate-email-user@localhost", "password");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.driver.findElement(By.className((String)"kc-feedback-text")).getText());
    }
}

